// media/mojo/mojom/media_metrics_provider.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/media_metrics_provider.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var video_decode_stats_recorder$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/video_decode_stats_recorder.mojom', 'video_decode_stats_recorder.mojom.js');
  }
  var playback_events_recorder$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/playback_events_recorder.mojom', 'playback_events_recorder.mojom.js');
  }
  var watch_time_recorder$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/watch_time_recorder.mojom', 'watch_time_recorder.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }


  var MediaURLScheme = {};
  MediaURLScheme.kUnknown = 0;
  MediaURLScheme.kMissing = 1;
  MediaURLScheme.kHttp = 2;
  MediaURLScheme.kHttps = 3;
  MediaURLScheme.kFtp = 4;
  MediaURLScheme.kChromeExtension = 5;
  MediaURLScheme.kJavascript = 6;
  MediaURLScheme.kFile = 7;
  MediaURLScheme.kBlob = 8;
  MediaURLScheme.kData = 9;
  MediaURLScheme.kFileSystem = 10;
  MediaURLScheme.kChrome = 11;
  MediaURLScheme.kContent = 12;
  MediaURLScheme.kContentId = 13;
  MediaURLScheme.MIN_VALUE = 0;
  MediaURLScheme.MAX_VALUE = 13;

  MediaURLScheme.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
      return true;
    }
    return false;
  };

  MediaURLScheme.toKnownEnumValue = function(value) {
    return value;
  };

  MediaURLScheme.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function MediaMetricsProvider_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_Initialize_Params.prototype.initDefaults_ = function() {
    this.isMse = false;
    this.urlScheme = 0;
    this.streamType = 0;
  };
  MediaMetricsProvider_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaMetricsProvider_Initialize_Params.urlScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, MediaURLScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_Initialize_Params.streamType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, media_types$.MediaStreamType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_Initialize_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaMetricsProvider_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isMse = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.urlScheme =
        decoder.decodeStruct(new codec.Enum(MediaURLScheme));
    val.streamType =
        decoder.decodeStruct(new codec.Enum(media_types$.MediaStreamType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_Initialize_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isMse & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.urlScheme);
    encoder.encodeStruct(codec.Int32, val.streamType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_OnStarted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_OnStarted_Params.prototype.initDefaults_ = function() {
    this.status = null;
  };
  MediaMetricsProvider_OnStarted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_OnStarted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_OnStarted_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.PipelineStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_OnStarted_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_OnStarted_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_OnStarted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStructPointer(media_types$.PipelineStatus);
    return val;
  };

  MediaMetricsProvider_OnStarted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_OnStarted_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.PipelineStatus, val.status);
  };
  function MediaMetricsProvider_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_OnError_Params.prototype.initDefaults_ = function() {
    this.status = null;
  };
  MediaMetricsProvider_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_OnError_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.PipelineStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_OnError_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStructPointer(media_types$.PipelineStatus);
    return val;
  };

  MediaMetricsProvider_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.PipelineStatus, val.status);
  };
  function MediaMetricsProvider_OnFallback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_OnFallback_Params.prototype.initDefaults_ = function() {
    this.status = null;
  };
  MediaMetricsProvider_OnFallback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_OnFallback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_OnFallback_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.PipelineStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_OnFallback_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_OnFallback_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_OnFallback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStructPointer(media_types$.PipelineStatus);
    return val;
  };

  MediaMetricsProvider_OnFallback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_OnFallback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.PipelineStatus, val.status);
  };
  function MediaMetricsProvider_SetHasPlayed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetHasPlayed_Params.prototype.initDefaults_ = function() {
  };
  MediaMetricsProvider_SetHasPlayed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetHasPlayed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetHasPlayed_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaMetricsProvider_SetHasPlayed_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetHasPlayed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaMetricsProvider_SetHasPlayed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetHasPlayed_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaMetricsProvider_SetHaveEnough_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetHaveEnough_Params.prototype.initDefaults_ = function() {
  };
  MediaMetricsProvider_SetHaveEnough_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetHaveEnough_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetHaveEnough_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaMetricsProvider_SetHaveEnough_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetHaveEnough_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaMetricsProvider_SetHaveEnough_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetHaveEnough_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaMetricsProvider_SetIsEME_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetIsEME_Params.prototype.initDefaults_ = function() {
  };
  MediaMetricsProvider_SetIsEME_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetIsEME_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetIsEME_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaMetricsProvider_SetIsEME_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetIsEME_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaMetricsProvider_SetIsEME_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetIsEME_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaMetricsProvider_SetTimeToMetadata_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetTimeToMetadata_Params.prototype.initDefaults_ = function() {
    this.elapsed = null;
  };
  MediaMetricsProvider_SetTimeToMetadata_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetTimeToMetadata_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetTimeToMetadata_Params.elapsed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetTimeToMetadata_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetTimeToMetadata_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetTimeToMetadata_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elapsed =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaMetricsProvider_SetTimeToMetadata_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetTimeToMetadata_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.elapsed);
  };
  function MediaMetricsProvider_SetTimeToFirstFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetTimeToFirstFrame_Params.prototype.initDefaults_ = function() {
    this.elapsed = null;
  };
  MediaMetricsProvider_SetTimeToFirstFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetTimeToFirstFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetTimeToFirstFrame_Params.elapsed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetTimeToFirstFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetTimeToFirstFrame_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetTimeToFirstFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elapsed =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaMetricsProvider_SetTimeToFirstFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetTimeToFirstFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.elapsed);
  };
  function MediaMetricsProvider_SetTimeToPlayReady_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetTimeToPlayReady_Params.prototype.initDefaults_ = function() {
    this.elapsed = null;
  };
  MediaMetricsProvider_SetTimeToPlayReady_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetTimeToPlayReady_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetTimeToPlayReady_Params.elapsed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetTimeToPlayReady_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetTimeToPlayReady_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetTimeToPlayReady_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elapsed =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaMetricsProvider_SetTimeToPlayReady_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetTimeToPlayReady_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.elapsed);
  };
  function MediaMetricsProvider_SetRendererType_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetRendererType_Params.prototype.initDefaults_ = function() {
    this.rendererType = 0;
  };
  MediaMetricsProvider_SetRendererType_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetRendererType_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetRendererType_Params.rendererType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.RendererType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetRendererType_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetRendererType_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetRendererType_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rendererType =
        decoder.decodeStruct(new codec.Enum(media_types$.RendererType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_SetRendererType_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetRendererType_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.rendererType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_SetDemuxerType_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetDemuxerType_Params.prototype.initDefaults_ = function() {
    this.demuxerType = 0;
  };
  MediaMetricsProvider_SetDemuxerType_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetDemuxerType_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetDemuxerType_Params.demuxerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.DemuxerType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetDemuxerType_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetDemuxerType_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetDemuxerType_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.demuxerType =
        decoder.decodeStruct(new codec.Enum(media_types$.DemuxerType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_SetDemuxerType_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetDemuxerType_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.demuxerType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_SetKeySystem_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetKeySystem_Params.prototype.initDefaults_ = function() {
    this.keySystem = null;
  };
  MediaMetricsProvider_SetKeySystem_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetKeySystem_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetKeySystem_Params.keySystem
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetKeySystem_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetKeySystem_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetKeySystem_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keySystem =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaMetricsProvider_SetKeySystem_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetKeySystem_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.keySystem);
  };
  function MediaMetricsProvider_SetHasWaitingForKey_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetHasWaitingForKey_Params.prototype.initDefaults_ = function() {
  };
  MediaMetricsProvider_SetHasWaitingForKey_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetHasWaitingForKey_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetHasWaitingForKey_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaMetricsProvider_SetHasWaitingForKey_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetHasWaitingForKey_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaMetricsProvider_SetHasWaitingForKey_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetHasWaitingForKey_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaMetricsProvider_SetIsHardwareSecure_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetIsHardwareSecure_Params.prototype.initDefaults_ = function() {
  };
  MediaMetricsProvider_SetIsHardwareSecure_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetIsHardwareSecure_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetIsHardwareSecure_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaMetricsProvider_SetIsHardwareSecure_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetIsHardwareSecure_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaMetricsProvider_SetIsHardwareSecure_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetIsHardwareSecure_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaMetricsProvider_SetContainerName_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetContainerName_Params.prototype.initDefaults_ = function() {
    this.containerName = 0;
  };
  MediaMetricsProvider_SetContainerName_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetContainerName_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetContainerName_Params.containerName
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.MediaContainerName);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetContainerName_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetContainerName_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetContainerName_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.containerName =
        decoder.decodeStruct(new codec.Enum(media_types$.MediaContainerName));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_SetContainerName_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetContainerName_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.containerName);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_AcquireWatchTimeRecorder_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_AcquireWatchTimeRecorder_Params.prototype.initDefaults_ = function() {
    this.properties = null;
    this.recorder = new bindings.InterfaceRequest();
  };
  MediaMetricsProvider_AcquireWatchTimeRecorder_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_AcquireWatchTimeRecorder_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_AcquireWatchTimeRecorder_Params.properties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, watch_time_recorder$.PlaybackProperties, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_AcquireWatchTimeRecorder_Params.recorder
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_AcquireWatchTimeRecorder_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaMetricsProvider_AcquireWatchTimeRecorder_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_AcquireWatchTimeRecorder_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.properties =
        decoder.decodeStructPointer(watch_time_recorder$.PlaybackProperties);
    val.recorder =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_AcquireWatchTimeRecorder_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_AcquireWatchTimeRecorder_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(watch_time_recorder$.PlaybackProperties, val.properties);
    encoder.encodeStruct(codec.InterfaceRequest, val.recorder);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.prototype.initDefaults_ = function() {
    this.recorder = new bindings.InterfaceRequest();
  };
  MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.recorder
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.recorder =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.recorder);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_SetHasAudio_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetHasAudio_Params.prototype.initDefaults_ = function() {
    this.codec = 0;
  };
  MediaMetricsProvider_SetHasAudio_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetHasAudio_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetHasAudio_Params.codec
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.AudioCodec);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetHasAudio_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetHasAudio_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetHasAudio_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.codec =
        decoder.decodeStruct(new codec.Enum(media_types$.AudioCodec));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_SetHasAudio_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetHasAudio_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.codec);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_SetHasVideo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetHasVideo_Params.prototype.initDefaults_ = function() {
    this.codec = 0;
  };
  MediaMetricsProvider_SetHasVideo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetHasVideo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetHasVideo_Params.codec
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.VideoCodec);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetHasVideo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetHasVideo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetHasVideo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.codec =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoCodec));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaMetricsProvider_SetHasVideo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetHasVideo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.codec);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaMetricsProvider_SetVideoPipelineInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetVideoPipelineInfo_Params.prototype.initDefaults_ = function() {
    this.info = null;
  };
  MediaMetricsProvider_SetVideoPipelineInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetVideoPipelineInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetVideoPipelineInfo_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.VideoPipelineInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetVideoPipelineInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetVideoPipelineInfo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetVideoPipelineInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(media_types$.VideoPipelineInfo);
    return val;
  };

  MediaMetricsProvider_SetVideoPipelineInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetVideoPipelineInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.VideoPipelineInfo, val.info);
  };
  function MediaMetricsProvider_SetAudioPipelineInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetricsProvider_SetAudioPipelineInfo_Params.prototype.initDefaults_ = function() {
    this.info = null;
  };
  MediaMetricsProvider_SetAudioPipelineInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetricsProvider_SetAudioPipelineInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetricsProvider_SetAudioPipelineInfo_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.AudioPipelineInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetricsProvider_SetAudioPipelineInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaMetricsProvider_SetAudioPipelineInfo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaMetricsProvider_SetAudioPipelineInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(media_types$.AudioPipelineInfo);
    return val;
  };

  MediaMetricsProvider_SetAudioPipelineInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetricsProvider_SetAudioPipelineInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.AudioPipelineInfo, val.info);
  };
  var kMediaMetricsProvider_Initialize_Name = 0;
  var kMediaMetricsProvider_OnStarted_Name = 1;
  var kMediaMetricsProvider_OnError_Name = 2;
  var kMediaMetricsProvider_OnFallback_Name = 3;
  var kMediaMetricsProvider_SetHasPlayed_Name = 4;
  var kMediaMetricsProvider_SetHaveEnough_Name = 5;
  var kMediaMetricsProvider_SetIsEME_Name = 6;
  var kMediaMetricsProvider_SetTimeToMetadata_Name = 7;
  var kMediaMetricsProvider_SetTimeToFirstFrame_Name = 8;
  var kMediaMetricsProvider_SetTimeToPlayReady_Name = 9;
  var kMediaMetricsProvider_SetRendererType_Name = 10;
  var kMediaMetricsProvider_SetDemuxerType_Name = 11;
  var kMediaMetricsProvider_SetKeySystem_Name = 12;
  var kMediaMetricsProvider_SetHasWaitingForKey_Name = 13;
  var kMediaMetricsProvider_SetIsHardwareSecure_Name = 14;
  var kMediaMetricsProvider_SetContainerName_Name = 15;
  var kMediaMetricsProvider_AcquireWatchTimeRecorder_Name = 16;
  var kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name = 17;
  var kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name = 18;
  var kMediaMetricsProvider_SetHasAudio_Name = 19;
  var kMediaMetricsProvider_SetHasVideo_Name = 20;
  var kMediaMetricsProvider_SetVideoPipelineInfo_Name = 21;
  var kMediaMetricsProvider_SetAudioPipelineInfo_Name = 22;

  function MediaMetricsProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaMetricsProvider,
                                                   handleOrPtrInfo);
  }

  function MediaMetricsProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaMetricsProvider, associatedInterfacePtrInfo);
  }

  MediaMetricsProviderAssociatedPtr.prototype =
      Object.create(MediaMetricsProviderPtr.prototype);
  MediaMetricsProviderAssociatedPtr.prototype.constructor =
      MediaMetricsProviderAssociatedPtr;

  function MediaMetricsProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaMetricsProviderPtr.prototype.initialize = function() {
    return MediaMetricsProviderProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.initialize = function(isMse, urlScheme, streamType) {
    var params_ = new MediaMetricsProvider_Initialize_Params();
    params_.isMse = isMse;
    params_.urlScheme = urlScheme;
    params_.streamType = streamType;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_Initialize_Name,
        codec.align(MediaMetricsProvider_Initialize_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_Initialize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.onStarted = function() {
    return MediaMetricsProviderProxy.prototype.onStarted
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.onStarted = function(status) {
    var params_ = new MediaMetricsProvider_OnStarted_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_OnStarted_Name,
        codec.align(MediaMetricsProvider_OnStarted_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_OnStarted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.onError = function() {
    return MediaMetricsProviderProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.onError = function(status) {
    var params_ = new MediaMetricsProvider_OnError_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_OnError_Name,
        codec.align(MediaMetricsProvider_OnError_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.onFallback = function() {
    return MediaMetricsProviderProxy.prototype.onFallback
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.onFallback = function(status) {
    var params_ = new MediaMetricsProvider_OnFallback_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_OnFallback_Name,
        codec.align(MediaMetricsProvider_OnFallback_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_OnFallback_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setHasPlayed = function() {
    return MediaMetricsProviderProxy.prototype.setHasPlayed
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setHasPlayed = function() {
    var params_ = new MediaMetricsProvider_SetHasPlayed_Params();
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetHasPlayed_Name,
        codec.align(MediaMetricsProvider_SetHasPlayed_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetHasPlayed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setHaveEnough = function() {
    return MediaMetricsProviderProxy.prototype.setHaveEnough
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setHaveEnough = function() {
    var params_ = new MediaMetricsProvider_SetHaveEnough_Params();
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetHaveEnough_Name,
        codec.align(MediaMetricsProvider_SetHaveEnough_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetHaveEnough_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setIsEME = function() {
    return MediaMetricsProviderProxy.prototype.setIsEME
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setIsEME = function() {
    var params_ = new MediaMetricsProvider_SetIsEME_Params();
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetIsEME_Name,
        codec.align(MediaMetricsProvider_SetIsEME_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetIsEME_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setTimeToMetadata = function() {
    return MediaMetricsProviderProxy.prototype.setTimeToMetadata
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setTimeToMetadata = function(elapsed) {
    var params_ = new MediaMetricsProvider_SetTimeToMetadata_Params();
    params_.elapsed = elapsed;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetTimeToMetadata_Name,
        codec.align(MediaMetricsProvider_SetTimeToMetadata_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetTimeToMetadata_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setTimeToFirstFrame = function() {
    return MediaMetricsProviderProxy.prototype.setTimeToFirstFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setTimeToFirstFrame = function(elapsed) {
    var params_ = new MediaMetricsProvider_SetTimeToFirstFrame_Params();
    params_.elapsed = elapsed;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetTimeToFirstFrame_Name,
        codec.align(MediaMetricsProvider_SetTimeToFirstFrame_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetTimeToFirstFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setTimeToPlayReady = function() {
    return MediaMetricsProviderProxy.prototype.setTimeToPlayReady
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setTimeToPlayReady = function(elapsed) {
    var params_ = new MediaMetricsProvider_SetTimeToPlayReady_Params();
    params_.elapsed = elapsed;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetTimeToPlayReady_Name,
        codec.align(MediaMetricsProvider_SetTimeToPlayReady_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetTimeToPlayReady_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setRendererType = function() {
    return MediaMetricsProviderProxy.prototype.setRendererType
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setRendererType = function(rendererType) {
    var params_ = new MediaMetricsProvider_SetRendererType_Params();
    params_.rendererType = rendererType;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetRendererType_Name,
        codec.align(MediaMetricsProvider_SetRendererType_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetRendererType_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setDemuxerType = function() {
    return MediaMetricsProviderProxy.prototype.setDemuxerType
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setDemuxerType = function(demuxerType) {
    var params_ = new MediaMetricsProvider_SetDemuxerType_Params();
    params_.demuxerType = demuxerType;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetDemuxerType_Name,
        codec.align(MediaMetricsProvider_SetDemuxerType_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetDemuxerType_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setKeySystem = function() {
    return MediaMetricsProviderProxy.prototype.setKeySystem
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setKeySystem = function(keySystem) {
    var params_ = new MediaMetricsProvider_SetKeySystem_Params();
    params_.keySystem = keySystem;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetKeySystem_Name,
        codec.align(MediaMetricsProvider_SetKeySystem_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetKeySystem_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setHasWaitingForKey = function() {
    return MediaMetricsProviderProxy.prototype.setHasWaitingForKey
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setHasWaitingForKey = function() {
    var params_ = new MediaMetricsProvider_SetHasWaitingForKey_Params();
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetHasWaitingForKey_Name,
        codec.align(MediaMetricsProvider_SetHasWaitingForKey_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetHasWaitingForKey_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setIsHardwareSecure = function() {
    return MediaMetricsProviderProxy.prototype.setIsHardwareSecure
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setIsHardwareSecure = function() {
    var params_ = new MediaMetricsProvider_SetIsHardwareSecure_Params();
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetIsHardwareSecure_Name,
        codec.align(MediaMetricsProvider_SetIsHardwareSecure_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetIsHardwareSecure_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setContainerName = function() {
    return MediaMetricsProviderProxy.prototype.setContainerName
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setContainerName = function(containerName) {
    var params_ = new MediaMetricsProvider_SetContainerName_Params();
    params_.containerName = containerName;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetContainerName_Name,
        codec.align(MediaMetricsProvider_SetContainerName_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetContainerName_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.acquireWatchTimeRecorder = function() {
    return MediaMetricsProviderProxy.prototype.acquireWatchTimeRecorder
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.acquireWatchTimeRecorder = function(properties, recorder) {
    var params_ = new MediaMetricsProvider_AcquireWatchTimeRecorder_Params();
    params_.properties = properties;
    params_.recorder = recorder;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_AcquireWatchTimeRecorder_Name,
        codec.align(MediaMetricsProvider_AcquireWatchTimeRecorder_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_AcquireWatchTimeRecorder_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.acquireVideoDecodeStatsRecorder = function() {
    return MediaMetricsProviderProxy.prototype.acquireVideoDecodeStatsRecorder
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.acquireVideoDecodeStatsRecorder = function(recorder) {
    var params_ = new MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params();
    params_.recorder = recorder;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name,
        codec.align(MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.acquirePlaybackEventsRecorder = function() {
    return MediaMetricsProviderProxy.prototype.acquirePlaybackEventsRecorder
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.acquirePlaybackEventsRecorder = function(receiver) {
    var params_ = new MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name,
        codec.align(MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setHasAudio = function() {
    return MediaMetricsProviderProxy.prototype.setHasAudio
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setHasAudio = function(codec) {
    var params_ = new MediaMetricsProvider_SetHasAudio_Params();
    params_.codec = codec;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetHasAudio_Name,
        codec.align(MediaMetricsProvider_SetHasAudio_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetHasAudio_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setHasVideo = function() {
    return MediaMetricsProviderProxy.prototype.setHasVideo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setHasVideo = function(codec) {
    var params_ = new MediaMetricsProvider_SetHasVideo_Params();
    params_.codec = codec;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetHasVideo_Name,
        codec.align(MediaMetricsProvider_SetHasVideo_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetHasVideo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setVideoPipelineInfo = function() {
    return MediaMetricsProviderProxy.prototype.setVideoPipelineInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setVideoPipelineInfo = function(info) {
    var params_ = new MediaMetricsProvider_SetVideoPipelineInfo_Params();
    params_.info = info;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetVideoPipelineInfo_Name,
        codec.align(MediaMetricsProvider_SetVideoPipelineInfo_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetVideoPipelineInfo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaMetricsProviderPtr.prototype.setAudioPipelineInfo = function() {
    return MediaMetricsProviderProxy.prototype.setAudioPipelineInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaMetricsProviderProxy.prototype.setAudioPipelineInfo = function(info) {
    var params_ = new MediaMetricsProvider_SetAudioPipelineInfo_Params();
    params_.info = info;
    var builder = new codec.MessageV0Builder(
        kMediaMetricsProvider_SetAudioPipelineInfo_Name,
        codec.align(MediaMetricsProvider_SetAudioPipelineInfo_Params.encodedSize));
    builder.encodeStruct(MediaMetricsProvider_SetAudioPipelineInfo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaMetricsProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaMetricsProviderStub.prototype.initialize = function(isMse, urlScheme, streamType) {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize(isMse, urlScheme, streamType);
  }
  MediaMetricsProviderStub.prototype.onStarted = function(status) {
    return this.delegate_ && this.delegate_.onStarted && this.delegate_.onStarted(status);
  }
  MediaMetricsProviderStub.prototype.onError = function(status) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(status);
  }
  MediaMetricsProviderStub.prototype.onFallback = function(status) {
    return this.delegate_ && this.delegate_.onFallback && this.delegate_.onFallback(status);
  }
  MediaMetricsProviderStub.prototype.setHasPlayed = function() {
    return this.delegate_ && this.delegate_.setHasPlayed && this.delegate_.setHasPlayed();
  }
  MediaMetricsProviderStub.prototype.setHaveEnough = function() {
    return this.delegate_ && this.delegate_.setHaveEnough && this.delegate_.setHaveEnough();
  }
  MediaMetricsProviderStub.prototype.setIsEME = function() {
    return this.delegate_ && this.delegate_.setIsEME && this.delegate_.setIsEME();
  }
  MediaMetricsProviderStub.prototype.setTimeToMetadata = function(elapsed) {
    return this.delegate_ && this.delegate_.setTimeToMetadata && this.delegate_.setTimeToMetadata(elapsed);
  }
  MediaMetricsProviderStub.prototype.setTimeToFirstFrame = function(elapsed) {
    return this.delegate_ && this.delegate_.setTimeToFirstFrame && this.delegate_.setTimeToFirstFrame(elapsed);
  }
  MediaMetricsProviderStub.prototype.setTimeToPlayReady = function(elapsed) {
    return this.delegate_ && this.delegate_.setTimeToPlayReady && this.delegate_.setTimeToPlayReady(elapsed);
  }
  MediaMetricsProviderStub.prototype.setRendererType = function(rendererType) {
    return this.delegate_ && this.delegate_.setRendererType && this.delegate_.setRendererType(rendererType);
  }
  MediaMetricsProviderStub.prototype.setDemuxerType = function(demuxerType) {
    return this.delegate_ && this.delegate_.setDemuxerType && this.delegate_.setDemuxerType(demuxerType);
  }
  MediaMetricsProviderStub.prototype.setKeySystem = function(keySystem) {
    return this.delegate_ && this.delegate_.setKeySystem && this.delegate_.setKeySystem(keySystem);
  }
  MediaMetricsProviderStub.prototype.setHasWaitingForKey = function() {
    return this.delegate_ && this.delegate_.setHasWaitingForKey && this.delegate_.setHasWaitingForKey();
  }
  MediaMetricsProviderStub.prototype.setIsHardwareSecure = function() {
    return this.delegate_ && this.delegate_.setIsHardwareSecure && this.delegate_.setIsHardwareSecure();
  }
  MediaMetricsProviderStub.prototype.setContainerName = function(containerName) {
    return this.delegate_ && this.delegate_.setContainerName && this.delegate_.setContainerName(containerName);
  }
  MediaMetricsProviderStub.prototype.acquireWatchTimeRecorder = function(properties, recorder) {
    return this.delegate_ && this.delegate_.acquireWatchTimeRecorder && this.delegate_.acquireWatchTimeRecorder(properties, recorder);
  }
  MediaMetricsProviderStub.prototype.acquireVideoDecodeStatsRecorder = function(recorder) {
    return this.delegate_ && this.delegate_.acquireVideoDecodeStatsRecorder && this.delegate_.acquireVideoDecodeStatsRecorder(recorder);
  }
  MediaMetricsProviderStub.prototype.acquirePlaybackEventsRecorder = function(receiver) {
    return this.delegate_ && this.delegate_.acquirePlaybackEventsRecorder && this.delegate_.acquirePlaybackEventsRecorder(receiver);
  }
  MediaMetricsProviderStub.prototype.setHasAudio = function(codec) {
    return this.delegate_ && this.delegate_.setHasAudio && this.delegate_.setHasAudio(codec);
  }
  MediaMetricsProviderStub.prototype.setHasVideo = function(codec) {
    return this.delegate_ && this.delegate_.setHasVideo && this.delegate_.setHasVideo(codec);
  }
  MediaMetricsProviderStub.prototype.setVideoPipelineInfo = function(info) {
    return this.delegate_ && this.delegate_.setVideoPipelineInfo && this.delegate_.setVideoPipelineInfo(info);
  }
  MediaMetricsProviderStub.prototype.setAudioPipelineInfo = function(info) {
    return this.delegate_ && this.delegate_.setAudioPipelineInfo && this.delegate_.setAudioPipelineInfo(info);
  }

  MediaMetricsProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaMetricsProvider_Initialize_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_Initialize_Params);
      this.initialize(params.isMse, params.urlScheme, params.streamType);
      return true;
    case kMediaMetricsProvider_OnStarted_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_OnStarted_Params);
      this.onStarted(params.status);
      return true;
    case kMediaMetricsProvider_OnError_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_OnError_Params);
      this.onError(params.status);
      return true;
    case kMediaMetricsProvider_OnFallback_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_OnFallback_Params);
      this.onFallback(params.status);
      return true;
    case kMediaMetricsProvider_SetHasPlayed_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetHasPlayed_Params);
      this.setHasPlayed();
      return true;
    case kMediaMetricsProvider_SetHaveEnough_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetHaveEnough_Params);
      this.setHaveEnough();
      return true;
    case kMediaMetricsProvider_SetIsEME_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetIsEME_Params);
      this.setIsEME();
      return true;
    case kMediaMetricsProvider_SetTimeToMetadata_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetTimeToMetadata_Params);
      this.setTimeToMetadata(params.elapsed);
      return true;
    case kMediaMetricsProvider_SetTimeToFirstFrame_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetTimeToFirstFrame_Params);
      this.setTimeToFirstFrame(params.elapsed);
      return true;
    case kMediaMetricsProvider_SetTimeToPlayReady_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetTimeToPlayReady_Params);
      this.setTimeToPlayReady(params.elapsed);
      return true;
    case kMediaMetricsProvider_SetRendererType_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetRendererType_Params);
      this.setRendererType(params.rendererType);
      return true;
    case kMediaMetricsProvider_SetDemuxerType_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetDemuxerType_Params);
      this.setDemuxerType(params.demuxerType);
      return true;
    case kMediaMetricsProvider_SetKeySystem_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetKeySystem_Params);
      this.setKeySystem(params.keySystem);
      return true;
    case kMediaMetricsProvider_SetHasWaitingForKey_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetHasWaitingForKey_Params);
      this.setHasWaitingForKey();
      return true;
    case kMediaMetricsProvider_SetIsHardwareSecure_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetIsHardwareSecure_Params);
      this.setIsHardwareSecure();
      return true;
    case kMediaMetricsProvider_SetContainerName_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetContainerName_Params);
      this.setContainerName(params.containerName);
      return true;
    case kMediaMetricsProvider_AcquireWatchTimeRecorder_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_AcquireWatchTimeRecorder_Params);
      this.acquireWatchTimeRecorder(params.properties, params.recorder);
      return true;
    case kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params);
      this.acquireVideoDecodeStatsRecorder(params.recorder);
      return true;
    case kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params);
      this.acquirePlaybackEventsRecorder(params.receiver);
      return true;
    case kMediaMetricsProvider_SetHasAudio_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetHasAudio_Params);
      this.setHasAudio(params.codec);
      return true;
    case kMediaMetricsProvider_SetHasVideo_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetHasVideo_Params);
      this.setHasVideo(params.codec);
      return true;
    case kMediaMetricsProvider_SetVideoPipelineInfo_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetVideoPipelineInfo_Params);
      this.setVideoPipelineInfo(params.info);
      return true;
    case kMediaMetricsProvider_SetAudioPipelineInfo_Name:
      var params = reader.decodeStruct(MediaMetricsProvider_SetAudioPipelineInfo_Params);
      this.setAudioPipelineInfo(params.info);
      return true;
    default:
      return false;
    }
  };

  MediaMetricsProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaMetricsProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaMetricsProvider_Initialize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_Initialize_Params;
      break;
      case kMediaMetricsProvider_OnStarted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_OnStarted_Params;
      break;
      case kMediaMetricsProvider_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_OnError_Params;
      break;
      case kMediaMetricsProvider_OnFallback_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_OnFallback_Params;
      break;
      case kMediaMetricsProvider_SetHasPlayed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetHasPlayed_Params;
      break;
      case kMediaMetricsProvider_SetHaveEnough_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetHaveEnough_Params;
      break;
      case kMediaMetricsProvider_SetIsEME_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetIsEME_Params;
      break;
      case kMediaMetricsProvider_SetTimeToMetadata_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetTimeToMetadata_Params;
      break;
      case kMediaMetricsProvider_SetTimeToFirstFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetTimeToFirstFrame_Params;
      break;
      case kMediaMetricsProvider_SetTimeToPlayReady_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetTimeToPlayReady_Params;
      break;
      case kMediaMetricsProvider_SetRendererType_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetRendererType_Params;
      break;
      case kMediaMetricsProvider_SetDemuxerType_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetDemuxerType_Params;
      break;
      case kMediaMetricsProvider_SetKeySystem_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetKeySystem_Params;
      break;
      case kMediaMetricsProvider_SetHasWaitingForKey_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetHasWaitingForKey_Params;
      break;
      case kMediaMetricsProvider_SetIsHardwareSecure_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetIsHardwareSecure_Params;
      break;
      case kMediaMetricsProvider_SetContainerName_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetContainerName_Params;
      break;
      case kMediaMetricsProvider_AcquireWatchTimeRecorder_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_AcquireWatchTimeRecorder_Params;
      break;
      case kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params;
      break;
      case kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params;
      break;
      case kMediaMetricsProvider_SetHasAudio_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetHasAudio_Params;
      break;
      case kMediaMetricsProvider_SetHasVideo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetHasVideo_Params;
      break;
      case kMediaMetricsProvider_SetVideoPipelineInfo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetVideoPipelineInfo_Params;
      break;
      case kMediaMetricsProvider_SetAudioPipelineInfo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaMetricsProvider_SetAudioPipelineInfo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaMetricsProviderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaMetricsProvider = {
    name: 'media.mojom.MediaMetricsProvider',
    kVersion: 0,
    ptrClass: MediaMetricsProviderPtr,
    proxyClass: MediaMetricsProviderProxy,
    stubClass: MediaMetricsProviderStub,
    validateRequest: validateMediaMetricsProviderRequest,
    validateResponse: null,
  };
  MediaMetricsProviderStub.prototype.validator = validateMediaMetricsProviderRequest;
  MediaMetricsProviderProxy.prototype.validator = null;
  exports.MediaURLScheme = MediaURLScheme;
  exports.MediaMetricsProvider = MediaMetricsProvider;
  exports.MediaMetricsProviderPtr = MediaMetricsProviderPtr;
  exports.MediaMetricsProviderAssociatedPtr = MediaMetricsProviderAssociatedPtr;
})();