// media/mojo/mojom/media_metrics_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/media_metrics_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* MediaURLSchemeToStringHelper(MediaURLScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaURLScheme::kUnknown:
      return "kUnknown";
    case MediaURLScheme::kMissing:
      return "kMissing";
    case MediaURLScheme::kHttp:
      return "kHttp";
    case MediaURLScheme::kHttps:
      return "kHttps";
    case MediaURLScheme::kFtp:
      return "kFtp";
    case MediaURLScheme::kChromeExtension:
      return "kChromeExtension";
    case MediaURLScheme::kJavascript:
      return "kJavascript";
    case MediaURLScheme::kFile:
      return "kFile";
    case MediaURLScheme::kBlob:
      return "kBlob";
    case MediaURLScheme::kData:
      return "kData";
    case MediaURLScheme::kFileSystem:
      return "kFileSystem";
    case MediaURLScheme::kChrome:
      return "kChrome";
    case MediaURLScheme::kContent:
      return "kContent";
    case MediaURLScheme::kContentId:
      return "kContentId";
    default:
      return nullptr;
  }
}

std::string MediaURLSchemeToString(MediaURLScheme value) {
  const char *str = MediaURLSchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaURLScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaURLScheme value) {
  return os << MediaURLSchemeToString(value);
}

namespace internal {


// static
bool MediaMetricsProvider_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_Initialize_Params_Data* object =
      static_cast<const MediaMetricsProvider_Initialize_Params_Data*>(data);


  if (!::media::mojom::internal::MediaURLScheme_Data
        ::Validate(object->url_scheme, validation_context))
    return false;


  if (!::media::mojom::internal::MediaStreamType_Data
        ::Validate(object->stream_type, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_Initialize_Params_Data::MediaMetricsProvider_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_OnStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_OnStarted_Params_Data* object =
      static_cast<const MediaMetricsProvider_OnStarted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_OnStarted_Params_Data::MediaMetricsProvider_OnStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_OnError_Params_Data* object =
      static_cast<const MediaMetricsProvider_OnError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_OnError_Params_Data::MediaMetricsProvider_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_OnFallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_OnFallback_Params_Data* object =
      static_cast<const MediaMetricsProvider_OnFallback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_OnFallback_Params_Data::MediaMetricsProvider_OnFallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetHasPlayed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetHasPlayed_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetHasPlayed_Params_Data*>(data);

  return true;
}

MediaMetricsProvider_SetHasPlayed_Params_Data::MediaMetricsProvider_SetHasPlayed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetHaveEnough_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetHaveEnough_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetHaveEnough_Params_Data*>(data);

  return true;
}

MediaMetricsProvider_SetHaveEnough_Params_Data::MediaMetricsProvider_SetHaveEnough_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetIsEME_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetIsEME_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetIsEME_Params_Data*>(data);

  return true;
}

MediaMetricsProvider_SetIsEME_Params_Data::MediaMetricsProvider_SetIsEME_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetTimeToMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetTimeToMetadata_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetTimeToMetadata_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elapsed, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->elapsed, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetTimeToMetadata_Params_Data::MediaMetricsProvider_SetTimeToMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetTimeToFirstFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetTimeToFirstFrame_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetTimeToFirstFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elapsed, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->elapsed, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetTimeToFirstFrame_Params_Data::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetTimeToPlayReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetTimeToPlayReady_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetTimeToPlayReady_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elapsed, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->elapsed, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetTimeToPlayReady_Params_Data::MediaMetricsProvider_SetTimeToPlayReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetRendererType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetRendererType_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetRendererType_Params_Data*>(data);


  if (!::media::mojom::internal::RendererType_Data
        ::Validate(object->renderer_type, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetRendererType_Params_Data::MediaMetricsProvider_SetRendererType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetDemuxerType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetDemuxerType_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetDemuxerType_Params_Data*>(data);


  if (!::media::mojom::internal::DemuxerType_Data
        ::Validate(object->demuxer_type, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetDemuxerType_Params_Data::MediaMetricsProvider_SetDemuxerType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetKeySystem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetKeySystem_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetKeySystem_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_system, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_system_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_system, validation_context,
                                         &key_system_validate_params)) {
    return false;
  }

  return true;
}

MediaMetricsProvider_SetKeySystem_Params_Data::MediaMetricsProvider_SetKeySystem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetHasWaitingForKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetHasWaitingForKey_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetHasWaitingForKey_Params_Data*>(data);

  return true;
}

MediaMetricsProvider_SetHasWaitingForKey_Params_Data::MediaMetricsProvider_SetHasWaitingForKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetIsHardwareSecure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetIsHardwareSecure_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetIsHardwareSecure_Params_Data*>(data);

  return true;
}

MediaMetricsProvider_SetIsHardwareSecure_Params_Data::MediaMetricsProvider_SetIsHardwareSecure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetContainerName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetContainerName_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetContainerName_Params_Data*>(data);


  if (!::media::mojom::internal::MediaContainerName_Data
        ::Validate(object->container_name, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetContainerName_Params_Data::MediaMetricsProvider_SetContainerName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data* object =
      static_cast<const MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->recorder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->recorder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data* object =
      static_cast<const MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->recorder, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->recorder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data* object =
      static_cast<const MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetHasAudio_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetHasAudio_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetHasAudio_Params_Data*>(data);


  if (!::media::mojom::internal::AudioCodec_Data
        ::Validate(object->codec, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetHasAudio_Params_Data::MediaMetricsProvider_SetHasAudio_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetHasVideo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetHasVideo_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetHasVideo_Params_Data*>(data);


  if (!::media::mojom::internal::VideoCodec_Data
        ::Validate(object->codec, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetHasVideo_Params_Data::MediaMetricsProvider_SetHasVideo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetVideoPipelineInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetVideoPipelineInfo_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetVideoPipelineInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetVideoPipelineInfo_Params_Data::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetricsProvider_SetAudioPipelineInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetricsProvider_SetAudioPipelineInfo_Params_Data* object =
      static_cast<const MediaMetricsProvider_SetAudioPipelineInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaMetricsProvider_SetAudioPipelineInfo_Params_Data::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::MediaURLScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::MediaURLScheme value) {
  return std::move(context).WriteString(::media::mojom::MediaURLSchemeToString(value));
}

} // namespace perfetto