// media/mojo/mojom/media_log.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  MediaLogRecord as media_mojom_MediaLogRecord,
  MediaLogRecordSpec as media_mojom_MediaLogRecordSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaLogPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaLog', scope);
  }
}

/** @interface */
export class MediaLogInterface {
  
  /**
   * @param { !media_mojom_MediaLogRecord } event
   */

  addLogRecord(event) {}
}

/**
 * @implements { MediaLogInterface }
 */
export class MediaLogRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaLogPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaLogPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaLogPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_MediaLogRecord } event
   */

  addLogRecord(
      event) {
    this.proxy.sendMessage(
        0,
        MediaLog_AddLogRecord_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaLog
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaLogReceiver {
  /**
   * @param {!MediaLogInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaLogRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaLogRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaLogRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaLog_AddLogRecord_ParamsSpec.$,
        null,
        impl.addLogRecord.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaLog {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaLog";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaLogRemote}
   */
  static getRemote() {
    let remote = new MediaLogRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaLog
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaLogCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaLogRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaLogRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addLogRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaLog_AddLogRecord_ParamsSpec.$,
        null,
        this.addLogRecord.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaLog_AddLogRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaLog_AddLogRecord_ParamsSpec.$,
    'MediaLog_AddLogRecord_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        media_mojom_MediaLogRecordSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaLog_AddLogRecord_Params {
  constructor() {
    /** @type { !media_mojom_MediaLogRecord } */
    this.event;
  }
}

