// media/mojo/mojom/key_system_support.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SHARED_INTERNAL_H_
#define MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "media/mojo/mojom/content_decryption_module.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/version.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace media::mojom {
namespace internal {
class VideoCodecInfo_Data;
class CdmCapability_Data;
class KeySystemCapability_Data;

struct CdmCapabilityQueryStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  VideoCodecInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> supported_profiles;
  uint8_t supports_clear_lead : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<VideoCodecInfo_Data>;

  VideoCodecInfo_Data();
  ~VideoCodecInfo_Data() = delete;
};
static_assert(sizeof(VideoCodecInfo_Data) == 24,
              "Bad sizeof(VideoCodecInfo_Data)");
// Used by VideoCodecInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoCodecInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoCodecInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoCodecInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<VideoCodecInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoCodecInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CdmCapability_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> audio_codecs;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<internal::VideoCodecInfo_Data>>> video_codecs;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> encryption_schemes;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> session_types;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Version_Data> version;

 private:
  friend class mojo::internal::MessageFragment<CdmCapability_Data>;

  CdmCapability_Data();
  ~CdmCapability_Data() = delete;
};
static_assert(sizeof(CdmCapability_Data) == 48,
              "Bad sizeof(CdmCapability_Data)");
// Used by CdmCapability::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CdmCapability_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CdmCapability_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CdmCapability_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CdmCapability_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CdmCapability_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  KeySystemCapability_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmCapability_Data> sw_secure_capability;
  mojo::internal::Pointer<internal::CdmCapability_Data> hw_secure_capability;
  uint8_t sw_secure_capability_query_status_$flag : 1;
  uint8_t hw_secure_capability_query_status_$flag : 1;
  uint8_t pad3_[3];
  int32_t sw_secure_capability_query_status_$value;
  int32_t hw_secure_capability_query_status_$value;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<KeySystemCapability_Data>;

  KeySystemCapability_Data();
  ~KeySystemCapability_Data() = delete;
};
static_assert(sizeof(KeySystemCapability_Data) == 40,
              "Bad sizeof(KeySystemCapability_Data)");
// Used by KeySystemCapability::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct KeySystemCapability_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  KeySystemCapability_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~KeySystemCapability_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<KeySystemCapability_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    KeySystemCapability_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_SHARED_INTERNAL_H_