// media/mojo/mojom/key_system_support.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.AudioCodec');
goog.require('media.mojom.CdmSessionType');
goog.require('media.mojom.EncryptionScheme');
goog.require('media.mojom.VideoCodec');
goog.require('media.mojom.VideoCodecProfile');
goog.require('mojoBase.mojom.Version');




goog.provide('media.mojom.CdmCapabilityQueryStatus');
goog.provide('media.mojom.CdmCapabilityQueryStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmCapabilityQueryStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmCapabilityQueryStatus = {
  
  kSuccess: 0,
  kUnknown: 1,
  kHardwareSecureCodecNotSupported: 2,
  kNoSupportedVideoCodec: 3,
  kNoSupportedEncryptionScheme: 4,
  kUnsupportedKeySystem: 5,
  kMediaFoundationCdmNotSupported: 6,
  kDisconnectionError: 7,
  kMediaFoundationGetCdmFactoryFailed: 8,
  kCreateDummyMediaFoundationCdmFailed: 9,
  kUnexpectedEmptyCapability: 10,
  kNoMediaDrmSupport: 11,
  kMediaFoundationGetExtendedDRMTypeSupportFailed: 12,
  MIN_VALUE: 0,
  MAX_VALUE: 12,
};



goog.provide('media.mojom.KeySystemSupportObserver');
goog.provide('media.mojom.KeySystemSupportObserverReceiver');
goog.provide('media.mojom.KeySystemSupportObserverCallbackRouter');
goog.provide('media.mojom.KeySystemSupportObserverInterface');
goog.provide('media.mojom.KeySystemSupportObserverRemote');
goog.provide('media.mojom.KeySystemSupportObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.KeySystemSupportObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.KeySystemSupportObserver.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.KeySystemSupportObserverInterface = class {
  
  /**
   * @param { !Object<!string, !media.mojom.KeySystemCapability> } keySystems
   */

  onKeySystemSupportUpdated(keySystems) {}
};

/**
 * @export
 * @implements { media.mojom.KeySystemSupportObserverInterface }
 */
media.mojom.KeySystemSupportObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.KeySystemSupportObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.KeySystemSupportObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.KeySystemSupportObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object<!string, !media.mojom.KeySystemCapability> } keySystems
   */

  onKeySystemSupportUpdated(
      keySystems) {
    this.proxy.sendMessage(
        0,
        media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
        null,
        [
          keySystems
        ],
        false);
  }
};

/**
 * An object which receives request messages for the KeySystemSupportObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.KeySystemSupportObserverReceiver = class {
  /**
   * @param {!media.mojom.KeySystemSupportObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.KeySystemSupportObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.KeySystemSupportObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.KeySystemSupportObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
        null,
        impl.onKeySystemSupportUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.KeySystemSupportObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.KeySystemSupportObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.KeySystemSupportObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.KeySystemSupportObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the KeySystemSupportObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.KeySystemSupportObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.KeySystemSupportObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.KeySystemSupportObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onKeySystemSupportUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
        null,
        this.onKeySystemSupportUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.KeySystemSupport');
goog.provide('media.mojom.KeySystemSupportReceiver');
goog.provide('media.mojom.KeySystemSupportCallbackRouter');
goog.provide('media.mojom.KeySystemSupportInterface');
goog.provide('media.mojom.KeySystemSupportRemote');
goog.provide('media.mojom.KeySystemSupportPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.KeySystemSupportPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.KeySystemSupport.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.KeySystemSupportInterface = class {
  
  /**
   * @param { !media.mojom.KeySystemSupportObserverRemote } observer
   */

  setObserver(observer) {}
};

/**
 * @export
 * @implements { media.mojom.KeySystemSupportInterface }
 */
media.mojom.KeySystemSupportRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.KeySystemSupportPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.KeySystemSupportPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.KeySystemSupportPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.KeySystemSupportObserverRemote } observer
   */

  setObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        media.mojom.KeySystemSupport_SetObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the KeySystemSupport
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.KeySystemSupportReceiver = class {
  /**
   * @param {!media.mojom.KeySystemSupportInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.KeySystemSupportRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.KeySystemSupportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.KeySystemSupportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.KeySystemSupport_SetObserver_ParamsSpec.$,
        null,
        impl.setObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.KeySystemSupport = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.KeySystemSupport";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.KeySystemSupportRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.KeySystemSupportRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the KeySystemSupport
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.KeySystemSupportCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.KeySystemSupportRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.KeySystemSupportRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.KeySystemSupport_SetObserver_ParamsSpec.$,
        null,
        this.setObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoCodecInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCodecInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmCapabilitySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmCapabilitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.KeySystemCapabilitySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.KeySystemCapabilitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.KeySystemSupport_SetObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.KeySystemSupport_SetObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.VideoCodecInfoSpec.$,
    'VideoCodecInfo',
    [
      mojo.internal.StructField(
        'supportedProfiles', 0,
        0,
        mojo.internal.Array(media.mojom.VideoCodecProfileSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supportsClearLead', 8,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoCodecInfo');

/** @record */
media.mojom.VideoCodecInfo = class {
  constructor() {
    /** @export { !Array<!media.mojom.VideoCodecProfile> } */
    this.supportedProfiles;
    /** @export { !boolean } */
    this.supportsClearLead;
  }
};



mojo.internal.Struct(
    media.mojom.CdmCapabilitySpec.$,
    'CdmCapability',
    [
      mojo.internal.StructField(
        'audioCodecs', 0,
        0,
        mojo.internal.Array(media.mojom.AudioCodecSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoCodecs', 8,
        0,
        mojo.internal.Map(media.mojom.VideoCodecSpec.$, media.mojom.VideoCodecInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encryptionSchemes', 16,
        0,
        mojo.internal.Array(media.mojom.EncryptionSchemeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionTypes', 24,
        0,
        mojo.internal.Array(media.mojom.CdmSessionTypeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'version', 32,
        0,
        mojoBase.mojom.VersionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('media.mojom.CdmCapability');

/** @record */
media.mojom.CdmCapability = class {
  constructor() {
    /** @export { !Array<!media.mojom.AudioCodec> } */
    this.audioCodecs;
    /** @export { !Object<!media.mojom.VideoCodec, !media.mojom.VideoCodecInfo> } */
    this.videoCodecs;
    /** @export { !Array<!media.mojom.EncryptionScheme> } */
    this.encryptionSchemes;
    /** @export { !Array<!media.mojom.CdmSessionType> } */
    this.sessionTypes;
    /** @export { !mojoBase.mojom.Version } */
    this.version;
  }
};



mojo.internal.Struct(
    media.mojom.KeySystemCapabilitySpec.$,
    'KeySystemCapability',
    [
      mojo.internal.StructField(
        'swSecureCapability', 0,
        0,
        media.mojom.CdmCapabilitySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hwSecureCapability', 8,
        0,
        media.mojom.CdmCapabilitySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sw_secure_capability_query_status_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "sw_secure_capability_query_status_$value",
          originalFieldName: "swSecureCapabilityQueryStatus",
        }
      ),
      mojo.internal.StructField(
        'sw_secure_capability_query_status_$value', 20,
        0,
        media.mojom.CdmCapabilityQueryStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "swSecureCapabilityQueryStatus",
        }
      ),
      mojo.internal.StructField(
        'hw_secure_capability_query_status_$flag', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "hw_secure_capability_query_status_$value",
          originalFieldName: "hwSecureCapabilityQueryStatus",
        }
      ),
      mojo.internal.StructField(
        'hw_secure_capability_query_status_$value', 24,
        0,
        media.mojom.CdmCapabilityQueryStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "hwSecureCapabilityQueryStatus",
        }
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.KeySystemCapability');

/** @record */
media.mojom.KeySystemCapability = class {
  constructor() {
    /** @export { (media.mojom.CdmCapability|undefined) } */
    this.swSecureCapability;
    /** @export { (media.mojom.CdmCapability|undefined) } */
    this.hwSecureCapability;
    /** @export { (media.mojom.CdmCapabilityQueryStatus|undefined) } */
    this.swSecureCapabilityQueryStatus;
    /** @export { (media.mojom.CdmCapabilityQueryStatus|undefined) } */
    this.hwSecureCapabilityQueryStatus;
  }
};



mojo.internal.Struct(
    media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsSpec.$,
    'KeySystemSupportObserver_OnKeySystemSupportUpdated_Params',
    [
      mojo.internal.StructField(
        'keySystems', 0,
        0,
        mojo.internal.Map(mojo.internal.String, media.mojom.KeySystemCapabilitySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_Params');

/** @record */
media.mojom.KeySystemSupportObserver_OnKeySystemSupportUpdated_Params = class {
  constructor() {
    /** @export { !Object<!string, !media.mojom.KeySystemCapability> } */
    this.keySystems;
  }
};



mojo.internal.Struct(
    media.mojom.KeySystemSupport_SetObserver_ParamsSpec.$,
    'KeySystemSupport_SetObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(media.mojom.KeySystemSupportObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.KeySystemSupport_SetObserver_Params');

/** @record */
media.mojom.KeySystemSupport_SetObserver_Params = class {
  constructor() {
    /** @export { !media.mojom.KeySystemSupportObserverRemote } */
    this.observer;
  }
};

