// media/mojo/mojom/key_system_support.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/key_system_support.mojom-shared-internal.h"
#include "media/mojo/mojom/content_decryption_module.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"


namespace media::mojom {
class VideoCodecInfoDataView;

class CdmCapabilityDataView;

class KeySystemCapabilityDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoCodecInfoDataView> {
  using Data = ::media::mojom::internal::VideoCodecInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmCapabilityDataView> {
  using Data = ::media::mojom::internal::CdmCapability_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::KeySystemCapabilityDataView> {
  using Data = ::media::mojom::internal::KeySystemCapability_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class CdmCapabilityQueryStatus : int32_t {
  
  kSuccess = 0,
  
  kUnknown = 1,
  
  kHardwareSecureCodecNotSupported = 2,
  
  kNoSupportedVideoCodec = 3,
  
  kNoSupportedEncryptionScheme = 4,
  
  kUnsupportedKeySystem = 5,
  
  kMediaFoundationCdmNotSupported = 6,
  
  kDisconnectionError = 7,
  
  kMediaFoundationGetCdmFactoryFailed = 8,
  
  kCreateDummyMediaFoundationCdmFailed = 9,
  
  kUnexpectedEmptyCapability = 10,
  
  kNoMediaDrmSupport = 11,
  
  kMediaFoundationGetExtendedDRMTypeSupportFailed = 12,
  kMinValue = 0,
  kMaxValue = 12,
};

 std::ostream& operator<<(std::ostream& os, CdmCapabilityQueryStatus value);
inline bool IsKnownEnumValue(CdmCapabilityQueryStatus value) {
  return internal::CdmCapabilityQueryStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class KeySystemSupportObserverInterfaceBase {};

using KeySystemSupportObserverPtrDataView =
    mojo::InterfacePtrDataView<KeySystemSupportObserverInterfaceBase>;
using KeySystemSupportObserverRequestDataView =
    mojo::InterfaceRequestDataView<KeySystemSupportObserverInterfaceBase>;
using KeySystemSupportObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<KeySystemSupportObserverInterfaceBase>;
using KeySystemSupportObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<KeySystemSupportObserverInterfaceBase>;
class KeySystemSupportInterfaceBase {};

using KeySystemSupportPtrDataView =
    mojo::InterfacePtrDataView<KeySystemSupportInterfaceBase>;
using KeySystemSupportRequestDataView =
    mojo::InterfaceRequestDataView<KeySystemSupportInterfaceBase>;
using KeySystemSupportAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<KeySystemSupportInterfaceBase>;
using KeySystemSupportAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<KeySystemSupportInterfaceBase>;


class VideoCodecInfoDataView {
 public:
  VideoCodecInfoDataView() = default;

  VideoCodecInfoDataView(
      internal::VideoCodecInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedProfilesDataView(
      mojo::ArrayDataView<::media::mojom::VideoCodecProfile>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedProfiles(UserType* output) {
    
    auto* pointer = data_->supported_profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoCodecProfile>>(
        pointer, output, message_);
  }
  bool supports_clear_lead() const {
    return data_->supports_clear_lead;
  }
 private:
  internal::VideoCodecInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmCapabilityDataView {
 public:
  CdmCapabilityDataView() = default;

  CdmCapabilityDataView(
      internal::CdmCapability_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAudioCodecsDataView(
      mojo::ArrayDataView<::media::mojom::AudioCodec>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioCodecs(UserType* output) {
    
    auto* pointer = data_->audio_codecs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::AudioCodec>>(
        pointer, output, message_);
  }
  inline void GetVideoCodecsDataView(
      mojo::MapDataView<::media::mojom::VideoCodec, VideoCodecInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoCodecs(UserType* output) {
    
    auto* pointer = data_->video_codecs.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::media::mojom::VideoCodec, ::media::mojom::VideoCodecInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetEncryptionSchemesDataView(
      mojo::ArrayDataView<::media::mojom::EncryptionScheme>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionSchemes(UserType* output) {
    
    auto* pointer = data_->encryption_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::EncryptionScheme>>(
        pointer, output, message_);
  }
  inline void GetSessionTypesDataView(
      mojo::ArrayDataView<::media::mojom::CdmSessionType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionTypes(UserType* output) {
    
    auto* pointer = data_->session_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::CdmSessionType>>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      ::mojo_base::mojom::VersionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::VersionDataView>(
        pointer, output, message_);
  }
 private:
  internal::CdmCapability_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class KeySystemCapabilityDataView {
 public:
  KeySystemCapabilityDataView() = default;

  KeySystemCapabilityDataView(
      internal::KeySystemCapability_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSwSecureCapabilityDataView(
      CdmCapabilityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSwSecureCapability(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CdmCapabilityDataView, UserType>(),
    "Attempting to read the optional `sw_secure_capability` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSwSecureCapability` instead "
    "of `ReadSwSecureCapability if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sw_secure_capability.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityDataView>(
        pointer, output, message_);
  }
  inline void GetHwSecureCapabilityDataView(
      CdmCapabilityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHwSecureCapability(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CdmCapabilityDataView, UserType>(),
    "Attempting to read the optional `hw_secure_capability` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHwSecureCapability` instead "
    "of `ReadHwSecureCapability if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hw_secure_capability.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSwSecureCapabilityQueryStatus(UserType* output) const {
    if (!data_->sw_secure_capability_query_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityQueryStatus>(
        data_->sw_secure_capability_query_status_$value, &output->emplace());
  }
  std::optional<CdmCapabilityQueryStatus> sw_secure_capability_query_status() const {
    if (!data_->sw_secure_capability_query_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmCapabilityQueryStatus>(data_->sw_secure_capability_query_status_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHwSecureCapabilityQueryStatus(UserType* output) const {
    if (!data_->hw_secure_capability_query_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CdmCapabilityQueryStatus>(
        data_->hw_secure_capability_query_status_$value, &output->emplace());
  }
  std::optional<CdmCapabilityQueryStatus> hw_secure_capability_query_status() const {
    if (!data_->hw_secure_capability_query_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmCapabilityQueryStatus>(data_->hw_secure_capability_query_status_$value));
  }
 private:
  internal::KeySystemCapability_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_DATA_VIEW_H_