// media/mojo/mojom/interface_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_H_
#define MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/interface_factory.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/interface_factory.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/interface_factory.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_decoder.mojom-forward.h"
#include "media/mojo/mojom/audio_encoder.mojom-forward.h"
#include "media/mojo/mojom/decryptor.mojom-forward.h"
#include "media/mojo/mojom/content_decryption_module.mojom.h"
#include "media/mojo/mojom/media_log.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "media/mojo/mojom/renderer.mojom-forward.h"
#include "media/mojo/mojom/renderer_extensions.mojom-forward.h"
#include "media/mojo/mojom/video_decoder.mojom-forward.h"
#include "mojo/public/mojom/base/token.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class InterfaceFactoryProxy;

template <typename ImplRefTraits>
class InterfaceFactoryStub;

class InterfaceFactoryRequestValidator;
class InterfaceFactoryResponseValidator;


class InterfaceFactory
    : public InterfaceFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.InterfaceFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = InterfaceFactoryInterfaceBase;
  using Proxy_ = InterfaceFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = InterfaceFactoryStub<ImplRefTraits>;

  using RequestValidator_ = InterfaceFactoryRequestValidator;
  using ResponseValidator_ = InterfaceFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateAudioDecoderMinVersion = 0,
    kCreateVideoDecoderMinVersion = 0,
    kCreateAudioEncoderMinVersion = 0,
    kCreateDefaultRendererMinVersion = 0,
    kCreateCdmMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateAudioDecoder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateVideoDecoder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAudioEncoder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateDefaultRenderer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateCdm_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~InterfaceFactory() = default;

  virtual void CreateAudioDecoder(::mojo::PendingReceiver<::media::mojom::AudioDecoder> audio_decoder) = 0;

  virtual void CreateVideoDecoder(::mojo::PendingReceiver<::media::mojom::VideoDecoder> video_decoder, ::mojo::PendingRemote<::media::mojom::VideoDecoder> dst_video_decoder) = 0;

  virtual void CreateAudioEncoder(::mojo::PendingReceiver<::media::mojom::AudioEncoder> audio_encoder) = 0;

  virtual void CreateDefaultRenderer(const std::string& audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> renderer) = 0;

  using CreateCdmCallback = base::OnceCallback<void(::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>, ::media::mojom::CdmContextPtr, ::media::CreateCdmStatus)>;
  using CreateCdmMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>, ::media::mojom::CdmContextPtr, ::media::CreateCdmStatus)>;

  virtual void CreateCdm(const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) = 0;
};



class  InterfaceFactoryProxy
    : public InterfaceFactory {
 public:
  using InterfaceType = InterfaceFactory;

  explicit InterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAudioDecoder(::mojo::PendingReceiver<::media::mojom::AudioDecoder> audio_decoder) final;
  
  void CreateVideoDecoder(::mojo::PendingReceiver<::media::mojom::VideoDecoder> video_decoder, ::mojo::PendingRemote<::media::mojom::VideoDecoder> dst_video_decoder) final;
  
  void CreateAudioEncoder(::mojo::PendingReceiver<::media::mojom::AudioEncoder> audio_encoder) final;
  
  void CreateDefaultRenderer(const std::string& audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> renderer) final;
  
  void CreateCdm(const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  InterfaceFactoryStubDispatch {
 public:
  static bool Accept(InterfaceFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      InterfaceFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<InterfaceFactory>>
class InterfaceFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  InterfaceFactoryStub() = default;
  ~InterfaceFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InterfaceFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InterfaceFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  InterfaceFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  InterfaceFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_H_