// media/mojo/mojom/interface_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/interface_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/interface_factory.mojom-params-data.h"
#include "media/mojo/mojom/interface_factory.mojom-shared-message-ids.h"

#include "media/mojo/mojom/interface_factory.mojom-import-headers.h"
#include "media/mojo/mojom/interface_factory.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

InterfaceFactory::IPCStableHashFunction InterfaceFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InterfaceFactory>(message.name())) {
    case messages::InterfaceFactory::kCreateAudioDecoder: {
      return &InterfaceFactory::CreateAudioDecoder_Sym::IPCStableHash;
    }
    case messages::InterfaceFactory::kCreateVideoDecoder: {
      return &InterfaceFactory::CreateVideoDecoder_Sym::IPCStableHash;
    }
    case messages::InterfaceFactory::kCreateAudioEncoder: {
      return &InterfaceFactory::CreateAudioEncoder_Sym::IPCStableHash;
    }
    case messages::InterfaceFactory::kCreateDefaultRenderer: {
      return &InterfaceFactory::CreateDefaultRenderer_Sym::IPCStableHash;
    }
    case messages::InterfaceFactory::kCreateCdm: {
      return &InterfaceFactory::CreateCdm_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InterfaceFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InterfaceFactory>(message.name())) {
      case messages::InterfaceFactory::kCreateAudioDecoder:
            return "Receive media::mojom::InterfaceFactory::CreateAudioDecoder";
      case messages::InterfaceFactory::kCreateVideoDecoder:
            return "Receive media::mojom::InterfaceFactory::CreateVideoDecoder";
      case messages::InterfaceFactory::kCreateAudioEncoder:
            return "Receive media::mojom::InterfaceFactory::CreateAudioEncoder";
      case messages::InterfaceFactory::kCreateDefaultRenderer:
            return "Receive media::mojom::InterfaceFactory::CreateDefaultRenderer";
      case messages::InterfaceFactory::kCreateCdm:
            return "Receive media::mojom::InterfaceFactory::CreateCdm";
    }
  } else {
    switch (static_cast<messages::InterfaceFactory>(message.name())) {
      case messages::InterfaceFactory::kCreateAudioDecoder:
            return "Receive reply media::mojom::InterfaceFactory::CreateAudioDecoder";
      case messages::InterfaceFactory::kCreateVideoDecoder:
            return "Receive reply media::mojom::InterfaceFactory::CreateVideoDecoder";
      case messages::InterfaceFactory::kCreateAudioEncoder:
            return "Receive reply media::mojom::InterfaceFactory::CreateAudioEncoder";
      case messages::InterfaceFactory::kCreateDefaultRenderer:
            return "Receive reply media::mojom::InterfaceFactory::CreateDefaultRenderer";
      case messages::InterfaceFactory::kCreateCdm:
            return "Receive reply media::mojom::InterfaceFactory::CreateCdm";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InterfaceFactory::CreateAudioDecoder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe1cdde48;  // IPCStableHash for media::mojom::InterfaceFactory::CreateAudioDecoder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InterfaceFactory::CreateVideoDecoder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e00969c;  // IPCStableHash for media::mojom::InterfaceFactory::CreateVideoDecoder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InterfaceFactory::CreateAudioEncoder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92b392ae;  // IPCStableHash for media::mojom::InterfaceFactory::CreateAudioEncoder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InterfaceFactory::CreateDefaultRenderer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x140b4d04;  // IPCStableHash for media::mojom::InterfaceFactory::CreateDefaultRenderer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t InterfaceFactory::CreateCdm_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e540e5c;  // IPCStableHash for media::mojom::InterfaceFactory::CreateCdm
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class InterfaceFactory_CreateCdm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InterfaceFactory_CreateCdm_ForwardToCallback(
      InterfaceFactory::CreateCdmCallback callback
      ) : callback_(std::move(callback)) {
  }

  InterfaceFactory_CreateCdm_ForwardToCallback(const InterfaceFactory_CreateCdm_ForwardToCallback&) = delete;
  InterfaceFactory_CreateCdm_ForwardToCallback& operator=(const InterfaceFactory_CreateCdm_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InterfaceFactory::CreateCdmCallback callback_;
};

InterfaceFactoryProxy::InterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InterfaceFactoryProxy::CreateAudioDecoder(
    ::mojo::PendingReceiver<::media::mojom::AudioDecoder> in_audio_decoder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::InterfaceFactory::CreateAudioDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_decoder"), in_audio_decoder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioDecoder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InterfaceFactory::kCreateAudioDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateAudioDecoder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioDecoderInterfaceBase>>(
    in_audio_decoder,
    &params->audio_decoder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->audio_decoder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid audio_decoder in InterfaceFactory.CreateAudioDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateAudioDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void InterfaceFactoryProxy::CreateVideoDecoder(
    ::mojo::PendingReceiver<::media::mojom::VideoDecoder> in_video_decoder, ::mojo::PendingRemote<::media::mojom::VideoDecoder> in_dst_video_decoder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::InterfaceFactory::CreateVideoDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_decoder"), in_video_decoder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::VideoDecoder>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dst_video_decoder"), in_dst_video_decoder,
                        "<value of type ::mojo::PendingRemote<::media::mojom::VideoDecoder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InterfaceFactory::kCreateVideoDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateVideoDecoder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoDecoderInterfaceBase>>(
    in_video_decoder,
    &params->video_decoder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->video_decoder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid video_decoder in InterfaceFactory.CreateVideoDecoder request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::VideoDecoderInterfaceBase>>(
    in_dst_video_decoder,
    &params->dst_video_decoder,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateVideoDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void InterfaceFactoryProxy::CreateAudioEncoder(
    ::mojo::PendingReceiver<::media::mojom::AudioEncoder> in_audio_encoder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::InterfaceFactory::CreateAudioEncoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_encoder"), in_audio_encoder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioEncoder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InterfaceFactory::kCreateAudioEncoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateAudioEncoder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioEncoderInterfaceBase>>(
    in_audio_encoder,
    &params->audio_encoder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->audio_encoder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid audio_encoder in InterfaceFactory.CreateAudioEncoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateAudioEncoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void InterfaceFactoryProxy::CreateDefaultRenderer(
    const std::string& in_audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> in_renderer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::InterfaceFactory::CreateDefaultRenderer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_device_id"), in_audio_device_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer"), in_renderer,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::Renderer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InterfaceFactory::kCreateDefaultRenderer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateDefaultRenderer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->audio_device_id)::BaseType> audio_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_audio_device_id,
    audio_device_id_fragment);

  params->audio_device_id.Set(
      audio_device_id_fragment.is_null() ? nullptr : audio_device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_device_id in InterfaceFactory.CreateDefaultRenderer request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::RendererInterfaceBase>>(
    in_renderer,
    &params->renderer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->renderer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid renderer in InterfaceFactory.CreateDefaultRenderer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateDefaultRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void InterfaceFactoryProxy::CreateCdm(
    const ::media::CdmConfig& in_cdm_config, CreateCdmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::InterfaceFactory::CreateCdm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_config"), in_cdm_config,
                        "<value of type const ::media::CdmConfig&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InterfaceFactory::kCreateCdm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateCdm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_config)::BaseType> cdm_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmConfigDataView>(
    in_cdm_config,
    cdm_config_fragment);

  params->cdm_config.Set(
      cdm_config_fragment.is_null() ? nullptr : cdm_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cdm_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cdm_config in InterfaceFactory.CreateCdm request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateCdm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InterfaceFactory_CreateCdm_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class InterfaceFactory_CreateCdm_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InterfaceFactory::CreateCdmCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InterfaceFactory_CreateCdm_ProxyToResponder> proxy(
        new InterfaceFactory_CreateCdm_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InterfaceFactory_CreateCdm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InterfaceFactory_CreateCdm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InterfaceFactory_CreateCdm_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "InterfaceFactory::CreateCdmCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> in_cdm, ::media::mojom::CdmContextPtr in_cdm_context, ::media::CreateCdmStatus in_status);
};

bool InterfaceFactory_CreateCdm_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InterfaceFactory_CreateCdm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InterfaceFactory_CreateCdm_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InterfaceFactory.4
  bool success = true;
  ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> p_cdm{};
  ::media::mojom::CdmContextPtr p_cdm_context{};
  ::media::CreateCdmStatus p_status{};
  InterfaceFactory_CreateCdm_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_cdm =
        input_data_view.TakeCdm<decltype(p_cdm)>();
  }
  if (success && !input_data_view.ReadCdmContext(&p_cdm_context))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InterfaceFactory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cdm), 
std::move(p_cdm_context), 
std::move(p_status));
  }
  return true;
}

void InterfaceFactory_CreateCdm_ProxyToResponder::Run(
    ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> in_cdm, ::media::mojom::CdmContextPtr in_cdm_context, ::media::CreateCdmStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::InterfaceFactory::CreateCdm", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm"), in_cdm,
                        "<value of type ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_context"), in_cdm_context,
                        "<value of type ::media::mojom::CdmContextPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::CreateCdmStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InterfaceFactory::kCreateCdm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::InterfaceFactory_CreateCdm_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::ContentDecryptionModuleInterfaceBase>>(
    in_cdm,
    &params->cdm,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_context)::BaseType> cdm_context_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CdmContextDataView>(
    in_cdm_context,
    cdm_context_fragment);

  params->cdm_context.Set(
      cdm_context_fragment.is_null() ? nullptr : cdm_context_fragment.data());

  
  mojo::internal::Serialize<::media::mojom::CreateCdmStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceFactory::Name_);
  message.set_method_name("CreateCdm");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InterfaceFactoryStubDispatch::Accept(
    InterfaceFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InterfaceFactory>(message->header()->name)) {
    case messages::InterfaceFactory::kCreateAudioDecoder: {
      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateAudioDecoder_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateAudioDecoder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for InterfaceFactory.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioDecoder> p_audio_decoder{};
      InterfaceFactory_CreateAudioDecoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_audio_decoder =
            input_data_view.TakeAudioDecoder<decltype(p_audio_decoder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAudioDecoder(        
        std::move(p_audio_decoder));
      return true;
    }
    case messages::InterfaceFactory::kCreateVideoDecoder: {
      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateVideoDecoder_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateVideoDecoder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for InterfaceFactory.1
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoDecoder> p_video_decoder{};
      ::mojo::PendingRemote<::media::mojom::VideoDecoder> p_dst_video_decoder{};
      InterfaceFactory_CreateVideoDecoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_video_decoder =
            input_data_view.TakeVideoDecoder<decltype(p_video_decoder)>();
      }
      if (success) {
        p_dst_video_decoder =
            input_data_view.TakeDstVideoDecoder<decltype(p_dst_video_decoder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoDecoder(        
        std::move(p_video_decoder), 
        std::move(p_dst_video_decoder));
      return true;
    }
    case messages::InterfaceFactory::kCreateAudioEncoder: {
      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateAudioEncoder_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateAudioEncoder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for InterfaceFactory.2
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioEncoder> p_audio_encoder{};
      InterfaceFactory_CreateAudioEncoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_audio_encoder =
            input_data_view.TakeAudioEncoder<decltype(p_audio_encoder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAudioEncoder(        
        std::move(p_audio_encoder));
      return true;
    }
    case messages::InterfaceFactory::kCreateDefaultRenderer: {
      DCHECK(message->is_serialized());
      internal::InterfaceFactory_CreateDefaultRenderer_Params_Data* params =
          reinterpret_cast<internal::InterfaceFactory_CreateDefaultRenderer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for InterfaceFactory.3
      bool success = true;
      std::string p_audio_device_id{};
      ::mojo::PendingReceiver<::media::mojom::Renderer> p_renderer{};
      InterfaceFactory_CreateDefaultRenderer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAudioDeviceId(&p_audio_device_id))
        success = false;
      if (success) {
        p_renderer =
            input_data_view.TakeRenderer<decltype(p_renderer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDefaultRenderer(        
        std::move(p_audio_device_id), 
        std::move(p_renderer));
      return true;
    }
    case messages::InterfaceFactory::kCreateCdm: {
      break;
    }
  }
  return false;
}

// static
bool InterfaceFactoryStubDispatch::AcceptWithResponder(
    InterfaceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InterfaceFactory>(message->header()->name)) {
    case messages::InterfaceFactory::kCreateAudioDecoder: {
      break;
    }
    case messages::InterfaceFactory::kCreateVideoDecoder: {
      break;
    }
    case messages::InterfaceFactory::kCreateAudioEncoder: {
      break;
    }
    case messages::InterfaceFactory::kCreateDefaultRenderer: {
      break;
    }
    case messages::InterfaceFactory::kCreateCdm: {
      internal::InterfaceFactory_CreateCdm_Params_Data* params =
          reinterpret_cast<
              internal::InterfaceFactory_CreateCdm_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InterfaceFactory.4
      bool success = true;
      ::media::CdmConfig p_cdm_config{};
      InterfaceFactory_CreateCdm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCdmConfig(&p_cdm_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceFactory::Name_, 4, false);
        return false;
      }
      auto callback =
          InterfaceFactory_CreateCdm_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdm(        
        std::move(p_cdm_config), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kInterfaceFactoryValidationInfo[] = {
    { &internal::InterfaceFactory_CreateAudioDecoder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::InterfaceFactory_CreateVideoDecoder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::InterfaceFactory_CreateAudioEncoder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::InterfaceFactory_CreateDefaultRenderer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::InterfaceFactory_CreateCdm_Params_Data::Validate,
     &internal::InterfaceFactory_CreateCdm_ResponseParams_Data::Validate},
};

bool InterfaceFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::InterfaceFactory::Name_,
    kInterfaceFactoryValidationInfo);
}

bool InterfaceFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::InterfaceFactory::Name_,
    kInterfaceFactoryValidationInfo);
}


}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void InterfaceFactoryInterceptorForTesting::CreateAudioDecoder(::mojo::PendingReceiver<::media::mojom::AudioDecoder> audio_decoder) {
  GetForwardingInterface()->CreateAudioDecoder(
    std::move(audio_decoder)
    );
}
void InterfaceFactoryInterceptorForTesting::CreateVideoDecoder(::mojo::PendingReceiver<::media::mojom::VideoDecoder> video_decoder, ::mojo::PendingRemote<::media::mojom::VideoDecoder> dst_video_decoder) {
  GetForwardingInterface()->CreateVideoDecoder(
    std::move(video_decoder)
    , 
    std::move(dst_video_decoder)
    );
}
void InterfaceFactoryInterceptorForTesting::CreateAudioEncoder(::mojo::PendingReceiver<::media::mojom::AudioEncoder> audio_encoder) {
  GetForwardingInterface()->CreateAudioEncoder(
    std::move(audio_encoder)
    );
}
void InterfaceFactoryInterceptorForTesting::CreateDefaultRenderer(const std::string& audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> renderer) {
  GetForwardingInterface()->CreateDefaultRenderer(
    std::move(audio_device_id)
    , 
    std::move(renderer)
    );
}
void InterfaceFactoryInterceptorForTesting::CreateCdm(const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) {
  GetForwardingInterface()->CreateCdm(
    std::move(cdm_config)
    , std::move(callback));
}
InterfaceFactoryAsyncWaiter::InterfaceFactoryAsyncWaiter(
    InterfaceFactory* proxy) : proxy_(proxy) {}

InterfaceFactoryAsyncWaiter::~InterfaceFactoryAsyncWaiter() = default;


void InterfaceFactoryAsyncWaiter::CreateCdm(
    const ::media::CdmConfig& cdm_config, ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>* out_cdm, ::media::mojom::CdmContextPtr* out_cdm_context, ::media::CreateCdmStatus* out_status) {
  base::RunLoop loop;
  proxy_->CreateCdm(
      std::move(cdm_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>* out_cdm
,
             ::media::mojom::CdmContextPtr* out_cdm_context
,
             ::media::CreateCdmStatus* out_status
,
             ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> cdm,
             ::media::mojom::CdmContextPtr cdm_context,
             ::media::CreateCdmStatus status) {*out_cdm = std::move(cdm);*out_cdm_context = std::move(cdm_context);*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_cdm,
          out_cdm_context,
          out_status));
  loop.Run();
}








}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif