// media/mojo/mojom/display_media_information.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/display_media_information.mojom-shared-internal.h"
#include "media/mojo/mojom/capture_handle.mojom-shared.h"




#include "media/mojo/mojom/display_media_information.mojom-data-view.h"




namespace std {

template <>
struct hash<::media::mojom::DisplayCaptureSurfaceType>
    : public mojo::internal::EnumHashImpl<::media::mojom::DisplayCaptureSurfaceType> {};

template <>
struct hash<::media::mojom::CursorCaptureType>
    : public mojo::internal::EnumHashImpl<::media::mojom::CursorCaptureType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DisplayCaptureSurfaceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::DisplayCaptureSurfaceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::DisplayCaptureSurfaceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CursorCaptureType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CursorCaptureType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CursorCaptureType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DisplayMediaInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DisplayMediaInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DisplayMediaInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::DisplayCaptureSurfaceType>(
      Traits::display_surface(input),
      &fragment->display_surface);

    fragment->logical_surface = Traits::logical_surface(input);

    
    mojo::internal::Serialize<::media::mojom::CursorCaptureType>(
      Traits::cursor(input),
      &fragment->cursor);

    decltype(Traits::capture_handle(input)) in_capture_handle = Traits::capture_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capture_handle)::BaseType> capture_handle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::CaptureHandleDataView>(
      in_capture_handle,
      capture_handle_fragment);

    fragment->capture_handle.Set(
        capture_handle_fragment.is_null() ? nullptr : capture_handle_fragment.data());

    fragment->initial_zoom_level = Traits::initial_zoom_level(input);
  }

  static bool Deserialize(::media::mojom::internal::DisplayMediaInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::DisplayMediaInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void DisplayMediaInformationDataView::GetCaptureHandleDataView(
    ::media::mojom::CaptureHandleDataView* output) {
  auto pointer = data_->capture_handle.Get();
  *output = ::media::mojom::CaptureHandleDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::DisplayCaptureSurfaceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::DisplayCaptureSurfaceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CursorCaptureType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CursorCaptureType value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SHARED_H_