// media/mojo/mojom/display_media_information.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SHARED_INTERNAL_H_
#define MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "media/mojo/mojom/capture_handle.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace media::mojom {
namespace internal {
class DisplayMediaInformation_Data;

struct DisplayCaptureSurfaceType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CursorCaptureType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  DisplayMediaInformation_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t display_surface;
  uint8_t logical_surface : 1;
  uint8_t pad1_[3];
  int32_t cursor;
  int32_t initial_zoom_level;
  mojo::internal::Pointer<::media::mojom::internal::CaptureHandle_Data> capture_handle;

 private:
  friend class mojo::internal::MessageFragment<DisplayMediaInformation_Data>;

  DisplayMediaInformation_Data();
  ~DisplayMediaInformation_Data() = delete;
};
static_assert(sizeof(DisplayMediaInformation_Data) == 32,
              "Bad sizeof(DisplayMediaInformation_Data)");
// Used by DisplayMediaInformation::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DisplayMediaInformation_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DisplayMediaInformation_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DisplayMediaInformation_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DisplayMediaInformation_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DisplayMediaInformation_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SHARED_INTERNAL_H_