// media/mojo/mojom/display_media_information.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/display_media_information.mojom-shared-internal.h"
#include "media/mojo/mojom/capture_handle.mojom-shared.h"

#include "media/mojo/mojom/display_media_information.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::DisplayCaptureSurfaceType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::CursorCaptureType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DisplayMediaInformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DisplayMediaInformationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DisplayMediaInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::DisplayCaptureSurfaceType>(
        Traits::display_surface(input),
        &fragment->display_surface);

      fragment->logical_surface = Traits::logical_surface(input);

      
      mojo::internal::Serialize<::media::mojom::CursorCaptureType>(
        Traits::cursor(input),
        &fragment->cursor);

      decltype(Traits::capture_handle(input)) in_capture_handle = Traits::capture_handle(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capture_handle)::BaseType> capture_handle_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::CaptureHandleDataView, send_validation>(
        in_capture_handle,
        capture_handle_fragment);

      fragment->capture_handle.Set(
          capture_handle_fragment.is_null() ? nullptr : capture_handle_fragment.data());

      fragment->initial_zoom_level = Traits::initial_zoom_level(input);
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_SEND_VALIDATION_H_