// media/mojo/mojom/display_media_information.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/display_media_information.mojom-shared-internal.h"
#include "media/mojo/mojom/capture_handle.mojom-shared.h"


namespace media::mojom {
class DisplayMediaInformationDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::DisplayMediaInformationDataView> {
  using Data = ::media::mojom::internal::DisplayMediaInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class DisplayCaptureSurfaceType : int32_t {
  
  MONITOR = 0,
  
  WINDOW = 1,
  
  BROWSER = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DisplayCaptureSurfaceType value);
inline bool IsKnownEnumValue(DisplayCaptureSurfaceType value) {
  return internal::DisplayCaptureSurfaceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CursorCaptureType : int32_t {
  
  NEVER = 0,
  
  ALWAYS = 1,
  
  MOTION = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CursorCaptureType value);
inline bool IsKnownEnumValue(CursorCaptureType value) {
  return internal::CursorCaptureType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DisplayMediaInformationDataView {
 public:
  DisplayMediaInformationDataView() = default;

  DisplayMediaInformationDataView(
      internal::DisplayMediaInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDisplaySurface(UserType* output) const {
    auto data_value = data_->display_surface;
    return mojo::internal::Deserialize<::media::mojom::DisplayCaptureSurfaceType>(
        data_value, output);
  }
  DisplayCaptureSurfaceType display_surface() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::DisplayCaptureSurfaceType>(data_->display_surface));
  }
  bool logical_surface() const {
    return data_->logical_surface;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCursor(UserType* output) const {
    auto data_value = data_->cursor;
    return mojo::internal::Deserialize<::media::mojom::CursorCaptureType>(
        data_value, output);
  }
  CursorCaptureType cursor() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CursorCaptureType>(data_->cursor));
  }
  inline void GetCaptureHandleDataView(
      ::media::mojom::CaptureHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CaptureHandleDataView, UserType>(),
    "Attempting to read the optional `capture_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCaptureHandle` instead "
    "of `ReadCaptureHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->capture_handle.Get();
    return mojo::internal::Deserialize<::media::mojom::CaptureHandleDataView>(
        pointer, output, message_);
  }
  int32_t initial_zoom_level() const {
    return data_->initial_zoom_level;
  }
 private:
  internal::DisplayMediaInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_DATA_VIEW_H_