// media/mojo/mojom/demuxer_stream.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DEMUXER_STREAM_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_DEMUXER_STREAM_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  DemuxerStream_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<DemuxerStream_Initialize_Params_Data>;

  DemuxerStream_Initialize_Params_Data();
  ~DemuxerStream_Initialize_Params_Data() = delete;
};
static_assert(sizeof(DemuxerStream_Initialize_Params_Data) == 8,
              "Bad sizeof(DemuxerStream_Initialize_Params_Data)");
class  DemuxerStream_Initialize_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  mojo::internal::Handle_Data pipe;
  mojo::internal::Pointer<::media::mojom::internal::AudioDecoderConfig_Data> audio_config;
  mojo::internal::Pointer<::media::mojom::internal::VideoDecoderConfig_Data> video_config;

 private:
  friend class mojo::internal::MessageFragment<DemuxerStream_Initialize_ResponseParams_Data>;

  DemuxerStream_Initialize_ResponseParams_Data();
  ~DemuxerStream_Initialize_ResponseParams_Data() = delete;
};
static_assert(sizeof(DemuxerStream_Initialize_ResponseParams_Data) == 32,
              "Bad sizeof(DemuxerStream_Initialize_ResponseParams_Data)");
class  DemuxerStream_Read_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t count;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<DemuxerStream_Read_Params_Data>;

  DemuxerStream_Read_Params_Data();
  ~DemuxerStream_Read_Params_Data() = delete;
};
static_assert(sizeof(DemuxerStream_Read_Params_Data) == 16,
              "Bad sizeof(DemuxerStream_Read_Params_Data)");
class  DemuxerStream_Read_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<::media::mojom::internal::DecoderBuffer_Data>> batch_buffers;
  mojo::internal::Pointer<::media::mojom::internal::AudioDecoderConfig_Data> audio_config;
  mojo::internal::Pointer<::media::mojom::internal::VideoDecoderConfig_Data> video_config;

 private:
  friend class mojo::internal::MessageFragment<DemuxerStream_Read_ResponseParams_Data>;

  DemuxerStream_Read_ResponseParams_Data();
  ~DemuxerStream_Read_ResponseParams_Data() = delete;
};
static_assert(sizeof(DemuxerStream_Read_ResponseParams_Data) == 40,
              "Bad sizeof(DemuxerStream_Read_ResponseParams_Data)");
class  DemuxerStream_EnableBitstreamConverter_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<DemuxerStream_EnableBitstreamConverter_Params_Data>;

  DemuxerStream_EnableBitstreamConverter_Params_Data();
  ~DemuxerStream_EnableBitstreamConverter_Params_Data() = delete;
};
static_assert(sizeof(DemuxerStream_EnableBitstreamConverter_Params_Data) == 8,
              "Bad sizeof(DemuxerStream_EnableBitstreamConverter_Params_Data)");

}  // namespace internal


class DemuxerStream_Initialize_ParamsDataView {
 public:
  DemuxerStream_Initialize_ParamsDataView() = default;

  DemuxerStream_Initialize_ParamsDataView(
      internal::DemuxerStream_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::DemuxerStream_Initialize_Params_Data* data_ = nullptr;
};


class DemuxerStream_Initialize_ResponseParamsDataView {
 public:
  DemuxerStream_Initialize_ResponseParamsDataView() = default;

  DemuxerStream_Initialize_ResponseParamsDataView(
      internal::DemuxerStream_Initialize_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media::mojom::DemuxerStream_Type>(
        data_value, output);
  }
  DemuxerStream_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::DemuxerStream_Type>(data_->type));
  }
  mojo::ScopedDataPipeConsumerHandle TakePipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetAudioConfigDataView(
      ::media::mojom::AudioDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::AudioDecoderConfigDataView, UserType>(),
    "Attempting to read the optional `audio_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioConfig` instead "
    "of `ReadAudioConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->audio_config.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderConfigDataView>(
        pointer, output, message_);
  }
  inline void GetVideoConfigDataView(
      ::media::mojom::VideoDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::VideoDecoderConfigDataView, UserType>(),
    "Attempting to read the optional `video_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVideoConfig` instead "
    "of `ReadVideoConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->video_config.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::DemuxerStream_Initialize_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DemuxerStream_Read_ParamsDataView {
 public:
  DemuxerStream_Read_ParamsDataView() = default;

  DemuxerStream_Read_ParamsDataView(
      internal::DemuxerStream_Read_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t count() const {
    return data_->count;
  }
 private:
  internal::DemuxerStream_Read_Params_Data* data_ = nullptr;
};


class DemuxerStream_Read_ResponseParamsDataView {
 public:
  DemuxerStream_Read_ResponseParamsDataView() = default;

  DemuxerStream_Read_ResponseParamsDataView(
      internal::DemuxerStream_Read_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::DemuxerStream_Status>(
        data_value, output);
  }
  DemuxerStream_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::DemuxerStream_Status>(data_->status));
  }
  inline void GetBatchBuffersDataView(
      mojo::ArrayDataView<::media::mojom::DecoderBufferDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBatchBuffers(UserType* output) {
    
    auto* pointer = data_->batch_buffers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::DecoderBufferDataView>>(
        pointer, output, message_);
  }
  inline void GetAudioConfigDataView(
      ::media::mojom::AudioDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::AudioDecoderConfigDataView, UserType>(),
    "Attempting to read the optional `audio_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAudioConfig` instead "
    "of `ReadAudioConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->audio_config.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderConfigDataView>(
        pointer, output, message_);
  }
  inline void GetVideoConfigDataView(
      ::media::mojom::VideoDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::VideoDecoderConfigDataView, UserType>(),
    "Attempting to read the optional `video_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVideoConfig` instead "
    "of `ReadVideoConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->video_config.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::DemuxerStream_Read_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DemuxerStream_EnableBitstreamConverter_ParamsDataView {
 public:
  DemuxerStream_EnableBitstreamConverter_ParamsDataView() = default;

  DemuxerStream_EnableBitstreamConverter_ParamsDataView(
      internal::DemuxerStream_EnableBitstreamConverter_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::DemuxerStream_EnableBitstreamConverter_Params_Data* data_ = nullptr;
};



inline void DemuxerStream_Initialize_ResponseParamsDataView::GetAudioConfigDataView(
    ::media::mojom::AudioDecoderConfigDataView* output) {
  auto pointer = data_->audio_config.Get();
  *output = ::media::mojom::AudioDecoderConfigDataView(pointer, message_);
}
inline void DemuxerStream_Initialize_ResponseParamsDataView::GetVideoConfigDataView(
    ::media::mojom::VideoDecoderConfigDataView* output) {
  auto pointer = data_->video_config.Get();
  *output = ::media::mojom::VideoDecoderConfigDataView(pointer, message_);
}




inline void DemuxerStream_Read_ResponseParamsDataView::GetBatchBuffersDataView(
    mojo::ArrayDataView<::media::mojom::DecoderBufferDataView>* output) {
  auto pointer = data_->batch_buffers.Get();
  *output = mojo::ArrayDataView<::media::mojom::DecoderBufferDataView>(pointer, message_);
}
inline void DemuxerStream_Read_ResponseParamsDataView::GetAudioConfigDataView(
    ::media::mojom::AudioDecoderConfigDataView* output) {
  auto pointer = data_->audio_config.Get();
  *output = ::media::mojom::AudioDecoderConfigDataView(pointer, message_);
}
inline void DemuxerStream_Read_ResponseParamsDataView::GetVideoConfigDataView(
    ::media::mojom::VideoDecoderConfigDataView* output) {
  auto pointer = data_->video_config.Get();
  *output = ::media::mojom::VideoDecoderConfigDataView(pointer, message_);
}





}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_DEMUXER_STREAM_MOJOM_PARAMS_DATA_H_