// media/mojo/mojom/decryptor.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DECRYPTOR_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_DECRYPTOR_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/decryptor.mojom.h"


namespace media::mojom {


class  DecryptorInterceptorForTesting : public Decryptor {
  virtual Decryptor* GetForwardingInterface() = 0;
  void Initialize(::mojo::ScopedDataPipeConsumerHandle audio_pipe, ::mojo::ScopedDataPipeConsumerHandle video_pipe, ::mojo::ScopedDataPipeConsumerHandle decrypt_pipe, ::mojo::ScopedDataPipeProducerHandle decrypted_pipe) override;
  void Decrypt(::media::Decryptor::StreamType stream_type, ::media::mojom::DecoderBufferPtr encrypted, DecryptCallback callback) override;
  void CancelDecrypt(::media::Decryptor::StreamType stream_type) override;
  void InitializeAudioDecoder(const ::media::AudioDecoderConfig& config, InitializeAudioDecoderCallback callback) override;
  void InitializeVideoDecoder(const ::media::VideoDecoderConfig& config, InitializeVideoDecoderCallback callback) override;
  void DecryptAndDecodeAudio(::media::mojom::DecoderBufferPtr encrypted, DecryptAndDecodeAudioCallback callback) override;
  void DecryptAndDecodeVideo(::media::mojom::DecoderBufferPtr encrypted, DecryptAndDecodeVideoCallback callback) override;
  void ResetDecoder(::media::Decryptor::StreamType stream_type) override;
  void DeinitializeDecoder(::media::Decryptor::StreamType stream_type) override;
};
class  DecryptorAsyncWaiter {
 public:
  explicit DecryptorAsyncWaiter(Decryptor* proxy);

  DecryptorAsyncWaiter(const DecryptorAsyncWaiter&) = delete;
  DecryptorAsyncWaiter& operator=(const DecryptorAsyncWaiter&) = delete;

  ~DecryptorAsyncWaiter();
  void Decrypt(
      ::media::Decryptor::StreamType stream_type, ::media::mojom::DecoderBufferPtr encrypted, ::media::Decryptor::Status* out_status, ::media::mojom::DecoderBufferPtr* out_buffer);
  
  void InitializeAudioDecoder(
      const ::media::AudioDecoderConfig& config, bool* out_success);
  bool InitializeAudioDecoder(const ::media::AudioDecoderConfig& config);
  void InitializeVideoDecoder(
      const ::media::VideoDecoderConfig& config, bool* out_success);
  bool InitializeVideoDecoder(const ::media::VideoDecoderConfig& config);
  void DecryptAndDecodeAudio(
      ::media::mojom::DecoderBufferPtr encrypted, ::media::Decryptor::Status* out_status, std::vector<::media::mojom::AudioBufferPtr>* out_audio_buffers);
  
  void DecryptAndDecodeVideo(
      ::media::mojom::DecoderBufferPtr encrypted, ::media::Decryptor::Status* out_status, ::scoped_refptr<::media::VideoFrame>* out_video_frame, ::mojo::PendingRemote<FrameResourceReleaser>* out_releaser);
  

 private:
  Decryptor* const proxy_;
};


class  FrameResourceReleaserInterceptorForTesting : public FrameResourceReleaser {
  virtual FrameResourceReleaser* GetForwardingInterface() = 0;
};
class  FrameResourceReleaserAsyncWaiter {
 public:
  explicit FrameResourceReleaserAsyncWaiter(FrameResourceReleaser* proxy);

  FrameResourceReleaserAsyncWaiter(const FrameResourceReleaserAsyncWaiter&) = delete;
  FrameResourceReleaserAsyncWaiter& operator=(const FrameResourceReleaserAsyncWaiter&) = delete;

  ~FrameResourceReleaserAsyncWaiter();

 private:
  FrameResourceReleaser* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_DECRYPTOR_MOJOM_TEST_UTILS_H_