// media/mojo/mojom/decryptor.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DECRYPTOR_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_DECRYPTOR_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  Decryptor_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data audio_pipe;
  mojo::internal::Handle_Data video_pipe;
  mojo::internal::Handle_Data decrypt_pipe;
  mojo::internal::Handle_Data decrypted_pipe;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_Initialize_Params_Data>;

  Decryptor_Initialize_Params_Data();
  ~Decryptor_Initialize_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_Initialize_Params_Data) == 24,
              "Bad sizeof(Decryptor_Initialize_Params_Data)");
class  Decryptor_Decrypt_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t stream_type;
  uint8_t pad0_[4];
  ::media::mojom::internal::DecoderBuffer_Data encrypted;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_Decrypt_Params_Data>;

  Decryptor_Decrypt_Params_Data();
  ~Decryptor_Decrypt_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_Decrypt_Params_Data) == 32,
              "Bad sizeof(Decryptor_Decrypt_Params_Data)");
class  Decryptor_Decrypt_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  ::media::mojom::internal::DecoderBuffer_Data buffer;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_Decrypt_ResponseParams_Data>;

  Decryptor_Decrypt_ResponseParams_Data();
  ~Decryptor_Decrypt_ResponseParams_Data() = delete;
};
static_assert(sizeof(Decryptor_Decrypt_ResponseParams_Data) == 32,
              "Bad sizeof(Decryptor_Decrypt_ResponseParams_Data)");
class  Decryptor_CancelDecrypt_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t stream_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Decryptor_CancelDecrypt_Params_Data>;

  Decryptor_CancelDecrypt_Params_Data();
  ~Decryptor_CancelDecrypt_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_CancelDecrypt_Params_Data) == 16,
              "Bad sizeof(Decryptor_CancelDecrypt_Params_Data)");
class  Decryptor_InitializeAudioDecoder_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::AudioDecoderConfig_Data> config;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_InitializeAudioDecoder_Params_Data>;

  Decryptor_InitializeAudioDecoder_Params_Data();
  ~Decryptor_InitializeAudioDecoder_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_InitializeAudioDecoder_Params_Data) == 16,
              "Bad sizeof(Decryptor_InitializeAudioDecoder_Params_Data)");
class  Decryptor_InitializeAudioDecoder_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Decryptor_InitializeAudioDecoder_ResponseParams_Data>;

  Decryptor_InitializeAudioDecoder_ResponseParams_Data();
  ~Decryptor_InitializeAudioDecoder_ResponseParams_Data() = delete;
};
static_assert(sizeof(Decryptor_InitializeAudioDecoder_ResponseParams_Data) == 16,
              "Bad sizeof(Decryptor_InitializeAudioDecoder_ResponseParams_Data)");
class  Decryptor_InitializeVideoDecoder_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoDecoderConfig_Data> config;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_InitializeVideoDecoder_Params_Data>;

  Decryptor_InitializeVideoDecoder_Params_Data();
  ~Decryptor_InitializeVideoDecoder_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_InitializeVideoDecoder_Params_Data) == 16,
              "Bad sizeof(Decryptor_InitializeVideoDecoder_Params_Data)");
class  Decryptor_InitializeVideoDecoder_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Decryptor_InitializeVideoDecoder_ResponseParams_Data>;

  Decryptor_InitializeVideoDecoder_ResponseParams_Data();
  ~Decryptor_InitializeVideoDecoder_ResponseParams_Data() = delete;
};
static_assert(sizeof(Decryptor_InitializeVideoDecoder_ResponseParams_Data) == 16,
              "Bad sizeof(Decryptor_InitializeVideoDecoder_ResponseParams_Data)");
class  Decryptor_DecryptAndDecodeAudio_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::media::mojom::internal::DecoderBuffer_Data encrypted;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_DecryptAndDecodeAudio_Params_Data>;

  Decryptor_DecryptAndDecodeAudio_Params_Data();
  ~Decryptor_DecryptAndDecodeAudio_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_DecryptAndDecodeAudio_Params_Data) == 24,
              "Bad sizeof(Decryptor_DecryptAndDecodeAudio_Params_Data)");
class  Decryptor_DecryptAndDecodeAudio_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::media::mojom::internal::AudioBuffer_Data>>> audio_buffers;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_DecryptAndDecodeAudio_ResponseParams_Data>;

  Decryptor_DecryptAndDecodeAudio_ResponseParams_Data();
  ~Decryptor_DecryptAndDecodeAudio_ResponseParams_Data() = delete;
};
static_assert(sizeof(Decryptor_DecryptAndDecodeAudio_ResponseParams_Data) == 24,
              "Bad sizeof(Decryptor_DecryptAndDecodeAudio_ResponseParams_Data)");
class  Decryptor_DecryptAndDecodeVideo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::media::mojom::internal::DecoderBuffer_Data encrypted;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_DecryptAndDecodeVideo_Params_Data>;

  Decryptor_DecryptAndDecodeVideo_Params_Data();
  ~Decryptor_DecryptAndDecodeVideo_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_DecryptAndDecodeVideo_Params_Data) == 24,
              "Bad sizeof(Decryptor_DecryptAndDecodeVideo_Params_Data)");
class  Decryptor_DecryptAndDecodeVideo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoFrame_Data> video_frame;
  mojo::internal::Interface_Data releaser;

 private:
  friend class mojo::internal::MessageFragment<Decryptor_DecryptAndDecodeVideo_ResponseParams_Data>;

  Decryptor_DecryptAndDecodeVideo_ResponseParams_Data();
  ~Decryptor_DecryptAndDecodeVideo_ResponseParams_Data() = delete;
};
static_assert(sizeof(Decryptor_DecryptAndDecodeVideo_ResponseParams_Data) == 32,
              "Bad sizeof(Decryptor_DecryptAndDecodeVideo_ResponseParams_Data)");
class  Decryptor_ResetDecoder_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t stream_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Decryptor_ResetDecoder_Params_Data>;

  Decryptor_ResetDecoder_Params_Data();
  ~Decryptor_ResetDecoder_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_ResetDecoder_Params_Data) == 16,
              "Bad sizeof(Decryptor_ResetDecoder_Params_Data)");
class  Decryptor_DeinitializeDecoder_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t stream_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Decryptor_DeinitializeDecoder_Params_Data>;

  Decryptor_DeinitializeDecoder_Params_Data();
  ~Decryptor_DeinitializeDecoder_Params_Data() = delete;
};
static_assert(sizeof(Decryptor_DeinitializeDecoder_Params_Data) == 16,
              "Bad sizeof(Decryptor_DeinitializeDecoder_Params_Data)");

}  // namespace internal


class Decryptor_Initialize_ParamsDataView {
 public:
  Decryptor_Initialize_ParamsDataView() = default;

  Decryptor_Initialize_ParamsDataView(
      internal::Decryptor_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedDataPipeConsumerHandle TakeAudioPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->audio_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeVideoPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->video_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeDecryptPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->decrypt_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeDecryptedPipe() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->decrypted_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Decryptor_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_Decrypt_ParamsDataView {
 public:
  Decryptor_Decrypt_ParamsDataView() = default;

  Decryptor_Decrypt_ParamsDataView(
      internal::Decryptor_Decrypt_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamType(UserType* output) const {
    auto data_value = data_->stream_type;
    return mojo::internal::Deserialize<::media::mojom::Decryptor_StreamType>(
        data_value, output);
  }
  Decryptor_StreamType stream_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::Decryptor_StreamType>(data_->stream_type));
  }
  inline void GetEncryptedDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncrypted(UserType* output) {
    
    auto* pointer = !data_->encrypted.is_null() ? &data_->encrypted : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::Decryptor_Decrypt_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_Decrypt_ResponseParamsDataView {
 public:
  Decryptor_Decrypt_ResponseParamsDataView() = default;

  Decryptor_Decrypt_ResponseParamsDataView(
      internal::Decryptor_Decrypt_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::Decryptor_Status>(
        data_value, output);
  }
  Decryptor_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::Decryptor_Status>(data_->status));
  }
  inline void GetBufferDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::DecoderBufferDataView, UserType>(),
    "Attempting to read the optional `buffer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBuffer` instead "
    "of `ReadBuffer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->buffer.is_null() ? &data_->buffer : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::Decryptor_Decrypt_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_CancelDecrypt_ParamsDataView {
 public:
  Decryptor_CancelDecrypt_ParamsDataView() = default;

  Decryptor_CancelDecrypt_ParamsDataView(
      internal::Decryptor_CancelDecrypt_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamType(UserType* output) const {
    auto data_value = data_->stream_type;
    return mojo::internal::Deserialize<::media::mojom::Decryptor_StreamType>(
        data_value, output);
  }
  Decryptor_StreamType stream_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::Decryptor_StreamType>(data_->stream_type));
  }
 private:
  internal::Decryptor_CancelDecrypt_Params_Data* data_ = nullptr;
};


class Decryptor_InitializeAudioDecoder_ParamsDataView {
 public:
  Decryptor_InitializeAudioDecoder_ParamsDataView() = default;

  Decryptor_InitializeAudioDecoder_ParamsDataView(
      internal::Decryptor_InitializeAudioDecoder_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ::media::mojom::AudioDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::Decryptor_InitializeAudioDecoder_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_InitializeAudioDecoder_ResponseParamsDataView {
 public:
  Decryptor_InitializeAudioDecoder_ResponseParamsDataView() = default;

  Decryptor_InitializeAudioDecoder_ResponseParamsDataView(
      internal::Decryptor_InitializeAudioDecoder_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Decryptor_InitializeAudioDecoder_ResponseParams_Data* data_ = nullptr;
};


class Decryptor_InitializeVideoDecoder_ParamsDataView {
 public:
  Decryptor_InitializeVideoDecoder_ParamsDataView() = default;

  Decryptor_InitializeVideoDecoder_ParamsDataView(
      internal::Decryptor_InitializeVideoDecoder_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ::media::mojom::VideoDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::Decryptor_InitializeVideoDecoder_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_InitializeVideoDecoder_ResponseParamsDataView {
 public:
  Decryptor_InitializeVideoDecoder_ResponseParamsDataView() = default;

  Decryptor_InitializeVideoDecoder_ResponseParamsDataView(
      internal::Decryptor_InitializeVideoDecoder_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Decryptor_InitializeVideoDecoder_ResponseParams_Data* data_ = nullptr;
};


class Decryptor_DecryptAndDecodeAudio_ParamsDataView {
 public:
  Decryptor_DecryptAndDecodeAudio_ParamsDataView() = default;

  Decryptor_DecryptAndDecodeAudio_ParamsDataView(
      internal::Decryptor_DecryptAndDecodeAudio_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncryptedDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncrypted(UserType* output) {
    
    auto* pointer = !data_->encrypted.is_null() ? &data_->encrypted : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::Decryptor_DecryptAndDecodeAudio_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_DecryptAndDecodeAudio_ResponseParamsDataView {
 public:
  Decryptor_DecryptAndDecodeAudio_ResponseParamsDataView() = default;

  Decryptor_DecryptAndDecodeAudio_ResponseParamsDataView(
      internal::Decryptor_DecryptAndDecodeAudio_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::Decryptor_Status>(
        data_value, output);
  }
  Decryptor_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::Decryptor_Status>(data_->status));
  }
  inline void GetAudioBuffersDataView(
      mojo::ArrayDataView<::media::mojom::AudioBufferDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioBuffers(UserType* output) {
    
    auto* pointer = data_->audio_buffers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::AudioBufferDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Decryptor_DecryptAndDecodeAudio_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_DecryptAndDecodeVideo_ParamsDataView {
 public:
  Decryptor_DecryptAndDecodeVideo_ParamsDataView() = default;

  Decryptor_DecryptAndDecodeVideo_ParamsDataView(
      internal::Decryptor_DecryptAndDecodeVideo_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncryptedDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncrypted(UserType* output) {
    
    auto* pointer = !data_->encrypted.is_null() ? &data_->encrypted : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::Decryptor_DecryptAndDecodeVideo_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_DecryptAndDecodeVideo_ResponseParamsDataView {
 public:
  Decryptor_DecryptAndDecodeVideo_ResponseParamsDataView() = default;

  Decryptor_DecryptAndDecodeVideo_ResponseParamsDataView(
      internal::Decryptor_DecryptAndDecodeVideo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::Decryptor_Status>(
        data_value, output);
  }
  Decryptor_Status status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::Decryptor_Status>(data_->status));
  }
  inline void GetVideoFrameDataView(
      ::media::mojom::VideoFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoFrame(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::VideoFrameDataView, UserType>(),
    "Attempting to read the optional `video_frame` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVideoFrame` instead "
    "of `ReadVideoFrame if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->video_frame.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReleaser() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::FrameResourceReleaserInterfaceBase>>(
            &data_->releaser, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Decryptor_DecryptAndDecodeVideo_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Decryptor_ResetDecoder_ParamsDataView {
 public:
  Decryptor_ResetDecoder_ParamsDataView() = default;

  Decryptor_ResetDecoder_ParamsDataView(
      internal::Decryptor_ResetDecoder_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamType(UserType* output) const {
    auto data_value = data_->stream_type;
    return mojo::internal::Deserialize<::media::mojom::Decryptor_StreamType>(
        data_value, output);
  }
  Decryptor_StreamType stream_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::Decryptor_StreamType>(data_->stream_type));
  }
 private:
  internal::Decryptor_ResetDecoder_Params_Data* data_ = nullptr;
};


class Decryptor_DeinitializeDecoder_ParamsDataView {
 public:
  Decryptor_DeinitializeDecoder_ParamsDataView() = default;

  Decryptor_DeinitializeDecoder_ParamsDataView(
      internal::Decryptor_DeinitializeDecoder_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStreamType(UserType* output) const {
    auto data_value = data_->stream_type;
    return mojo::internal::Deserialize<::media::mojom::Decryptor_StreamType>(
        data_value, output);
  }
  Decryptor_StreamType stream_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::Decryptor_StreamType>(data_->stream_type));
  }
 private:
  internal::Decryptor_DeinitializeDecoder_Params_Data* data_ = nullptr;
};



inline void Decryptor_Decrypt_ParamsDataView::GetEncryptedDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->encrypted;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}


inline void Decryptor_Decrypt_ResponseParamsDataView::GetBufferDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->buffer;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}




inline void Decryptor_InitializeAudioDecoder_ParamsDataView::GetConfigDataView(
    ::media::mojom::AudioDecoderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ::media::mojom::AudioDecoderConfigDataView(pointer, message_);
}




inline void Decryptor_InitializeVideoDecoder_ParamsDataView::GetConfigDataView(
    ::media::mojom::VideoDecoderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ::media::mojom::VideoDecoderConfigDataView(pointer, message_);
}




inline void Decryptor_DecryptAndDecodeAudio_ParamsDataView::GetEncryptedDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->encrypted;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}


inline void Decryptor_DecryptAndDecodeAudio_ResponseParamsDataView::GetAudioBuffersDataView(
    mojo::ArrayDataView<::media::mojom::AudioBufferDataView>* output) {
  auto pointer = data_->audio_buffers.Get();
  *output = mojo::ArrayDataView<::media::mojom::AudioBufferDataView>(pointer, message_);
}


inline void Decryptor_DecryptAndDecodeVideo_ParamsDataView::GetEncryptedDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->encrypted;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}


inline void Decryptor_DecryptAndDecodeVideo_ResponseParamsDataView::GetVideoFrameDataView(
    ::media::mojom::VideoFrameDataView* output) {
  auto pointer = data_->video_frame.Get();
  *output = ::media::mojom::VideoFrameDataView(pointer, message_);
}







}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_DECRYPTOR_MOJOM_PARAMS_DATA_H_