// media/mojo/mojom/content_decryption_module.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/content_decryption_module.mojom-shared-internal.h"
#include "media/mojo/mojom/decryptor.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "media/mojo/mojom/content_decryption_module.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::CdmKeyStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CdmConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key_system(input)) in_key_system = Traits::key_system(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_system)::BaseType> key_system_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_key_system,
        key_system_fragment);

      fragment->key_system.Set(
          key_system_fragment.is_null() ? nullptr : key_system_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_system.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_system in CdmConfig struct");

      fragment->allow_distinctive_identifier = Traits::allow_distinctive_identifier(input);

      fragment->allow_persistent_state = Traits::allow_persistent_state(input);

      fragment->use_hw_secure_codecs = Traits::use_hw_secure_codecs(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CdmPromiseResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmPromiseResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmPromiseResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->success = Traits::success(input);

      
      mojo::internal::Serialize<::media::mojom::CdmPromiseResult_Exception>(
        Traits::exception(input),
        &fragment->exception);

      fragment->system_code = Traits::system_code(input);

      decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->error_message)::BaseType> error_message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_error_message,
        error_message_fragment);

      fragment->error_message.Set(
          error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->error_message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_message in CdmPromiseResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CdmKeyInformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmKeyInformationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmKeyInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_id)::BaseType>
          key_id_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& key_id_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_key_id,
        key_id_fragment,
        &key_id_validate_params);

      fragment->key_id.Set(
          key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_id in CdmKeyInformation struct");

      
      mojo::internal::Serialize<::media::mojom::CdmKeyStatus>(
        Traits::status(input),
        &fragment->status);

      fragment->system_code = Traits::system_code(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CdmContextDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmContextDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cdm_id(input)) in_cdm_id = Traits::cdm_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cdm_id)::BaseType> cdm_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_cdm_id,
        cdm_id_fragment);

      fragment->cdm_id.Set(
          cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cdm_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cdm_id in CdmContext struct");

      decltype(Traits::decryptor(input)) in_decryptor = Traits::decryptor(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::DecryptorInterfaceBase>>(
        in_decryptor,
        &fragment->decryptor,
        &fragment.message());
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SEND_VALIDATION_H_