// media/mojo/mojom/content_decryption_module.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  ContentDecryptionModule_SetClient_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data client;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_SetClient_Params_Data>;

  ContentDecryptionModule_SetClient_Params_Data();
  ~ContentDecryptionModule_SetClient_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_SetClient_Params_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_SetClient_Params_Data)");
class  ContentDecryptionModule_SetServerCertificate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> certificate_data;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_SetServerCertificate_Params_Data>;

  ContentDecryptionModule_SetServerCertificate_Params_Data();
  ~ContentDecryptionModule_SetServerCertificate_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_SetServerCertificate_Params_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_SetServerCertificate_Params_Data)");
class  ContentDecryptionModule_SetServerCertificate_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmPromiseResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_SetServerCertificate_ResponseParams_Data>;

  ContentDecryptionModule_SetServerCertificate_ResponseParams_Data();
  ~ContentDecryptionModule_SetServerCertificate_ResponseParams_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_SetServerCertificate_ResponseParams_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_SetServerCertificate_ResponseParams_Data)");
class  ContentDecryptionModule_GetStatusForPolicy_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t min_hdcp_version;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_GetStatusForPolicy_Params_Data>;

  ContentDecryptionModule_GetStatusForPolicy_Params_Data();
  ~ContentDecryptionModule_GetStatusForPolicy_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_GetStatusForPolicy_Params_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_GetStatusForPolicy_Params_Data)");
class  ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmPromiseResult_Data> result;
  int32_t key_status;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data>;

  ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data();
  ~ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data) == 24,
              "Bad sizeof(ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data)");
class  ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t session_type;
  int32_t init_data_type;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> init_data;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data>;

  ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data();
  ~ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data) == 24,
              "Bad sizeof(ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data)");
class  ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmPromiseResult_Data> result;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data>;

  ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data();
  ~ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data) == 24,
              "Bad sizeof(ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data)");
class  ContentDecryptionModule_LoadSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t session_type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_LoadSession_Params_Data>;

  ContentDecryptionModule_LoadSession_Params_Data();
  ~ContentDecryptionModule_LoadSession_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_LoadSession_Params_Data) == 24,
              "Bad sizeof(ContentDecryptionModule_LoadSession_Params_Data)");
class  ContentDecryptionModule_LoadSession_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmPromiseResult_Data> result;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_LoadSession_ResponseParams_Data>;

  ContentDecryptionModule_LoadSession_ResponseParams_Data();
  ~ContentDecryptionModule_LoadSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_LoadSession_ResponseParams_Data) == 24,
              "Bad sizeof(ContentDecryptionModule_LoadSession_ResponseParams_Data)");
class  ContentDecryptionModule_UpdateSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> response;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_UpdateSession_Params_Data>;

  ContentDecryptionModule_UpdateSession_Params_Data();
  ~ContentDecryptionModule_UpdateSession_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_UpdateSession_Params_Data) == 24,
              "Bad sizeof(ContentDecryptionModule_UpdateSession_Params_Data)");
class  ContentDecryptionModule_UpdateSession_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmPromiseResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_UpdateSession_ResponseParams_Data>;

  ContentDecryptionModule_UpdateSession_ResponseParams_Data();
  ~ContentDecryptionModule_UpdateSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_UpdateSession_ResponseParams_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_UpdateSession_ResponseParams_Data)");
class  ContentDecryptionModule_CloseSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_CloseSession_Params_Data>;

  ContentDecryptionModule_CloseSession_Params_Data();
  ~ContentDecryptionModule_CloseSession_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_CloseSession_Params_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_CloseSession_Params_Data)");
class  ContentDecryptionModule_CloseSession_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmPromiseResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_CloseSession_ResponseParams_Data>;

  ContentDecryptionModule_CloseSession_ResponseParams_Data();
  ~ContentDecryptionModule_CloseSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_CloseSession_ResponseParams_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_CloseSession_ResponseParams_Data)");
class  ContentDecryptionModule_RemoveSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_RemoveSession_Params_Data>;

  ContentDecryptionModule_RemoveSession_Params_Data();
  ~ContentDecryptionModule_RemoveSession_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_RemoveSession_Params_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_RemoveSession_Params_Data)");
class  ContentDecryptionModule_RemoveSession_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmPromiseResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModule_RemoveSession_ResponseParams_Data>;

  ContentDecryptionModule_RemoveSession_ResponseParams_Data();
  ~ContentDecryptionModule_RemoveSession_ResponseParams_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModule_RemoveSession_ResponseParams_Data) == 16,
              "Bad sizeof(ContentDecryptionModule_RemoveSession_ResponseParams_Data)");
class  ContentDecryptionModuleClient_OnSessionMessage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;
  int32_t message_type;
  uint8_t pad1_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> message;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModuleClient_OnSessionMessage_Params_Data>;

  ContentDecryptionModuleClient_OnSessionMessage_Params_Data();
  ~ContentDecryptionModuleClient_OnSessionMessage_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModuleClient_OnSessionMessage_Params_Data) == 32,
              "Bad sizeof(ContentDecryptionModuleClient_OnSessionMessage_Params_Data)");
class  ContentDecryptionModuleClient_OnSessionClosed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModuleClient_OnSessionClosed_Params_Data>;

  ContentDecryptionModuleClient_OnSessionClosed_Params_Data();
  ~ContentDecryptionModuleClient_OnSessionClosed_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModuleClient_OnSessionClosed_Params_Data) == 24,
              "Bad sizeof(ContentDecryptionModuleClient_OnSessionClosed_Params_Data)");
class  ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;
  uint8_t has_additional_usable_key : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CdmKeyInformation_Data>>> keys_info;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data>;

  ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data();
  ~ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data) == 32,
              "Bad sizeof(ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data)");
class  ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> session_id;
  double new_expiry_time_sec;

 private:
  friend class mojo::internal::MessageFragment<ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data>;

  ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data();
  ~ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data() = delete;
};
static_assert(sizeof(ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data) == 24,
              "Bad sizeof(ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data)");
class  CdmFactory_CreateCdm_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CdmConfig_Data> cdm_config;

 private:
  friend class mojo::internal::MessageFragment<CdmFactory_CreateCdm_Params_Data>;

  CdmFactory_CreateCdm_Params_Data();
  ~CdmFactory_CreateCdm_Params_Data() = delete;
};
static_assert(sizeof(CdmFactory_CreateCdm_Params_Data) == 16,
              "Bad sizeof(CdmFactory_CreateCdm_Params_Data)");
class  CdmFactory_CreateCdm_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data cdm;
  mojo::internal::Pointer<internal::CdmContext_Data> cdm_context;
  int32_t status;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CdmFactory_CreateCdm_ResponseParams_Data>;

  CdmFactory_CreateCdm_ResponseParams_Data();
  ~CdmFactory_CreateCdm_ResponseParams_Data() = delete;
};
static_assert(sizeof(CdmFactory_CreateCdm_ResponseParams_Data) == 32,
              "Bad sizeof(CdmFactory_CreateCdm_ResponseParams_Data)");

}  // namespace internal


class ContentDecryptionModule_SetClient_ParamsDataView {
 public:
  ContentDecryptionModule_SetClient_ParamsDataView() = default;

  ContentDecryptionModule_SetClient_ParamsDataView(
      internal::ContentDecryptionModule_SetClient_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::ContentDecryptionModuleClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ContentDecryptionModule_SetClient_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_SetServerCertificate_ParamsDataView {
 public:
  ContentDecryptionModule_SetServerCertificate_ParamsDataView() = default;

  ContentDecryptionModule_SetServerCertificate_ParamsDataView(
      internal::ContentDecryptionModule_SetServerCertificate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCertificateDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertificateData(UserType* output) {
    
    auto* pointer = data_->certificate_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_SetServerCertificate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_SetServerCertificate_ResponseParamsDataView {
 public:
  ContentDecryptionModule_SetServerCertificate_ResponseParamsDataView() = default;

  ContentDecryptionModule_SetServerCertificate_ResponseParamsDataView(
      internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CdmPromiseResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_SetServerCertificate_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_GetStatusForPolicy_ParamsDataView {
 public:
  ContentDecryptionModule_GetStatusForPolicy_ParamsDataView() = default;

  ContentDecryptionModule_GetStatusForPolicy_ParamsDataView(
      internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMinHdcpVersion(UserType* output) const {
    auto data_value = data_->min_hdcp_version;
    return mojo::internal::Deserialize<::media::mojom::HdcpVersion>(
        data_value, output);
  }
  HdcpVersion min_hdcp_version() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::HdcpVersion>(data_->min_hdcp_version));
  }
 private:
  internal::ContentDecryptionModule_GetStatusForPolicy_Params_Data* data_ = nullptr;
};


class ContentDecryptionModule_GetStatusForPolicy_ResponseParamsDataView {
 public:
  ContentDecryptionModule_GetStatusForPolicy_ResponseParamsDataView() = default;

  ContentDecryptionModule_GetStatusForPolicy_ResponseParamsDataView(
      internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CdmPromiseResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResultDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadKeyStatus(UserType* output) const {
    auto data_value = data_->key_status;
    return mojo::internal::Deserialize<::media::mojom::CdmKeyStatus>(
        data_value, output);
  }
  CdmKeyStatus key_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmKeyStatus>(data_->key_status));
  }
 private:
  internal::ContentDecryptionModule_GetStatusForPolicy_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsDataView {
 public:
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsDataView() = default;

  ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsDataView(
      internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadSessionType(UserType* output) const {
    auto data_value = data_->session_type;
    return mojo::internal::Deserialize<::media::mojom::CdmSessionType>(
        data_value, output);
  }
  CdmSessionType session_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmSessionType>(data_->session_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitDataType(UserType* output) const {
    auto data_value = data_->init_data_type;
    return mojo::internal::Deserialize<::media::mojom::EmeInitDataType>(
        data_value, output);
  }
  EmeInitDataType init_data_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EmeInitDataType>(data_->init_data_type));
  }
  inline void GetInitDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitData(UserType* output) {
    
    auto* pointer = data_->init_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsDataView {
 public:
  ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsDataView() = default;

  ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsDataView(
      internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CdmPromiseResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResultDataView>(
        pointer, output, message_);
  }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_LoadSession_ParamsDataView {
 public:
  ContentDecryptionModule_LoadSession_ParamsDataView() = default;

  ContentDecryptionModule_LoadSession_ParamsDataView(
      internal::ContentDecryptionModule_LoadSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadSessionType(UserType* output) const {
    auto data_value = data_->session_type;
    return mojo::internal::Deserialize<::media::mojom::CdmSessionType>(
        data_value, output);
  }
  CdmSessionType session_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmSessionType>(data_->session_type));
  }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_LoadSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_LoadSession_ResponseParamsDataView {
 public:
  ContentDecryptionModule_LoadSession_ResponseParamsDataView() = default;

  ContentDecryptionModule_LoadSession_ResponseParamsDataView(
      internal::ContentDecryptionModule_LoadSession_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CdmPromiseResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResultDataView>(
        pointer, output, message_);
  }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_LoadSession_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_UpdateSession_ParamsDataView {
 public:
  ContentDecryptionModule_UpdateSession_ParamsDataView() = default;

  ContentDecryptionModule_UpdateSession_ParamsDataView(
      internal::ContentDecryptionModule_UpdateSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_UpdateSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_UpdateSession_ResponseParamsDataView {
 public:
  ContentDecryptionModule_UpdateSession_ResponseParamsDataView() = default;

  ContentDecryptionModule_UpdateSession_ResponseParamsDataView(
      internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CdmPromiseResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_UpdateSession_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_CloseSession_ParamsDataView {
 public:
  ContentDecryptionModule_CloseSession_ParamsDataView() = default;

  ContentDecryptionModule_CloseSession_ParamsDataView(
      internal::ContentDecryptionModule_CloseSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_CloseSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_CloseSession_ResponseParamsDataView {
 public:
  ContentDecryptionModule_CloseSession_ResponseParamsDataView() = default;

  ContentDecryptionModule_CloseSession_ResponseParamsDataView(
      internal::ContentDecryptionModule_CloseSession_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CdmPromiseResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_CloseSession_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_RemoveSession_ParamsDataView {
 public:
  ContentDecryptionModule_RemoveSession_ParamsDataView() = default;

  ContentDecryptionModule_RemoveSession_ParamsDataView(
      internal::ContentDecryptionModule_RemoveSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_RemoveSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModule_RemoveSession_ResponseParamsDataView {
 public:
  ContentDecryptionModule_RemoveSession_ResponseParamsDataView() = default;

  ContentDecryptionModule_RemoveSession_ResponseParamsDataView(
      internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      CdmPromiseResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModule_RemoveSession_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModuleClient_OnSessionMessage_ParamsDataView {
 public:
  ContentDecryptionModuleClient_OnSessionMessage_ParamsDataView() = default;

  ContentDecryptionModuleClient_OnSessionMessage_ParamsDataView(
      internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMessageType(UserType* output) const {
    auto data_value = data_->message_type;
    return mojo::internal::Deserialize<::media::mojom::CdmMessageType>(
        data_value, output);
  }
  CdmMessageType message_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmMessageType>(data_->message_type));
  }
  inline void GetMessageDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModuleClient_OnSessionMessage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModuleClient_OnSessionClosed_ParamsDataView {
 public:
  ContentDecryptionModuleClient_OnSessionClosed_ParamsDataView() = default;

  ContentDecryptionModuleClient_OnSessionClosed_ParamsDataView(
      internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::CdmSessionClosedReason>(
        data_value, output);
  }
  ::media::mojom::CdmSessionClosedReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmSessionClosedReason>(data_->reason));
  }
 private:
  internal::ContentDecryptionModuleClient_OnSessionClosed_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModuleClient_OnSessionKeysChange_ParamsDataView {
 public:
  ContentDecryptionModuleClient_OnSessionKeysChange_ParamsDataView() = default;

  ContentDecryptionModuleClient_OnSessionKeysChange_ParamsDataView(
      internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_additional_usable_key() const {
    return data_->has_additional_usable_key;
  }
  inline void GetKeysInfoDataView(
      mojo::ArrayDataView<CdmKeyInformationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeysInfo(UserType* output) {
    
    auto* pointer = data_->keys_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::CdmKeyInformationDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ContentDecryptionModuleClient_OnSessionKeysChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsDataView {
 public:
  ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsDataView() = default;

  ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsDataView(
      internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double new_expiry_time_sec() const {
    return data_->new_expiry_time_sec;
  }
 private:
  internal::ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmFactory_CreateCdm_ParamsDataView {
 public:
  CdmFactory_CreateCdm_ParamsDataView() = default;

  CdmFactory_CreateCdm_ParamsDataView(
      internal::CdmFactory_CreateCdm_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCdmConfigDataView(
      CdmConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCdmConfig(UserType* output) {
    
    auto* pointer = data_->cdm_config.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::CdmFactory_CreateCdm_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmFactory_CreateCdm_ResponseParamsDataView {
 public:
  CdmFactory_CreateCdm_ResponseParamsDataView() = default;

  CdmFactory_CreateCdm_ResponseParamsDataView(
      internal::CdmFactory_CreateCdm_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeCdm() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::ContentDecryptionModuleInterfaceBase>>(
            &data_->cdm, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetCdmContextDataView(
      CdmContextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCdmContext(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::CdmContextDataView, UserType>(),
    "Attempting to read the optional `cdm_context` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCdmContext` instead "
    "of `ReadCdmContext if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cdm_context.Get();
    return mojo::internal::Deserialize<::media::mojom::CdmContextDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::CreateCdmStatus>(
        data_value, output);
  }
  ::media::mojom::CreateCdmStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CreateCdmStatus>(data_->status));
  }
 private:
  internal::CdmFactory_CreateCdm_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void ContentDecryptionModule_SetServerCertificate_ParamsDataView::GetCertificateDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->certificate_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void ContentDecryptionModule_SetServerCertificate_ResponseParamsDataView::GetResultDataView(
    CdmPromiseResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = CdmPromiseResultDataView(pointer, message_);
}




inline void ContentDecryptionModule_GetStatusForPolicy_ResponseParamsDataView::GetResultDataView(
    CdmPromiseResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = CdmPromiseResultDataView(pointer, message_);
}


inline void ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsDataView::GetInitDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->init_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsDataView::GetResultDataView(
    CdmPromiseResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = CdmPromiseResultDataView(pointer, message_);
}
inline void ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentDecryptionModule_LoadSession_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentDecryptionModule_LoadSession_ResponseParamsDataView::GetResultDataView(
    CdmPromiseResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = CdmPromiseResultDataView(pointer, message_);
}
inline void ContentDecryptionModule_LoadSession_ResponseParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentDecryptionModule_UpdateSession_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentDecryptionModule_UpdateSession_ParamsDataView::GetResponseDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->response.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void ContentDecryptionModule_UpdateSession_ResponseParamsDataView::GetResultDataView(
    CdmPromiseResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = CdmPromiseResultDataView(pointer, message_);
}


inline void ContentDecryptionModule_CloseSession_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentDecryptionModule_CloseSession_ResponseParamsDataView::GetResultDataView(
    CdmPromiseResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = CdmPromiseResultDataView(pointer, message_);
}


inline void ContentDecryptionModule_RemoveSession_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentDecryptionModule_RemoveSession_ResponseParamsDataView::GetResultDataView(
    CdmPromiseResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = CdmPromiseResultDataView(pointer, message_);
}


inline void ContentDecryptionModuleClient_OnSessionMessage_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentDecryptionModuleClient_OnSessionMessage_ParamsDataView::GetMessageDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->message.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void ContentDecryptionModuleClient_OnSessionClosed_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentDecryptionModuleClient_OnSessionKeysChange_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentDecryptionModuleClient_OnSessionKeysChange_ParamsDataView::GetKeysInfoDataView(
    mojo::ArrayDataView<CdmKeyInformationDataView>* output) {
  auto pointer = data_->keys_info.Get();
  *output = mojo::ArrayDataView<CdmKeyInformationDataView>(pointer, message_);
}


inline void ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CdmFactory_CreateCdm_ParamsDataView::GetCdmConfigDataView(
    CdmConfigDataView* output) {
  auto pointer = data_->cdm_config.Get();
  *output = CdmConfigDataView(pointer, message_);
}


inline void CdmFactory_CreateCdm_ResponseParamsDataView::GetCdmContextDataView(
    CdmContextDataView* output) {
  auto pointer = data_->cdm_context.Get();
  *output = CdmContextDataView(pointer, message_);
}



}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_PARAMS_DATA_H_