// media/mojo/mojom/content_decryption_module.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/content_decryption_module.mojom-shared-internal.h"
#include "media/mojo/mojom/decryptor.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"


namespace media::mojom {
class CdmConfigDataView;

class CdmPromiseResultDataView;

class CdmKeyInformationDataView;

class CdmContextDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::CdmConfigDataView> {
  using Data = ::media::mojom::internal::CdmConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmPromiseResultDataView> {
  using Data = ::media::mojom::internal::CdmPromiseResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmKeyInformationDataView> {
  using Data = ::media::mojom::internal::CdmKeyInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmContextDataView> {
  using Data = ::media::mojom::internal::CdmContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
using EmeInitDataType = mojo::NativeEnum;
using CdmSessionType = mojo::NativeEnum;
using CdmMessageType = mojo::NativeEnum;


enum class CdmKeyStatus : int32_t {
  
  USABLE = 0,
  
  INTERNAL_ERROR = 1,
  
  EXPIRED = 2,
  
  OUTPUT_RESTRICTED = 3,
  
  OUTPUT_DOWNSCALED = 4,
  
  KEY_STATUS_PENDING = 5,
  
  RELEASED = 6,
  
  USABLE_IN_FUTURE = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, CdmKeyStatus value);
inline bool IsKnownEnumValue(CdmKeyStatus value) {
  return internal::CdmKeyStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
using HdcpVersion = mojo::NativeEnum;
using CdmPromiseResult_Exception = mojo::NativeEnum;
// Interface base classes. They are used for type safety check.
class ContentDecryptionModuleInterfaceBase {};

using ContentDecryptionModulePtrDataView =
    mojo::InterfacePtrDataView<ContentDecryptionModuleInterfaceBase>;
using ContentDecryptionModuleRequestDataView =
    mojo::InterfaceRequestDataView<ContentDecryptionModuleInterfaceBase>;
using ContentDecryptionModuleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContentDecryptionModuleInterfaceBase>;
using ContentDecryptionModuleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContentDecryptionModuleInterfaceBase>;
class ContentDecryptionModuleClientInterfaceBase {};

using ContentDecryptionModuleClientPtrDataView =
    mojo::InterfacePtrDataView<ContentDecryptionModuleClientInterfaceBase>;
using ContentDecryptionModuleClientRequestDataView =
    mojo::InterfaceRequestDataView<ContentDecryptionModuleClientInterfaceBase>;
using ContentDecryptionModuleClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContentDecryptionModuleClientInterfaceBase>;
using ContentDecryptionModuleClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContentDecryptionModuleClientInterfaceBase>;
class CdmFactoryInterfaceBase {};

using CdmFactoryPtrDataView =
    mojo::InterfacePtrDataView<CdmFactoryInterfaceBase>;
using CdmFactoryRequestDataView =
    mojo::InterfaceRequestDataView<CdmFactoryInterfaceBase>;
using CdmFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CdmFactoryInterfaceBase>;
using CdmFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CdmFactoryInterfaceBase>;


class CdmConfigDataView {
 public:
  CdmConfigDataView() = default;

  CdmConfigDataView(
      internal::CdmConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeySystemDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeySystem(UserType* output) {
    
    auto* pointer = data_->key_system.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool allow_distinctive_identifier() const {
    return data_->allow_distinctive_identifier;
  }
  bool allow_persistent_state() const {
    return data_->allow_persistent_state;
  }
  bool use_hw_secure_codecs() const {
    return data_->use_hw_secure_codecs;
  }
 private:
  internal::CdmConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmPromiseResultDataView {
 public:
  CdmPromiseResultDataView() = default;

  CdmPromiseResultDataView(
      internal::CdmPromiseResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadException(UserType* output) const {
    auto data_value = data_->exception;
    return mojo::internal::Deserialize<::media::mojom::CdmPromiseResult_Exception>(
        data_value, output);
  }
  CdmPromiseResult_Exception exception() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmPromiseResult_Exception>(data_->exception));
  }
  uint32_t system_code() const {
    return data_->system_code;
  }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CdmPromiseResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmKeyInformationDataView {
 public:
  CdmKeyInformationDataView() = default;

  CdmKeyInformationDataView(
      internal::CdmKeyInformation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyId(UserType* output) {
    
    auto* pointer = data_->key_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::media::mojom::CdmKeyStatus>(
        data_value, output);
  }
  CdmKeyStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CdmKeyStatus>(data_->status));
  }
  uint32_t system_code() const {
    return data_->system_code;
  }
 private:
  internal::CdmKeyInformation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmContextDataView {
 public:
  CdmContextDataView() = default;

  CdmContextDataView(
      internal::CdmContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCdmIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCdmId(UserType* output) {
    
    auto* pointer = data_->cdm_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeDecryptor() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::DecryptorInterfaceBase>>(
            &data_->decryptor, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CdmContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_DATA_VIEW_H_