// media/mojo/mojom/content_decryption_module.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_BLINK_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_BLINK_TEST_UTILS_H_

#include "media/mojo/mojom/content_decryption_module.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media::mojom::blink {


class BLINK_PLATFORM_EXPORT ContentDecryptionModuleInterceptorForTesting : public ContentDecryptionModule {
  virtual ContentDecryptionModule* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingAssociatedRemote<ContentDecryptionModuleClient> client) override;
  void SetServerCertificate(const ::blink::Vector<uint8_t>& certificate_data, SetServerCertificateCallback callback) override;
  void GetStatusForPolicy(HdcpVersion min_hdcp_version, GetStatusForPolicyCallback callback) override;
  void CreateSessionAndGenerateRequest(CdmSessionType session_type, EmeInitDataType init_data_type, const ::blink::Vector<uint8_t>& init_data, CreateSessionAndGenerateRequestCallback callback) override;
  void LoadSession(CdmSessionType session_type, const ::blink::String& session_id, LoadSessionCallback callback) override;
  void UpdateSession(const ::blink::String& session_id, const ::blink::Vector<uint8_t>& response, UpdateSessionCallback callback) override;
  void CloseSession(const ::blink::String& session_id, CloseSessionCallback callback) override;
  void RemoveSession(const ::blink::String& session_id, RemoveSessionCallback callback) override;
};
class BLINK_PLATFORM_EXPORT ContentDecryptionModuleAsyncWaiter {
 public:
  explicit ContentDecryptionModuleAsyncWaiter(ContentDecryptionModule* proxy);

  ContentDecryptionModuleAsyncWaiter(const ContentDecryptionModuleAsyncWaiter&) = delete;
  ContentDecryptionModuleAsyncWaiter& operator=(const ContentDecryptionModuleAsyncWaiter&) = delete;

  ~ContentDecryptionModuleAsyncWaiter();
  void SetServerCertificate(
      const ::blink::Vector<uint8_t>& certificate_data, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr SetServerCertificate(const ::blink::Vector<uint8_t>& certificate_data);
  void GetStatusForPolicy(
      HdcpVersion min_hdcp_version, CdmPromiseResultPtr* out_result, CdmKeyStatus* out_key_status);
  
  void CreateSessionAndGenerateRequest(
      CdmSessionType session_type, EmeInitDataType init_data_type, const ::blink::Vector<uint8_t>& init_data, CdmPromiseResultPtr* out_result, ::blink::String* out_session_id);
  
  void LoadSession(
      CdmSessionType session_type, const ::blink::String& session_id, CdmPromiseResultPtr* out_result, ::blink::String* out_session_id);
  
  void UpdateSession(
      const ::blink::String& session_id, const ::blink::Vector<uint8_t>& response, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr UpdateSession(const ::blink::String& session_id, const ::blink::Vector<uint8_t>& response);
  void CloseSession(
      const ::blink::String& session_id, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr CloseSession(const ::blink::String& session_id);
  void RemoveSession(
      const ::blink::String& session_id, CdmPromiseResultPtr* out_result);
  CdmPromiseResultPtr RemoveSession(const ::blink::String& session_id);

 private:
  ContentDecryptionModule* const proxy_;
};


class BLINK_PLATFORM_EXPORT ContentDecryptionModuleClientInterceptorForTesting : public ContentDecryptionModuleClient {
  virtual ContentDecryptionModuleClient* GetForwardingInterface() = 0;
  void OnSessionMessage(const ::blink::String& session_id, CdmMessageType message_type, const ::blink::Vector<uint8_t>& message) override;
  void OnSessionClosed(const ::blink::String& session_id, ::media::mojom::blink::CdmSessionClosedReason reason) override;
  void OnSessionKeysChange(const ::blink::String& session_id, bool has_additional_usable_key, ::blink::Vector<CdmKeyInformationPtr> keys_info) override;
  void OnSessionExpirationUpdate(const ::blink::String& session_id, double new_expiry_time_sec) override;
};
class BLINK_PLATFORM_EXPORT ContentDecryptionModuleClientAsyncWaiter {
 public:
  explicit ContentDecryptionModuleClientAsyncWaiter(ContentDecryptionModuleClient* proxy);

  ContentDecryptionModuleClientAsyncWaiter(const ContentDecryptionModuleClientAsyncWaiter&) = delete;
  ContentDecryptionModuleClientAsyncWaiter& operator=(const ContentDecryptionModuleClientAsyncWaiter&) = delete;

  ~ContentDecryptionModuleClientAsyncWaiter();

 private:
  ContentDecryptionModuleClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT CdmFactoryInterceptorForTesting : public CdmFactory {
  virtual CdmFactory* GetForwardingInterface() = 0;
  void CreateCdm(CdmConfigPtr cdm_config, CreateCdmCallback callback) override;
};
class BLINK_PLATFORM_EXPORT CdmFactoryAsyncWaiter {
 public:
  explicit CdmFactoryAsyncWaiter(CdmFactory* proxy);

  CdmFactoryAsyncWaiter(const CdmFactoryAsyncWaiter&) = delete;
  CdmFactoryAsyncWaiter& operator=(const CdmFactoryAsyncWaiter&) = delete;

  ~CdmFactoryAsyncWaiter();
  void CreateCdm(
      CdmConfigPtr cdm_config, ::mojo::PendingRemote<ContentDecryptionModule>* out_cdm, CdmContextPtr* out_cdm_context, ::media::mojom::blink::CreateCdmStatus* out_status);
  

 private:
  CdmFactory* const proxy_;
};




}  // media::mojom::blink

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_BLINK_TEST_UTILS_H_