// media/mojo/mojom/cdm_storage.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/cdm_storage.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');



  function CdmStorage_Open_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmStorage_Open_Params.prototype.initDefaults_ = function() {
    this.fileName = null;
  };
  CdmStorage_Open_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmStorage_Open_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmStorage_Open_Params.fileName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmStorage_Open_Params.encodedSize = codec.kStructHeaderSize + 8;

  CdmStorage_Open_Params.decode = function(decoder) {
    var packed;
    var val = new CdmStorage_Open_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fileName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CdmStorage_Open_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmStorage_Open_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.fileName);
  };
  function CdmStorage_Open_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmStorage_Open_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.cdmFile = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  CdmStorage_Open_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmStorage_Open_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmStorage_Open_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CdmStorage.Status);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmStorage_Open_ResponseParams.cdmFile
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 4, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmStorage_Open_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CdmStorage_Open_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmStorage_Open_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(CdmStorage.Status));
    val.cdmFile =
        decoder.decodeStruct(codec.NullableAssociatedInterfacePtrInfo);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CdmStorage_Open_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmStorage_Open_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.encodeStruct(codec.NullableAssociatedInterfacePtrInfo, val.cdmFile);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CdmFile_Read_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmFile_Read_Params.prototype.initDefaults_ = function() {
  };
  CdmFile_Read_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmFile_Read_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmFile_Read_Params.encodedSize = codec.kStructHeaderSize + 0;

  CdmFile_Read_Params.decode = function(decoder) {
    var packed;
    var val = new CdmFile_Read_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CdmFile_Read_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmFile_Read_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CdmFile_Read_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmFile_Read_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.data = null;
  };
  CdmFile_Read_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmFile_Read_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmFile_Read_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CdmFile.Status);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmFile_Read_ResponseParams.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmFile_Read_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CdmFile_Read_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmFile_Read_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(CdmFile.Status));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmFile_Read_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmFile_Read_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function CdmFile_Write_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmFile_Write_Params.prototype.initDefaults_ = function() {
    this.data = null;
  };
  CdmFile_Write_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmFile_Write_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmFile_Write_Params.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmFile_Write_Params.encodedSize = codec.kStructHeaderSize + 8;

  CdmFile_Write_Params.decode = function(decoder) {
    var packed;
    var val = new CdmFile_Write_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CdmFile_Write_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmFile_Write_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function CdmFile_Write_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CdmFile_Write_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  CdmFile_Write_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CdmFile_Write_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CdmFile_Write_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CdmFile.Status);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CdmFile_Write_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CdmFile_Write_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CdmFile_Write_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(CdmFile.Status));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CdmFile_Write_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CdmFile_Write_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kCdmStorage_Open_Name = 0;

  function CdmStoragePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CdmStorage,
                                                   handleOrPtrInfo);
  }

  function CdmStorageAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CdmStorage, associatedInterfacePtrInfo);
  }

  CdmStorageAssociatedPtr.prototype =
      Object.create(CdmStoragePtr.prototype);
  CdmStorageAssociatedPtr.prototype.constructor =
      CdmStorageAssociatedPtr;

  function CdmStorageProxy(receiver) {
    this.receiver_ = receiver;
  }
  CdmStoragePtr.prototype.open = function() {
    return CdmStorageProxy.prototype.open
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmStorageProxy.prototype.open = function(fileName) {
    var params_ = new CdmStorage_Open_Params();
    params_.fileName = fileName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kCdmStorage_Open_Name,
          codec.align(CdmStorage_Open_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(CdmStorage_Open_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmStorage_Open_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CdmStorageStub(delegate) {
    this.delegate_ = delegate;
  }
  CdmStorageStub.prototype.open = function(fileName) {
    return this.delegate_ && this.delegate_.open && this.delegate_.open(fileName);
  }

  CdmStorageStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CdmStorageStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCdmStorage_Open_Name:
      var params = reader.decodeStruct(CdmStorage_Open_Params);
      this.open(params.fileName).then(function(response) {
        var responseParams =
            new CdmStorage_Open_ResponseParams();
        responseParams.status = response.status;
        responseParams.cdmFile = response.cdmFile;
        var builder = new codec.MessageV2Builder(
            kCdmStorage_Open_Name,
            codec.align(CdmStorage_Open_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(CdmStorage_Open_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCdmStorageRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCdmStorage_Open_Name:
        if (message.expectsResponse())
          paramsClass = CdmStorage_Open_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCdmStorageResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCdmStorage_Open_Name:
        if (message.isResponse())
          paramsClass = CdmStorage_Open_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CdmStorage = {
    name: 'media.mojom.CdmStorage',
    kVersion: 0,
    ptrClass: CdmStoragePtr,
    proxyClass: CdmStorageProxy,
    stubClass: CdmStorageStub,
    validateRequest: validateCdmStorageRequest,
    validateResponse: validateCdmStorageResponse,
  };
  CdmStorage.Status = {};
  CdmStorage.Status.kSuccess = 0;
  CdmStorage.Status.kInUse = 1;
  CdmStorage.Status.kFailure = 2;
  CdmStorage.Status.MIN_VALUE = 0;
  CdmStorage.Status.MAX_VALUE = 2;

  CdmStorage.Status.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CdmStorage.Status.toKnownEnumValue = function(value) {
    return value;
  };

  CdmStorage.Status.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  CdmStorageStub.prototype.validator = validateCdmStorageRequest;
  CdmStorageProxy.prototype.validator = validateCdmStorageResponse;
  var kCdmFile_Read_Name = 0;
  var kCdmFile_Write_Name = 1;

  function CdmFilePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CdmFile,
                                                   handleOrPtrInfo);
  }

  function CdmFileAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CdmFile, associatedInterfacePtrInfo);
  }

  CdmFileAssociatedPtr.prototype =
      Object.create(CdmFilePtr.prototype);
  CdmFileAssociatedPtr.prototype.constructor =
      CdmFileAssociatedPtr;

  function CdmFileProxy(receiver) {
    this.receiver_ = receiver;
  }
  CdmFilePtr.prototype.read = function() {
    return CdmFileProxy.prototype.read
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmFileProxy.prototype.read = function() {
    var params_ = new CdmFile_Read_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmFile_Read_Name,
          codec.align(CdmFile_Read_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmFile_Read_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmFile_Read_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CdmFilePtr.prototype.write = function() {
    return CdmFileProxy.prototype.write
        .apply(this.ptr.getProxy(), arguments);
  };

  CdmFileProxy.prototype.write = function(data) {
    var params_ = new CdmFile_Write_Params();
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCdmFile_Write_Name,
          codec.align(CdmFile_Write_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CdmFile_Write_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CdmFile_Write_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CdmFileStub(delegate) {
    this.delegate_ = delegate;
  }
  CdmFileStub.prototype.read = function() {
    return this.delegate_ && this.delegate_.read && this.delegate_.read();
  }
  CdmFileStub.prototype.write = function(data) {
    return this.delegate_ && this.delegate_.write && this.delegate_.write(data);
  }

  CdmFileStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CdmFileStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCdmFile_Read_Name:
      var params = reader.decodeStruct(CdmFile_Read_Params);
      this.read().then(function(response) {
        var responseParams =
            new CdmFile_Read_ResponseParams();
        responseParams.status = response.status;
        responseParams.data = response.data;
        var builder = new codec.MessageV1Builder(
            kCdmFile_Read_Name,
            codec.align(CdmFile_Read_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmFile_Read_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCdmFile_Write_Name:
      var params = reader.decodeStruct(CdmFile_Write_Params);
      this.write(params.data).then(function(response) {
        var responseParams =
            new CdmFile_Write_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kCdmFile_Write_Name,
            codec.align(CdmFile_Write_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CdmFile_Write_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCdmFileRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCdmFile_Read_Name:
        if (message.expectsResponse())
          paramsClass = CdmFile_Read_Params;
      break;
      case kCdmFile_Write_Name:
        if (message.expectsResponse())
          paramsClass = CdmFile_Write_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCdmFileResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCdmFile_Read_Name:
        if (message.isResponse())
          paramsClass = CdmFile_Read_ResponseParams;
        break;
      case kCdmFile_Write_Name:
        if (message.isResponse())
          paramsClass = CdmFile_Write_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CdmFile = {
    name: 'media.mojom.CdmFile',
    kVersion: 0,
    ptrClass: CdmFilePtr,
    proxyClass: CdmFileProxy,
    stubClass: CdmFileStub,
    validateRequest: validateCdmFileRequest,
    validateResponse: validateCdmFileResponse,
  };
  CdmFile.Status = {};
  CdmFile.Status.kSuccess = 0;
  CdmFile.Status.kFailure = 1;
  CdmFile.Status.MIN_VALUE = 0;
  CdmFile.Status.MAX_VALUE = 1;

  CdmFile.Status.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CdmFile.Status.toKnownEnumValue = function(value) {
    return value;
  };

  CdmFile.Status.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  CdmFileStub.prototype.validator = validateCdmFileRequest;
  CdmFileProxy.prototype.validator = validateCdmFileResponse;
  exports.CdmStorage = CdmStorage;
  exports.CdmStoragePtr = CdmStoragePtr;
  exports.CdmStorageAssociatedPtr = CdmStorageAssociatedPtr;
  exports.CdmFile = CdmFile;
  exports.CdmFilePtr = CdmFilePtr;
  exports.CdmFileAssociatedPtr = CdmFileAssociatedPtr;
})();