// media/mojo/mojom/cdm_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_service.mojom-params-data.h"
#include "media/mojo/mojom/cdm_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_service.mojom-blink-import-headers.h"
#include "media/mojo/mojom/cdm_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
// The declaration includes the definition on other builds.

CdmService::IPCStableHashFunction CdmService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmService>(message.name())) {
    case messages::CdmService::kCreateCdmFactory: {
      return &CdmService::CreateCdmFactory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmService>(message.name())) {
      case messages::CdmService::kCreateCdmFactory:
            return "Receive media::mojom::CdmService::CreateCdmFactory";
    }
  } else {
    switch (static_cast<messages::CdmService>(message.name())) {
      case messages::CdmService::kCreateCdmFactory:
            return "Receive reply media::mojom::CdmService::CreateCdmFactory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmService::CreateCdmFactory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5effe783;  // IPCStableHash for media::mojom::CdmService::CreateCdmFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CdmServiceProxy::CdmServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmServiceProxy::CreateCdmFactory(
    ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> in_factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> in_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmService::CreateCdmFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_interfaces"), in_frame_interfaces,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmService::kCreateCdmFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmService_CreateCdmFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in CdmService.CreateCdmFactory request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::FrameInterfaceFactoryInterfaceBase>>(
    in_frame_interfaces,
    &params->frame_interfaces,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->frame_interfaces)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid frame_interfaces in CdmService.CreateCdmFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmService::Name_);
  message.set_method_name("CreateCdmFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CdmServiceStubDispatch::Accept(
    CdmService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmService>(message->header()->name)) {
    case messages::CdmService::kCreateCdmFactory: {
      DCHECK(message->is_serialized());
      internal::CdmService_CreateCdmFactory_Params_Data* params =
          reinterpret_cast<internal::CdmService_CreateCdmFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CdmService.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> p_factory{};
      ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> p_frame_interfaces{};
      CdmService_CreateCdmFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success) {
        p_frame_interfaces =
            input_data_view.TakeFrameInterfaces<decltype(p_frame_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdmFactory(        
        std::move(p_factory), 
        std::move(p_frame_interfaces));
      return true;
    }
  }
  return false;
}

// static
bool CdmServiceStubDispatch::AcceptWithResponder(
    CdmService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmService>(message->header()->name)) {
    case messages::CdmService::kCreateCdmFactory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCdmServiceValidationInfo[] = {
    { &internal::CdmService_CreateCdmFactory_Params_Data::Validate,
     nullptr /* no response */},
};

bool CdmServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::CdmService::Name_,
    kCdmServiceValidationInfo);
}

// The declaration includes the definition on other builds.

SeatbeltExtensionTokenProvider::IPCStableHashFunction SeatbeltExtensionTokenProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SeatbeltExtensionTokenProvider>(message.name())) {
    case messages::SeatbeltExtensionTokenProvider::kGetTokens: {
      return &SeatbeltExtensionTokenProvider::GetTokens_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SeatbeltExtensionTokenProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SeatbeltExtensionTokenProvider>(message.name())) {
      case messages::SeatbeltExtensionTokenProvider::kGetTokens:
            return "Receive media::mojom::SeatbeltExtensionTokenProvider::GetTokens";
    }
  } else {
    switch (static_cast<messages::SeatbeltExtensionTokenProvider>(message.name())) {
      case messages::SeatbeltExtensionTokenProvider::kGetTokens:
            return "Receive reply media::mojom::SeatbeltExtensionTokenProvider::GetTokens";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SeatbeltExtensionTokenProvider::GetTokens_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85ba295d;  // IPCStableHash for media::mojom::SeatbeltExtensionTokenProvider::GetTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool SeatbeltExtensionTokenProvider::GetTokens(::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>* out_tokens) {
  NOTREACHED();
}
class SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse(
      bool* result, ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>* out_tokens)
      : result_(result), out_tokens_(out_tokens) {
    DCHECK(!*result_);
  }

  SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse(const SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse&) = delete;
  SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse& operator=(const SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>* out_tokens_;};

class SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback(
      SeatbeltExtensionTokenProvider::GetTokensCallback callback
      ) : callback_(std::move(callback)) {
  }

  SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback(const SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback&) = delete;
  SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback& operator=(const SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SeatbeltExtensionTokenProvider::GetTokensCallback callback_;
};

SeatbeltExtensionTokenProviderProxy::SeatbeltExtensionTokenProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool SeatbeltExtensionTokenProviderProxy::GetTokens(
    ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>* out_param_tokens) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::mojom::SeatbeltExtensionTokenProvider::GetTokens (sync)");
#else
  TRACE_EVENT0("mojom", "SeatbeltExtensionTokenProvider::GetTokens");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SeatbeltExtensionTokenProvider::kGetTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SeatbeltExtensionTokenProvider_GetTokens_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SeatbeltExtensionTokenProvider::Name_);
  message.set_method_name("GetTokens");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse(
          &result, out_param_tokens));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "SeatbeltExtensionTokenProvider::GetTokens", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tokens"), out_param_tokens,
                        "<value of type ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>>");
   });
#endif
  return result;
}

void SeatbeltExtensionTokenProviderProxy::GetTokens(
    GetTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::SeatbeltExtensionTokenProvider::GetTokens");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SeatbeltExtensionTokenProvider::kGetTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SeatbeltExtensionTokenProvider_GetTokens_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SeatbeltExtensionTokenProvider::Name_);
  message.set_method_name("GetTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SeatbeltExtensionTokenProvider::GetTokensCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder> proxy(
        new SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SeatbeltExtensionTokenProvider::GetTokensCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr> in_tokens);
};

bool SeatbeltExtensionTokenProvider_GetTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SeatbeltExtensionTokenProvider_GetTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SeatbeltExtensionTokenProvider_GetTokens_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SeatbeltExtensionTokenProvider.0
  bool success = true;
  ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr> p_tokens{};
  SeatbeltExtensionTokenProvider_GetTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTokens(&p_tokens))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SeatbeltExtensionTokenProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tokens));
  }
  return true;
}

void SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder::Run(
    ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr> in_tokens) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::SeatbeltExtensionTokenProvider::GetTokens", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tokens"), in_tokens,
                        "<value of type ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SeatbeltExtensionTokenProvider::kGetTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SeatbeltExtensionTokenProvider_GetTokens_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tokens)::BaseType>
      tokens_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tokens_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::sandbox::mac::mojom::SeatbeltExtensionTokenDataView>>(
    in_tokens,
    tokens_fragment,
    &tokens_validate_params);

  params->tokens.Set(
      tokens_fragment.is_null() ? nullptr : tokens_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tokens.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tokens in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SeatbeltExtensionTokenProvider::Name_);
  message.set_method_name("GetTokens");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool SeatbeltExtensionTokenProvider_GetTokens_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SeatbeltExtensionTokenProvider_GetTokens_ResponseParams_Data* params =
      reinterpret_cast<internal::SeatbeltExtensionTokenProvider_GetTokens_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for SeatbeltExtensionTokenProvider.0
  bool success = true;
  ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr> p_tokens{};
  SeatbeltExtensionTokenProvider_GetTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTokens(&p_tokens))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SeatbeltExtensionTokenProvider::Name_, 0, true);
    return false;
  }
  *out_tokens_ = std::move(p_tokens);
  *result_ = true;
  return true;
}

// static
bool SeatbeltExtensionTokenProviderStubDispatch::Accept(
    SeatbeltExtensionTokenProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SeatbeltExtensionTokenProvider>(message->header()->name)) {
    case messages::SeatbeltExtensionTokenProvider::kGetTokens: {
      break;
    }
  }
  return false;
}

// static
bool SeatbeltExtensionTokenProviderStubDispatch::AcceptWithResponder(
    SeatbeltExtensionTokenProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SeatbeltExtensionTokenProvider>(message->header()->name)) {
    case messages::SeatbeltExtensionTokenProvider::kGetTokens: {
      internal::SeatbeltExtensionTokenProvider_GetTokens_Params_Data* params =
          reinterpret_cast<
              internal::SeatbeltExtensionTokenProvider_GetTokens_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SeatbeltExtensionTokenProvider.0
      bool success = true;
      SeatbeltExtensionTokenProvider_GetTokens_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SeatbeltExtensionTokenProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          SeatbeltExtensionTokenProvider_GetTokens_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTokens(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSeatbeltExtensionTokenProviderValidationInfo[] = {
    { &internal::SeatbeltExtensionTokenProvider_GetTokens_Params_Data::Validate,
     &internal::SeatbeltExtensionTokenProvider_GetTokens_ResponseParams_Data::Validate},
};

bool SeatbeltExtensionTokenProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::SeatbeltExtensionTokenProvider::Name_,
    kSeatbeltExtensionTokenProviderValidationInfo);
}

bool SeatbeltExtensionTokenProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::SeatbeltExtensionTokenProvider::Name_,
    kSeatbeltExtensionTokenProviderValidationInfo);
}
// The declaration includes the definition on other builds.

CdmServiceBroker::IPCStableHashFunction CdmServiceBroker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmServiceBroker>(message.name())) {
    case messages::CdmServiceBroker::kGetService: {
      return &CdmServiceBroker::GetService_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmServiceBroker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmServiceBroker>(message.name())) {
      case messages::CdmServiceBroker::kGetService:
            return "Receive media::mojom::CdmServiceBroker::GetService";
    }
  } else {
    switch (static_cast<messages::CdmServiceBroker>(message.name())) {
      case messages::CdmServiceBroker::kGetService:
            return "Receive reply media::mojom::CdmServiceBroker::GetService";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmServiceBroker::GetService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2f81a706;  // IPCStableHash for media::mojom::CdmServiceBroker::GetService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CdmServiceBrokerProxy::CdmServiceBrokerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmServiceBrokerProxy::GetService(
    const ::base::FilePath& in_cdm_path, ::mojo::PendingRemote<SeatbeltExtensionTokenProvider> in_token_provider, ::mojo::PendingReceiver<CdmService> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmServiceBroker::GetService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_path"), in_cdm_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token_provider"), in_token_provider,
                        "<value of type ::mojo::PendingRemote<SeatbeltExtensionTokenProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<CdmService>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmServiceBroker::kGetService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmServiceBroker_GetService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_path)::BaseType> cdm_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_cdm_path,
    cdm_path_fragment);

  params->cdm_path.Set(
      cdm_path_fragment.is_null() ? nullptr : cdm_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cdm_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cdm_path in CdmServiceBroker.GetService request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SeatbeltExtensionTokenProviderInterfaceBase>>(
    in_token_provider,
    &params->token_provider,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmServiceInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in CdmServiceBroker.GetService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmServiceBroker::Name_);
  message.set_method_name("GetService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CdmServiceBrokerStubDispatch::Accept(
    CdmServiceBroker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmServiceBroker>(message->header()->name)) {
    case messages::CdmServiceBroker::kGetService: {
      DCHECK(message->is_serialized());
      internal::CdmServiceBroker_GetService_Params_Data* params =
          reinterpret_cast<internal::CdmServiceBroker_GetService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CdmServiceBroker.0
      bool success = true;
      ::base::FilePath p_cdm_path{};
      ::mojo::PendingRemote<SeatbeltExtensionTokenProvider> p_token_provider{};
      ::mojo::PendingReceiver<CdmService> p_receiver{};
      CdmServiceBroker_GetService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCdmPath(&p_cdm_path))
        success = false;
      if (success) {
        p_token_provider =
            input_data_view.TakeTokenProvider<decltype(p_token_provider)>();
      }
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmServiceBroker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetService(        
        std::move(p_cdm_path), 
        std::move(p_token_provider), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool CdmServiceBrokerStubDispatch::AcceptWithResponder(
    CdmServiceBroker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmServiceBroker>(message->header()->name)) {
    case messages::CdmServiceBroker::kGetService: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCdmServiceBrokerValidationInfo[] = {
    { &internal::CdmServiceBroker_GetService_Params_Data::Validate,
     nullptr /* no response */},
};

bool CdmServiceBrokerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::CdmServiceBroker::Name_,
    kCdmServiceBrokerValidationInfo);
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void CdmServiceInterceptorForTesting::CreateCdmFactory(::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> frame_interfaces) {
  GetForwardingInterface()->CreateCdmFactory(
    std::move(factory)
    , 
    std::move(frame_interfaces)
    );
}
CdmServiceAsyncWaiter::CdmServiceAsyncWaiter(
    CdmService* proxy) : proxy_(proxy) {}

CdmServiceAsyncWaiter::~CdmServiceAsyncWaiter() = default;





void SeatbeltExtensionTokenProviderInterceptorForTesting::GetTokens(GetTokensCallback callback) {
  GetForwardingInterface()->GetTokens(std::move(callback));
}
SeatbeltExtensionTokenProviderAsyncWaiter::SeatbeltExtensionTokenProviderAsyncWaiter(
    SeatbeltExtensionTokenProvider* proxy) : proxy_(proxy) {}

SeatbeltExtensionTokenProviderAsyncWaiter::~SeatbeltExtensionTokenProviderAsyncWaiter() = default;


void SeatbeltExtensionTokenProviderAsyncWaiter::GetTokens(
    ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>* out_tokens) {
  base::RunLoop loop;
  proxy_->GetTokens(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr>* out_tokens
,
             ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr> tokens) {*out_tokens = std::move(tokens);
            loop->Quit();
          },
          &loop,
          out_tokens));
  loop.Run();
}

::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr> SeatbeltExtensionTokenProviderAsyncWaiter::GetTokens(
    ) {
  ::blink::Vector<::sandbox::mac::mojom::blink::SeatbeltExtensionTokenPtr> async_wait_result;
  GetTokens(&async_wait_result);
  return async_wait_result;
}




void CdmServiceBrokerInterceptorForTesting::GetService(const ::base::FilePath& cdm_path, ::mojo::PendingRemote<SeatbeltExtensionTokenProvider> token_provider, ::mojo::PendingReceiver<CdmService> receiver) {
  GetForwardingInterface()->GetService(
    std::move(cdm_path)
    , 
    std::move(token_provider)
    , 
    std::move(receiver)
    );
}
CdmServiceBrokerAsyncWaiter::CdmServiceBrokerAsyncWaiter(
    CdmServiceBroker* proxy) : proxy_(proxy) {}

CdmServiceBrokerAsyncWaiter::~CdmServiceBrokerAsyncWaiter() = default;







}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif