// media/mojo/mojom/audio_stream_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  ReadWriteAudioDataPipe as media_mojom_ReadWriteAudioDataPipe,
  ReadWriteAudioDataPipeSpec as media_mojom_ReadWriteAudioDataPipeSpec
} from './audio_data_pipe.mojom.m.js';

import {
  AudioInputStreamRemote as media_mojom_AudioInputStreamRemote,
  AudioInputStreamPendingReceiver as media_mojom_AudioInputStreamPendingReceiver,
  AudioInputStreamClientRemote as media_mojom_AudioInputStreamClientRemote,
  AudioInputStreamClientPendingReceiver as media_mojom_AudioInputStreamClientPendingReceiver,
  AudioInputStreamObserverRemote as media_mojom_AudioInputStreamObserverRemote,
  AudioInputStreamObserverPendingReceiver as media_mojom_AudioInputStreamObserverPendingReceiver
} from './audio_input_stream.mojom.m.js';

import {
  AudioLogRemote as media_mojom_AudioLogRemote,
  AudioLogPendingReceiver as media_mojom_AudioLogPendingReceiver
} from './audio_logging.mojom.m.js';

import {
  AudioOutputStreamRemote as media_mojom_AudioOutputStreamRemote,
  AudioOutputStreamPendingReceiver as media_mojom_AudioOutputStreamPendingReceiver,
  AudioOutputStreamObserverRemote as media_mojom_AudioOutputStreamObserverRemote,
  AudioOutputStreamObserverPendingReceiver as media_mojom_AudioOutputStreamObserverPendingReceiver,
  DeviceSwitchInterfaceRemote as media_mojom_DeviceSwitchInterfaceRemote,
  DeviceSwitchInterfacePendingReceiver as media_mojom_DeviceSwitchInterfacePendingReceiver
} from './audio_output_stream.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from './audio_parameters.mojom.m.js';

import {
  AudioProcessingConfig as media_mojom_AudioProcessingConfig,
  AudioProcessingConfigSpec as media_mojom_AudioProcessingConfigSpec
} from './audio_processing.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LocalMuterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.LocalMuter', scope);
  }
}

/** @interface */
export class LocalMuterInterface {
}

/**
 * @implements { LocalMuterInterface }
 */
export class LocalMuterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LocalMuterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LocalMuterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LocalMuterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the LocalMuter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LocalMuterReceiver {
  /**
   * @param {!LocalMuterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LocalMuterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LocalMuterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LocalMuterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LocalMuter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.LocalMuter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LocalMuterRemote}
   */
  static getRemote() {
    let remote = new LocalMuterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LocalMuter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LocalMuterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LocalMuterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LocalMuterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioStreamFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioStreamFactory', scope);
  }
}

/** @interface */
export class AudioStreamFactoryInterface {
  
  /**
   * @param { !media_mojom_AudioInputStreamPendingReceiver } stream
   * @param { !media_mojom_AudioInputStreamClientRemote } client
   * @param { ?media_mojom_AudioInputStreamObserverRemote } observer
   * @param { ?media_mojom_AudioLogRemote } log
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } params
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @param { !number } sharedMemoryCount
   * @param { !boolean } enableAgc
   * @param { ?media_mojom_AudioProcessingConfig } processingConfig
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
        initiallyMuted: !boolean,
        streamId: ?mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  createInputStream(stream, client, observer, log, deviceId, params, groupId, sharedMemoryCount, enableAgc, processingConfig) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } inputStreamId
   * @param { !string } outputDeviceId
   */

  associateInputAndOutputForAec(inputStreamId, outputDeviceId) {}
  
  /**
   * @param { !media_mojom_AudioOutputStreamPendingReceiver } stream
   * @param { ?Object } observer
   * @param { ?media_mojom_AudioLogRemote } log
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } params
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
   *  }>}
   */

  createOutputStream(stream, observer, log, deviceId, params, groupId) {}
  
  /**
   * @param { !media_mojom_AudioOutputStreamPendingReceiver } stream
   * @param { !media_mojom_DeviceSwitchInterfacePendingReceiver } deviceSwitchReceiver
   * @param { ?Object } observer
   * @param { ?media_mojom_AudioLogRemote } log
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } params
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
   *  }>}
   */

  createSwitchableOutputStream(stream, deviceSwitchReceiver, observer, log, deviceId, params, groupId) {}
  
  /**
   * @param { !Object } receiver
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   */

  bindMuter(receiver, groupId) {}
  
  /**
   * @param { !media_mojom_AudioInputStreamPendingReceiver } receiver
   * @param { !media_mojom_AudioInputStreamClientRemote } client
   * @param { !media_mojom_AudioInputStreamObserverRemote } observer
   * @param { !media_mojom_AudioParameters } params
   * @param { !number } sharedMemoryCount
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
   *  }>}
   */

  createLoopbackStream(receiver, client, observer, params, sharedMemoryCount, groupId) {}
}

/**
 * @implements { AudioStreamFactoryInterface }
 */
export class AudioStreamFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioStreamFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioStreamFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioStreamFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioInputStreamPendingReceiver } stream
   * @param { !media_mojom_AudioInputStreamClientRemote } client
   * @param { ?media_mojom_AudioInputStreamObserverRemote } observer
   * @param { ?media_mojom_AudioLogRemote } log
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } params
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @param { !number } sharedMemoryCount
   * @param { !boolean } enableAgc
   * @param { ?media_mojom_AudioProcessingConfig } processingConfig
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
        initiallyMuted: !boolean,
        streamId: ?mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  createInputStream(
      stream,
      client,
      observer,
      log,
      deviceId,
      params,
      groupId,
      sharedMemoryCount,
      enableAgc,
      processingConfig) {
    return this.proxy.sendMessage(
        0,
        AudioStreamFactory_CreateInputStream_ParamsSpec.$,
        AudioStreamFactory_CreateInputStream_ResponseParamsSpec.$,
        [
          stream,
          client,
          observer,
          log,
          deviceId,
          params,
          groupId,
          sharedMemoryCount,
          enableAgc,
          processingConfig
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } inputStreamId
   * @param { !string } outputDeviceId
   */

  associateInputAndOutputForAec(
      inputStreamId,
      outputDeviceId) {
    this.proxy.sendMessage(
        1,
        AudioStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        [
          inputStreamId,
          outputDeviceId
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioOutputStreamPendingReceiver } stream
   * @param { ?Object } observer
   * @param { ?media_mojom_AudioLogRemote } log
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } params
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
   *  }>}
   */

  createOutputStream(
      stream,
      observer,
      log,
      deviceId,
      params,
      groupId) {
    return this.proxy.sendMessage(
        2,
        AudioStreamFactory_CreateOutputStream_ParamsSpec.$,
        AudioStreamFactory_CreateOutputStream_ResponseParamsSpec.$,
        [
          stream,
          observer,
          log,
          deviceId,
          params,
          groupId
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioOutputStreamPendingReceiver } stream
   * @param { !media_mojom_DeviceSwitchInterfacePendingReceiver } deviceSwitchReceiver
   * @param { ?Object } observer
   * @param { ?media_mojom_AudioLogRemote } log
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } params
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
   *  }>}
   */

  createSwitchableOutputStream(
      stream,
      deviceSwitchReceiver,
      observer,
      log,
      deviceId,
      params,
      groupId) {
    return this.proxy.sendMessage(
        3,
        AudioStreamFactory_CreateSwitchableOutputStream_ParamsSpec.$,
        AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsSpec.$,
        [
          stream,
          deviceSwitchReceiver,
          observer,
          log,
          deviceId,
          params,
          groupId
        ],
        false);
  }

  
  /**
   * @param { !Object } receiver
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   */

  bindMuter(
      receiver,
      groupId) {
    this.proxy.sendMessage(
        4,
        AudioStreamFactory_BindMuter_ParamsSpec.$,
        null,
        [
          receiver,
          groupId
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioInputStreamPendingReceiver } receiver
   * @param { !media_mojom_AudioInputStreamClientRemote } client
   * @param { !media_mojom_AudioInputStreamObserverRemote } observer
   * @param { !media_mojom_AudioParameters } params
   * @param { !number } sharedMemoryCount
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        dataPipe: ?media_mojom_ReadWriteAudioDataPipe,
   *  }>}
   */

  createLoopbackStream(
      receiver,
      client,
      observer,
      params,
      sharedMemoryCount,
      groupId) {
    return this.proxy.sendMessage(
        5,
        AudioStreamFactory_CreateLoopbackStream_ParamsSpec.$,
        AudioStreamFactory_CreateLoopbackStream_ResponseParamsSpec.$,
        [
          receiver,
          client,
          observer,
          params,
          sharedMemoryCount,
          groupId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioStreamFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioStreamFactoryReceiver {
  /**
   * @param {!AudioStreamFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioStreamFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioStreamFactory_CreateInputStream_ParamsSpec.$,
        AudioStreamFactory_CreateInputStream_ResponseParamsSpec.$,
        impl.createInputStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        impl.associateInputAndOutputForAec.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioStreamFactory_CreateOutputStream_ParamsSpec.$,
        AudioStreamFactory_CreateOutputStream_ResponseParamsSpec.$,
        impl.createOutputStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AudioStreamFactory_CreateSwitchableOutputStream_ParamsSpec.$,
        AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsSpec.$,
        impl.createSwitchableOutputStream.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AudioStreamFactory_BindMuter_ParamsSpec.$,
        null,
        impl.bindMuter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AudioStreamFactory_CreateLoopbackStream_ParamsSpec.$,
        AudioStreamFactory_CreateLoopbackStream_ResponseParamsSpec.$,
        impl.createLoopbackStream.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioStreamFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioStreamFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioStreamFactoryRemote}
   */
  static getRemote() {
    let remote = new AudioStreamFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioStreamFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioStreamFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createInputStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioStreamFactory_CreateInputStream_ParamsSpec.$,
        AudioStreamFactory_CreateInputStream_ResponseParamsSpec.$,
        this.createInputStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.associateInputAndOutputForAec =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
        null,
        this.associateInputAndOutputForAec.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createOutputStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioStreamFactory_CreateOutputStream_ParamsSpec.$,
        AudioStreamFactory_CreateOutputStream_ResponseParamsSpec.$,
        this.createOutputStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSwitchableOutputStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AudioStreamFactory_CreateSwitchableOutputStream_ParamsSpec.$,
        AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsSpec.$,
        this.createSwitchableOutputStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindMuter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AudioStreamFactory_BindMuter_ParamsSpec.$,
        null,
        this.bindMuter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createLoopbackStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AudioStreamFactory_CreateLoopbackStream_ParamsSpec.$,
        AudioStreamFactory_CreateLoopbackStream_ResponseParamsSpec.$,
        this.createLoopbackStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateInputStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateInputStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_AssociateInputAndOutputForAec_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateOutputStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateOutputStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateSwitchableOutputStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_BindMuter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateLoopbackStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioStreamFactory_CreateLoopbackStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioStreamFactory_CreateInputStream_ParamsSpec.$,
    'AudioStreamFactory_CreateInputStream_Params',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioInputStreamPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioInputStreamClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioInputStreamObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'log', 20,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioLogRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 40,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 48,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedMemoryCount', 28,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableAgc', 56,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'processingConfig', 64,
        0,
        media_mojom_AudioProcessingConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateInputStream_Params {
  constructor() {
    /** @type { !media_mojom_AudioInputStreamPendingReceiver } */
    this.stream;
    /** @type { !media_mojom_AudioInputStreamClientRemote } */
    this.client;
    /** @type { (media_mojom_AudioInputStreamObserverRemote|undefined) } */
    this.observer;
    /** @type { (media_mojom_AudioLogRemote|undefined) } */
    this.log;
    /** @type { !string } */
    this.deviceId;
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.groupId;
    /** @type { !number } */
    this.sharedMemoryCount;
    /** @type { !boolean } */
    this.enableAgc;
    /** @type { (media_mojom_AudioProcessingConfig|undefined) } */
    this.processingConfig;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_CreateInputStream_ResponseParamsSpec.$,
    'AudioStreamFactory_CreateInputStream_ResponseParams',
    [
      mojo.internal.StructField(
        'dataPipe', 0,
        0,
        media_mojom_ReadWriteAudioDataPipeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initiallyMuted', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamId', 16,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateInputStream_ResponseParams {
  constructor() {
    /** @type { (media_mojom_ReadWriteAudioDataPipe|undefined) } */
    this.dataPipe;
    /** @type { !boolean } */
    this.initiallyMuted;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.streamId;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_AssociateInputAndOutputForAec_ParamsSpec.$,
    'AudioStreamFactory_AssociateInputAndOutputForAec_Params',
    [
      mojo.internal.StructField(
        'inputStreamId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputDeviceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioStreamFactory_AssociateInputAndOutputForAec_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.inputStreamId;
    /** @type { !string } */
    this.outputDeviceId;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_CreateOutputStream_ParamsSpec.$,
    'AudioStreamFactory_CreateOutputStream_Params',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioOutputStreamPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(media_mojom_AudioOutputStreamObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'log', 12,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioLogRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 32,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 40,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateOutputStream_Params {
  constructor() {
    /** @type { !media_mojom_AudioOutputStreamPendingReceiver } */
    this.stream;
    /** @type { (Object|undefined) } */
    this.observer;
    /** @type { (media_mojom_AudioLogRemote|undefined) } */
    this.log;
    /** @type { !string } */
    this.deviceId;
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.groupId;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_CreateOutputStream_ResponseParamsSpec.$,
    'AudioStreamFactory_CreateOutputStream_ResponseParams',
    [
      mojo.internal.StructField(
        'dataPipe', 0,
        0,
        media_mojom_ReadWriteAudioDataPipeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateOutputStream_ResponseParams {
  constructor() {
    /** @type { (media_mojom_ReadWriteAudioDataPipe|undefined) } */
    this.dataPipe;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_CreateSwitchableOutputStream_ParamsSpec.$,
    'AudioStreamFactory_CreateSwitchableOutputStream_Params',
    [
      mojo.internal.StructField(
        'stream', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioOutputStreamPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceSwitchReceiver', 4,
        0,
        mojo.internal.InterfaceRequest(media_mojom_DeviceSwitchInterfacePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(media_mojom_AudioOutputStreamObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'log', 16,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioLogRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 32,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 40,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateSwitchableOutputStream_Params {
  constructor() {
    /** @type { !media_mojom_AudioOutputStreamPendingReceiver } */
    this.stream;
    /** @type { !media_mojom_DeviceSwitchInterfacePendingReceiver } */
    this.deviceSwitchReceiver;
    /** @type { (Object|undefined) } */
    this.observer;
    /** @type { (media_mojom_AudioLogRemote|undefined) } */
    this.log;
    /** @type { !string } */
    this.deviceId;
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.groupId;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsSpec.$,
    'AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams',
    [
      mojo.internal.StructField(
        'dataPipe', 0,
        0,
        media_mojom_ReadWriteAudioDataPipeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams {
  constructor() {
    /** @type { (media_mojom_ReadWriteAudioDataPipe|undefined) } */
    this.dataPipe;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_BindMuter_ParamsSpec.$,
    'AudioStreamFactory_BindMuter_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(LocalMuterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioStreamFactory_BindMuter_Params {
  constructor() {
    /** @type { !Object } */
    this.receiver;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.groupId;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_CreateLoopbackStream_ParamsSpec.$,
    'AudioStreamFactory_CreateLoopbackStream_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioInputStreamPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioInputStreamClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioInputStreamObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 24,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedMemoryCount', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateLoopbackStream_Params {
  constructor() {
    /** @type { !media_mojom_AudioInputStreamPendingReceiver } */
    this.receiver;
    /** @type { !media_mojom_AudioInputStreamClientRemote } */
    this.client;
    /** @type { !media_mojom_AudioInputStreamObserverRemote } */
    this.observer;
    /** @type { !media_mojom_AudioParameters } */
    this.params;
    /** @type { !number } */
    this.sharedMemoryCount;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.groupId;
  }
}



mojo.internal.Struct(
    AudioStreamFactory_CreateLoopbackStream_ResponseParamsSpec.$,
    'AudioStreamFactory_CreateLoopbackStream_ResponseParams',
    [
      mojo.internal.StructField(
        'dataPipe', 0,
        0,
        media_mojom_ReadWriteAudioDataPipeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioStreamFactory_CreateLoopbackStream_ResponseParams {
  constructor() {
    /** @type { (media_mojom_ReadWriteAudioDataPipe|undefined) } */
    this.dataPipe;
  }
}

