// media/mojo/mojom/audio_stream_factory.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_STREAM_FACTORY_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_AUDIO_STREAM_FACTORY_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  AudioStreamFactory_CreateInputStream_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data stream;
  mojo::internal::Interface_Data client;
  mojo::internal::Interface_Data observer;
  mojo::internal::Interface_Data log;
  uint32_t shared_memory_count;
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;
  uint8_t enable_agc : 1;
  uint8_t pad8_[7];
  mojo::internal::Pointer<::media::mojom::internal::AudioProcessingConfig_Data> processing_config;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateInputStream_Params_Data>;

  AudioStreamFactory_CreateInputStream_Params_Data();
  ~AudioStreamFactory_CreateInputStream_Params_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateInputStream_Params_Data) == 80,
              "Bad sizeof(AudioStreamFactory_CreateInputStream_Params_Data)");
class  AudioStreamFactory_CreateInputStream_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::ReadWriteAudioDataPipe_Data> data_pipe;
  uint8_t initially_muted : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> stream_id;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateInputStream_ResponseParams_Data>;

  AudioStreamFactory_CreateInputStream_ResponseParams_Data();
  ~AudioStreamFactory_CreateInputStream_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateInputStream_ResponseParams_Data) == 32,
              "Bad sizeof(AudioStreamFactory_CreateInputStream_ResponseParams_Data)");
class  AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> input_stream_id;
  mojo::internal::Pointer<mojo::internal::String_Data> output_device_id;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data>;

  AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data();
  ~AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data) == 24,
              "Bad sizeof(AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data)");
class  AudioStreamFactory_CreateOutputStream_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data stream;
  mojo::internal::AssociatedInterface_Data observer;
  mojo::internal::Interface_Data log;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateOutputStream_Params_Data>;

  AudioStreamFactory_CreateOutputStream_Params_Data();
  ~AudioStreamFactory_CreateOutputStream_Params_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateOutputStream_Params_Data) == 56,
              "Bad sizeof(AudioStreamFactory_CreateOutputStream_Params_Data)");
class  AudioStreamFactory_CreateOutputStream_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::ReadWriteAudioDataPipe_Data> data_pipe;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateOutputStream_ResponseParams_Data>;

  AudioStreamFactory_CreateOutputStream_ResponseParams_Data();
  ~AudioStreamFactory_CreateOutputStream_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateOutputStream_ResponseParams_Data) == 16,
              "Bad sizeof(AudioStreamFactory_CreateOutputStream_ResponseParams_Data)");
class  AudioStreamFactory_CreateSwitchableOutputStream_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data stream;
  mojo::internal::Handle_Data device_switch_receiver;
  mojo::internal::AssociatedInterface_Data observer;
  mojo::internal::Interface_Data log;
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateSwitchableOutputStream_Params_Data>;

  AudioStreamFactory_CreateSwitchableOutputStream_Params_Data();
  ~AudioStreamFactory_CreateSwitchableOutputStream_Params_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateSwitchableOutputStream_Params_Data) == 56,
              "Bad sizeof(AudioStreamFactory_CreateSwitchableOutputStream_Params_Data)");
class  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::ReadWriteAudioDataPipe_Data> data_pipe;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data>;

  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data();
  ~AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data) == 16,
              "Bad sizeof(AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data)");
class  AudioStreamFactory_BindMuter_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data receiver;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_BindMuter_Params_Data>;

  AudioStreamFactory_BindMuter_Params_Data();
  ~AudioStreamFactory_BindMuter_Params_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_BindMuter_Params_Data) == 24,
              "Bad sizeof(AudioStreamFactory_BindMuter_Params_Data)");
class  AudioStreamFactory_CreateLoopbackStream_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  mojo::internal::Interface_Data client;
  mojo::internal::Interface_Data observer;
  uint32_t shared_memory_count;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateLoopbackStream_Params_Data>;

  AudioStreamFactory_CreateLoopbackStream_Params_Data();
  ~AudioStreamFactory_CreateLoopbackStream_Params_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateLoopbackStream_Params_Data) == 48,
              "Bad sizeof(AudioStreamFactory_CreateLoopbackStream_Params_Data)");
class  AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::ReadWriteAudioDataPipe_Data> data_pipe;

 private:
  friend class mojo::internal::MessageFragment<AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data>;

  AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data();
  ~AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data) == 16,
              "Bad sizeof(AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data)");

}  // namespace internal


class AudioStreamFactory_CreateInputStream_ParamsDataView {
 public:
  AudioStreamFactory_CreateInputStream_ParamsDataView() = default;

  AudioStreamFactory_CreateInputStream_ParamsDataView(
      internal::AudioStreamFactory_CreateInputStream_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
            &data_->stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
            &data_->log, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  uint32_t shared_memory_count() const {
    return data_->shared_memory_count;
  }
  bool enable_agc() const {
    return data_->enable_agc;
  }
  inline void GetProcessingConfigDataView(
      ::media::mojom::AudioProcessingConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProcessingConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::AudioProcessingConfigDataView, UserType>(),
    "Attempting to read the optional `processing_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProcessingConfig` instead "
    "of `ReadProcessingConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->processing_config.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioProcessingConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateInputStream_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_CreateInputStream_ResponseParamsDataView {
 public:
  AudioStreamFactory_CreateInputStream_ResponseParamsDataView() = default;

  AudioStreamFactory_CreateInputStream_ResponseParamsDataView(
      internal::AudioStreamFactory_CreateInputStream_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadWriteAudioDataPipeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ReadWriteAudioDataPipeDataView, UserType>(),
    "Attempting to read the optional `data_pipe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataPipe` instead "
    "of `ReadDataPipe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
        pointer, output, message_);
  }
  bool initially_muted() const {
    return data_->initially_muted;
  }
  inline void GetStreamIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `stream_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStreamId` instead "
    "of `ReadStreamId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stream_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateInputStream_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_AssociateInputAndOutputForAec_ParamsDataView {
 public:
  AudioStreamFactory_AssociateInputAndOutputForAec_ParamsDataView() = default;

  AudioStreamFactory_AssociateInputAndOutputForAec_ParamsDataView(
      internal::AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputStreamIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputStreamId(UserType* output) {
    
    auto* pointer = data_->input_stream_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetOutputDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputDeviceId(UserType* output) {
    
    auto* pointer = data_->output_device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_CreateOutputStream_ParamsDataView {
 public:
  AudioStreamFactory_CreateOutputStream_ParamsDataView() = default;

  AudioStreamFactory_CreateOutputStream_ParamsDataView(
      internal::AudioStreamFactory_CreateOutputStream_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
            &data_->stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::AudioOutputStreamObserverAssociatedPtrInfoDataView>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
            &data_->log, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateOutputStream_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_CreateOutputStream_ResponseParamsDataView {
 public:
  AudioStreamFactory_CreateOutputStream_ResponseParamsDataView() = default;

  AudioStreamFactory_CreateOutputStream_ResponseParamsDataView(
      internal::AudioStreamFactory_CreateOutputStream_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadWriteAudioDataPipeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ReadWriteAudioDataPipeDataView, UserType>(),
    "Attempting to read the optional `data_pipe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataPipe` instead "
    "of `ReadDataPipe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateOutputStream_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_CreateSwitchableOutputStream_ParamsDataView {
 public:
  AudioStreamFactory_CreateSwitchableOutputStream_ParamsDataView() = default;

  AudioStreamFactory_CreateSwitchableOutputStream_ParamsDataView(
      internal::AudioStreamFactory_CreateSwitchableOutputStream_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
            &data_->stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDeviceSwitchReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::DeviceSwitchInterfaceInterfaceBase>>(
            &data_->device_switch_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::AudioOutputStreamObserverAssociatedPtrInfoDataView>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
            &data_->log, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateSwitchableOutputStream_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsDataView {
 public:
  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsDataView() = default;

  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsDataView(
      internal::AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadWriteAudioDataPipeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ReadWriteAudioDataPipeDataView, UserType>(),
    "Attempting to read the optional `data_pipe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataPipe` instead "
    "of `ReadDataPipe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_BindMuter_ParamsDataView {
 public:
  AudioStreamFactory_BindMuter_ParamsDataView() = default;

  AudioStreamFactory_BindMuter_ParamsDataView(
      internal::AudioStreamFactory_BindMuter_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::LocalMuterAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_BindMuter_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_CreateLoopbackStream_ParamsDataView {
 public:
  AudioStreamFactory_CreateLoopbackStream_ParamsDataView() = default;

  AudioStreamFactory_CreateLoopbackStream_ParamsDataView(
      internal::AudioStreamFactory_CreateLoopbackStream_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  uint32_t shared_memory_count() const {
    return data_->shared_memory_count;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateLoopbackStream_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioStreamFactory_CreateLoopbackStream_ResponseParamsDataView {
 public:
  AudioStreamFactory_CreateLoopbackStream_ResponseParamsDataView() = default;

  AudioStreamFactory_CreateLoopbackStream_ResponseParamsDataView(
      internal::AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadWriteAudioDataPipeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ReadWriteAudioDataPipeDataView, UserType>(),
    "Attempting to read the optional `data_pipe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataPipe` instead "
    "of `ReadDataPipe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void AudioStreamFactory_CreateInputStream_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateInputStream_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateInputStream_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateInputStream_ParamsDataView::GetProcessingConfigDataView(
    ::media::mojom::AudioProcessingConfigDataView* output) {
  auto pointer = data_->processing_config.Get();
  *output = ::media::mojom::AudioProcessingConfigDataView(pointer, message_);
}


inline void AudioStreamFactory_CreateInputStream_ResponseParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadWriteAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadWriteAudioDataPipeDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateInputStream_ResponseParamsDataView::GetStreamIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->stream_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void AudioStreamFactory_AssociateInputAndOutputForAec_ParamsDataView::GetInputStreamIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->input_stream_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void AudioStreamFactory_AssociateInputAndOutputForAec_ParamsDataView::GetOutputDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->output_device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AudioStreamFactory_CreateOutputStream_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateOutputStream_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateOutputStream_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void AudioStreamFactory_CreateOutputStream_ResponseParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadWriteAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadWriteAudioDataPipeDataView(pointer, message_);
}


inline void AudioStreamFactory_CreateSwitchableOutputStream_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateSwitchableOutputStream_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateSwitchableOutputStream_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadWriteAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadWriteAudioDataPipeDataView(pointer, message_);
}


inline void AudioStreamFactory_BindMuter_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void AudioStreamFactory_CreateLoopbackStream_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void AudioStreamFactory_CreateLoopbackStream_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void AudioStreamFactory_CreateLoopbackStream_ResponseParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadWriteAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadWriteAudioDataPipeDataView(pointer, message_);
}



}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_AUDIO_STREAM_FACTORY_MOJOM_PARAMS_DATA_H_