// media/mojo/mojom/audio_processing.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/audio_processing.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');



  function AudioProcessingStats(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioProcessingStats.prototype.initDefaults_ = function() {
    this.hasEchoReturnLoss = false;
    this.hasEchoReturnLossEnhancement = false;
    this.echoReturnLoss = 0;
    this.echoReturnLossEnhancement = 0;
  };
  AudioProcessingStats.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioProcessingStats.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  AudioProcessingStats.encodedSize = codec.kStructHeaderSize + 24;

  AudioProcessingStats.decode = function(decoder) {
    var packed;
    var val = new AudioProcessingStats();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasEchoReturnLoss = (packed >> 0) & 1 ? true : false;
    val.hasEchoReturnLossEnhancement = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.echoReturnLoss =
        decoder.decodeStruct(codec.Double);
    val.echoReturnLossEnhancement =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  AudioProcessingStats.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioProcessingStats.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasEchoReturnLoss & 1) << 0
    packed |= (val.hasEchoReturnLossEnhancement & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.echoReturnLoss);
    encoder.encodeStruct(codec.Double, val.echoReturnLossEnhancement);
  };
  function AudioProcessingSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioProcessingSettings.prototype.initDefaults_ = function() {
    this.echoCancellation = false;
    this.noiseSuppression = false;
    this.automaticGainControl = false;
    this.multiChannelCaptureProcessing = false;
    this.useLoopbackAecReference = false;
  };
  AudioProcessingSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioProcessingSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  AudioProcessingSettings.encodedSize = codec.kStructHeaderSize + 8;

  AudioProcessingSettings.decode = function(decoder) {
    var packed;
    var val = new AudioProcessingSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.echoCancellation = (packed >> 0) & 1 ? true : false;
    val.noiseSuppression = (packed >> 1) & 1 ? true : false;
    val.automaticGainControl = (packed >> 2) & 1 ? true : false;
    val.multiChannelCaptureProcessing = (packed >> 3) & 1 ? true : false;
    val.useLoopbackAecReference = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioProcessingSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioProcessingSettings.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.echoCancellation & 1) << 0
    packed |= (val.noiseSuppression & 1) << 1
    packed |= (val.automaticGainControl & 1) << 2
    packed |= (val.multiChannelCaptureProcessing & 1) << 3
    packed |= (val.useLoopbackAecReference & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AudioProcessingConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioProcessingConfig.prototype.initDefaults_ = function() {
    this.controlsReceiver = new bindings.InterfaceRequest();
    this.settings = null;
  };
  AudioProcessingConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioProcessingConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioProcessingConfig.controlsReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioProcessingConfig.settings
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AudioProcessingSettings, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioProcessingConfig.encodedSize = codec.kStructHeaderSize + 16;

  AudioProcessingConfig.decode = function(decoder) {
    var packed;
    var val = new AudioProcessingConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.controlsReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.settings =
        decoder.decodeStructPointer(AudioProcessingSettings);
    return val;
  };

  AudioProcessingConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioProcessingConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.controlsReceiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(AudioProcessingSettings, val.settings);
  };
  function AudioProcessorControls_GetStats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioProcessorControls_GetStats_Params.prototype.initDefaults_ = function() {
  };
  AudioProcessorControls_GetStats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioProcessorControls_GetStats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioProcessorControls_GetStats_Params.encodedSize = codec.kStructHeaderSize + 0;

  AudioProcessorControls_GetStats_Params.decode = function(decoder) {
    var packed;
    var val = new AudioProcessorControls_GetStats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioProcessorControls_GetStats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioProcessorControls_GetStats_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AudioProcessorControls_GetStats_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioProcessorControls_GetStats_ResponseParams.prototype.initDefaults_ = function() {
    this.stats = null;
  };
  AudioProcessorControls_GetStats_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioProcessorControls_GetStats_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioProcessorControls_GetStats_ResponseParams.stats
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AudioProcessingStats, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioProcessorControls_GetStats_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioProcessorControls_GetStats_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioProcessorControls_GetStats_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stats =
        decoder.decodeStructPointer(AudioProcessingStats);
    return val;
  };

  AudioProcessorControls_GetStats_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioProcessorControls_GetStats_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AudioProcessingStats, val.stats);
  };
  function AudioProcessorControls_SetPreferredNumCaptureChannels_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioProcessorControls_SetPreferredNumCaptureChannels_Params.prototype.initDefaults_ = function() {
    this.numPreferredChannels = 0;
  };
  AudioProcessorControls_SetPreferredNumCaptureChannels_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioProcessorControls_SetPreferredNumCaptureChannels_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AudioProcessorControls_SetPreferredNumCaptureChannels_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioProcessorControls_SetPreferredNumCaptureChannels_Params.decode = function(decoder) {
    var packed;
    var val = new AudioProcessorControls_SetPreferredNumCaptureChannels_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numPreferredChannels =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioProcessorControls_SetPreferredNumCaptureChannels_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioProcessorControls_SetPreferredNumCaptureChannels_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.numPreferredChannels);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kAudioProcessorControls_GetStats_Name = 0;
  var kAudioProcessorControls_SetPreferredNumCaptureChannels_Name = 1;

  function AudioProcessorControlsPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioProcessorControls,
                                                   handleOrPtrInfo);
  }

  function AudioProcessorControlsAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioProcessorControls, associatedInterfacePtrInfo);
  }

  AudioProcessorControlsAssociatedPtr.prototype =
      Object.create(AudioProcessorControlsPtr.prototype);
  AudioProcessorControlsAssociatedPtr.prototype.constructor =
      AudioProcessorControlsAssociatedPtr;

  function AudioProcessorControlsProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioProcessorControlsPtr.prototype.getStats = function() {
    return AudioProcessorControlsProxy.prototype.getStats
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioProcessorControlsProxy.prototype.getStats = function() {
    var params_ = new AudioProcessorControls_GetStats_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioProcessorControls_GetStats_Name,
          codec.align(AudioProcessorControls_GetStats_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioProcessorControls_GetStats_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioProcessorControls_GetStats_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioProcessorControlsPtr.prototype.setPreferredNumCaptureChannels = function() {
    return AudioProcessorControlsProxy.prototype.setPreferredNumCaptureChannels
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioProcessorControlsProxy.prototype.setPreferredNumCaptureChannels = function(numPreferredChannels) {
    var params_ = new AudioProcessorControls_SetPreferredNumCaptureChannels_Params();
    params_.numPreferredChannels = numPreferredChannels;
    var builder = new codec.MessageV0Builder(
        kAudioProcessorControls_SetPreferredNumCaptureChannels_Name,
        codec.align(AudioProcessorControls_SetPreferredNumCaptureChannels_Params.encodedSize));
    builder.encodeStruct(AudioProcessorControls_SetPreferredNumCaptureChannels_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AudioProcessorControlsStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioProcessorControlsStub.prototype.getStats = function() {
    return this.delegate_ && this.delegate_.getStats && this.delegate_.getStats();
  }
  AudioProcessorControlsStub.prototype.setPreferredNumCaptureChannels = function(numPreferredChannels) {
    return this.delegate_ && this.delegate_.setPreferredNumCaptureChannels && this.delegate_.setPreferredNumCaptureChannels(numPreferredChannels);
  }

  AudioProcessorControlsStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioProcessorControls_SetPreferredNumCaptureChannels_Name:
      var params = reader.decodeStruct(AudioProcessorControls_SetPreferredNumCaptureChannels_Params);
      this.setPreferredNumCaptureChannels(params.numPreferredChannels);
      return true;
    default:
      return false;
    }
  };

  AudioProcessorControlsStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioProcessorControls_GetStats_Name:
      var params = reader.decodeStruct(AudioProcessorControls_GetStats_Params);
      this.getStats().then(function(response) {
        var responseParams =
            new AudioProcessorControls_GetStats_ResponseParams();
        responseParams.stats = response.stats;
        var builder = new codec.MessageV1Builder(
            kAudioProcessorControls_GetStats_Name,
            codec.align(AudioProcessorControls_GetStats_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioProcessorControls_GetStats_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAudioProcessorControlsRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioProcessorControls_GetStats_Name:
        if (message.expectsResponse())
          paramsClass = AudioProcessorControls_GetStats_Params;
      break;
      case kAudioProcessorControls_SetPreferredNumCaptureChannels_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioProcessorControls_SetPreferredNumCaptureChannels_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioProcessorControlsResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAudioProcessorControls_GetStats_Name:
        if (message.isResponse())
          paramsClass = AudioProcessorControls_GetStats_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AudioProcessorControls = {
    name: 'media.mojom.AudioProcessorControls',
    kVersion: 0,
    ptrClass: AudioProcessorControlsPtr,
    proxyClass: AudioProcessorControlsProxy,
    stubClass: AudioProcessorControlsStub,
    validateRequest: validateAudioProcessorControlsRequest,
    validateResponse: validateAudioProcessorControlsResponse,
  };
  AudioProcessorControlsStub.prototype.validator = validateAudioProcessorControlsRequest;
  AudioProcessorControlsProxy.prototype.validator = validateAudioProcessorControlsResponse;
  exports.AudioProcessingStats = AudioProcessingStats;
  exports.AudioProcessingSettings = AudioProcessingSettings;
  exports.AudioProcessingConfig = AudioProcessingConfig;
  exports.AudioProcessorControls = AudioProcessorControls;
  exports.AudioProcessorControlsPtr = AudioProcessorControlsPtr;
  exports.AudioProcessorControlsAssociatedPtr = AudioProcessorControlsAssociatedPtr;
})();