// media/mojo/mojom/audio_processing.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/audio_processing.mojom-shared-internal.h"

#include "media/mojo/mojom/audio_processing.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AudioProcessingStatsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingStatsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->has_echo_return_loss = Traits::has_echo_return_loss(input);

      fragment->echo_return_loss = Traits::echo_return_loss(input);

      fragment->has_echo_return_loss_enhancement = Traits::has_echo_return_loss_enhancement(input);

      fragment->echo_return_loss_enhancement = Traits::echo_return_loss_enhancement(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AudioProcessingSettingsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingSettingsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->echo_cancellation = Traits::echo_cancellation(input);

      fragment->noise_suppression = Traits::noise_suppression(input);

      fragment->automatic_gain_control = Traits::automatic_gain_control(input);

      fragment->multi_channel_capture_processing = Traits::multi_channel_capture_processing(input);

      fragment->use_loopback_aec_reference = Traits::use_loopback_aec_reference(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::AudioProcessingConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioProcessingConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioProcessingConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::controls_receiver(input)) in_controls_receiver = Traits::controls_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioProcessorControlsInterfaceBase>>(
        in_controls_receiver,
        &fragment->controls_receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->controls_receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid controls_receiver in AudioProcessingConfig struct");

      decltype(Traits::settings(input)) in_settings = Traits::settings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->settings)::BaseType> settings_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::AudioProcessingSettingsDataView, send_validation>(
        in_settings,
        settings_fragment);

      fragment->settings.Set(
          settings_fragment.is_null() ? nullptr : settings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->settings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null settings in AudioProcessingConfig struct");
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_SEND_VALIDATION_H_