// media/mojo/mojom/audio_processing.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('media.mojom.AudioProcessorControls');
goog.provide('media.mojom.AudioProcessorControlsReceiver');
goog.provide('media.mojom.AudioProcessorControlsCallbackRouter');
goog.provide('media.mojom.AudioProcessorControlsInterface');
goog.provide('media.mojom.AudioProcessorControlsRemote');
goog.provide('media.mojom.AudioProcessorControlsPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioProcessorControlsPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioProcessorControls.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.AudioProcessorControlsInterface = class {
  
  /**
   * @return {!Promise<{
        stats: !media.mojom.AudioProcessingStats,
   *  }>}
   */

  getStats() {}
  
  /**
   * @param { !number } numPreferredChannels
   */

  setPreferredNumCaptureChannels(numPreferredChannels) {}
};

/**
 * @export
 * @implements { media.mojom.AudioProcessorControlsInterface }
 */
media.mojom.AudioProcessorControlsRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioProcessorControlsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioProcessorControlsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioProcessorControlsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        stats: !media.mojom.AudioProcessingStats,
   *  }>}
   */

  getStats() {
    return this.proxy.sendMessage(
        0,
        media.mojom.AudioProcessorControls_GetStats_ParamsSpec.$,
        media.mojom.AudioProcessorControls_GetStats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } numPreferredChannels
   */

  setPreferredNumCaptureChannels(
      numPreferredChannels) {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
        null,
        [
          numPreferredChannels
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioProcessorControls
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioProcessorControlsReceiver = class {
  /**
   * @param {!media.mojom.AudioProcessorControlsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioProcessorControlsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioProcessorControlsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioProcessorControlsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioProcessorControls_GetStats_ParamsSpec.$,
        media.mojom.AudioProcessorControls_GetStats_ResponseParamsSpec.$,
        impl.getStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
        null,
        impl.setPreferredNumCaptureChannels.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioProcessorControls = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioProcessorControls";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioProcessorControlsRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioProcessorControlsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioProcessorControls
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioProcessorControlsCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioProcessorControlsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioProcessorControlsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioProcessorControls_GetStats_ParamsSpec.$,
        media.mojom.AudioProcessorControls_GetStats_ResponseParamsSpec.$,
        this.getStats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPreferredNumCaptureChannels =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
        null,
        this.setPreferredNumCaptureChannels.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.AudioProcessingStatsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioProcessingStatsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioProcessingSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioProcessingSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioProcessingConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioProcessingConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioProcessorControls_GetStats_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioProcessorControls_GetStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioProcessorControls_GetStats_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioProcessorControls_GetStats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.AudioProcessingStatsSpec.$,
    'AudioProcessingStats',
    [
      mojo.internal.StructField(
        'hasEchoReturnLoss', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoReturnLoss', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasEchoReturnLossEnhancement', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'echoReturnLossEnhancement', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.AudioProcessingStats');

/** @record */
media.mojom.AudioProcessingStats = class {
  constructor() {
    /** @export { !boolean } */
    this.hasEchoReturnLoss;
    /** @export { !number } */
    this.echoReturnLoss;
    /** @export { !boolean } */
    this.hasEchoReturnLossEnhancement;
    /** @export { !number } */
    this.echoReturnLossEnhancement;
  }
};



mojo.internal.Struct(
    media.mojom.AudioProcessingSettingsSpec.$,
    'AudioProcessingSettings',
    [
      mojo.internal.StructField(
        'echoCancellation', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'noiseSuppression', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'automaticGainControl', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'multiChannelCaptureProcessing', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useLoopbackAecReference', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioProcessingSettings');

/** @record */
media.mojom.AudioProcessingSettings = class {
  constructor() {
    /** @export { !boolean } */
    this.echoCancellation;
    /** @export { !boolean } */
    this.noiseSuppression;
    /** @export { !boolean } */
    this.automaticGainControl;
    /** @export { !boolean } */
    this.multiChannelCaptureProcessing;
    /** @export { !boolean } */
    this.useLoopbackAecReference;
  }
};



mojo.internal.Struct(
    media.mojom.AudioProcessingConfigSpec.$,
    'AudioProcessingConfig',
    [
      mojo.internal.StructField(
        'controlsReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.AudioProcessorControlsPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        media.mojom.AudioProcessingSettingsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.AudioProcessingConfig');

/** @record */
media.mojom.AudioProcessingConfig = class {
  constructor() {
    /** @export { !media.mojom.AudioProcessorControlsPendingReceiver } */
    this.controlsReceiver;
    /** @export { !media.mojom.AudioProcessingSettings } */
    this.settings;
  }
};



mojo.internal.Struct(
    media.mojom.AudioProcessorControls_GetStats_ParamsSpec.$,
    'AudioProcessorControls_GetStats_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.AudioProcessorControls_GetStats_Params');

/** @record */
media.mojom.AudioProcessorControls_GetStats_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioProcessorControls_GetStats_ResponseParamsSpec.$,
    'AudioProcessorControls_GetStats_ResponseParams',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        media.mojom.AudioProcessingStatsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioProcessorControls_GetStats_ResponseParams');

/** @record */
media.mojom.AudioProcessorControls_GetStats_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.AudioProcessingStats } */
    this.stats;
  }
};



mojo.internal.Struct(
    media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
    'AudioProcessorControls_SetPreferredNumCaptureChannels_Params',
    [
      mojo.internal.StructField(
        'numPreferredChannels', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_Params');

/** @record */
media.mojom.AudioProcessorControls_SetPreferredNumCaptureChannels_Params = class {
  constructor() {
    /** @export { !number } */
    this.numPreferredChannels;
  }
};

