// media/mojo/mojom/audio_processing.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/audio_processing.mojom-shared-internal.h"


namespace media::mojom {
class AudioProcessingStatsDataView;

class AudioProcessingSettingsDataView;

class AudioProcessingConfigDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::AudioProcessingStatsDataView> {
  using Data = ::media::mojom::internal::AudioProcessingStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioProcessingSettingsDataView> {
  using Data = ::media::mojom::internal::AudioProcessingSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioProcessingConfigDataView> {
  using Data = ::media::mojom::internal::AudioProcessingConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class AudioProcessorControlsInterfaceBase {};

using AudioProcessorControlsPtrDataView =
    mojo::InterfacePtrDataView<AudioProcessorControlsInterfaceBase>;
using AudioProcessorControlsRequestDataView =
    mojo::InterfaceRequestDataView<AudioProcessorControlsInterfaceBase>;
using AudioProcessorControlsAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioProcessorControlsInterfaceBase>;
using AudioProcessorControlsAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioProcessorControlsInterfaceBase>;


class AudioProcessingStatsDataView {
 public:
  AudioProcessingStatsDataView() = default;

  AudioProcessingStatsDataView(
      internal::AudioProcessingStats_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_echo_return_loss() const {
    return data_->has_echo_return_loss;
  }
  double echo_return_loss() const {
    return data_->echo_return_loss;
  }
  bool has_echo_return_loss_enhancement() const {
    return data_->has_echo_return_loss_enhancement;
  }
  double echo_return_loss_enhancement() const {
    return data_->echo_return_loss_enhancement;
  }
 private:
  internal::AudioProcessingStats_Data* data_ = nullptr;
};


class AudioProcessingSettingsDataView {
 public:
  AudioProcessingSettingsDataView() = default;

  AudioProcessingSettingsDataView(
      internal::AudioProcessingSettings_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool echo_cancellation() const {
    return data_->echo_cancellation;
  }
  bool noise_suppression() const {
    return data_->noise_suppression;
  }
  bool automatic_gain_control() const {
    return data_->automatic_gain_control;
  }
  bool multi_channel_capture_processing() const {
    return data_->multi_channel_capture_processing;
  }
  bool use_loopback_aec_reference() const {
    return data_->use_loopback_aec_reference;
  }
 private:
  internal::AudioProcessingSettings_Data* data_ = nullptr;
};


class AudioProcessingConfigDataView {
 public:
  AudioProcessingConfigDataView() = default;

  AudioProcessingConfigDataView(
      internal::AudioProcessingConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeControlsReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioProcessorControlsInterfaceBase>>(
            &data_->controls_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSettingsDataView(
      AudioProcessingSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioProcessingSettingsDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioProcessingConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_AUDIO_PROCESSING_MOJOM_DATA_VIEW_H_