// media/mojo/mojom/audio_processing.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_processing.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_processing.mojom-params-data.h"
#include "media/mojo/mojom/audio_processing.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_processing.mojom-blink-import-headers.h"
#include "media/mojo/mojom/audio_processing.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
AudioProcessingStats::AudioProcessingStats()
    : has_echo_return_loss(),
      echo_return_loss(),
      has_echo_return_loss_enhancement(),
      echo_return_loss_enhancement() {}

AudioProcessingStats::AudioProcessingStats(
    bool has_echo_return_loss_in,
    double echo_return_loss_in,
    bool has_echo_return_loss_enhancement_in,
    double echo_return_loss_enhancement_in)
    : has_echo_return_loss(std::move(has_echo_return_loss_in)),
      echo_return_loss(std::move(echo_return_loss_in)),
      has_echo_return_loss_enhancement(std::move(has_echo_return_loss_enhancement_in)),
      echo_return_loss_enhancement(std::move(echo_return_loss_enhancement_in)) {}

AudioProcessingStats::~AudioProcessingStats() = default;

void AudioProcessingStats::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_echo_return_loss"), this->has_echo_return_loss,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_return_loss"), this->echo_return_loss,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_echo_return_loss_enhancement"), this->has_echo_return_loss_enhancement,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_return_loss_enhancement"), this->echo_return_loss_enhancement,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioProcessingStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioProcessingSettings::AudioProcessingSettings()
    : echo_cancellation(),
      noise_suppression(),
      automatic_gain_control(),
      multi_channel_capture_processing(),
      use_loopback_aec_reference() {}

AudioProcessingSettings::AudioProcessingSettings(
    bool echo_cancellation_in,
    bool noise_suppression_in,
    bool automatic_gain_control_in,
    bool multi_channel_capture_processing_in,
    bool use_loopback_aec_reference_in)
    : echo_cancellation(std::move(echo_cancellation_in)),
      noise_suppression(std::move(noise_suppression_in)),
      automatic_gain_control(std::move(automatic_gain_control_in)),
      multi_channel_capture_processing(std::move(multi_channel_capture_processing_in)),
      use_loopback_aec_reference(std::move(use_loopback_aec_reference_in)) {}

AudioProcessingSettings::~AudioProcessingSettings() = default;

void AudioProcessingSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_cancellation"), this->echo_cancellation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "noise_suppression"), this->noise_suppression,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "automatic_gain_control"), this->automatic_gain_control,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multi_channel_capture_processing"), this->multi_channel_capture_processing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_loopback_aec_reference"), this->use_loopback_aec_reference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioProcessingSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioProcessingConfig::AudioProcessingConfig()
    : controls_receiver(),
      settings() {}

AudioProcessingConfig::AudioProcessingConfig(
    ::mojo::PendingReceiver<AudioProcessorControls> controls_receiver_in,
    const ::media::AudioProcessingSettings& settings_in)
    : controls_receiver(std::move(controls_receiver_in)),
      settings(std::move(settings_in)) {}

AudioProcessingConfig::~AudioProcessingConfig() = default;

void AudioProcessingConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "controls_receiver"), this->controls_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<AudioProcessorControls>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "settings"), this->settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::AudioProcessingSettings&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioProcessingConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AudioProcessorControls::IPCStableHashFunction AudioProcessorControls::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioProcessorControls>(message.name())) {
    case messages::AudioProcessorControls::kGetStats: {
      return &AudioProcessorControls::GetStats_Sym::IPCStableHash;
    }
    case messages::AudioProcessorControls::kSetPreferredNumCaptureChannels: {
      return &AudioProcessorControls::SetPreferredNumCaptureChannels_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioProcessorControls::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioProcessorControls>(message.name())) {
      case messages::AudioProcessorControls::kGetStats:
            return "Receive media::mojom::AudioProcessorControls::GetStats";
      case messages::AudioProcessorControls::kSetPreferredNumCaptureChannels:
            return "Receive media::mojom::AudioProcessorControls::SetPreferredNumCaptureChannels";
    }
  } else {
    switch (static_cast<messages::AudioProcessorControls>(message.name())) {
      case messages::AudioProcessorControls::kGetStats:
            return "Receive reply media::mojom::AudioProcessorControls::GetStats";
      case messages::AudioProcessorControls::kSetPreferredNumCaptureChannels:
            return "Receive reply media::mojom::AudioProcessorControls::SetPreferredNumCaptureChannels";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioProcessorControls::GetStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5b16728;  // IPCStableHash for media::mojom::AudioProcessorControls::GetStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioProcessorControls::SetPreferredNumCaptureChannels_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x740ec1ac;  // IPCStableHash for media::mojom::AudioProcessorControls::SetPreferredNumCaptureChannels
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AudioProcessorControls_GetStats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioProcessorControls_GetStats_ForwardToCallback(
      AudioProcessorControls::GetStatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioProcessorControls_GetStats_ForwardToCallback(const AudioProcessorControls_GetStats_ForwardToCallback&) = delete;
  AudioProcessorControls_GetStats_ForwardToCallback& operator=(const AudioProcessorControls_GetStats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioProcessorControls::GetStatsCallback callback_;
};

AudioProcessorControlsProxy::AudioProcessorControlsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioProcessorControlsProxy::GetStats(
    GetStatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioProcessorControls::GetStats");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioProcessorControls::kGetStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioProcessorControls_GetStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioProcessorControls::Name_);
  message.set_method_name("GetStats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioProcessorControls_GetStats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioProcessorControlsProxy::SetPreferredNumCaptureChannels(
    int32_t in_num_preferred_channels) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioProcessorControls::SetPreferredNumCaptureChannels", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_preferred_channels"), in_num_preferred_channels,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioProcessorControls::kSetPreferredNumCaptureChannels), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioProcessorControls_SetPreferredNumCaptureChannels_Params_Data> params(
          message);
  params.Allocate();

  params->num_preferred_channels = in_num_preferred_channels;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioProcessorControls::Name_);
  message.set_method_name("SetPreferredNumCaptureChannels");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AudioProcessorControls_GetStats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioProcessorControls::GetStatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioProcessorControls_GetStats_ProxyToResponder> proxy(
        new AudioProcessorControls_GetStats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioProcessorControls_GetStats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioProcessorControls_GetStats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioProcessorControls_GetStats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioProcessorControls::GetStatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::AudioProcessingStats& in_stats);
};

bool AudioProcessorControls_GetStats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioProcessorControls_GetStats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioProcessorControls_GetStats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioProcessorControls.0
  bool success = true;
  ::media::AudioProcessingStats p_stats{};
  AudioProcessorControls_GetStats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStats(&p_stats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioProcessorControls::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_stats));
  }
  return true;
}

void AudioProcessorControls_GetStats_ProxyToResponder::Run(
    const ::media::AudioProcessingStats& in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioProcessorControls::GetStats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats,
                        "<value of type const ::media::AudioProcessingStats&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioProcessorControls::kGetStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioProcessorControls_GetStats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioProcessingStatsDataView>(
    in_stats,
    stats_fragment);

  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stats in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioProcessorControls::Name_);
  message.set_method_name("GetStats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioProcessorControlsStubDispatch::Accept(
    AudioProcessorControls* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioProcessorControls>(message->header()->name)) {
    case messages::AudioProcessorControls::kGetStats: {
      break;
    }
    case messages::AudioProcessorControls::kSetPreferredNumCaptureChannels: {
      DCHECK(message->is_serialized());
      internal::AudioProcessorControls_SetPreferredNumCaptureChannels_Params_Data* params =
          reinterpret_cast<internal::AudioProcessorControls_SetPreferredNumCaptureChannels_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioProcessorControls.1
      bool success = true;
      int32_t p_num_preferred_channels{};
      AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_num_preferred_channels = input_data_view.num_preferred_channels();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioProcessorControls::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreferredNumCaptureChannels(        
        std::move(p_num_preferred_channels));
      return true;
    }
  }
  return false;
}

// static
bool AudioProcessorControlsStubDispatch::AcceptWithResponder(
    AudioProcessorControls* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioProcessorControls>(message->header()->name)) {
    case messages::AudioProcessorControls::kGetStats: {
      internal::AudioProcessorControls_GetStats_Params_Data* params =
          reinterpret_cast<
              internal::AudioProcessorControls_GetStats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioProcessorControls.0
      bool success = true;
      AudioProcessorControls_GetStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioProcessorControls::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioProcessorControls_GetStats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStats(std::move(callback));
      return true;
    }
    case messages::AudioProcessorControls::kSetPreferredNumCaptureChannels: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioProcessorControlsValidationInfo[] = {
    { &internal::AudioProcessorControls_GetStats_Params_Data::Validate,
     &internal::AudioProcessorControls_GetStats_ResponseParams_Data::Validate},
    { &internal::AudioProcessorControls_SetPreferredNumCaptureChannels_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioProcessorControlsRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::AudioProcessorControls::Name_,
    kAudioProcessorControlsValidationInfo);
}

bool AudioProcessorControlsResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::AudioProcessorControls::Name_,
    kAudioProcessorControlsValidationInfo);
}


}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::AudioProcessingStats::DataView, ::media::mojom::blink::AudioProcessingStatsPtr>::Read(
    ::media::mojom::blink::AudioProcessingStats::DataView input,
    ::media::mojom::blink::AudioProcessingStatsPtr* output) {
  bool success = true;
  ::media::mojom::blink::AudioProcessingStatsPtr result(::media::mojom::blink::AudioProcessingStats::New());
  
      if (success)
        result->has_echo_return_loss = input.has_echo_return_loss();
      if (success)
        result->echo_return_loss = input.echo_return_loss();
      if (success)
        result->has_echo_return_loss_enhancement = input.has_echo_return_loss_enhancement();
      if (success)
        result->echo_return_loss_enhancement = input.echo_return_loss_enhancement();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::AudioProcessingSettings::DataView, ::media::mojom::blink::AudioProcessingSettingsPtr>::Read(
    ::media::mojom::blink::AudioProcessingSettings::DataView input,
    ::media::mojom::blink::AudioProcessingSettingsPtr* output) {
  bool success = true;
  ::media::mojom::blink::AudioProcessingSettingsPtr result(::media::mojom::blink::AudioProcessingSettings::New());
  
      if (success)
        result->echo_cancellation = input.echo_cancellation();
      if (success)
        result->noise_suppression = input.noise_suppression();
      if (success)
        result->automatic_gain_control = input.automatic_gain_control();
      if (success)
        result->multi_channel_capture_processing = input.multi_channel_capture_processing();
      if (success)
        result->use_loopback_aec_reference = input.use_loopback_aec_reference();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::AudioProcessingConfig::DataView, ::media::mojom::blink::AudioProcessingConfigPtr>::Read(
    ::media::mojom::blink::AudioProcessingConfig::DataView input,
    ::media::mojom::blink::AudioProcessingConfigPtr* output) {
  bool success = true;
  ::media::mojom::blink::AudioProcessingConfigPtr result(::media::mojom::blink::AudioProcessingConfig::New());
  
      if (success) {
        result->controls_receiver =
            input.TakeControlsReceiver<decltype(result->controls_receiver)>();
      }
      if (success && !input.ReadSettings(&result->settings))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void AudioProcessorControlsInterceptorForTesting::GetStats(GetStatsCallback callback) {
  GetForwardingInterface()->GetStats(std::move(callback));
}
void AudioProcessorControlsInterceptorForTesting::SetPreferredNumCaptureChannels(int32_t num_preferred_channels) {
  GetForwardingInterface()->SetPreferredNumCaptureChannels(
    std::move(num_preferred_channels)
    );
}
AudioProcessorControlsAsyncWaiter::AudioProcessorControlsAsyncWaiter(
    AudioProcessorControls* proxy) : proxy_(proxy) {}

AudioProcessorControlsAsyncWaiter::~AudioProcessorControlsAsyncWaiter() = default;


void AudioProcessorControlsAsyncWaiter::GetStats(
    ::media::AudioProcessingStats* out_stats) {
  base::RunLoop loop;
  proxy_->GetStats(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::AudioProcessingStats* out_stats
,
             const ::media::AudioProcessingStats& stats) {*out_stats = std::move(stats);
            loop->Quit();
          },
          &loop,
          out_stats));
  loop.Run();
}

::media::AudioProcessingStats AudioProcessorControlsAsyncWaiter::GetStats(
    ) {
  ::media::AudioProcessingStats async_wait_result;
  GetStats(&async_wait_result);
  return async_wait_result;
}






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif