// media/mojo/mojom/audio_input_stream.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  InputStreamErrorCode as media_mojom_InputStreamErrorCode,
  InputStreamErrorCodeSpec as media_mojom_InputStreamErrorCodeSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioInputStreamPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioInputStream', scope);
  }
}

/** @interface */
export class AudioInputStreamInterface {
  
  /**
   */

  record() {}
  
  /**
   * @param { !number } volume
   */

  setVolume(volume) {}
}

/**
 * @implements { AudioInputStreamInterface }
 */
export class AudioInputStreamRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioInputStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioInputStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioInputStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  record() {
    this.proxy.sendMessage(
        0,
        AudioInputStream_Record_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        1,
        AudioInputStream_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioInputStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioInputStreamReceiver {
  /**
   * @param {!AudioInputStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioInputStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioInputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioInputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioInputStream_Record_ParamsSpec.$,
        null,
        impl.record.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioInputStream_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioInputStream {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioInputStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioInputStreamRemote}
   */
  static getRemote() {
    let remote = new AudioInputStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioInputStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioInputStreamCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioInputStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioInputStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.record =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioInputStream_Record_ParamsSpec.$,
        null,
        this.record.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioInputStream_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioInputStreamClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioInputStreamClient', scope);
  }
}

/** @interface */
export class AudioInputStreamClientInterface {
  
  /**
   * @param { !media_mojom_InputStreamErrorCode } code
   */

  onError(code) {}
  
  /**
   * @param { !boolean } isMuted
   */

  onMutedStateChanged(isMuted) {}
}

/**
 * @implements { AudioInputStreamClientInterface }
 */
export class AudioInputStreamClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioInputStreamClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioInputStreamClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioInputStreamClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_InputStreamErrorCode } code
   */

  onError(
      code) {
    this.proxy.sendMessage(
        0,
        AudioInputStreamClient_OnError_ParamsSpec.$,
        null,
        [
          code
        ],
        false);
  }

  
  /**
   * @param { !boolean } isMuted
   */

  onMutedStateChanged(
      isMuted) {
    this.proxy.sendMessage(
        1,
        AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
        null,
        [
          isMuted
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioInputStreamClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioInputStreamClientReceiver {
  /**
   * @param {!AudioInputStreamClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioInputStreamClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioInputStreamClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioInputStreamClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioInputStreamClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
        null,
        impl.onMutedStateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioInputStreamClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioInputStreamClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioInputStreamClientRemote}
   */
  static getRemote() {
    let remote = new AudioInputStreamClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioInputStreamClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioInputStreamClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioInputStreamClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioInputStreamClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioInputStreamClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMutedStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
        null,
        this.onMutedStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioInputStreamObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioInputStreamObserver', scope);
  }
}

/** @interface */
export class AudioInputStreamObserverInterface {
  
  /**
   */

  didStartRecording() {}
}

/**
 * @implements { AudioInputStreamObserverInterface }
 */
export class AudioInputStreamObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioInputStreamObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioInputStreamObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioInputStreamObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  didStartRecording() {
    this.proxy.sendMessage(
        0,
        AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioInputStreamObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioInputStreamObserverReceiver {
  /**
   * @param {!AudioInputStreamObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioInputStreamObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioInputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioInputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
        null,
        impl.didStartRecording.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioInputStreamObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioInputStreamObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioInputStreamObserverRemote}
   */
  static getRemote() {
    let remote = new AudioInputStreamObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioInputStreamObserver_DisconnectReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioInputStreamObserver_DisconnectReason = {
  
  kDefault: 0,
  kPlatformError: 1,
  kTerminatedByClient: 2,
  kStreamCreationFailed: 3,
  kDocumentDestroyed: 4,
  kSystemPermissions: 5,
  kDeviceInUse: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * An object which receives request messages for the AudioInputStreamObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioInputStreamObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioInputStreamObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioInputStreamObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartRecording =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
        null,
        this.didStartRecording.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioInputStream_Record_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioInputStream_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioInputStreamClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioInputStreamClient_OnMutedStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioInputStreamObserver_DidStartRecording_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioInputStream_Record_ParamsSpec.$,
    'AudioInputStream_Record_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioInputStream_Record_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioInputStream_SetVolume_ParamsSpec.$,
    'AudioInputStream_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioInputStream_SetVolume_Params {
  constructor() {
    /** @type { !number } */
    this.volume;
  }
}



mojo.internal.Struct(
    AudioInputStreamClient_OnError_ParamsSpec.$,
    'AudioInputStreamClient_OnError_Params',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        media_mojom_InputStreamErrorCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioInputStreamClient_OnError_Params {
  constructor() {
    /** @type { !media_mojom_InputStreamErrorCode } */
    this.code;
  }
}



mojo.internal.Struct(
    AudioInputStreamClient_OnMutedStateChanged_ParamsSpec.$,
    'AudioInputStreamClient_OnMutedStateChanged_Params',
    [
      mojo.internal.StructField(
        'isMuted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioInputStreamClient_OnMutedStateChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.isMuted;
  }
}



mojo.internal.Struct(
    AudioInputStreamObserver_DidStartRecording_ParamsSpec.$,
    'AudioInputStreamObserver_DidStartRecording_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioInputStreamObserver_DidStartRecording_Params {
  constructor() {
  }
}

