// media/mojo/mojom/audio_input_stream.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  AudioInputStream_Record_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioInputStream_Record_Params_Data>;

  AudioInputStream_Record_Params_Data();
  ~AudioInputStream_Record_Params_Data() = delete;
};
static_assert(sizeof(AudioInputStream_Record_Params_Data) == 8,
              "Bad sizeof(AudioInputStream_Record_Params_Data)");
class  AudioInputStream_SetVolume_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double volume;

 private:
  friend class mojo::internal::MessageFragment<AudioInputStream_SetVolume_Params_Data>;

  AudioInputStream_SetVolume_Params_Data();
  ~AudioInputStream_SetVolume_Params_Data() = delete;
};
static_assert(sizeof(AudioInputStream_SetVolume_Params_Data) == 16,
              "Bad sizeof(AudioInputStream_SetVolume_Params_Data)");
class  AudioInputStreamClient_OnError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AudioInputStreamClient_OnError_Params_Data>;

  AudioInputStreamClient_OnError_Params_Data();
  ~AudioInputStreamClient_OnError_Params_Data() = delete;
};
static_assert(sizeof(AudioInputStreamClient_OnError_Params_Data) == 16,
              "Bad sizeof(AudioInputStreamClient_OnError_Params_Data)");
class  AudioInputStreamClient_OnMutedStateChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_muted : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AudioInputStreamClient_OnMutedStateChanged_Params_Data>;

  AudioInputStreamClient_OnMutedStateChanged_Params_Data();
  ~AudioInputStreamClient_OnMutedStateChanged_Params_Data() = delete;
};
static_assert(sizeof(AudioInputStreamClient_OnMutedStateChanged_Params_Data) == 16,
              "Bad sizeof(AudioInputStreamClient_OnMutedStateChanged_Params_Data)");
class  AudioInputStreamObserver_DidStartRecording_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioInputStreamObserver_DidStartRecording_Params_Data>;

  AudioInputStreamObserver_DidStartRecording_Params_Data();
  ~AudioInputStreamObserver_DidStartRecording_Params_Data() = delete;
};
static_assert(sizeof(AudioInputStreamObserver_DidStartRecording_Params_Data) == 8,
              "Bad sizeof(AudioInputStreamObserver_DidStartRecording_Params_Data)");

}  // namespace internal


class AudioInputStream_Record_ParamsDataView {
 public:
  AudioInputStream_Record_ParamsDataView() = default;

  AudioInputStream_Record_ParamsDataView(
      internal::AudioInputStream_Record_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioInputStream_Record_Params_Data* data_ = nullptr;
};


class AudioInputStream_SetVolume_ParamsDataView {
 public:
  AudioInputStream_SetVolume_ParamsDataView() = default;

  AudioInputStream_SetVolume_ParamsDataView(
      internal::AudioInputStream_SetVolume_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double volume() const {
    return data_->volume;
  }
 private:
  internal::AudioInputStream_SetVolume_Params_Data* data_ = nullptr;
};


class AudioInputStreamClient_OnError_ParamsDataView {
 public:
  AudioInputStreamClient_OnError_ParamsDataView() = default;

  AudioInputStreamClient_OnError_ParamsDataView(
      internal::AudioInputStreamClient_OnError_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::media::mojom::InputStreamErrorCode>(
        data_value, output);
  }
  ::media::mojom::InputStreamErrorCode code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::InputStreamErrorCode>(data_->code));
  }
 private:
  internal::AudioInputStreamClient_OnError_Params_Data* data_ = nullptr;
};


class AudioInputStreamClient_OnMutedStateChanged_ParamsDataView {
 public:
  AudioInputStreamClient_OnMutedStateChanged_ParamsDataView() = default;

  AudioInputStreamClient_OnMutedStateChanged_ParamsDataView(
      internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_muted() const {
    return data_->is_muted;
  }
 private:
  internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data* data_ = nullptr;
};


class AudioInputStreamObserver_DidStartRecording_ParamsDataView {
 public:
  AudioInputStreamObserver_DidStartRecording_ParamsDataView() = default;

  AudioInputStreamObserver_DidStartRecording_ParamsDataView(
      internal::AudioInputStreamObserver_DidStartRecording_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioInputStreamObserver_DidStartRecording_Params_Data* data_ = nullptr;
};












}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_PARAMS_DATA_H_