// media/mojo/mojom/audio_encoder.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/audio_encoder.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace media::mojom {
class AacAudioEncoderConfigDataView;

class AudioEncoderConfigDataView;

class EncodedAudioBufferDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::AacAudioEncoderConfigDataView> {
  using Data = ::media::mojom::internal::AacAudioEncoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioEncoderConfigDataView> {
  using Data = ::media::mojom::internal::AudioEncoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::EncodedAudioBufferDataView> {
  using Data = ::media::mojom::internal::EncodedAudioBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class AacOutputFormat : int32_t {
  
  kAAC = 0,
  
  kADTS = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, AacOutputFormat value);
inline bool IsKnownEnumValue(AacOutputFormat value) {
  return internal::AacOutputFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AudioEncoderInterfaceBase {};

using AudioEncoderPtrDataView =
    mojo::InterfacePtrDataView<AudioEncoderInterfaceBase>;
using AudioEncoderRequestDataView =
    mojo::InterfaceRequestDataView<AudioEncoderInterfaceBase>;
using AudioEncoderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioEncoderInterfaceBase>;
using AudioEncoderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioEncoderInterfaceBase>;
class AudioEncoderClientInterfaceBase {};

using AudioEncoderClientPtrDataView =
    mojo::InterfacePtrDataView<AudioEncoderClientInterfaceBase>;
using AudioEncoderClientRequestDataView =
    mojo::InterfaceRequestDataView<AudioEncoderClientInterfaceBase>;
using AudioEncoderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioEncoderClientInterfaceBase>;
using AudioEncoderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioEncoderClientInterfaceBase>;


class AacAudioEncoderConfigDataView {
 public:
  AacAudioEncoderConfigDataView() = default;

  AacAudioEncoderConfigDataView(
      internal::AacAudioEncoderConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::media::mojom::AacOutputFormat>(
        data_value, output);
  }
  AacOutputFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AacOutputFormat>(data_->format));
  }
 private:
  internal::AacAudioEncoderConfig_Data* data_ = nullptr;
};


class AudioEncoderConfigDataView {
 public:
  AudioEncoderConfigDataView() = default;

  AudioEncoderConfigDataView(
      internal::AudioEncoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::media::mojom::AudioCodec>(
        data_value, output);
  }
  ::media::mojom::AudioCodec codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodec>(data_->codec));
  }
  uint8_t channel_count() const {
    return data_->channel_count;
  }
  uint32_t sample_rate() const {
    return data_->sample_rate;
  }
  uint32_t bitrate() const {
    return data_->bitrate;
  }
  inline void GetAacDataView(
      AacAudioEncoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAac(UserType* output) {
    
    auto* pointer = data_->aac.Get();
    return mojo::internal::Deserialize<::media::mojom::AacAudioEncoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioEncoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EncodedAudioBufferDataView {
 public:
  EncodedAudioBufferDataView() = default;

  EncodedAudioBufferDataView(
      internal::EncodedAudioBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::EncodedAudioBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_DATA_VIEW_H_