// media/mojo/mojom/audio_decoder.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  AudioDecoder_GetSupportedConfigs_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_GetSupportedConfigs_Params_Data>;

  AudioDecoder_GetSupportedConfigs_Params_Data();
  ~AudioDecoder_GetSupportedConfigs_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoder_GetSupportedConfigs_Params_Data) == 8,
              "Bad sizeof(AudioDecoder_GetSupportedConfigs_Params_Data)");
class  AudioDecoder_GetSupportedConfigs_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SupportedAudioDecoderConfig_Data>>> supported_configs;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_GetSupportedConfigs_ResponseParams_Data>;

  AudioDecoder_GetSupportedConfigs_ResponseParams_Data();
  ~AudioDecoder_GetSupportedConfigs_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioDecoder_GetSupportedConfigs_ResponseParams_Data) == 16,
              "Bad sizeof(AudioDecoder_GetSupportedConfigs_ResponseParams_Data)");
class  AudioDecoder_Construct_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data client;
  mojo::internal::Interface_Data media_log;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_Construct_Params_Data>;

  AudioDecoder_Construct_Params_Data();
  ~AudioDecoder_Construct_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoder_Construct_Params_Data) == 24,
              "Bad sizeof(AudioDecoder_Construct_Params_Data)");
class  AudioDecoder_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::AudioDecoderConfig_Data> config;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> cdm_id;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_Initialize_Params_Data>;

  AudioDecoder_Initialize_Params_Data();
  ~AudioDecoder_Initialize_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoder_Initialize_Params_Data) == 24,
              "Bad sizeof(AudioDecoder_Initialize_Params_Data)");
class  AudioDecoder_Initialize_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::DecoderStatus_Data> success;
  uint8_t needs_bitstream_conversion : 1;
  uint8_t pad1_[3];
  int32_t decoder_type;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_Initialize_ResponseParams_Data>;

  AudioDecoder_Initialize_ResponseParams_Data();
  ~AudioDecoder_Initialize_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioDecoder_Initialize_ResponseParams_Data) == 24,
              "Bad sizeof(AudioDecoder_Initialize_ResponseParams_Data)");
class  AudioDecoder_SetDataSource_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receive_pipe;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_SetDataSource_Params_Data>;

  AudioDecoder_SetDataSource_Params_Data();
  ~AudioDecoder_SetDataSource_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoder_SetDataSource_Params_Data) == 16,
              "Bad sizeof(AudioDecoder_SetDataSource_Params_Data)");
class  AudioDecoder_Decode_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::media::mojom::internal::DecoderBuffer_Data buffer;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_Decode_Params_Data>;

  AudioDecoder_Decode_Params_Data();
  ~AudioDecoder_Decode_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoder_Decode_Params_Data) == 24,
              "Bad sizeof(AudioDecoder_Decode_Params_Data)");
class  AudioDecoder_Decode_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::DecoderStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_Decode_ResponseParams_Data>;

  AudioDecoder_Decode_ResponseParams_Data();
  ~AudioDecoder_Decode_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioDecoder_Decode_ResponseParams_Data) == 16,
              "Bad sizeof(AudioDecoder_Decode_ResponseParams_Data)");
class  AudioDecoder_Reset_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_Reset_Params_Data>;

  AudioDecoder_Reset_Params_Data();
  ~AudioDecoder_Reset_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoder_Reset_Params_Data) == 8,
              "Bad sizeof(AudioDecoder_Reset_Params_Data)");
class  AudioDecoder_Reset_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoder_Reset_ResponseParams_Data>;

  AudioDecoder_Reset_ResponseParams_Data();
  ~AudioDecoder_Reset_ResponseParams_Data() = delete;
};
static_assert(sizeof(AudioDecoder_Reset_ResponseParams_Data) == 8,
              "Bad sizeof(AudioDecoder_Reset_ResponseParams_Data)");
class  AudioDecoderClient_OnBufferDecoded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::AudioBuffer_Data> buffer;

 private:
  friend class mojo::internal::MessageFragment<AudioDecoderClient_OnBufferDecoded_Params_Data>;

  AudioDecoderClient_OnBufferDecoded_Params_Data();
  ~AudioDecoderClient_OnBufferDecoded_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoderClient_OnBufferDecoded_Params_Data) == 16,
              "Bad sizeof(AudioDecoderClient_OnBufferDecoded_Params_Data)");
class  AudioDecoderClient_OnWaiting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AudioDecoderClient_OnWaiting_Params_Data>;

  AudioDecoderClient_OnWaiting_Params_Data();
  ~AudioDecoderClient_OnWaiting_Params_Data() = delete;
};
static_assert(sizeof(AudioDecoderClient_OnWaiting_Params_Data) == 16,
              "Bad sizeof(AudioDecoderClient_OnWaiting_Params_Data)");

}  // namespace internal


class AudioDecoder_GetSupportedConfigs_ParamsDataView {
 public:
  AudioDecoder_GetSupportedConfigs_ParamsDataView() = default;

  AudioDecoder_GetSupportedConfigs_ParamsDataView(
      internal::AudioDecoder_GetSupportedConfigs_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioDecoder_GetSupportedConfigs_Params_Data* data_ = nullptr;
};


class AudioDecoder_GetSupportedConfigs_ResponseParamsDataView {
 public:
  AudioDecoder_GetSupportedConfigs_ResponseParamsDataView() = default;

  AudioDecoder_GetSupportedConfigs_ResponseParamsDataView(
      internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedConfigsDataView(
      mojo::ArrayDataView<SupportedAudioDecoderConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedConfigs(UserType* output) {
    
    auto* pointer = data_->supported_configs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SupportedAudioDecoderConfigDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AudioDecoder_GetSupportedConfigs_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoder_Construct_ParamsDataView {
 public:
  AudioDecoder_Construct_ParamsDataView() = default;

  AudioDecoder_Construct_ParamsDataView(
      internal::AudioDecoder_Construct_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::AudioDecoderClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMediaLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::MediaLogInterfaceBase>>(
            &data_->media_log, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AudioDecoder_Construct_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoder_Initialize_ParamsDataView {
 public:
  AudioDecoder_Initialize_ParamsDataView() = default;

  AudioDecoder_Initialize_ParamsDataView(
      internal::AudioDecoder_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ::media::mojom::AudioDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderConfigDataView>(
        pointer, output, message_);
  }
  inline void GetCdmIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCdmId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `cdm_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCdmId` instead "
    "of `ReadCdmId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cdm_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioDecoder_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoder_Initialize_ResponseParamsDataView {
 public:
  AudioDecoder_Initialize_ResponseParamsDataView() = default;

  AudioDecoder_Initialize_ResponseParamsDataView(
      internal::AudioDecoder_Initialize_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSuccessDataView(
      ::media::mojom::DecoderStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) {
    
    auto* pointer = data_->success.Get();
    return mojo::internal::Deserialize<::media::mojom::DecoderStatusDataView>(
        pointer, output, message_);
  }
  bool needs_bitstream_conversion() const {
    return data_->needs_bitstream_conversion;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoderType(UserType* output) const {
    auto data_value = data_->decoder_type;
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderType>(
        data_value, output);
  }
  ::media::mojom::AudioDecoderType decoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioDecoderType>(data_->decoder_type));
  }
 private:
  internal::AudioDecoder_Initialize_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoder_SetDataSource_ParamsDataView {
 public:
  AudioDecoder_SetDataSource_ParamsDataView() = default;

  AudioDecoder_SetDataSource_ParamsDataView(
      internal::AudioDecoder_SetDataSource_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedDataPipeConsumerHandle TakeReceivePipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->receive_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AudioDecoder_SetDataSource_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoder_Decode_ParamsDataView {
 public:
  AudioDecoder_Decode_ParamsDataView() = default;

  AudioDecoder_Decode_ParamsDataView(
      internal::AudioDecoder_Decode_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBufferDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
    auto* pointer = !data_->buffer.is_null() ? &data_->buffer : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioDecoder_Decode_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoder_Decode_ResponseParamsDataView {
 public:
  AudioDecoder_Decode_ResponseParamsDataView() = default;

  AudioDecoder_Decode_ResponseParamsDataView(
      internal::AudioDecoder_Decode_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::media::mojom::DecoderStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::mojom::DecoderStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioDecoder_Decode_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoder_Reset_ParamsDataView {
 public:
  AudioDecoder_Reset_ParamsDataView() = default;

  AudioDecoder_Reset_ParamsDataView(
      internal::AudioDecoder_Reset_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioDecoder_Reset_Params_Data* data_ = nullptr;
};


class AudioDecoder_Reset_ResponseParamsDataView {
 public:
  AudioDecoder_Reset_ResponseParamsDataView() = default;

  AudioDecoder_Reset_ResponseParamsDataView(
      internal::AudioDecoder_Reset_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioDecoder_Reset_ResponseParams_Data* data_ = nullptr;
};


class AudioDecoderClient_OnBufferDecoded_ParamsDataView {
 public:
  AudioDecoderClient_OnBufferDecoded_ParamsDataView() = default;

  AudioDecoderClient_OnBufferDecoded_ParamsDataView(
      internal::AudioDecoderClient_OnBufferDecoded_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBufferDataView(
      ::media::mojom::AudioBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
    auto* pointer = data_->buffer.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioDecoderClient_OnBufferDecoded_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioDecoderClient_OnWaiting_ParamsDataView {
 public:
  AudioDecoderClient_OnWaiting_ParamsDataView() = default;

  AudioDecoderClient_OnWaiting_ParamsDataView(
      internal::AudioDecoderClient_OnWaiting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::WaitingReason>(
        data_value, output);
  }
  ::media::mojom::WaitingReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::WaitingReason>(data_->reason));
  }
 private:
  internal::AudioDecoderClient_OnWaiting_Params_Data* data_ = nullptr;
};



inline void AudioDecoder_GetSupportedConfigs_ResponseParamsDataView::GetSupportedConfigsDataView(
    mojo::ArrayDataView<SupportedAudioDecoderConfigDataView>* output) {
  auto pointer = data_->supported_configs.Get();
  *output = mojo::ArrayDataView<SupportedAudioDecoderConfigDataView>(pointer, message_);
}




inline void AudioDecoder_Initialize_ParamsDataView::GetConfigDataView(
    ::media::mojom::AudioDecoderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ::media::mojom::AudioDecoderConfigDataView(pointer, message_);
}
inline void AudioDecoder_Initialize_ParamsDataView::GetCdmIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->cdm_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void AudioDecoder_Initialize_ResponseParamsDataView::GetSuccessDataView(
    ::media::mojom::DecoderStatusDataView* output) {
  auto pointer = data_->success.Get();
  *output = ::media::mojom::DecoderStatusDataView(pointer, message_);
}




inline void AudioDecoder_Decode_ParamsDataView::GetBufferDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->buffer;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}


inline void AudioDecoder_Decode_ResponseParamsDataView::GetStatusDataView(
    ::media::mojom::DecoderStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::mojom::DecoderStatusDataView(pointer, message_);
}






inline void AudioDecoderClient_OnBufferDecoded_ParamsDataView::GetBufferDataView(
    ::media::mojom::AudioBufferDataView* output) {
  auto pointer = data_->buffer.Get();
  *output = ::media::mojom::AudioBufferDataView(pointer, message_);
}





}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_PARAMS_DATA_H_