// media/mojo/mojom/audio_decoder.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.AudioCodec');
goog.require('media.mojom.AudioCodecProfile');
goog.require('media.mojom.AudioDecoderType');
goog.require('media.mojom.WaitingReason');
goog.require('media.mojom.MediaLog');
goog.require('media.mojom.AudioBuffer');
goog.require('media.mojom.AudioDecoderConfig');
goog.require('media.mojom.DecoderStatus');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('media.mojom.DecoderBuffer');






goog.provide('media.mojom.AudioDecoder');
goog.provide('media.mojom.AudioDecoderReceiver');
goog.provide('media.mojom.AudioDecoderCallbackRouter');
goog.provide('media.mojom.AudioDecoderInterface');
goog.provide('media.mojom.AudioDecoderRemote');
goog.provide('media.mojom.AudioDecoderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioDecoderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioDecoder.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.AudioDecoderInterface = class {
  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!media.mojom.SupportedAudioDecoderConfig>,
   *  }>}
   */

  getSupportedConfigs() {}
  
  /**
   * @param { !Object } client
   * @param { !media.mojom.MediaLogRemote } mediaLog
   */

  construct(client, mediaLog) {}
  
  /**
   * @param { !media.mojom.AudioDecoderConfig } config
   * @param { ?mojoBase.mojom.UnguessableToken } cdmId
   * @return {!Promise<{
        success: !media.mojom.DecoderStatus,
        needsBitstreamConversion: !boolean,
        decoderType: !media.mojom.AudioDecoderType,
   *  }>}
   */

  initialize(config, cdmId) {}
  
  /**
   * @param { !MojoHandle } receivePipe
   */

  setDataSource(receivePipe) {}
  
  /**
   * @param { !media.mojom.DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media.mojom.DecoderStatus,
   *  }>}
   */

  decode(buffer) {}
  
  /**
   * @return {!Promise}
   */

  reset() {}
};

/**
 * @export
 * @implements { media.mojom.AudioDecoderInterface }
 */
media.mojom.AudioDecoderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioDecoderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioDecoderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioDecoderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!media.mojom.SupportedAudioDecoderConfig>,
   *  }>}
   */

  getSupportedConfigs() {
    return this.proxy.sendMessage(
        0,
        media.mojom.AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
        media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !media.mojom.MediaLogRemote } mediaLog
   */

  construct(
      client,
      mediaLog) {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioDecoder_Construct_ParamsSpec.$,
        null,
        [
          client,
          mediaLog
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.AudioDecoderConfig } config
   * @param { ?mojoBase.mojom.UnguessableToken } cdmId
   * @return {!Promise<{
        success: !media.mojom.DecoderStatus,
        needsBitstreamConversion: !boolean,
        decoderType: !media.mojom.AudioDecoderType,
   *  }>}
   */

  initialize(
      config,
      cdmId) {
    return this.proxy.sendMessage(
        2,
        media.mojom.AudioDecoder_Initialize_ParamsSpec.$,
        media.mojom.AudioDecoder_Initialize_ResponseParamsSpec.$,
        [
          config,
          cdmId
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } receivePipe
   */

  setDataSource(
      receivePipe) {
    this.proxy.sendMessage(
        3,
        media.mojom.AudioDecoder_SetDataSource_ParamsSpec.$,
        null,
        [
          receivePipe
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media.mojom.DecoderStatus,
   *  }>}
   */

  decode(
      buffer) {
    return this.proxy.sendMessage(
        4,
        media.mojom.AudioDecoder_Decode_ParamsSpec.$,
        media.mojom.AudioDecoder_Decode_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  reset() {
    return this.proxy.sendMessage(
        5,
        media.mojom.AudioDecoder_Reset_ParamsSpec.$,
        media.mojom.AudioDecoder_Reset_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioDecoder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioDecoderReceiver = class {
  /**
   * @param {!media.mojom.AudioDecoderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioDecoderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
        media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        impl.getSupportedConfigs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioDecoder_Construct_ParamsSpec.$,
        null,
        impl.construct.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioDecoder_Initialize_ParamsSpec.$,
        media.mojom.AudioDecoder_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.AudioDecoder_SetDataSource_ParamsSpec.$,
        null,
        impl.setDataSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.AudioDecoder_Decode_ParamsSpec.$,
        media.mojom.AudioDecoder_Decode_ResponseParamsSpec.$,
        impl.decode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.AudioDecoder_Reset_ParamsSpec.$,
        media.mojom.AudioDecoder_Reset_ResponseParamsSpec.$,
        impl.reset.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioDecoder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioDecoder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioDecoderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioDecoderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioDecoder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioDecoderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSupportedConfigs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
        media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        this.getSupportedConfigs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.construct =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioDecoder_Construct_ParamsSpec.$,
        null,
        this.construct.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.AudioDecoder_Initialize_ParamsSpec.$,
        media.mojom.AudioDecoder_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDataSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.AudioDecoder_SetDataSource_ParamsSpec.$,
        null,
        this.setDataSource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.AudioDecoder_Decode_ParamsSpec.$,
        media.mojom.AudioDecoder_Decode_ResponseParamsSpec.$,
        this.decode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.AudioDecoder_Reset_ParamsSpec.$,
        media.mojom.AudioDecoder_Reset_ResponseParamsSpec.$,
        this.reset.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.AudioDecoderClient');
goog.provide('media.mojom.AudioDecoderClientReceiver');
goog.provide('media.mojom.AudioDecoderClientCallbackRouter');
goog.provide('media.mojom.AudioDecoderClientInterface');
goog.provide('media.mojom.AudioDecoderClientRemote');
goog.provide('media.mojom.AudioDecoderClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.AudioDecoderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.AudioDecoderClient.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.AudioDecoderClientInterface = class {
  
  /**
   * @param { !media.mojom.AudioBuffer } buffer
   */

  onBufferDecoded(buffer) {}
  
  /**
   * @param { !media.mojom.WaitingReason } reason
   */

  onWaiting(reason) {}
};

/**
 * @export
 * @implements { media.mojom.AudioDecoderClientInterface }
 */
media.mojom.AudioDecoderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.AudioDecoderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.AudioDecoderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.AudioDecoderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.AudioBuffer } buffer
   */

  onBufferDecoded(
      buffer) {
    this.proxy.sendMessage(
        0,
        media.mojom.AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
        null,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.WaitingReason } reason
   */

  onWaiting(
      reason) {
    this.proxy.sendMessage(
        1,
        media.mojom.AudioDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioDecoderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.AudioDecoderClientReceiver = class {
  /**
   * @param {!media.mojom.AudioDecoderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.AudioDecoderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.AudioDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
        null,
        impl.onBufferDecoded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        impl.onWaiting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.AudioDecoderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioDecoderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.AudioDecoderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.AudioDecoderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioDecoderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.AudioDecoderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.AudioDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.AudioDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferDecoded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
        null,
        this.onBufferDecoded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.AudioDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        this.onWaiting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.SupportedAudioDecoderConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SupportedAudioDecoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_GetSupportedConfigs_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_GetSupportedConfigs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_Construct_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_Construct_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_Initialize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_Initialize_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_SetDataSource_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_SetDataSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_Decode_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_Decode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_Decode_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_Decode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_Reset_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_Reset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoder_Reset_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoder_Reset_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoderClient_OnBufferDecoded_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoderClient_OnBufferDecoded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.AudioDecoderClient_OnWaiting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.AudioDecoderClient_OnWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.SupportedAudioDecoderConfigSpec.$,
    'SupportedAudioDecoderConfig',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media.mojom.AudioCodecSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'profile', 4,
        0,
        media.mojom.AudioCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.SupportedAudioDecoderConfig');

/** @record */
media.mojom.SupportedAudioDecoderConfig = class {
  constructor() {
    /** @export { !media.mojom.AudioCodec } */
    this.codec;
    /** @export { !media.mojom.AudioCodecProfile } */
    this.profile;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
    'AudioDecoder_GetSupportedConfigs_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.AudioDecoder_GetSupportedConfigs_Params');

/** @record */
media.mojom.AudioDecoder_GetSupportedConfigs_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
    'AudioDecoder_GetSupportedConfigs_ResponseParams',
    [
      mojo.internal.StructField(
        'supportedConfigs', 0,
        0,
        mojo.internal.Array(media.mojom.SupportedAudioDecoderConfigSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParams');

/** @record */
media.mojom.AudioDecoder_GetSupportedConfigs_ResponseParams = class {
  constructor() {
    /** @export { !Array<!media.mojom.SupportedAudioDecoderConfig> } */
    this.supportedConfigs;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_Construct_ParamsSpec.$,
    'AudioDecoder_Construct_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(media.mojom.AudioDecoderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaLog', 8,
        0,
        mojo.internal.InterfaceProxy(media.mojom.MediaLogRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.AudioDecoder_Construct_Params');

/** @record */
media.mojom.AudioDecoder_Construct_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { !media.mojom.MediaLogRemote } */
    this.mediaLog;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_Initialize_ParamsSpec.$,
    'AudioDecoder_Initialize_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media.mojom.AudioDecoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cdmId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.AudioDecoder_Initialize_Params');

/** @record */
media.mojom.AudioDecoder_Initialize_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioDecoderConfig } */
    this.config;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.cdmId;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_Initialize_ResponseParamsSpec.$,
    'AudioDecoder_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        media.mojom.DecoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'needsBitstreamConversion', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decoderType', 12,
        0,
        media.mojom.AudioDecoderTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.AudioDecoder_Initialize_ResponseParams');

/** @record */
media.mojom.AudioDecoder_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DecoderStatus } */
    this.success;
    /** @export { !boolean } */
    this.needsBitstreamConversion;
    /** @export { !media.mojom.AudioDecoderType } */
    this.decoderType;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_SetDataSource_ParamsSpec.$,
    'AudioDecoder_SetDataSource_Params',
    [
      mojo.internal.StructField(
        'receivePipe', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioDecoder_SetDataSource_Params');

/** @record */
media.mojom.AudioDecoder_SetDataSource_Params = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.receivePipe;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_Decode_ParamsSpec.$,
    'AudioDecoder_Decode_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.AudioDecoder_Decode_Params');

/** @record */
media.mojom.AudioDecoder_Decode_Params = class {
  constructor() {
    /** @export { !media.mojom.DecoderBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_Decode_ResponseParamsSpec.$,
    'AudioDecoder_Decode_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.DecoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioDecoder_Decode_ResponseParams');

/** @record */
media.mojom.AudioDecoder_Decode_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DecoderStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_Reset_ParamsSpec.$,
    'AudioDecoder_Reset_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.AudioDecoder_Reset_Params');

/** @record */
media.mojom.AudioDecoder_Reset_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoder_Reset_ResponseParamsSpec.$,
    'AudioDecoder_Reset_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.AudioDecoder_Reset_ResponseParams');

/** @record */
media.mojom.AudioDecoder_Reset_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
    'AudioDecoderClient_OnBufferDecoded_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.AudioBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioDecoderClient_OnBufferDecoded_Params');

/** @record */
media.mojom.AudioDecoderClient_OnBufferDecoded_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    media.mojom.AudioDecoderClient_OnWaiting_ParamsSpec.$,
    'AudioDecoderClient_OnWaiting_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media.mojom.WaitingReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.AudioDecoderClient_OnWaiting_Params');

/** @record */
media.mojom.AudioDecoderClient_OnWaiting_Params = class {
  constructor() {
    /** @export { !media.mojom.WaitingReason } */
    this.reason;
  }
};

