// media/midi/midi_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MIDI_MIDI_SERVICE_MOJOM_PARAMS_DATA_H_
#define MEDIA_MIDI_MIDI_SERVICE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace midi::mojom {
namespace internal {
class  MidiSessionClient_AddInputPort_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PortInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<MidiSessionClient_AddInputPort_Params_Data>;

  MidiSessionClient_AddInputPort_Params_Data();
  ~MidiSessionClient_AddInputPort_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionClient_AddInputPort_Params_Data) == 16,
              "Bad sizeof(MidiSessionClient_AddInputPort_Params_Data)");
class  MidiSessionClient_AddOutputPort_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PortInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<MidiSessionClient_AddOutputPort_Params_Data>;

  MidiSessionClient_AddOutputPort_Params_Data();
  ~MidiSessionClient_AddOutputPort_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionClient_AddOutputPort_Params_Data) == 16,
              "Bad sizeof(MidiSessionClient_AddOutputPort_Params_Data)");
class  MidiSessionClient_SetInputPortState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t port;
  int32_t state;

 private:
  friend class mojo::internal::MessageFragment<MidiSessionClient_SetInputPortState_Params_Data>;

  MidiSessionClient_SetInputPortState_Params_Data();
  ~MidiSessionClient_SetInputPortState_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionClient_SetInputPortState_Params_Data) == 16,
              "Bad sizeof(MidiSessionClient_SetInputPortState_Params_Data)");
class  MidiSessionClient_SetOutputPortState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t port;
  int32_t state;

 private:
  friend class mojo::internal::MessageFragment<MidiSessionClient_SetOutputPortState_Params_Data>;

  MidiSessionClient_SetOutputPortState_Params_Data();
  ~MidiSessionClient_SetOutputPortState_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionClient_SetOutputPortState_Params_Data) == 16,
              "Bad sizeof(MidiSessionClient_SetOutputPortState_Params_Data)");
class  MidiSessionClient_SessionStarted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MidiSessionClient_SessionStarted_Params_Data>;

  MidiSessionClient_SessionStarted_Params_Data();
  ~MidiSessionClient_SessionStarted_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionClient_SessionStarted_Params_Data) == 16,
              "Bad sizeof(MidiSessionClient_SessionStarted_Params_Data)");
class  MidiSessionClient_AcknowledgeSentData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t bytes;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MidiSessionClient_AcknowledgeSentData_Params_Data>;

  MidiSessionClient_AcknowledgeSentData_Params_Data();
  ~MidiSessionClient_AcknowledgeSentData_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionClient_AcknowledgeSentData_Params_Data) == 16,
              "Bad sizeof(MidiSessionClient_AcknowledgeSentData_Params_Data)");
class  MidiSessionClient_DataReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t port;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> timestamp;

 private:
  friend class mojo::internal::MessageFragment<MidiSessionClient_DataReceived_Params_Data>;

  MidiSessionClient_DataReceived_Params_Data();
  ~MidiSessionClient_DataReceived_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionClient_DataReceived_Params_Data) == 32,
              "Bad sizeof(MidiSessionClient_DataReceived_Params_Data)");
class  MidiSessionProvider_StartSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  mojo::internal::Interface_Data client;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MidiSessionProvider_StartSession_Params_Data>;

  MidiSessionProvider_StartSession_Params_Data();
  ~MidiSessionProvider_StartSession_Params_Data() = delete;
};
static_assert(sizeof(MidiSessionProvider_StartSession_Params_Data) == 24,
              "Bad sizeof(MidiSessionProvider_StartSession_Params_Data)");
class  MidiSession_SendData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t port;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> timestamp;

 private:
  friend class mojo::internal::MessageFragment<MidiSession_SendData_Params_Data>;

  MidiSession_SendData_Params_Data();
  ~MidiSession_SendData_Params_Data() = delete;
};
static_assert(sizeof(MidiSession_SendData_Params_Data) == 32,
              "Bad sizeof(MidiSession_SendData_Params_Data)");

}  // namespace internal


class MidiSessionClient_AddInputPort_ParamsDataView {
 public:
  MidiSessionClient_AddInputPort_ParamsDataView() = default;

  MidiSessionClient_AddInputPort_ParamsDataView(
      internal::MidiSessionClient_AddInputPort_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      PortInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::midi::mojom::PortInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::MidiSessionClient_AddInputPort_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MidiSessionClient_AddOutputPort_ParamsDataView {
 public:
  MidiSessionClient_AddOutputPort_ParamsDataView() = default;

  MidiSessionClient_AddOutputPort_ParamsDataView(
      internal::MidiSessionClient_AddOutputPort_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      PortInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::midi::mojom::PortInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::MidiSessionClient_AddOutputPort_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MidiSessionClient_SetInputPortState_ParamsDataView {
 public:
  MidiSessionClient_SetInputPortState_ParamsDataView() = default;

  MidiSessionClient_SetInputPortState_ParamsDataView(
      internal::MidiSessionClient_SetInputPortState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t port() const {
    return data_->port;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::midi::mojom::PortState>(
        data_value, output);
  }
  PortState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::midi::mojom::PortState>(data_->state));
  }
 private:
  internal::MidiSessionClient_SetInputPortState_Params_Data* data_ = nullptr;
};


class MidiSessionClient_SetOutputPortState_ParamsDataView {
 public:
  MidiSessionClient_SetOutputPortState_ParamsDataView() = default;

  MidiSessionClient_SetOutputPortState_ParamsDataView(
      internal::MidiSessionClient_SetOutputPortState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t port() const {
    return data_->port;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::midi::mojom::PortState>(
        data_value, output);
  }
  PortState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::midi::mojom::PortState>(data_->state));
  }
 private:
  internal::MidiSessionClient_SetOutputPortState_Params_Data* data_ = nullptr;
};


class MidiSessionClient_SessionStarted_ParamsDataView {
 public:
  MidiSessionClient_SessionStarted_ParamsDataView() = default;

  MidiSessionClient_SessionStarted_ParamsDataView(
      internal::MidiSessionClient_SessionStarted_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::midi::mojom::Result>(
        data_value, output);
  }
  Result result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::midi::mojom::Result>(data_->result));
  }
 private:
  internal::MidiSessionClient_SessionStarted_Params_Data* data_ = nullptr;
};


class MidiSessionClient_AcknowledgeSentData_ParamsDataView {
 public:
  MidiSessionClient_AcknowledgeSentData_ParamsDataView() = default;

  MidiSessionClient_AcknowledgeSentData_ParamsDataView(
      internal::MidiSessionClient_AcknowledgeSentData_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t bytes() const {
    return data_->bytes;
  }
 private:
  internal::MidiSessionClient_AcknowledgeSentData_Params_Data* data_ = nullptr;
};


class MidiSessionClient_DataReceived_ParamsDataView {
 public:
  MidiSessionClient_DataReceived_ParamsDataView() = default;

  MidiSessionClient_DataReceived_ParamsDataView(
      internal::MidiSessionClient_DataReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t port() const {
    return data_->port;
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::MidiSessionClient_DataReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MidiSessionProvider_StartSession_ParamsDataView {
 public:
  MidiSessionProvider_StartSession_ParamsDataView() = default;

  MidiSessionProvider_StartSession_ParamsDataView(
      internal::MidiSessionProvider_StartSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::midi::mojom::MidiSessionInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::midi::mojom::MidiSessionClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MidiSessionProvider_StartSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MidiSession_SendData_ParamsDataView {
 public:
  MidiSession_SendData_ParamsDataView() = default;

  MidiSession_SendData_ParamsDataView(
      internal::MidiSession_SendData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t port() const {
    return data_->port;
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::MidiSession_SendData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void MidiSessionClient_AddInputPort_ParamsDataView::GetInfoDataView(
    PortInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = PortInfoDataView(pointer, message_);
}


inline void MidiSessionClient_AddOutputPort_ParamsDataView::GetInfoDataView(
    PortInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = PortInfoDataView(pointer, message_);
}










inline void MidiSessionClient_DataReceived_ParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void MidiSessionClient_DataReceived_ParamsDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}




inline void MidiSession_SendData_ParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void MidiSession_SendData_ParamsDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // midi::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MIDI_MIDI_SERVICE_MOJOM_PARAMS_DATA_H_