// media/midi/midi_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MIDI_MIDI_SERVICE_MOJOM_DATA_VIEW_H_
#define MEDIA_MIDI_MIDI_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/midi/midi_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace midi::mojom {
class PortInfoDataView;



}  // midi::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::midi::mojom::PortInfoDataView> {
  using Data = ::midi::mojom::internal::PortInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace midi::mojom {


enum class Result : int32_t {
  
  NOT_INITIALIZED = 0,
  
  OK = 1,
  
  NOT_SUPPORTED = 2,
  
  INITIALIZATION_ERROR = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, Result value);
inline bool IsKnownEnumValue(Result value) {
  return internal::Result_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PortState : int32_t {
  
  DISCONNECTED = 0,
  
  CONNECTED = 1,
  
  OPENED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PortState value);
inline bool IsKnownEnumValue(PortState value) {
  return internal::PortState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MidiSessionClientInterfaceBase {};

using MidiSessionClientPtrDataView =
    mojo::InterfacePtrDataView<MidiSessionClientInterfaceBase>;
using MidiSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<MidiSessionClientInterfaceBase>;
using MidiSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MidiSessionClientInterfaceBase>;
using MidiSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MidiSessionClientInterfaceBase>;
class MidiSessionProviderInterfaceBase {};

using MidiSessionProviderPtrDataView =
    mojo::InterfacePtrDataView<MidiSessionProviderInterfaceBase>;
using MidiSessionProviderRequestDataView =
    mojo::InterfaceRequestDataView<MidiSessionProviderInterfaceBase>;
using MidiSessionProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MidiSessionProviderInterfaceBase>;
using MidiSessionProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MidiSessionProviderInterfaceBase>;
class MidiSessionInterfaceBase {};

using MidiSessionPtrDataView =
    mojo::InterfacePtrDataView<MidiSessionInterfaceBase>;
using MidiSessionRequestDataView =
    mojo::InterfaceRequestDataView<MidiSessionInterfaceBase>;
using MidiSessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MidiSessionInterfaceBase>;
using MidiSessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MidiSessionInterfaceBase>;


class PortInfoDataView {
 public:
  PortInfoDataView() = default;

  PortInfoDataView(
      internal::PortInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetManufacturerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturer(UserType* output) {
    
    auto* pointer = data_->manufacturer.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::midi::mojom::PortState>(
        data_value, output);
  }
  PortState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::midi::mojom::PortState>(data_->state));
  }
 private:
  internal::PortInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // midi::mojom

#endif  // MEDIA_MIDI_MIDI_SERVICE_MOJOM_DATA_VIEW_H_