// media/capture/mojom/video_capture_types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/capture/mojom/video_capture_types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var VideoCapturePixelFormat = {};
  VideoCapturePixelFormat.UNKNOWN = 0;
  VideoCapturePixelFormat.I420 = 1;
  VideoCapturePixelFormat.YV12 = 2;
  VideoCapturePixelFormat.I422 = 3;
  VideoCapturePixelFormat.I420A = 4;
  VideoCapturePixelFormat.I444 = 5;
  VideoCapturePixelFormat.NV12 = 6;
  VideoCapturePixelFormat.NV21 = 7;
  VideoCapturePixelFormat.UYVY = 8;
  VideoCapturePixelFormat.YUY2 = 9;
  VideoCapturePixelFormat.ARGB = 10;
  VideoCapturePixelFormat.XRGB = 11;
  VideoCapturePixelFormat.RGB24 = 12;
  VideoCapturePixelFormat.MJPEG = 13;
  VideoCapturePixelFormat.YUV420P9_DEPRECATED = 14;
  VideoCapturePixelFormat.YUV420P10 = 15;
  VideoCapturePixelFormat.YUV422P9_DEPRECATED = 16;
  VideoCapturePixelFormat.YUV422P10 = 17;
  VideoCapturePixelFormat.YUV444P9_DEPRECATED = 18;
  VideoCapturePixelFormat.YUV444P10 = 19;
  VideoCapturePixelFormat.YUV420P12 = 20;
  VideoCapturePixelFormat.YUV422P12 = 21;
  VideoCapturePixelFormat.YUV444P12 = 22;
  VideoCapturePixelFormat.Y16 = 23;
  VideoCapturePixelFormat.ABGR = 24;
  VideoCapturePixelFormat.XBGR = 25;
  VideoCapturePixelFormat.P010LE = 26;
  VideoCapturePixelFormat.XR30 = 27;
  VideoCapturePixelFormat.XB30 = 28;
  VideoCapturePixelFormat.BGRA = 29;
  VideoCapturePixelFormat.RGBAF16 = 30;
  VideoCapturePixelFormat.I422A = 31;
  VideoCapturePixelFormat.I444A = 32;
  VideoCapturePixelFormat.YUV420AP10 = 33;
  VideoCapturePixelFormat.YUV422AP10 = 34;
  VideoCapturePixelFormat.YUV444AP10 = 35;
  VideoCapturePixelFormat.NV12A = 36;
  VideoCapturePixelFormat.NV16 = 37;
  VideoCapturePixelFormat.NV24 = 38;
  VideoCapturePixelFormat.P210LE = 39;
  VideoCapturePixelFormat.P410LE = 40;
  VideoCapturePixelFormat.MIN_VALUE = 0;
  VideoCapturePixelFormat.MAX_VALUE = 40;

  VideoCapturePixelFormat.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
      return true;
    }
    return false;
  };

  VideoCapturePixelFormat.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCapturePixelFormat.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ResolutionChangePolicy = {};
  ResolutionChangePolicy.FIXED_RESOLUTION = 0;
  ResolutionChangePolicy.FIXED_ASPECT_RATIO = 1;
  ResolutionChangePolicy.ANY_WITHIN_LIMIT = 2;
  ResolutionChangePolicy.MIN_VALUE = 0;
  ResolutionChangePolicy.MAX_VALUE = 2;

  ResolutionChangePolicy.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ResolutionChangePolicy.toKnownEnumValue = function(value) {
    return value;
  };

  ResolutionChangePolicy.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PowerLineFrequency = {};
  PowerLineFrequency.DEFAULT = 0;
  PowerLineFrequency.HZ_50 = 1;
  PowerLineFrequency.HZ_60 = 2;
  PowerLineFrequency.MIN_VALUE = 0;
  PowerLineFrequency.MAX_VALUE = 2;

  PowerLineFrequency.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  PowerLineFrequency.toKnownEnumValue = function(value) {
    return value;
  };

  PowerLineFrequency.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoFacingMode = {};
  VideoFacingMode.NONE = 0;
  VideoFacingMode.USER = 1;
  VideoFacingMode.ENVIRONMENT = 2;
  VideoFacingMode.MIN_VALUE = 0;
  VideoFacingMode.MAX_VALUE = 2;

  VideoFacingMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  VideoFacingMode.toKnownEnumValue = function(value) {
    return value;
  };

  VideoFacingMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CameraAvailability = {};
  CameraAvailability.kAvailable = 0;
  CameraAvailability.kUnavailableExclusivelyUsedByOtherApplication = 1;
  CameraAvailability.MIN_VALUE = 0;
  CameraAvailability.MAX_VALUE = 1;

  CameraAvailability.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CameraAvailability.toKnownEnumValue = function(value) {
    return value;
  };

  CameraAvailability.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoCaptureApi = {};
  VideoCaptureApi.LINUX_V4L2_SINGLE_PLANE = 0;
  VideoCaptureApi.WIN_MEDIA_FOUNDATION = 1;
  VideoCaptureApi.WIN_MEDIA_FOUNDATION_SENSOR = 2;
  VideoCaptureApi.WIN_DIRECT_SHOW = 3;
  VideoCaptureApi.MACOSX_AVFOUNDATION = 4;
  VideoCaptureApi.MACOSX_DECKLINK = 5;
  VideoCaptureApi.ANDROID_API1 = 6;
  VideoCaptureApi.ANDROID_API2_LEGACY = 7;
  VideoCaptureApi.ANDROID_API2_FULL = 8;
  VideoCaptureApi.ANDROID_API2_LIMITED = 9;
  VideoCaptureApi.FUCHSIA_CAMERA3 = 10;
  VideoCaptureApi.VIRTUAL_DEVICE = 11;
  VideoCaptureApi.UNKNOWN = 12;
  VideoCaptureApi.WEBRTC_LINUX_PIPEWIRE_SINGLE_PLANE = 13;
  VideoCaptureApi.MIN_VALUE = 0;
  VideoCaptureApi.MAX_VALUE = 13;

  VideoCaptureApi.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
      return true;
    }
    return false;
  };

  VideoCaptureApi.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCaptureApi.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoCaptureTransportType = {};
  VideoCaptureTransportType.APPLE_USB_OR_BUILT_IN = 0;
  VideoCaptureTransportType.OTHER_TRANSPORT = 1;
  VideoCaptureTransportType.MIN_VALUE = 0;
  VideoCaptureTransportType.MAX_VALUE = 1;

  VideoCaptureTransportType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  VideoCaptureTransportType.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCaptureTransportType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoCaptureBufferType = {};
  VideoCaptureBufferType.kSharedMemory = 0;
  VideoCaptureBufferType.kSharedMemoryViaRawFileDescriptor_DEPRECATED = 1;
  VideoCaptureBufferType.kMailboxHolder = 2;
  VideoCaptureBufferType.kGpuMemoryBuffer = 3;
  VideoCaptureBufferType.MIN_VALUE = 0;
  VideoCaptureBufferType.MAX_VALUE = 3;

  VideoCaptureBufferType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  VideoCaptureBufferType.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCaptureBufferType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoCaptureError = {};
  VideoCaptureError.kNone = 0;
  VideoCaptureError.kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested = 1;
  VideoCaptureError.kVideoCaptureControllerIsAlreadyInErrorState = 2;
  VideoCaptureError.kVideoCaptureManagerDeviceConnectionLost = 3;
  VideoCaptureError.kFrameSinkVideoCaptureDeviceAlreadyEndedOnFatalError = 4;
  VideoCaptureError.kFrameSinkVideoCaptureDeviceEncounteredFatalError = 5;
  VideoCaptureError.kV4L2FailedToOpenV4L2DeviceDriverFile = 6;
  VideoCaptureError.kV4L2ThisIsNotAV4L2VideoCaptureDevice = 7;
  VideoCaptureError.kV4L2FailedToFindASupportedCameraFormat = 8;
  VideoCaptureError.kV4L2FailedToSetVideoCaptureFormat = 9;
  VideoCaptureError.kV4L2UnsupportedPixelFormat = 10;
  VideoCaptureError.kV4L2FailedToSetCameraFramerate = 11;
  VideoCaptureError.kV4L2ErrorRequestingMmapBuffers = 12;
  VideoCaptureError.kV4L2AllocateBufferFailed = 13;
  VideoCaptureError.kV4L2VidiocStreamonFailed = 14;
  VideoCaptureError.kV4L2VidiocStreamoffFailed = 15;
  VideoCaptureError.kV4L2FailedToVidiocReqbufsWithCount0 = 16;
  VideoCaptureError.kV4L2PollFailed = 17;
  VideoCaptureError.kV4L2MultipleContinuousTimeoutsWhileReadPolling = 18;
  VideoCaptureError.kV4L2FailedToDequeueCaptureBuffer = 19;
  VideoCaptureError.kV4L2FailedToEnqueueCaptureBuffer = 20;
  VideoCaptureError.kSingleClientVideoCaptureHostLostConnectionToDevice = 21;
  VideoCaptureError.kSingleClientVideoCaptureDeviceLaunchAborted = 22;
  VideoCaptureError.kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed = 23;
  VideoCaptureError.kFileVideoCaptureDeviceCouldNotOpenVideoFile = 24;
  VideoCaptureError.kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate = 25;
  VideoCaptureError.kErrorFakeDeviceIntentionallyEmittingErrorEvent = 26;
  VideoCaptureError.kDeviceClientTooManyFramesDroppedY16 = 27;
  VideoCaptureError.kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType = 28;
  VideoCaptureError.kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound = 29;
  VideoCaptureError.kInProcessDeviceLauncherFailedToCreateDeviceInstance = 30;
  VideoCaptureError.kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart = 31;
  VideoCaptureError.kServiceDeviceLauncherServiceRespondedWithDeviceNotFound = 32;
  VideoCaptureError.kServiceDeviceLauncherConnectionLostWhileWaitingForCallback = 33;
  VideoCaptureError.kIntentionalErrorRaisedByUnitTest = 34;
  VideoCaptureError.kCrosHalV3FailedToStartDeviceThread = 35;
  VideoCaptureError.kCrosHalV3DeviceDelegateMojoConnectionError = 36;
  VideoCaptureError.kCrosHalV3DeviceDelegateFailedToGetCameraInfo = 37;
  VideoCaptureError.kCrosHalV3DeviceDelegateMissingSensorOrientationInfo = 38;
  VideoCaptureError.kCrosHalV3DeviceDelegateFailedToOpenCameraDevice = 39;
  VideoCaptureError.kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice = 40;
  VideoCaptureError.kCrosHalV3DeviceDelegateFailedToConfigureStreams = 41;
  VideoCaptureError.kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured = 42;
  VideoCaptureError.kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings = 43;
  VideoCaptureError.kCrosHalV3BufferManagerHalRequestedTooManyBuffers = 44;
  VideoCaptureError.kCrosHalV3BufferManagerFailedToCreateMappableSI = 45;
  VideoCaptureError.kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer = 46;
  VideoCaptureError.kCrosHalV3BufferManagerUnsupportedVideoPixelFormat = 47;
  VideoCaptureError.kCrosHalV3BufferManagerFailedToDupFd = 48;
  VideoCaptureError.kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle = 49;
  VideoCaptureError.kCrosHalV3BufferManagerFailedToRegisterBuffer = 50;
  VideoCaptureError.kCrosHalV3BufferManagerProcessCaptureRequestFailed = 51;
  VideoCaptureError.kCrosHalV3BufferManagerInvalidPendingResultId = 52;
  VideoCaptureError.kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata = 53;
  VideoCaptureError.kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived = 54;
  VideoCaptureError.kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived = 55;
  VideoCaptureError.kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame = 56;
  VideoCaptureError.kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg = 57;
  VideoCaptureError.kCrosHalV3BufferManagerReceivedInvalidShutterTime = 58;
  VideoCaptureError.kCrosHalV3BufferManagerFatalDeviceError = 59;
  VideoCaptureError.kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder = 60;
  VideoCaptureError.kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd = 61;
  VideoCaptureError.kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut = 62;
  VideoCaptureError.kCrosHalV3BufferManagerInvalidJpegBlob = 63;
  VideoCaptureError.kAndroidFailedToAllocate = 64;
  VideoCaptureError.kAndroidFailedToStartCapture = 65;
  VideoCaptureError.kAndroidFailedToStopCapture = 66;
  VideoCaptureError.kAndroidApi1CameraErrorCallbackReceived = 67;
  VideoCaptureError.kAndroidApi2CameraDeviceErrorReceived = 68;
  VideoCaptureError.kAndroidApi2CaptureSessionConfigureFailed = 69;
  VideoCaptureError.kAndroidApi2ImageReaderUnexpectedImageFormat = 70;
  VideoCaptureError.kAndroidApi2ImageReaderSizeDidNotMatchImageSize = 71;
  VideoCaptureError.kAndroidApi2ErrorRestartingPreview = 72;
  VideoCaptureError.kAndroidScreenCaptureUnsupportedFormat = 73;
  VideoCaptureError.kAndroidScreenCaptureFailedToStartCaptureMachine = 74;
  VideoCaptureError.kAndroidScreenCaptureTheUserDeniedScreenCapture = 75;
  VideoCaptureError.kAndroidScreenCaptureFailedToStartScreenCapture = 76;
  VideoCaptureError.kWinDirectShowCantGetCaptureFormatSettings = 77;
  VideoCaptureError.kWinDirectShowFailedToGetNumberOfCapabilities = 78;
  VideoCaptureError.kWinDirectShowFailedToGetCaptureDeviceCapabilities = 79;
  VideoCaptureError.kWinDirectShowFailedToSetCaptureDeviceOutputFormat = 80;
  VideoCaptureError.kWinDirectShowFailedToConnectTheCaptureGraph = 81;
  VideoCaptureError.kWinDirectShowFailedToPauseTheCaptureDevice = 82;
  VideoCaptureError.kWinDirectShowFailedToStartTheCaptureDevice = 83;
  VideoCaptureError.kWinDirectShowFailedToStopTheCaptureGraph = 84;
  VideoCaptureError.kWinMediaFoundationEngineIsNull = 85;
  VideoCaptureError.kWinMediaFoundationEngineGetSourceFailed = 86;
  VideoCaptureError.kWinMediaFoundationFillPhotoCapabilitiesFailed = 87;
  VideoCaptureError.kWinMediaFoundationFillVideoCapabilitiesFailed = 88;
  VideoCaptureError.kWinMediaFoundationNoVideoCapabilityFound = 89;
  VideoCaptureError.kWinMediaFoundationGetAvailableDeviceMediaTypeFailed = 90;
  VideoCaptureError.kWinMediaFoundationSetCurrentDeviceMediaTypeFailed = 91;
  VideoCaptureError.kWinMediaFoundationEngineGetSinkFailed = 92;
  VideoCaptureError.kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed = 93;
  VideoCaptureError.kWinMediaFoundationSinkRemoveAllStreamsFailed = 94;
  VideoCaptureError.kWinMediaFoundationCreateSinkVideoMediaTypeFailed = 95;
  VideoCaptureError.kWinMediaFoundationConvertToVideoSinkMediaTypeFailed = 96;
  VideoCaptureError.kWinMediaFoundationSinkAddStreamFailed = 97;
  VideoCaptureError.kWinMediaFoundationSinkSetSampleCallbackFailed = 98;
  VideoCaptureError.kWinMediaFoundationEngineStartPreviewFailed = 99;
  VideoCaptureError.kWinMediaFoundationGetMediaEventStatusFailed = 100;
  VideoCaptureError.kMacSetCaptureDeviceFailed = 101;
  VideoCaptureError.kMacCouldNotStartCaptureDevice = 102;
  VideoCaptureError.kMacReceivedFrameWithUnexpectedResolution = 103;
  VideoCaptureError.kMacUpdateCaptureResolutionFailed = 104;
  VideoCaptureError.kMacDeckLinkDeviceIdNotFoundInTheSystem = 105;
  VideoCaptureError.kMacDeckLinkErrorQueryingInputInterface = 106;
  VideoCaptureError.kMacDeckLinkErrorCreatingDisplayModeIterator = 107;
  VideoCaptureError.kMacDeckLinkCouldNotFindADisplayMode = 108;
  VideoCaptureError.kMacDeckLinkCouldNotSelectTheVideoFormatWeLike = 109;
  VideoCaptureError.kMacDeckLinkCouldNotStartCapturing = 110;
  VideoCaptureError.kMacDeckLinkUnsupportedPixelFormat = 111;
  VideoCaptureError.kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification = 112;
  VideoCaptureError.kAndroidApi2ErrorConfiguringCamera = 113;
  VideoCaptureError.kCrosHalV3DeviceDelegateFailedToFlush = 114;
  VideoCaptureError.kFuchsiaCameraDeviceDisconnected = 115;
  VideoCaptureError.kFuchsiaCameraStreamDisconnected = 116;
  VideoCaptureError.kFuchsiaSysmemDidNotSetImageFormat = 117;
  VideoCaptureError.kFuchsiaSysmemInvalidBufferIndex = 118;
  VideoCaptureError.kFuchsiaSysmemInvalidBufferSize = 119;
  VideoCaptureError.kFuchsiaUnsupportedPixelFormat = 120;
  VideoCaptureError.kFuchsiaFailedToMapSysmemBuffer = 121;
  VideoCaptureError.kCrosHalV3DeviceContextDuplicatedClient = 122;
  VideoCaptureError.kDesktopCaptureDeviceMacFailedStreamCreate = 123;
  VideoCaptureError.kDesktopCaptureDeviceMacFailedStreamStart = 124;
  VideoCaptureError.kCrosHalV3BufferManagerFailedToReserveBuffers = 125;
  VideoCaptureError.kWinMediaFoundationSystemPermissionDenied = 126;
  VideoCaptureError.kVideoCaptureImplTimedOutOnStart = 127;
  VideoCaptureError.kLacrosVideoCaptureDeviceProxyAlreadyEndedOnFatalError = 128;
  VideoCaptureError.kLacrosVideoCaptureDeviceProxyEncounteredFatalError = 129;
  VideoCaptureError.kScreenCaptureKitFailedGetShareableContent = 130;
  VideoCaptureError.kScreenCaptureKitFailedAddStreamOutput = 131;
  VideoCaptureError.kScreenCaptureKitFailedStartCapture = 132;
  VideoCaptureError.kScreenCaptureKitFailedStopCapture = 133;
  VideoCaptureError.kScreenCaptureKitStreamError = 134;
  VideoCaptureError.kScreenCaptureKitFailedToFindSCDisplay = 135;
  VideoCaptureError.kVideoCaptureControllerInvalid = 136;
  VideoCaptureError.kVideoCaptureDeviceFactoryChromeOSCreateDeviceFailed = 137;
  VideoCaptureError.kVideoCaptureControllerUnsupportedPixelFormat = 138;
  VideoCaptureError.kVideoCaptureDeviceAlreadyReleased = 139;
  VideoCaptureError.kVideoCaptureSystemDeviceIdNotFound = 140;
  VideoCaptureError.kVideoCaptureDeviceFactoryWinUnknownError = 141;
  VideoCaptureError.kWinMediaFoundationDeviceInitializationFailed = 142;
  VideoCaptureError.kWinMediaFoundationSourceCreationFailed = 143;
  VideoCaptureError.kWinDirectShowDeviceFilterCreationFailed = 144;
  VideoCaptureError.kWinDirectShowDeviceInitializationFailed = 145;
  VideoCaptureError.kVideoCaptureDeviceFactorySecondCreateDenied = 146;
  VideoCaptureError.kScreenCaptureKitResetStreamError = 147;
  VideoCaptureError.kWinMediaFoundationCameraBusy = 148;
  VideoCaptureError.kWebRtcStartCaptureFailed = 149;
  VideoCaptureError.MIN_VALUE = 0;
  VideoCaptureError.MAX_VALUE = 149;

  VideoCaptureError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
    case 89:
    case 90:
    case 91:
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
    case 102:
    case 103:
    case 104:
    case 105:
    case 106:
    case 107:
    case 108:
    case 109:
    case 110:
    case 111:
    case 112:
    case 113:
    case 114:
    case 115:
    case 116:
    case 117:
    case 118:
    case 119:
    case 120:
    case 121:
    case 122:
    case 123:
    case 124:
    case 125:
    case 126:
    case 127:
    case 128:
    case 129:
    case 130:
    case 131:
    case 132:
    case 133:
    case 134:
    case 135:
    case 136:
    case 137:
    case 138:
    case 139:
    case 140:
    case 141:
    case 142:
    case 143:
    case 144:
    case 145:
    case 146:
    case 147:
    case 148:
    case 149:
      return true;
    }
    return false;
  };

  VideoCaptureError.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCaptureError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoCaptureFrameDropReason = {};
  VideoCaptureFrameDropReason.kNone = 0;
  VideoCaptureFrameDropReason.kDeviceClientFrameHasInvalidFormat = 1;
  VideoCaptureFrameDropReason.kDeviceClientLibyuvConvertToI420Failed = 2;
  VideoCaptureFrameDropReason.kV4L2BufferErrorFlagWasSet = 3;
  VideoCaptureFrameDropReason.kV4L2InvalidNumberOfBytesInBuffer = 4;
  VideoCaptureFrameDropReason.kAndroidThrottling = 5;
  VideoCaptureFrameDropReason.kAndroidGetByteArrayElementsFailed = 6;
  VideoCaptureFrameDropReason.kAndroidApi1UnexpectedDataLength = 7;
  VideoCaptureFrameDropReason.kAndroidApi2AcquiredImageIsNull = 8;
  VideoCaptureFrameDropReason.kWinDirectShowUnexpectedSampleLength = 9;
  VideoCaptureFrameDropReason.kWinDirectShowFailedToGetMemoryPointerFromMediaSample = 10;
  VideoCaptureFrameDropReason.kWinMediaFoundationReceivedSampleIsNull = 11;
  VideoCaptureFrameDropReason.kWinMediaFoundationLockingBufferDelieveredNullptr = 12;
  VideoCaptureFrameDropReason.kWinMediaFoundationGetBufferByIndexReturnedNull = 13;
  VideoCaptureFrameDropReason.kBufferPoolMaxBufferCountExceeded = 14;
  VideoCaptureFrameDropReason.kBufferPoolBufferAllocationFailed = 15;
  VideoCaptureFrameDropReason.kVideoCaptureImplNotInStartedState = 16;
  VideoCaptureFrameDropReason.kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame = 17;
  VideoCaptureFrameDropReason.kVideoTrackAdapterHasNoResolutionAdapters = 18;
  VideoCaptureFrameDropReason.kResolutionAdapterFrameIsNotValid = 19;
  VideoCaptureFrameDropReason.kResolutionAdapterWrappingFrameForCroppingFailed = 20;
  VideoCaptureFrameDropReason.kResolutionAdapterTimestampTooCloseToPrevious_DEPRECATED = 21;
  VideoCaptureFrameDropReason.kResolutionAdapterFrameRateIsHigherThanRequested = 22;
  VideoCaptureFrameDropReason.kResolutionAdapterHasNoCallbacks = 23;
  VideoCaptureFrameDropReason.kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame = 24;
  VideoCaptureFrameDropReason.kRendererSinkFrameDelivererIsNotStarted = 25;
  VideoCaptureFrameDropReason.kCropVersionNotCurrent_DEPRECATED = 26;
  VideoCaptureFrameDropReason.kGpuMemoryBufferMapFailed = 27;
  VideoCaptureFrameDropReason.kSubCaptureTargetVersionNotCurrent_DEPRECATED = 28;
  VideoCaptureFrameDropReason.kPostProcessingFailed = 29;
  VideoCaptureFrameDropReason.kResolutionAdapterFrameIsNotMappable = 30;
  VideoCaptureFrameDropReason.kResolutionAdapterCannotCreateConvertFrame = 31;
  VideoCaptureFrameDropReason.kResolutionAdapterConvertAndScaleFailed = 32;
  VideoCaptureFrameDropReason.kOldCaptureVersion = 33;
  VideoCaptureFrameDropReason.MIN_VALUE = 0;
  VideoCaptureFrameDropReason.MAX_VALUE = 33;

  VideoCaptureFrameDropReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
      return true;
    }
    return false;
  };

  VideoCaptureFrameDropReason.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCaptureFrameDropReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SubCaptureTargetType = {};
  SubCaptureTargetType.kCropTarget = 0;
  SubCaptureTargetType.kRestrictionTarget = 1;
  SubCaptureTargetType.MIN_VALUE = 0;
  SubCaptureTargetType.MAX_VALUE = 1;

  SubCaptureTargetType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SubCaptureTargetType.toKnownEnumValue = function(value) {
    return value;
  };

  SubCaptureTargetType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ApplySubCaptureTargetResult = {};
  ApplySubCaptureTargetResult.kSuccess = 0;
  ApplySubCaptureTargetResult.kErrorGeneric = 1;
  ApplySubCaptureTargetResult.kUnsupportedCaptureDevice = 2;
  ApplySubCaptureTargetResult.kNotImplemented = 3;
  ApplySubCaptureTargetResult.kNonIncreasingVersion = 4;
  ApplySubCaptureTargetResult.kInvalidTarget = 5;
  ApplySubCaptureTargetResult.MIN_VALUE = 0;
  ApplySubCaptureTargetResult.MAX_VALUE = 5;

  ApplySubCaptureTargetResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  ApplySubCaptureTargetResult.toKnownEnumValue = function(value) {
    return value;
  };

  ApplySubCaptureTargetResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DeviceEnumerationResult = {};
  DeviceEnumerationResult.kSuccess = 0;
  DeviceEnumerationResult.kUnknownError = 1;
  DeviceEnumerationResult.kErrorCaptureServiceCrash = 2;
  DeviceEnumerationResult.kErrorCaptureServiceDroppedRequest = 3;
  DeviceEnumerationResult.MIN_VALUE = 0;
  DeviceEnumerationResult.MAX_VALUE = 3;

  DeviceEnumerationResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  DeviceEnumerationResult.toKnownEnumValue = function(value) {
    return value;
  };

  DeviceEnumerationResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function VideoCaptureControlSupport(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoCaptureControlSupport.prototype.initDefaults_ = function() {
    this.pan = false;
    this.tilt = false;
    this.zoom = false;
  };
  VideoCaptureControlSupport.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoCaptureControlSupport.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  VideoCaptureControlSupport.encodedSize = codec.kStructHeaderSize + 8;

  VideoCaptureControlSupport.decode = function(decoder) {
    var packed;
    var val = new VideoCaptureControlSupport();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.pan = (packed >> 0) & 1 ? true : false;
    val.tilt = (packed >> 1) & 1 ? true : false;
    val.zoom = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoCaptureControlSupport.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoCaptureControlSupport.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.pan & 1) << 0
    packed |= (val.tilt & 1) << 1
    packed |= (val.zoom & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoCaptureFormat(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoCaptureFormat.prototype.initDefaults_ = function() {
    this.frameSize = null;
    this.frameRate = 0;
    this.pixelFormat = 0;
  };
  VideoCaptureFormat.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoCaptureFormat.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureFormat.frameSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoCaptureFormat.pixelFormat
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, VideoCapturePixelFormat);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoCaptureFormat.encodedSize = codec.kStructHeaderSize + 16;

  VideoCaptureFormat.decode = function(decoder) {
    var packed;
    var val = new VideoCaptureFormat();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.frameRate =
        decoder.decodeStruct(codec.Float);
    val.pixelFormat =
        decoder.decodeStruct(new codec.Enum(VideoCapturePixelFormat));
    return val;
  };

  VideoCaptureFormat.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoCaptureFormat.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.frameSize);
    encoder.encodeStruct(codec.Float, val.frameRate);
    encoder.encodeStruct(codec.Int32, val.pixelFormat);
  };
  function VideoCaptureParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoCaptureParams.prototype.initDefaults_ = function() {
    this.requestedFormat = null;
    this.bufferType = 0;
    this.resolutionChangePolicy = 0;
    this.powerLineFrequency = 0;
    this.enableFaceDetection = false;
    this.isHighDpiEnabled = false;
    this.captureVersionSource = 0;
  };
  VideoCaptureParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoCaptureParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureParams.requestedFormat
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VideoCaptureFormat, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureParams.bufferType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, VideoCaptureBufferType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureParams.resolutionChangePolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ResolutionChangePolicy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureParams.powerLineFrequency
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, PowerLineFrequency);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  VideoCaptureParams.encodedSize = codec.kStructHeaderSize + 32;

  VideoCaptureParams.decode = function(decoder) {
    var packed;
    var val = new VideoCaptureParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestedFormat =
        decoder.decodeStructPointer(VideoCaptureFormat);
    val.bufferType =
        decoder.decodeStruct(new codec.Enum(VideoCaptureBufferType));
    val.resolutionChangePolicy =
        decoder.decodeStruct(new codec.Enum(ResolutionChangePolicy));
    val.powerLineFrequency =
        decoder.decodeStruct(new codec.Enum(PowerLineFrequency));
    packed = decoder.readUint8();
    val.enableFaceDetection = (packed >> 0) & 1 ? true : false;
    val.isHighDpiEnabled = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.captureVersionSource =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoCaptureParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoCaptureParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VideoCaptureFormat, val.requestedFormat);
    encoder.encodeStruct(codec.Int32, val.bufferType);
    encoder.encodeStruct(codec.Int32, val.resolutionChangePolicy);
    encoder.encodeStruct(codec.Int32, val.powerLineFrequency);
    packed = 0;
    packed |= (val.enableFaceDetection & 1) << 0
    packed |= (val.isHighDpiEnabled & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.captureVersionSource);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoCaptureFeedback(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoCaptureFeedback.prototype.initDefaults_ = function() {
    this.resourceUtilization = 0;
    this.maxFramerateFps = 0;
    this.maxPixels = 0;
    this.requireMappedFrame = false;
    this.hasFrameId = false;
    this.frameId = 0;
    this.dEPRECATEDMappedSizes = null;
  };
  VideoCaptureFeedback.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoCaptureFeedback.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate VideoCaptureFeedback.dEPRECATEDMappedSizes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(geometry$.Size), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  VideoCaptureFeedback.encodedSize = codec.kStructHeaderSize + 32;

  VideoCaptureFeedback.decode = function(decoder) {
    var packed;
    var val = new VideoCaptureFeedback();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resourceUtilization =
        decoder.decodeStruct(codec.Double);
    val.maxFramerateFps =
        decoder.decodeStruct(codec.Float);
    val.maxPixels =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.requireMappedFrame = (packed >> 0) & 1 ? true : false;
    val.hasFrameId = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.frameId =
        decoder.decodeStruct(codec.Int32);
    val.dEPRECATEDMappedSizes =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    return val;
  };

  VideoCaptureFeedback.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoCaptureFeedback.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.resourceUtilization);
    encoder.encodeStruct(codec.Float, val.maxFramerateFps);
    encoder.encodeStruct(codec.Int32, val.maxPixels);
    packed = 0;
    packed |= (val.requireMappedFrame & 1) << 0
    packed |= (val.hasFrameId & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.frameId);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.dEPRECATEDMappedSizes);
  };
  function PlaneStrides(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlaneStrides.prototype.initDefaults_ = function() {
    this.strideByPlane = null;
  };
  PlaneStrides.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlaneStrides.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PlaneStrides.strideByPlane
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [4], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlaneStrides.encodedSize = codec.kStructHeaderSize + 8;

  PlaneStrides.decode = function(decoder) {
    var packed;
    var val = new PlaneStrides();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.strideByPlane =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  PlaneStrides.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlaneStrides.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.strideByPlane);
  };
  function VideoCaptureDeviceDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoCaptureDeviceDescriptor.prototype.initDefaults_ = function() {
    this.displayName = null;
    this.deviceId = null;
    this.modelId = null;
    this.facingMode = 0;
    this.captureApi = 0;
    this.controlSupport = null;
    this.transportType = 0;
    this.availability_$flag = false;
    this.availability_$value = 0;
  };
  VideoCaptureDeviceDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoCaptureDeviceDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceDescriptor.displayName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceDescriptor.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceDescriptor.modelId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceDescriptor.facingMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, VideoFacingMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceDescriptor.captureApi
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, VideoCaptureApi);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceDescriptor.controlSupport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, VideoCaptureControlSupport, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceDescriptor.transportType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, VideoCaptureTransportType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoCaptureDeviceDescriptor.availability_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, CameraAvailability);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoCaptureDeviceDescriptor.encodedSize = codec.kStructHeaderSize + 56;

  VideoCaptureDeviceDescriptor.decode = function(decoder) {
    var packed;
    var val = new VideoCaptureDeviceDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.displayName =
        decoder.decodeStruct(codec.String);
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.modelId =
        decoder.decodeStruct(codec.String);
    val.facingMode =
        decoder.decodeStruct(new codec.Enum(VideoFacingMode));
    val.captureApi =
        decoder.decodeStruct(new codec.Enum(VideoCaptureApi));
    val.controlSupport =
        decoder.decodeStructPointer(VideoCaptureControlSupport);
    val.transportType =
        decoder.decodeStruct(new codec.Enum(VideoCaptureTransportType));
    packed = decoder.readUint8();
    val.availability_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.availability_$value =
        decoder.decodeStruct(new codec.Enum(CameraAvailability));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoCaptureDeviceDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoCaptureDeviceDescriptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.displayName);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStruct(codec.String, val.modelId);
    encoder.encodeStruct(codec.Int32, val.facingMode);
    encoder.encodeStruct(codec.Int32, val.captureApi);
    encoder.encodeStructPointer(VideoCaptureControlSupport, val.controlSupport);
    encoder.encodeStruct(codec.Int32, val.transportType);
    packed = 0;
    packed |= (val.availability_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.availability_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoCaptureDeviceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoCaptureDeviceInfo.prototype.initDefaults_ = function() {
    this.descriptor = null;
    this.supportedFormats = null;
  };
  VideoCaptureDeviceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoCaptureDeviceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceInfo.descriptor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VideoCaptureDeviceDescriptor, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoCaptureDeviceInfo.supportedFormats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(VideoCaptureFormat), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoCaptureDeviceInfo.encodedSize = codec.kStructHeaderSize + 16;

  VideoCaptureDeviceInfo.decode = function(decoder) {
    var packed;
    var val = new VideoCaptureDeviceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.descriptor =
        decoder.decodeStructPointer(VideoCaptureDeviceDescriptor);
    val.supportedFormats =
        decoder.decodeArrayPointer(new codec.PointerTo(VideoCaptureFormat));
    return val;
  };

  VideoCaptureDeviceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoCaptureDeviceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VideoCaptureDeviceDescriptor, val.descriptor);
    encoder.encodeArrayPointer(new codec.PointerTo(VideoCaptureFormat), val.supportedFormats);
  };
  exports.VideoCapturePixelFormat = VideoCapturePixelFormat;
  exports.ResolutionChangePolicy = ResolutionChangePolicy;
  exports.PowerLineFrequency = PowerLineFrequency;
  exports.VideoFacingMode = VideoFacingMode;
  exports.CameraAvailability = CameraAvailability;
  exports.VideoCaptureApi = VideoCaptureApi;
  exports.VideoCaptureTransportType = VideoCaptureTransportType;
  exports.VideoCaptureBufferType = VideoCaptureBufferType;
  exports.VideoCaptureError = VideoCaptureError;
  exports.VideoCaptureFrameDropReason = VideoCaptureFrameDropReason;
  exports.SubCaptureTargetType = SubCaptureTargetType;
  exports.ApplySubCaptureTargetResult = ApplySubCaptureTargetResult;
  exports.DeviceEnumerationResult = DeviceEnumerationResult;
  exports.VideoCaptureControlSupport = VideoCaptureControlSupport;
  exports.VideoCaptureFormat = VideoCaptureFormat;
  exports.VideoCaptureParams = VideoCaptureParams;
  exports.VideoCaptureFeedback = VideoCaptureFeedback;
  exports.PlaneStrides = PlaneStrides;
  exports.VideoCaptureDeviceDescriptor = VideoCaptureDeviceDescriptor;
  exports.VideoCaptureDeviceInfo = VideoCaptureDeviceInfo;
})();