// media/capture/mojom/video_capture_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SHARED_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_capture_types.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "media/capture/mojom/video_capture_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::media::mojom::VideoCapturePixelFormat>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCapturePixelFormat> {};

template <>
struct hash<::media::mojom::ResolutionChangePolicy>
    : public mojo::internal::EnumHashImpl<::media::mojom::ResolutionChangePolicy> {};

template <>
struct hash<::media::mojom::PowerLineFrequency>
    : public mojo::internal::EnumHashImpl<::media::mojom::PowerLineFrequency> {};

template <>
struct hash<::media::mojom::VideoFacingMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoFacingMode> {};

template <>
struct hash<::media::mojom::CameraAvailability>
    : public mojo::internal::EnumHashImpl<::media::mojom::CameraAvailability> {};

template <>
struct hash<::media::mojom::VideoCaptureApi>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureApi> {};

template <>
struct hash<::media::mojom::VideoCaptureTransportType>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureTransportType> {};

template <>
struct hash<::media::mojom::VideoCaptureBufferType>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureBufferType> {};

template <>
struct hash<::media::mojom::VideoCaptureError>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureError> {};

template <>
struct hash<::media::mojom::VideoCaptureFrameDropReason>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoCaptureFrameDropReason> {};

template <>
struct hash<::media::mojom::SubCaptureTargetType>
    : public mojo::internal::EnumHashImpl<::media::mojom::SubCaptureTargetType> {};

template <>
struct hash<::media::mojom::ApplySubCaptureTargetResult>
    : public mojo::internal::EnumHashImpl<::media::mojom::ApplySubCaptureTargetResult> {};

template <>
struct hash<::media::mojom::DeviceEnumerationResult>
    : public mojo::internal::EnumHashImpl<::media::mojom::DeviceEnumerationResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCapturePixelFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCapturePixelFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCapturePixelFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ResolutionChangePolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::ResolutionChangePolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::ResolutionChangePolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PowerLineFrequency, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::PowerLineFrequency, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::PowerLineFrequency>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoFacingMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoFacingMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoFacingMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CameraAvailability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CameraAvailability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CameraAvailability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureApi, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureApi, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureApi>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureTransportType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureTransportType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureTransportType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureBufferType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureBufferType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureBufferType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureFrameDropReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoCaptureFrameDropReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureFrameDropReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SubCaptureTargetType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::SubCaptureTargetType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::SubCaptureTargetType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ApplySubCaptureTargetResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::ApplySubCaptureTargetResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::ApplySubCaptureTargetResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DeviceEnumerationResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::DeviceEnumerationResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::DeviceEnumerationResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureControlSupportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureControlSupportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureControlSupport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->pan = Traits::pan(input);

    fragment->tilt = Traits::tilt(input);

    fragment->zoom = Traits::zoom(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureControlSupport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureControlSupportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureFormatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureFormatDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::frame_size(input)) in_frame_size = Traits::frame_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_size)::BaseType> frame_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_frame_size,
      frame_size_fragment);

    fragment->frame_size.Set(
        frame_size_fragment.is_null() ? nullptr : frame_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_size in VideoCaptureFormat struct");

    fragment->frame_rate = Traits::frame_rate(input);

    
    mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
      Traits::pixel_format(input),
      &fragment->pixel_format);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureFormat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureFormatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::requested_format(input)) in_requested_format = Traits::requested_format(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requested_format)::BaseType> requested_format_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoCaptureFormatDataView>(
      in_requested_format,
      requested_format_fragment);

    fragment->requested_format.Set(
        requested_format_fragment.is_null() ? nullptr : requested_format_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requested_format.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_format in VideoCaptureParams struct");

    
    mojo::internal::Serialize<::media::mojom::VideoCaptureBufferType>(
      Traits::buffer_type(input),
      &fragment->buffer_type);

    
    mojo::internal::Serialize<::media::mojom::ResolutionChangePolicy>(
      Traits::resolution_change_policy(input),
      &fragment->resolution_change_policy);

    
    mojo::internal::Serialize<::media::mojom::PowerLineFrequency>(
      Traits::power_line_frequency(input),
      &fragment->power_line_frequency);

    fragment->enable_face_detection = Traits::enable_face_detection(input);

    fragment->is_high_dpi_enabled = Traits::is_high_dpi_enabled(input);

    fragment->capture_version_source = Traits::capture_version_source(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureFeedbackDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureFeedbackDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureFeedback_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->resource_utilization = Traits::resource_utilization(input);

    fragment->max_framerate_fps = Traits::max_framerate_fps(input);

    fragment->max_pixels = Traits::max_pixels(input);

    fragment->require_mapped_frame = Traits::require_mapped_frame(input);

    decltype(Traits::DEPRECATED_mapped_sizes(input)) in_DEPRECATED_mapped_sizes = Traits::DEPRECATED_mapped_sizes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->DEPRECATED_mapped_sizes)::BaseType>
        DEPRECATED_mapped_sizes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& DEPRECATED_mapped_sizes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
      in_DEPRECATED_mapped_sizes,
      DEPRECATED_mapped_sizes_fragment,
      &DEPRECATED_mapped_sizes_validate_params);

    fragment->DEPRECATED_mapped_sizes.Set(
        DEPRECATED_mapped_sizes_fragment.is_null() ? nullptr : DEPRECATED_mapped_sizes_fragment.data());

    fragment->frame_id = Traits::frame_id(input);

    fragment->has_frame_id = Traits::has_frame_id(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureFeedback_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureFeedbackDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PlaneStridesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PlaneStridesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PlaneStrides_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::stride_by_plane(input)) in_stride_by_plane = Traits::stride_by_plane(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stride_by_plane)::BaseType>
        stride_by_plane_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stride_by_plane_validate_params =
        mojo::internal::GetArrayValidator<4, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_stride_by_plane,
      stride_by_plane_fragment,
      &stride_by_plane_validate_params);

    fragment->stride_by_plane.Set(
        stride_by_plane_fragment.is_null() ? nullptr : stride_by_plane_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stride_by_plane.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stride_by_plane in PlaneStrides struct");
  }

  static bool Deserialize(::media::mojom::internal::PlaneStrides_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PlaneStridesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureDeviceDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureDeviceDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureDeviceDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in VideoCaptureDeviceDescriptor struct");

    decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_id)::BaseType> device_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id,
      device_id_fragment);

    fragment->device_id.Set(
        device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureDeviceDescriptor struct");

    decltype(Traits::model_id(input)) in_model_id = Traits::model_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_id)::BaseType> model_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model_id,
      model_id_fragment);

    fragment->model_id.Set(
        model_id_fragment.is_null() ? nullptr : model_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_id in VideoCaptureDeviceDescriptor struct");

    
    mojo::internal::Serialize<::media::mojom::VideoFacingMode>(
      Traits::facing_mode(input),
      &fragment->facing_mode);

    
    mojo::internal::Serialize<::media::mojom::VideoCaptureApi>(
      Traits::capture_api(input),
      &fragment->capture_api);

    decltype(Traits::control_support(input)) in_control_support = Traits::control_support(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->control_support)::BaseType> control_support_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoCaptureControlSupportDataView>(
      in_control_support,
      control_support_fragment);

    fragment->control_support.Set(
        control_support_fragment.is_null() ? nullptr : control_support_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->control_support.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null control_support in VideoCaptureDeviceDescriptor struct");

    
    mojo::internal::Serialize<::media::mojom::VideoCaptureTransportType>(
      Traits::transport_type(input),
      &fragment->transport_type);
    fragment->availability_$flag = Traits::availability(input).has_value();
    if (Traits::availability(input).has_value()) {
      
      mojo::internal::Serialize<::media::mojom::CameraAvailability>(
        Traits::availability(input).value(),
        &fragment->availability_$value);
    } else {
      fragment->availability_$value =
          static_cast<int32_t>(::media::mojom::CameraAvailability::kMinValue);
    }
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureDeviceDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureDeviceDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoCaptureDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureDeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::descriptor(input)) in_descriptor = Traits::descriptor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->descriptor)::BaseType> descriptor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceDescriptorDataView>(
      in_descriptor,
      descriptor_fragment);

    fragment->descriptor.Set(
        descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->descriptor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null descriptor in VideoCaptureDeviceInfo struct");

    decltype(Traits::supported_formats(input)) in_supported_formats = Traits::supported_formats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_formats)::BaseType>
        supported_formats_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_formats_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
      in_supported_formats,
      supported_formats_fragment,
      &supported_formats_validate_params);

    fragment->supported_formats.Set(
        supported_formats_fragment.is_null() ? nullptr : supported_formats_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_formats.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_formats in VideoCaptureDeviceInfo struct");
  }

  static bool Deserialize(::media::mojom::internal::VideoCaptureDeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoCaptureDeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {



inline void VideoCaptureFormatDataView::GetFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void VideoCaptureParamsDataView::GetRequestedFormatDataView(
    VideoCaptureFormatDataView* output) {
  auto pointer = data_->requested_format.Get();
  *output = VideoCaptureFormatDataView(pointer, message_);
}


inline void VideoCaptureFeedbackDataView::GetDeprecatedMappedSizesDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->DEPRECATED_mapped_sizes.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}


inline void PlaneStridesDataView::GetStrideByPlaneDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->stride_by_plane.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}


inline void VideoCaptureDeviceDescriptorDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoCaptureDeviceDescriptorDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoCaptureDeviceDescriptorDataView::GetModelIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VideoCaptureDeviceDescriptorDataView::GetControlSupportDataView(
    VideoCaptureControlSupportDataView* output) {
  auto pointer = data_->control_support.Get();
  *output = VideoCaptureControlSupportDataView(pointer, message_);
}


inline void VideoCaptureDeviceInfoDataView::GetDescriptorDataView(
    VideoCaptureDeviceDescriptorDataView* output) {
  auto pointer = data_->descriptor.Get();
  *output = VideoCaptureDeviceDescriptorDataView(pointer, message_);
}
inline void VideoCaptureDeviceInfoDataView::GetSupportedFormatsDataView(
    mojo::ArrayDataView<VideoCaptureFormatDataView>* output) {
  auto pointer = data_->supported_formats.Get();
  *output = mojo::ArrayDataView<VideoCaptureFormatDataView>(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCapturePixelFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCapturePixelFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::ResolutionChangePolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::ResolutionChangePolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::PowerLineFrequency> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::PowerLineFrequency value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoFacingMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoFacingMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CameraAvailability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CameraAvailability value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureApi> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureApi value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureTransportType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureTransportType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureBufferType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureBufferType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoCaptureFrameDropReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoCaptureFrameDropReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::SubCaptureTargetType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::SubCaptureTargetType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::ApplySubCaptureTargetResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::ApplySubCaptureTargetResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::DeviceEnumerationResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::DeviceEnumerationResult value);
};

} // namespace perfetto

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SHARED_H_