// media/capture/mojom/video_capture_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/capture/mojom/video_capture_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture_types.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* VideoCapturePixelFormatToStringHelper(VideoCapturePixelFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCapturePixelFormat::UNKNOWN:
      return "UNKNOWN";
    case VideoCapturePixelFormat::I420:
      return "I420";
    case VideoCapturePixelFormat::YV12:
      return "YV12";
    case VideoCapturePixelFormat::I422:
      return "I422";
    case VideoCapturePixelFormat::I420A:
      return "I420A";
    case VideoCapturePixelFormat::I444:
      return "I444";
    case VideoCapturePixelFormat::NV12:
      return "NV12";
    case VideoCapturePixelFormat::NV21:
      return "NV21";
    case VideoCapturePixelFormat::UYVY:
      return "UYVY";
    case VideoCapturePixelFormat::YUY2:
      return "YUY2";
    case VideoCapturePixelFormat::ARGB:
      return "ARGB";
    case VideoCapturePixelFormat::XRGB:
      return "XRGB";
    case VideoCapturePixelFormat::RGB24:
      return "RGB24";
    case VideoCapturePixelFormat::MJPEG:
      return "MJPEG";
    case VideoCapturePixelFormat::YUV420P9_DEPRECATED:
      return "YUV420P9_DEPRECATED";
    case VideoCapturePixelFormat::YUV420P10:
      return "YUV420P10";
    case VideoCapturePixelFormat::YUV422P9_DEPRECATED:
      return "YUV422P9_DEPRECATED";
    case VideoCapturePixelFormat::YUV422P10:
      return "YUV422P10";
    case VideoCapturePixelFormat::YUV444P9_DEPRECATED:
      return "YUV444P9_DEPRECATED";
    case VideoCapturePixelFormat::YUV444P10:
      return "YUV444P10";
    case VideoCapturePixelFormat::YUV420P12:
      return "YUV420P12";
    case VideoCapturePixelFormat::YUV422P12:
      return "YUV422P12";
    case VideoCapturePixelFormat::YUV444P12:
      return "YUV444P12";
    case VideoCapturePixelFormat::Y16:
      return "Y16";
    case VideoCapturePixelFormat::ABGR:
      return "ABGR";
    case VideoCapturePixelFormat::XBGR:
      return "XBGR";
    case VideoCapturePixelFormat::P010LE:
      return "P010LE";
    case VideoCapturePixelFormat::XR30:
      return "XR30";
    case VideoCapturePixelFormat::XB30:
      return "XB30";
    case VideoCapturePixelFormat::BGRA:
      return "BGRA";
    case VideoCapturePixelFormat::RGBAF16:
      return "RGBAF16";
    case VideoCapturePixelFormat::I422A:
      return "I422A";
    case VideoCapturePixelFormat::I444A:
      return "I444A";
    case VideoCapturePixelFormat::YUV420AP10:
      return "YUV420AP10";
    case VideoCapturePixelFormat::YUV422AP10:
      return "YUV422AP10";
    case VideoCapturePixelFormat::YUV444AP10:
      return "YUV444AP10";
    case VideoCapturePixelFormat::NV12A:
      return "NV12A";
    case VideoCapturePixelFormat::NV16:
      return "NV16";
    case VideoCapturePixelFormat::NV24:
      return "NV24";
    case VideoCapturePixelFormat::P210LE:
      return "P210LE";
    case VideoCapturePixelFormat::P410LE:
      return "P410LE";
    default:
      return nullptr;
  }
}

std::string VideoCapturePixelFormatToString(VideoCapturePixelFormat value) {
  const char *str = VideoCapturePixelFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCapturePixelFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCapturePixelFormat value) {
  return os << VideoCapturePixelFormatToString(value);
}

NOINLINE static const char* ResolutionChangePolicyToStringHelper(ResolutionChangePolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResolutionChangePolicy::FIXED_RESOLUTION:
      return "FIXED_RESOLUTION";
    case ResolutionChangePolicy::FIXED_ASPECT_RATIO:
      return "FIXED_ASPECT_RATIO";
    case ResolutionChangePolicy::ANY_WITHIN_LIMIT:
      return "ANY_WITHIN_LIMIT";
    default:
      return nullptr;
  }
}

std::string ResolutionChangePolicyToString(ResolutionChangePolicy value) {
  const char *str = ResolutionChangePolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResolutionChangePolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResolutionChangePolicy value) {
  return os << ResolutionChangePolicyToString(value);
}

NOINLINE static const char* PowerLineFrequencyToStringHelper(PowerLineFrequency value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PowerLineFrequency::DEFAULT:
      return "DEFAULT";
    case PowerLineFrequency::HZ_50:
      return "HZ_50";
    case PowerLineFrequency::HZ_60:
      return "HZ_60";
    default:
      return nullptr;
  }
}

std::string PowerLineFrequencyToString(PowerLineFrequency value) {
  const char *str = PowerLineFrequencyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PowerLineFrequency value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PowerLineFrequency value) {
  return os << PowerLineFrequencyToString(value);
}

NOINLINE static const char* VideoFacingModeToStringHelper(VideoFacingMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoFacingMode::NONE:
      return "NONE";
    case VideoFacingMode::USER:
      return "USER";
    case VideoFacingMode::ENVIRONMENT:
      return "ENVIRONMENT";
    default:
      return nullptr;
  }
}

std::string VideoFacingModeToString(VideoFacingMode value) {
  const char *str = VideoFacingModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoFacingMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoFacingMode value) {
  return os << VideoFacingModeToString(value);
}

NOINLINE static const char* CameraAvailabilityToStringHelper(CameraAvailability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CameraAvailability::kAvailable:
      return "kAvailable";
    case CameraAvailability::kUnavailableExclusivelyUsedByOtherApplication:
      return "kUnavailableExclusivelyUsedByOtherApplication";
    default:
      return nullptr;
  }
}

std::string CameraAvailabilityToString(CameraAvailability value) {
  const char *str = CameraAvailabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CameraAvailability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CameraAvailability value) {
  return os << CameraAvailabilityToString(value);
}

NOINLINE static const char* VideoCaptureApiToStringHelper(VideoCaptureApi value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCaptureApi::LINUX_V4L2_SINGLE_PLANE:
      return "LINUX_V4L2_SINGLE_PLANE";
    case VideoCaptureApi::WIN_MEDIA_FOUNDATION:
      return "WIN_MEDIA_FOUNDATION";
    case VideoCaptureApi::WIN_MEDIA_FOUNDATION_SENSOR:
      return "WIN_MEDIA_FOUNDATION_SENSOR";
    case VideoCaptureApi::WIN_DIRECT_SHOW:
      return "WIN_DIRECT_SHOW";
    case VideoCaptureApi::MACOSX_AVFOUNDATION:
      return "MACOSX_AVFOUNDATION";
    case VideoCaptureApi::MACOSX_DECKLINK:
      return "MACOSX_DECKLINK";
    case VideoCaptureApi::ANDROID_API1:
      return "ANDROID_API1";
    case VideoCaptureApi::ANDROID_API2_LEGACY:
      return "ANDROID_API2_LEGACY";
    case VideoCaptureApi::ANDROID_API2_FULL:
      return "ANDROID_API2_FULL";
    case VideoCaptureApi::ANDROID_API2_LIMITED:
      return "ANDROID_API2_LIMITED";
    case VideoCaptureApi::FUCHSIA_CAMERA3:
      return "FUCHSIA_CAMERA3";
    case VideoCaptureApi::VIRTUAL_DEVICE:
      return "VIRTUAL_DEVICE";
    case VideoCaptureApi::UNKNOWN:
      return "UNKNOWN";
    case VideoCaptureApi::WEBRTC_LINUX_PIPEWIRE_SINGLE_PLANE:
      return "WEBRTC_LINUX_PIPEWIRE_SINGLE_PLANE";
    default:
      return nullptr;
  }
}

std::string VideoCaptureApiToString(VideoCaptureApi value) {
  const char *str = VideoCaptureApiToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCaptureApi value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCaptureApi value) {
  return os << VideoCaptureApiToString(value);
}

NOINLINE static const char* VideoCaptureTransportTypeToStringHelper(VideoCaptureTransportType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCaptureTransportType::APPLE_USB_OR_BUILT_IN:
      return "APPLE_USB_OR_BUILT_IN";
    case VideoCaptureTransportType::OTHER_TRANSPORT:
      return "OTHER_TRANSPORT";
    default:
      return nullptr;
  }
}

std::string VideoCaptureTransportTypeToString(VideoCaptureTransportType value) {
  const char *str = VideoCaptureTransportTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCaptureTransportType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCaptureTransportType value) {
  return os << VideoCaptureTransportTypeToString(value);
}

NOINLINE static const char* VideoCaptureBufferTypeToStringHelper(VideoCaptureBufferType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCaptureBufferType::kSharedMemory:
      return "kSharedMemory";
    case VideoCaptureBufferType::kSharedMemoryViaRawFileDescriptor_DEPRECATED:
      return "kSharedMemoryViaRawFileDescriptor_DEPRECATED";
    case VideoCaptureBufferType::kMailboxHolder:
      return "kMailboxHolder";
    case VideoCaptureBufferType::kGpuMemoryBuffer:
      return "kGpuMemoryBuffer";
    default:
      return nullptr;
  }
}

std::string VideoCaptureBufferTypeToString(VideoCaptureBufferType value) {
  const char *str = VideoCaptureBufferTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCaptureBufferType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCaptureBufferType value) {
  return os << VideoCaptureBufferTypeToString(value);
}

NOINLINE static const char* VideoCaptureErrorToStringHelper(VideoCaptureError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCaptureError::kNone:
      return "kNone";
    case VideoCaptureError::kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested:
      return "kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested";
    case VideoCaptureError::kVideoCaptureControllerIsAlreadyInErrorState:
      return "kVideoCaptureControllerIsAlreadyInErrorState";
    case VideoCaptureError::kVideoCaptureManagerDeviceConnectionLost:
      return "kVideoCaptureManagerDeviceConnectionLost";
    case VideoCaptureError::kFrameSinkVideoCaptureDeviceAlreadyEndedOnFatalError:
      return "kFrameSinkVideoCaptureDeviceAlreadyEndedOnFatalError";
    case VideoCaptureError::kFrameSinkVideoCaptureDeviceEncounteredFatalError:
      return "kFrameSinkVideoCaptureDeviceEncounteredFatalError";
    case VideoCaptureError::kV4L2FailedToOpenV4L2DeviceDriverFile:
      return "kV4L2FailedToOpenV4L2DeviceDriverFile";
    case VideoCaptureError::kV4L2ThisIsNotAV4L2VideoCaptureDevice:
      return "kV4L2ThisIsNotAV4L2VideoCaptureDevice";
    case VideoCaptureError::kV4L2FailedToFindASupportedCameraFormat:
      return "kV4L2FailedToFindASupportedCameraFormat";
    case VideoCaptureError::kV4L2FailedToSetVideoCaptureFormat:
      return "kV4L2FailedToSetVideoCaptureFormat";
    case VideoCaptureError::kV4L2UnsupportedPixelFormat:
      return "kV4L2UnsupportedPixelFormat";
    case VideoCaptureError::kV4L2FailedToSetCameraFramerate:
      return "kV4L2FailedToSetCameraFramerate";
    case VideoCaptureError::kV4L2ErrorRequestingMmapBuffers:
      return "kV4L2ErrorRequestingMmapBuffers";
    case VideoCaptureError::kV4L2AllocateBufferFailed:
      return "kV4L2AllocateBufferFailed";
    case VideoCaptureError::kV4L2VidiocStreamonFailed:
      return "kV4L2VidiocStreamonFailed";
    case VideoCaptureError::kV4L2VidiocStreamoffFailed:
      return "kV4L2VidiocStreamoffFailed";
    case VideoCaptureError::kV4L2FailedToVidiocReqbufsWithCount0:
      return "kV4L2FailedToVidiocReqbufsWithCount0";
    case VideoCaptureError::kV4L2PollFailed:
      return "kV4L2PollFailed";
    case VideoCaptureError::kV4L2MultipleContinuousTimeoutsWhileReadPolling:
      return "kV4L2MultipleContinuousTimeoutsWhileReadPolling";
    case VideoCaptureError::kV4L2FailedToDequeueCaptureBuffer:
      return "kV4L2FailedToDequeueCaptureBuffer";
    case VideoCaptureError::kV4L2FailedToEnqueueCaptureBuffer:
      return "kV4L2FailedToEnqueueCaptureBuffer";
    case VideoCaptureError::kSingleClientVideoCaptureHostLostConnectionToDevice:
      return "kSingleClientVideoCaptureHostLostConnectionToDevice";
    case VideoCaptureError::kSingleClientVideoCaptureDeviceLaunchAborted:
      return "kSingleClientVideoCaptureDeviceLaunchAborted";
    case VideoCaptureError::kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed:
      return "kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed";
    case VideoCaptureError::kFileVideoCaptureDeviceCouldNotOpenVideoFile:
      return "kFileVideoCaptureDeviceCouldNotOpenVideoFile";
    case VideoCaptureError::kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate:
      return "kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate";
    case VideoCaptureError::kErrorFakeDeviceIntentionallyEmittingErrorEvent:
      return "kErrorFakeDeviceIntentionallyEmittingErrorEvent";
    case VideoCaptureError::kDeviceClientTooManyFramesDroppedY16:
      return "kDeviceClientTooManyFramesDroppedY16";
    case VideoCaptureError::kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType:
      return "kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType";
    case VideoCaptureError::kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound:
      return "kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound";
    case VideoCaptureError::kInProcessDeviceLauncherFailedToCreateDeviceInstance:
      return "kInProcessDeviceLauncherFailedToCreateDeviceInstance";
    case VideoCaptureError::kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart:
      return "kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart";
    case VideoCaptureError::kServiceDeviceLauncherServiceRespondedWithDeviceNotFound:
      return "kServiceDeviceLauncherServiceRespondedWithDeviceNotFound";
    case VideoCaptureError::kServiceDeviceLauncherConnectionLostWhileWaitingForCallback:
      return "kServiceDeviceLauncherConnectionLostWhileWaitingForCallback";
    case VideoCaptureError::kIntentionalErrorRaisedByUnitTest:
      return "kIntentionalErrorRaisedByUnitTest";
    case VideoCaptureError::kCrosHalV3FailedToStartDeviceThread:
      return "kCrosHalV3FailedToStartDeviceThread";
    case VideoCaptureError::kCrosHalV3DeviceDelegateMojoConnectionError:
      return "kCrosHalV3DeviceDelegateMojoConnectionError";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToGetCameraInfo:
      return "kCrosHalV3DeviceDelegateFailedToGetCameraInfo";
    case VideoCaptureError::kCrosHalV3DeviceDelegateMissingSensorOrientationInfo:
      return "kCrosHalV3DeviceDelegateMissingSensorOrientationInfo";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToOpenCameraDevice:
      return "kCrosHalV3DeviceDelegateFailedToOpenCameraDevice";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice:
      return "kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToConfigureStreams:
      return "kCrosHalV3DeviceDelegateFailedToConfigureStreams";
    case VideoCaptureError::kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured:
      return "kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings:
      return "kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings";
    case VideoCaptureError::kCrosHalV3BufferManagerHalRequestedTooManyBuffers:
      return "kCrosHalV3BufferManagerHalRequestedTooManyBuffers";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToCreateMappableSI:
      return "kCrosHalV3BufferManagerFailedToCreateMappableSI";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer:
      return "kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer";
    case VideoCaptureError::kCrosHalV3BufferManagerUnsupportedVideoPixelFormat:
      return "kCrosHalV3BufferManagerUnsupportedVideoPixelFormat";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToDupFd:
      return "kCrosHalV3BufferManagerFailedToDupFd";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle:
      return "kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToRegisterBuffer:
      return "kCrosHalV3BufferManagerFailedToRegisterBuffer";
    case VideoCaptureError::kCrosHalV3BufferManagerProcessCaptureRequestFailed:
      return "kCrosHalV3BufferManagerProcessCaptureRequestFailed";
    case VideoCaptureError::kCrosHalV3BufferManagerInvalidPendingResultId:
      return "kCrosHalV3BufferManagerInvalidPendingResultId";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata:
      return "kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata";
    case VideoCaptureError::kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived:
      return "kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived";
    case VideoCaptureError::kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived:
      return "kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame:
      return "kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame";
    case VideoCaptureError::kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg:
      return "kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedInvalidShutterTime:
      return "kCrosHalV3BufferManagerReceivedInvalidShutterTime";
    case VideoCaptureError::kCrosHalV3BufferManagerFatalDeviceError:
      return "kCrosHalV3BufferManagerFatalDeviceError";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder:
      return "kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd:
      return "kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd";
    case VideoCaptureError::kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut:
      return "kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut";
    case VideoCaptureError::kCrosHalV3BufferManagerInvalidJpegBlob:
      return "kCrosHalV3BufferManagerInvalidJpegBlob";
    case VideoCaptureError::kAndroidFailedToAllocate:
      return "kAndroidFailedToAllocate";
    case VideoCaptureError::kAndroidFailedToStartCapture:
      return "kAndroidFailedToStartCapture";
    case VideoCaptureError::kAndroidFailedToStopCapture:
      return "kAndroidFailedToStopCapture";
    case VideoCaptureError::kAndroidApi1CameraErrorCallbackReceived:
      return "kAndroidApi1CameraErrorCallbackReceived";
    case VideoCaptureError::kAndroidApi2CameraDeviceErrorReceived:
      return "kAndroidApi2CameraDeviceErrorReceived";
    case VideoCaptureError::kAndroidApi2CaptureSessionConfigureFailed:
      return "kAndroidApi2CaptureSessionConfigureFailed";
    case VideoCaptureError::kAndroidApi2ImageReaderUnexpectedImageFormat:
      return "kAndroidApi2ImageReaderUnexpectedImageFormat";
    case VideoCaptureError::kAndroidApi2ImageReaderSizeDidNotMatchImageSize:
      return "kAndroidApi2ImageReaderSizeDidNotMatchImageSize";
    case VideoCaptureError::kAndroidApi2ErrorRestartingPreview:
      return "kAndroidApi2ErrorRestartingPreview";
    case VideoCaptureError::kAndroidScreenCaptureUnsupportedFormat:
      return "kAndroidScreenCaptureUnsupportedFormat";
    case VideoCaptureError::kAndroidScreenCaptureFailedToStartCaptureMachine:
      return "kAndroidScreenCaptureFailedToStartCaptureMachine";
    case VideoCaptureError::kAndroidScreenCaptureTheUserDeniedScreenCapture:
      return "kAndroidScreenCaptureTheUserDeniedScreenCapture";
    case VideoCaptureError::kAndroidScreenCaptureFailedToStartScreenCapture:
      return "kAndroidScreenCaptureFailedToStartScreenCapture";
    case VideoCaptureError::kWinDirectShowCantGetCaptureFormatSettings:
      return "kWinDirectShowCantGetCaptureFormatSettings";
    case VideoCaptureError::kWinDirectShowFailedToGetNumberOfCapabilities:
      return "kWinDirectShowFailedToGetNumberOfCapabilities";
    case VideoCaptureError::kWinDirectShowFailedToGetCaptureDeviceCapabilities:
      return "kWinDirectShowFailedToGetCaptureDeviceCapabilities";
    case VideoCaptureError::kWinDirectShowFailedToSetCaptureDeviceOutputFormat:
      return "kWinDirectShowFailedToSetCaptureDeviceOutputFormat";
    case VideoCaptureError::kWinDirectShowFailedToConnectTheCaptureGraph:
      return "kWinDirectShowFailedToConnectTheCaptureGraph";
    case VideoCaptureError::kWinDirectShowFailedToPauseTheCaptureDevice:
      return "kWinDirectShowFailedToPauseTheCaptureDevice";
    case VideoCaptureError::kWinDirectShowFailedToStartTheCaptureDevice:
      return "kWinDirectShowFailedToStartTheCaptureDevice";
    case VideoCaptureError::kWinDirectShowFailedToStopTheCaptureGraph:
      return "kWinDirectShowFailedToStopTheCaptureGraph";
    case VideoCaptureError::kWinMediaFoundationEngineIsNull:
      return "kWinMediaFoundationEngineIsNull";
    case VideoCaptureError::kWinMediaFoundationEngineGetSourceFailed:
      return "kWinMediaFoundationEngineGetSourceFailed";
    case VideoCaptureError::kWinMediaFoundationFillPhotoCapabilitiesFailed:
      return "kWinMediaFoundationFillPhotoCapabilitiesFailed";
    case VideoCaptureError::kWinMediaFoundationFillVideoCapabilitiesFailed:
      return "kWinMediaFoundationFillVideoCapabilitiesFailed";
    case VideoCaptureError::kWinMediaFoundationNoVideoCapabilityFound:
      return "kWinMediaFoundationNoVideoCapabilityFound";
    case VideoCaptureError::kWinMediaFoundationGetAvailableDeviceMediaTypeFailed:
      return "kWinMediaFoundationGetAvailableDeviceMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationSetCurrentDeviceMediaTypeFailed:
      return "kWinMediaFoundationSetCurrentDeviceMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationEngineGetSinkFailed:
      return "kWinMediaFoundationEngineGetSinkFailed";
    case VideoCaptureError::kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed:
      return "kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed";
    case VideoCaptureError::kWinMediaFoundationSinkRemoveAllStreamsFailed:
      return "kWinMediaFoundationSinkRemoveAllStreamsFailed";
    case VideoCaptureError::kWinMediaFoundationCreateSinkVideoMediaTypeFailed:
      return "kWinMediaFoundationCreateSinkVideoMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationConvertToVideoSinkMediaTypeFailed:
      return "kWinMediaFoundationConvertToVideoSinkMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationSinkAddStreamFailed:
      return "kWinMediaFoundationSinkAddStreamFailed";
    case VideoCaptureError::kWinMediaFoundationSinkSetSampleCallbackFailed:
      return "kWinMediaFoundationSinkSetSampleCallbackFailed";
    case VideoCaptureError::kWinMediaFoundationEngineStartPreviewFailed:
      return "kWinMediaFoundationEngineStartPreviewFailed";
    case VideoCaptureError::kWinMediaFoundationGetMediaEventStatusFailed:
      return "kWinMediaFoundationGetMediaEventStatusFailed";
    case VideoCaptureError::kMacSetCaptureDeviceFailed:
      return "kMacSetCaptureDeviceFailed";
    case VideoCaptureError::kMacCouldNotStartCaptureDevice:
      return "kMacCouldNotStartCaptureDevice";
    case VideoCaptureError::kMacReceivedFrameWithUnexpectedResolution:
      return "kMacReceivedFrameWithUnexpectedResolution";
    case VideoCaptureError::kMacUpdateCaptureResolutionFailed:
      return "kMacUpdateCaptureResolutionFailed";
    case VideoCaptureError::kMacDeckLinkDeviceIdNotFoundInTheSystem:
      return "kMacDeckLinkDeviceIdNotFoundInTheSystem";
    case VideoCaptureError::kMacDeckLinkErrorQueryingInputInterface:
      return "kMacDeckLinkErrorQueryingInputInterface";
    case VideoCaptureError::kMacDeckLinkErrorCreatingDisplayModeIterator:
      return "kMacDeckLinkErrorCreatingDisplayModeIterator";
    case VideoCaptureError::kMacDeckLinkCouldNotFindADisplayMode:
      return "kMacDeckLinkCouldNotFindADisplayMode";
    case VideoCaptureError::kMacDeckLinkCouldNotSelectTheVideoFormatWeLike:
      return "kMacDeckLinkCouldNotSelectTheVideoFormatWeLike";
    case VideoCaptureError::kMacDeckLinkCouldNotStartCapturing:
      return "kMacDeckLinkCouldNotStartCapturing";
    case VideoCaptureError::kMacDeckLinkUnsupportedPixelFormat:
      return "kMacDeckLinkUnsupportedPixelFormat";
    case VideoCaptureError::kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification:
      return "kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification";
    case VideoCaptureError::kAndroidApi2ErrorConfiguringCamera:
      return "kAndroidApi2ErrorConfiguringCamera";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToFlush:
      return "kCrosHalV3DeviceDelegateFailedToFlush";
    case VideoCaptureError::kFuchsiaCameraDeviceDisconnected:
      return "kFuchsiaCameraDeviceDisconnected";
    case VideoCaptureError::kFuchsiaCameraStreamDisconnected:
      return "kFuchsiaCameraStreamDisconnected";
    case VideoCaptureError::kFuchsiaSysmemDidNotSetImageFormat:
      return "kFuchsiaSysmemDidNotSetImageFormat";
    case VideoCaptureError::kFuchsiaSysmemInvalidBufferIndex:
      return "kFuchsiaSysmemInvalidBufferIndex";
    case VideoCaptureError::kFuchsiaSysmemInvalidBufferSize:
      return "kFuchsiaSysmemInvalidBufferSize";
    case VideoCaptureError::kFuchsiaUnsupportedPixelFormat:
      return "kFuchsiaUnsupportedPixelFormat";
    case VideoCaptureError::kFuchsiaFailedToMapSysmemBuffer:
      return "kFuchsiaFailedToMapSysmemBuffer";
    case VideoCaptureError::kCrosHalV3DeviceContextDuplicatedClient:
      return "kCrosHalV3DeviceContextDuplicatedClient";
    case VideoCaptureError::kDesktopCaptureDeviceMacFailedStreamCreate:
      return "kDesktopCaptureDeviceMacFailedStreamCreate";
    case VideoCaptureError::kDesktopCaptureDeviceMacFailedStreamStart:
      return "kDesktopCaptureDeviceMacFailedStreamStart";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToReserveBuffers:
      return "kCrosHalV3BufferManagerFailedToReserveBuffers";
    case VideoCaptureError::kWinMediaFoundationSystemPermissionDenied:
      return "kWinMediaFoundationSystemPermissionDenied";
    case VideoCaptureError::kVideoCaptureImplTimedOutOnStart:
      return "kVideoCaptureImplTimedOutOnStart";
    case VideoCaptureError::kLacrosVideoCaptureDeviceProxyAlreadyEndedOnFatalError:
      return "kLacrosVideoCaptureDeviceProxyAlreadyEndedOnFatalError";
    case VideoCaptureError::kLacrosVideoCaptureDeviceProxyEncounteredFatalError:
      return "kLacrosVideoCaptureDeviceProxyEncounteredFatalError";
    case VideoCaptureError::kScreenCaptureKitFailedGetShareableContent:
      return "kScreenCaptureKitFailedGetShareableContent";
    case VideoCaptureError::kScreenCaptureKitFailedAddStreamOutput:
      return "kScreenCaptureKitFailedAddStreamOutput";
    case VideoCaptureError::kScreenCaptureKitFailedStartCapture:
      return "kScreenCaptureKitFailedStartCapture";
    case VideoCaptureError::kScreenCaptureKitFailedStopCapture:
      return "kScreenCaptureKitFailedStopCapture";
    case VideoCaptureError::kScreenCaptureKitStreamError:
      return "kScreenCaptureKitStreamError";
    case VideoCaptureError::kScreenCaptureKitFailedToFindSCDisplay:
      return "kScreenCaptureKitFailedToFindSCDisplay";
    case VideoCaptureError::kVideoCaptureControllerInvalid:
      return "kVideoCaptureControllerInvalid";
    case VideoCaptureError::kVideoCaptureDeviceFactoryChromeOSCreateDeviceFailed:
      return "kVideoCaptureDeviceFactoryChromeOSCreateDeviceFailed";
    case VideoCaptureError::kVideoCaptureControllerUnsupportedPixelFormat:
      return "kVideoCaptureControllerUnsupportedPixelFormat";
    case VideoCaptureError::kVideoCaptureDeviceAlreadyReleased:
      return "kVideoCaptureDeviceAlreadyReleased";
    case VideoCaptureError::kVideoCaptureSystemDeviceIdNotFound:
      return "kVideoCaptureSystemDeviceIdNotFound";
    case VideoCaptureError::kVideoCaptureDeviceFactoryWinUnknownError:
      return "kVideoCaptureDeviceFactoryWinUnknownError";
    case VideoCaptureError::kWinMediaFoundationDeviceInitializationFailed:
      return "kWinMediaFoundationDeviceInitializationFailed";
    case VideoCaptureError::kWinMediaFoundationSourceCreationFailed:
      return "kWinMediaFoundationSourceCreationFailed";
    case VideoCaptureError::kWinDirectShowDeviceFilterCreationFailed:
      return "kWinDirectShowDeviceFilterCreationFailed";
    case VideoCaptureError::kWinDirectShowDeviceInitializationFailed:
      return "kWinDirectShowDeviceInitializationFailed";
    case VideoCaptureError::kVideoCaptureDeviceFactorySecondCreateDenied:
      return "kVideoCaptureDeviceFactorySecondCreateDenied";
    case VideoCaptureError::kScreenCaptureKitResetStreamError:
      return "kScreenCaptureKitResetStreamError";
    case VideoCaptureError::kWinMediaFoundationCameraBusy:
      return "kWinMediaFoundationCameraBusy";
    case VideoCaptureError::kWebRtcStartCaptureFailed:
      return "kWebRtcStartCaptureFailed";
    default:
      return nullptr;
  }
}

std::string VideoCaptureErrorToString(VideoCaptureError value) {
  const char *str = VideoCaptureErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCaptureError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCaptureError value) {
  return os << VideoCaptureErrorToString(value);
}

NOINLINE static const char* VideoCaptureFrameDropReasonToStringHelper(VideoCaptureFrameDropReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoCaptureFrameDropReason::kNone:
      return "kNone";
    case VideoCaptureFrameDropReason::kDeviceClientFrameHasInvalidFormat:
      return "kDeviceClientFrameHasInvalidFormat";
    case VideoCaptureFrameDropReason::kDeviceClientLibyuvConvertToI420Failed:
      return "kDeviceClientLibyuvConvertToI420Failed";
    case VideoCaptureFrameDropReason::kV4L2BufferErrorFlagWasSet:
      return "kV4L2BufferErrorFlagWasSet";
    case VideoCaptureFrameDropReason::kV4L2InvalidNumberOfBytesInBuffer:
      return "kV4L2InvalidNumberOfBytesInBuffer";
    case VideoCaptureFrameDropReason::kAndroidThrottling:
      return "kAndroidThrottling";
    case VideoCaptureFrameDropReason::kAndroidGetByteArrayElementsFailed:
      return "kAndroidGetByteArrayElementsFailed";
    case VideoCaptureFrameDropReason::kAndroidApi1UnexpectedDataLength:
      return "kAndroidApi1UnexpectedDataLength";
    case VideoCaptureFrameDropReason::kAndroidApi2AcquiredImageIsNull:
      return "kAndroidApi2AcquiredImageIsNull";
    case VideoCaptureFrameDropReason::kWinDirectShowUnexpectedSampleLength:
      return "kWinDirectShowUnexpectedSampleLength";
    case VideoCaptureFrameDropReason::kWinDirectShowFailedToGetMemoryPointerFromMediaSample:
      return "kWinDirectShowFailedToGetMemoryPointerFromMediaSample";
    case VideoCaptureFrameDropReason::kWinMediaFoundationReceivedSampleIsNull:
      return "kWinMediaFoundationReceivedSampleIsNull";
    case VideoCaptureFrameDropReason::kWinMediaFoundationLockingBufferDelieveredNullptr:
      return "kWinMediaFoundationLockingBufferDelieveredNullptr";
    case VideoCaptureFrameDropReason::kWinMediaFoundationGetBufferByIndexReturnedNull:
      return "kWinMediaFoundationGetBufferByIndexReturnedNull";
    case VideoCaptureFrameDropReason::kBufferPoolMaxBufferCountExceeded:
      return "kBufferPoolMaxBufferCountExceeded";
    case VideoCaptureFrameDropReason::kBufferPoolBufferAllocationFailed:
      return "kBufferPoolBufferAllocationFailed";
    case VideoCaptureFrameDropReason::kVideoCaptureImplNotInStartedState:
      return "kVideoCaptureImplNotInStartedState";
    case VideoCaptureFrameDropReason::kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame:
      return "kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame";
    case VideoCaptureFrameDropReason::kVideoTrackAdapterHasNoResolutionAdapters:
      return "kVideoTrackAdapterHasNoResolutionAdapters";
    case VideoCaptureFrameDropReason::kResolutionAdapterFrameIsNotValid:
      return "kResolutionAdapterFrameIsNotValid";
    case VideoCaptureFrameDropReason::kResolutionAdapterWrappingFrameForCroppingFailed:
      return "kResolutionAdapterWrappingFrameForCroppingFailed";
    case VideoCaptureFrameDropReason::kResolutionAdapterTimestampTooCloseToPrevious_DEPRECATED:
      return "kResolutionAdapterTimestampTooCloseToPrevious_DEPRECATED";
    case VideoCaptureFrameDropReason::kResolutionAdapterFrameRateIsHigherThanRequested:
      return "kResolutionAdapterFrameRateIsHigherThanRequested";
    case VideoCaptureFrameDropReason::kResolutionAdapterHasNoCallbacks:
      return "kResolutionAdapterHasNoCallbacks";
    case VideoCaptureFrameDropReason::kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame:
      return "kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame";
    case VideoCaptureFrameDropReason::kRendererSinkFrameDelivererIsNotStarted:
      return "kRendererSinkFrameDelivererIsNotStarted";
    case VideoCaptureFrameDropReason::kCropVersionNotCurrent_DEPRECATED:
      return "kCropVersionNotCurrent_DEPRECATED";
    case VideoCaptureFrameDropReason::kGpuMemoryBufferMapFailed:
      return "kGpuMemoryBufferMapFailed";
    case VideoCaptureFrameDropReason::kSubCaptureTargetVersionNotCurrent_DEPRECATED:
      return "kSubCaptureTargetVersionNotCurrent_DEPRECATED";
    case VideoCaptureFrameDropReason::kPostProcessingFailed:
      return "kPostProcessingFailed";
    case VideoCaptureFrameDropReason::kResolutionAdapterFrameIsNotMappable:
      return "kResolutionAdapterFrameIsNotMappable";
    case VideoCaptureFrameDropReason::kResolutionAdapterCannotCreateConvertFrame:
      return "kResolutionAdapterCannotCreateConvertFrame";
    case VideoCaptureFrameDropReason::kResolutionAdapterConvertAndScaleFailed:
      return "kResolutionAdapterConvertAndScaleFailed";
    case VideoCaptureFrameDropReason::kOldCaptureVersion:
      return "kOldCaptureVersion";
    default:
      return nullptr;
  }
}

std::string VideoCaptureFrameDropReasonToString(VideoCaptureFrameDropReason value) {
  const char *str = VideoCaptureFrameDropReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoCaptureFrameDropReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoCaptureFrameDropReason value) {
  return os << VideoCaptureFrameDropReasonToString(value);
}

NOINLINE static const char* SubCaptureTargetTypeToStringHelper(SubCaptureTargetType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SubCaptureTargetType::kCropTarget:
      return "kCropTarget";
    case SubCaptureTargetType::kRestrictionTarget:
      return "kRestrictionTarget";
    default:
      return nullptr;
  }
}

std::string SubCaptureTargetTypeToString(SubCaptureTargetType value) {
  const char *str = SubCaptureTargetTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SubCaptureTargetType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SubCaptureTargetType value) {
  return os << SubCaptureTargetTypeToString(value);
}

NOINLINE static const char* ApplySubCaptureTargetResultToStringHelper(ApplySubCaptureTargetResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ApplySubCaptureTargetResult::kSuccess:
      return "kSuccess";
    case ApplySubCaptureTargetResult::kErrorGeneric:
      return "kErrorGeneric";
    case ApplySubCaptureTargetResult::kUnsupportedCaptureDevice:
      return "kUnsupportedCaptureDevice";
    case ApplySubCaptureTargetResult::kNotImplemented:
      return "kNotImplemented";
    case ApplySubCaptureTargetResult::kNonIncreasingVersion:
      return "kNonIncreasingVersion";
    case ApplySubCaptureTargetResult::kInvalidTarget:
      return "kInvalidTarget";
    default:
      return nullptr;
  }
}

std::string ApplySubCaptureTargetResultToString(ApplySubCaptureTargetResult value) {
  const char *str = ApplySubCaptureTargetResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ApplySubCaptureTargetResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ApplySubCaptureTargetResult value) {
  return os << ApplySubCaptureTargetResultToString(value);
}

NOINLINE static const char* DeviceEnumerationResultToStringHelper(DeviceEnumerationResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceEnumerationResult::kSuccess:
      return "kSuccess";
    case DeviceEnumerationResult::kUnknownError:
      return "kUnknownError";
    case DeviceEnumerationResult::kErrorCaptureServiceCrash:
      return "kErrorCaptureServiceCrash";
    case DeviceEnumerationResult::kErrorCaptureServiceDroppedRequest:
      return "kErrorCaptureServiceDroppedRequest";
    default:
      return nullptr;
  }
}

std::string DeviceEnumerationResultToString(DeviceEnumerationResult value) {
  const char *str = DeviceEnumerationResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceEnumerationResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceEnumerationResult value) {
  return os << DeviceEnumerationResultToString(value);
}

namespace internal {


// static
bool VideoCaptureControlSupport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureControlSupport_Data* object =
      static_cast<const VideoCaptureControlSupport_Data*>(data);

  return true;
}

VideoCaptureControlSupport_Data::VideoCaptureControlSupport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureFormat_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureFormat_Data* object =
      static_cast<const VideoCaptureFormat_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_size, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCapturePixelFormat_Data
        ::Validate(object->pixel_format, validation_context))
    return false;

  return true;
}

VideoCaptureFormat_Data::VideoCaptureFormat_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureParams_Data* object =
      static_cast<const VideoCaptureParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_format, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_format, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCaptureBufferType_Data
        ::Validate(object->buffer_type, validation_context))
    return false;


  if (!::media::mojom::internal::ResolutionChangePolicy_Data
        ::Validate(object->resolution_change_policy, validation_context))
    return false;


  if (!::media::mojom::internal::PowerLineFrequency_Data
        ::Validate(object->power_line_frequency, validation_context))
    return false;

  return true;
}

VideoCaptureParams_Data::VideoCaptureParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureFeedback_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureFeedback_Data* object =
      static_cast<const VideoCaptureFeedback_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& DEPRECATED_mapped_sizes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->DEPRECATED_mapped_sizes, validation_context,
                                         &DEPRECATED_mapped_sizes_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureFeedback_Data::VideoCaptureFeedback_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PlaneStrides_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PlaneStrides_Data* object =
      static_cast<const PlaneStrides_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stride_by_plane, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stride_by_plane_validate_params =
      mojo::internal::GetArrayValidator<4, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stride_by_plane, validation_context,
                                         &stride_by_plane_validate_params)) {
    return false;
  }

  return true;
}

PlaneStrides_Data::PlaneStrides_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureDeviceDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureDeviceDescriptor_Data* object =
      static_cast<const VideoCaptureDeviceDescriptor_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_id, validation_context,
                                         &model_id_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::VideoFacingMode_Data
        ::Validate(object->facing_mode, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCaptureApi_Data
        ::Validate(object->capture_api, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->control_support, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->control_support, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCaptureTransportType_Data
        ::Validate(object->transport_type, validation_context))
    return false;


  if (!::media::mojom::internal::CameraAvailability_Data
        ::Validate(object->availability_$value, validation_context))
    return false;

  return true;
}

VideoCaptureDeviceDescriptor_Data::VideoCaptureDeviceDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoCaptureDeviceInfo_Data* object =
      static_cast<const VideoCaptureDeviceInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptor, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_formats, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_formats_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->supported_formats, validation_context,
                                         &supported_formats_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureDeviceInfo_Data::VideoCaptureDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCapturePixelFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCapturePixelFormat value) {
  return std::move(context).WriteString(::media::mojom::VideoCapturePixelFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::ResolutionChangePolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::ResolutionChangePolicy value) {
  return std::move(context).WriteString(::media::mojom::ResolutionChangePolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::PowerLineFrequency>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::PowerLineFrequency value) {
  return std::move(context).WriteString(::media::mojom::PowerLineFrequencyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoFacingMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoFacingMode value) {
  return std::move(context).WriteString(::media::mojom::VideoFacingModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CameraAvailability>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::CameraAvailability value) {
  return std::move(context).WriteString(::media::mojom::CameraAvailabilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureApi>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureApi value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureApiToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureTransportType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureTransportType value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureTransportTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureBufferType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureBufferType value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureBufferTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureError>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureError value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureFrameDropReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureFrameDropReason value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureFrameDropReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::SubCaptureTargetType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::SubCaptureTargetType value) {
  return std::move(context).WriteString(::media::mojom::SubCaptureTargetTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::ApplySubCaptureTargetResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::ApplySubCaptureTargetResult value) {
  return std::move(context).WriteString(::media::mojom::ApplySubCaptureTargetResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::DeviceEnumerationResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::DeviceEnumerationResult value) {
  return std::move(context).WriteString(::media::mojom::DeviceEnumerationResultToString(value));
}

} // namespace perfetto