// media/capture/mojom/video_capture_types.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');

goog.require('gfx.mojom.Size');




goog.provide('media.mojom.VideoCapturePixelFormat');
goog.provide('media.mojom.VideoCapturePixelFormatSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCapturePixelFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoCapturePixelFormat = {
  
  UNKNOWN: 0,
  I420: 1,
  YV12: 2,
  I422: 3,
  I420A: 4,
  I444: 5,
  NV12: 6,
  NV21: 7,
  UYVY: 8,
  YUY2: 9,
  ARGB: 10,
  XRGB: 11,
  RGB24: 12,
  MJPEG: 13,
  YUV420P9_DEPRECATED: 14,
  YUV420P10: 15,
  YUV422P9_DEPRECATED: 16,
  YUV422P10: 17,
  YUV444P9_DEPRECATED: 18,
  YUV444P10: 19,
  YUV420P12: 20,
  YUV422P12: 21,
  YUV444P12: 22,
  Y16: 23,
  ABGR: 24,
  XBGR: 25,
  P010LE: 26,
  XR30: 27,
  XB30: 28,
  BGRA: 29,
  RGBAF16: 30,
  I422A: 31,
  I444A: 32,
  YUV420AP10: 33,
  YUV422AP10: 34,
  YUV444AP10: 35,
  NV12A: 36,
  NV16: 37,
  NV24: 38,
  P210LE: 39,
  P410LE: 40,
  MIN_VALUE: 0,
  MAX_VALUE: 40,
};

goog.provide('media.mojom.ResolutionChangePolicy');
goog.provide('media.mojom.ResolutionChangePolicySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.ResolutionChangePolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.ResolutionChangePolicy = {
  
  FIXED_RESOLUTION: 0,
  FIXED_ASPECT_RATIO: 1,
  ANY_WITHIN_LIMIT: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('media.mojom.PowerLineFrequency');
goog.provide('media.mojom.PowerLineFrequencySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.PowerLineFrequencySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.PowerLineFrequency = {
  
  DEFAULT: 0,
  HZ_50: 1,
  HZ_60: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('media.mojom.VideoFacingMode');
goog.provide('media.mojom.VideoFacingModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoFacingModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoFacingMode = {
  
  NONE: 0,
  USER: 1,
  ENVIRONMENT: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('media.mojom.CameraAvailability');
goog.provide('media.mojom.CameraAvailabilitySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CameraAvailabilitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CameraAvailability = {
  
  kAvailable: 0,
  kUnavailableExclusivelyUsedByOtherApplication: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('media.mojom.VideoCaptureApi');
goog.provide('media.mojom.VideoCaptureApiSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCaptureApiSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoCaptureApi = {
  
  LINUX_V4L2_SINGLE_PLANE: 0,
  WIN_MEDIA_FOUNDATION: 1,
  WIN_MEDIA_FOUNDATION_SENSOR: 2,
  WIN_DIRECT_SHOW: 3,
  MACOSX_AVFOUNDATION: 4,
  MACOSX_DECKLINK: 5,
  ANDROID_API1: 6,
  ANDROID_API2_LEGACY: 7,
  ANDROID_API2_FULL: 8,
  ANDROID_API2_LIMITED: 9,
  FUCHSIA_CAMERA3: 10,
  VIRTUAL_DEVICE: 11,
  UNKNOWN: 12,
  WEBRTC_LINUX_PIPEWIRE_SINGLE_PLANE: 13,
  MIN_VALUE: 0,
  MAX_VALUE: 13,
};

goog.provide('media.mojom.VideoCaptureTransportType');
goog.provide('media.mojom.VideoCaptureTransportTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCaptureTransportTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoCaptureTransportType = {
  
  APPLE_USB_OR_BUILT_IN: 0,
  OTHER_TRANSPORT: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('media.mojom.VideoCaptureBufferType');
goog.provide('media.mojom.VideoCaptureBufferTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCaptureBufferTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoCaptureBufferType = {
  
  kSharedMemory: 0,
  kSharedMemoryViaRawFileDescriptor_DEPRECATED: 1,
  kMailboxHolder: 2,
  kGpuMemoryBuffer: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('media.mojom.VideoCaptureError');
goog.provide('media.mojom.VideoCaptureErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCaptureErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoCaptureError = {
  
  kNone: 0,
  kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested: 1,
  kVideoCaptureControllerIsAlreadyInErrorState: 2,
  kVideoCaptureManagerDeviceConnectionLost: 3,
  kFrameSinkVideoCaptureDeviceAlreadyEndedOnFatalError: 4,
  kFrameSinkVideoCaptureDeviceEncounteredFatalError: 5,
  kV4L2FailedToOpenV4L2DeviceDriverFile: 6,
  kV4L2ThisIsNotAV4L2VideoCaptureDevice: 7,
  kV4L2FailedToFindASupportedCameraFormat: 8,
  kV4L2FailedToSetVideoCaptureFormat: 9,
  kV4L2UnsupportedPixelFormat: 10,
  kV4L2FailedToSetCameraFramerate: 11,
  kV4L2ErrorRequestingMmapBuffers: 12,
  kV4L2AllocateBufferFailed: 13,
  kV4L2VidiocStreamonFailed: 14,
  kV4L2VidiocStreamoffFailed: 15,
  kV4L2FailedToVidiocReqbufsWithCount0: 16,
  kV4L2PollFailed: 17,
  kV4L2MultipleContinuousTimeoutsWhileReadPolling: 18,
  kV4L2FailedToDequeueCaptureBuffer: 19,
  kV4L2FailedToEnqueueCaptureBuffer: 20,
  kSingleClientVideoCaptureHostLostConnectionToDevice: 21,
  kSingleClientVideoCaptureDeviceLaunchAborted: 22,
  kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed: 23,
  kFileVideoCaptureDeviceCouldNotOpenVideoFile: 24,
  kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate: 25,
  kErrorFakeDeviceIntentionallyEmittingErrorEvent: 26,
  kDeviceClientTooManyFramesDroppedY16: 27,
  kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType: 28,
  kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound: 29,
  kInProcessDeviceLauncherFailedToCreateDeviceInstance: 30,
  kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart: 31,
  kServiceDeviceLauncherServiceRespondedWithDeviceNotFound: 32,
  kServiceDeviceLauncherConnectionLostWhileWaitingForCallback: 33,
  kIntentionalErrorRaisedByUnitTest: 34,
  kCrosHalV3FailedToStartDeviceThread: 35,
  kCrosHalV3DeviceDelegateMojoConnectionError: 36,
  kCrosHalV3DeviceDelegateFailedToGetCameraInfo: 37,
  kCrosHalV3DeviceDelegateMissingSensorOrientationInfo: 38,
  kCrosHalV3DeviceDelegateFailedToOpenCameraDevice: 39,
  kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice: 40,
  kCrosHalV3DeviceDelegateFailedToConfigureStreams: 41,
  kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured: 42,
  kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings: 43,
  kCrosHalV3BufferManagerHalRequestedTooManyBuffers: 44,
  kCrosHalV3BufferManagerFailedToCreateMappableSI: 45,
  kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer: 46,
  kCrosHalV3BufferManagerUnsupportedVideoPixelFormat: 47,
  kCrosHalV3BufferManagerFailedToDupFd: 48,
  kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle: 49,
  kCrosHalV3BufferManagerFailedToRegisterBuffer: 50,
  kCrosHalV3BufferManagerProcessCaptureRequestFailed: 51,
  kCrosHalV3BufferManagerInvalidPendingResultId: 52,
  kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata: 53,
  kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived: 54,
  kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived: 55,
  kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame: 56,
  kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg: 57,
  kCrosHalV3BufferManagerReceivedInvalidShutterTime: 58,
  kCrosHalV3BufferManagerFatalDeviceError: 59,
  kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder: 60,
  kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd: 61,
  kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut: 62,
  kCrosHalV3BufferManagerInvalidJpegBlob: 63,
  kAndroidFailedToAllocate: 64,
  kAndroidFailedToStartCapture: 65,
  kAndroidFailedToStopCapture: 66,
  kAndroidApi1CameraErrorCallbackReceived: 67,
  kAndroidApi2CameraDeviceErrorReceived: 68,
  kAndroidApi2CaptureSessionConfigureFailed: 69,
  kAndroidApi2ImageReaderUnexpectedImageFormat: 70,
  kAndroidApi2ImageReaderSizeDidNotMatchImageSize: 71,
  kAndroidApi2ErrorRestartingPreview: 72,
  kAndroidScreenCaptureUnsupportedFormat: 73,
  kAndroidScreenCaptureFailedToStartCaptureMachine: 74,
  kAndroidScreenCaptureTheUserDeniedScreenCapture: 75,
  kAndroidScreenCaptureFailedToStartScreenCapture: 76,
  kWinDirectShowCantGetCaptureFormatSettings: 77,
  kWinDirectShowFailedToGetNumberOfCapabilities: 78,
  kWinDirectShowFailedToGetCaptureDeviceCapabilities: 79,
  kWinDirectShowFailedToSetCaptureDeviceOutputFormat: 80,
  kWinDirectShowFailedToConnectTheCaptureGraph: 81,
  kWinDirectShowFailedToPauseTheCaptureDevice: 82,
  kWinDirectShowFailedToStartTheCaptureDevice: 83,
  kWinDirectShowFailedToStopTheCaptureGraph: 84,
  kWinMediaFoundationEngineIsNull: 85,
  kWinMediaFoundationEngineGetSourceFailed: 86,
  kWinMediaFoundationFillPhotoCapabilitiesFailed: 87,
  kWinMediaFoundationFillVideoCapabilitiesFailed: 88,
  kWinMediaFoundationNoVideoCapabilityFound: 89,
  kWinMediaFoundationGetAvailableDeviceMediaTypeFailed: 90,
  kWinMediaFoundationSetCurrentDeviceMediaTypeFailed: 91,
  kWinMediaFoundationEngineGetSinkFailed: 92,
  kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed: 93,
  kWinMediaFoundationSinkRemoveAllStreamsFailed: 94,
  kWinMediaFoundationCreateSinkVideoMediaTypeFailed: 95,
  kWinMediaFoundationConvertToVideoSinkMediaTypeFailed: 96,
  kWinMediaFoundationSinkAddStreamFailed: 97,
  kWinMediaFoundationSinkSetSampleCallbackFailed: 98,
  kWinMediaFoundationEngineStartPreviewFailed: 99,
  kWinMediaFoundationGetMediaEventStatusFailed: 100,
  kMacSetCaptureDeviceFailed: 101,
  kMacCouldNotStartCaptureDevice: 102,
  kMacReceivedFrameWithUnexpectedResolution: 103,
  kMacUpdateCaptureResolutionFailed: 104,
  kMacDeckLinkDeviceIdNotFoundInTheSystem: 105,
  kMacDeckLinkErrorQueryingInputInterface: 106,
  kMacDeckLinkErrorCreatingDisplayModeIterator: 107,
  kMacDeckLinkCouldNotFindADisplayMode: 108,
  kMacDeckLinkCouldNotSelectTheVideoFormatWeLike: 109,
  kMacDeckLinkCouldNotStartCapturing: 110,
  kMacDeckLinkUnsupportedPixelFormat: 111,
  kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification: 112,
  kAndroidApi2ErrorConfiguringCamera: 113,
  kCrosHalV3DeviceDelegateFailedToFlush: 114,
  kFuchsiaCameraDeviceDisconnected: 115,
  kFuchsiaCameraStreamDisconnected: 116,
  kFuchsiaSysmemDidNotSetImageFormat: 117,
  kFuchsiaSysmemInvalidBufferIndex: 118,
  kFuchsiaSysmemInvalidBufferSize: 119,
  kFuchsiaUnsupportedPixelFormat: 120,
  kFuchsiaFailedToMapSysmemBuffer: 121,
  kCrosHalV3DeviceContextDuplicatedClient: 122,
  kDesktopCaptureDeviceMacFailedStreamCreate: 123,
  kDesktopCaptureDeviceMacFailedStreamStart: 124,
  kCrosHalV3BufferManagerFailedToReserveBuffers: 125,
  kWinMediaFoundationSystemPermissionDenied: 126,
  kVideoCaptureImplTimedOutOnStart: 127,
  kLacrosVideoCaptureDeviceProxyAlreadyEndedOnFatalError: 128,
  kLacrosVideoCaptureDeviceProxyEncounteredFatalError: 129,
  kScreenCaptureKitFailedGetShareableContent: 130,
  kScreenCaptureKitFailedAddStreamOutput: 131,
  kScreenCaptureKitFailedStartCapture: 132,
  kScreenCaptureKitFailedStopCapture: 133,
  kScreenCaptureKitStreamError: 134,
  kScreenCaptureKitFailedToFindSCDisplay: 135,
  kVideoCaptureControllerInvalid: 136,
  kVideoCaptureDeviceFactoryChromeOSCreateDeviceFailed: 137,
  kVideoCaptureControllerUnsupportedPixelFormat: 138,
  kVideoCaptureDeviceAlreadyReleased: 139,
  kVideoCaptureSystemDeviceIdNotFound: 140,
  kVideoCaptureDeviceFactoryWinUnknownError: 141,
  kWinMediaFoundationDeviceInitializationFailed: 142,
  kWinMediaFoundationSourceCreationFailed: 143,
  kWinDirectShowDeviceFilterCreationFailed: 144,
  kWinDirectShowDeviceInitializationFailed: 145,
  kVideoCaptureDeviceFactorySecondCreateDenied: 146,
  kScreenCaptureKitResetStreamError: 147,
  kWinMediaFoundationCameraBusy: 148,
  kWebRtcStartCaptureFailed: 149,
  MIN_VALUE: 0,
  MAX_VALUE: 149,
};

goog.provide('media.mojom.VideoCaptureFrameDropReason');
goog.provide('media.mojom.VideoCaptureFrameDropReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCaptureFrameDropReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoCaptureFrameDropReason = {
  
  kNone: 0,
  kDeviceClientFrameHasInvalidFormat: 1,
  kDeviceClientLibyuvConvertToI420Failed: 2,
  kV4L2BufferErrorFlagWasSet: 3,
  kV4L2InvalidNumberOfBytesInBuffer: 4,
  kAndroidThrottling: 5,
  kAndroidGetByteArrayElementsFailed: 6,
  kAndroidApi1UnexpectedDataLength: 7,
  kAndroidApi2AcquiredImageIsNull: 8,
  kWinDirectShowUnexpectedSampleLength: 9,
  kWinDirectShowFailedToGetMemoryPointerFromMediaSample: 10,
  kWinMediaFoundationReceivedSampleIsNull: 11,
  kWinMediaFoundationLockingBufferDelieveredNullptr: 12,
  kWinMediaFoundationGetBufferByIndexReturnedNull: 13,
  kBufferPoolMaxBufferCountExceeded: 14,
  kBufferPoolBufferAllocationFailed: 15,
  kVideoCaptureImplNotInStartedState: 16,
  kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame: 17,
  kVideoTrackAdapterHasNoResolutionAdapters: 18,
  kResolutionAdapterFrameIsNotValid: 19,
  kResolutionAdapterWrappingFrameForCroppingFailed: 20,
  kResolutionAdapterTimestampTooCloseToPrevious_DEPRECATED: 21,
  kResolutionAdapterFrameRateIsHigherThanRequested: 22,
  kResolutionAdapterHasNoCallbacks: 23,
  kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame: 24,
  kRendererSinkFrameDelivererIsNotStarted: 25,
  kCropVersionNotCurrent_DEPRECATED: 26,
  kGpuMemoryBufferMapFailed: 27,
  kSubCaptureTargetVersionNotCurrent_DEPRECATED: 28,
  kPostProcessingFailed: 29,
  kResolutionAdapterFrameIsNotMappable: 30,
  kResolutionAdapterCannotCreateConvertFrame: 31,
  kResolutionAdapterConvertAndScaleFailed: 32,
  kOldCaptureVersion: 33,
  MIN_VALUE: 0,
  MAX_VALUE: 33,
};

goog.provide('media.mojom.SubCaptureTargetType');
goog.provide('media.mojom.SubCaptureTargetTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.SubCaptureTargetTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.SubCaptureTargetType = {
  
  kCropTarget: 0,
  kRestrictionTarget: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('media.mojom.ApplySubCaptureTargetResult');
goog.provide('media.mojom.ApplySubCaptureTargetResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.ApplySubCaptureTargetResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.ApplySubCaptureTargetResult = {
  
  kSuccess: 0,
  kErrorGeneric: 1,
  kUnsupportedCaptureDevice: 2,
  kNotImplemented: 3,
  kNonIncreasingVersion: 4,
  kInvalidTarget: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('media.mojom.DeviceEnumerationResult');
goog.provide('media.mojom.DeviceEnumerationResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.DeviceEnumerationResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.DeviceEnumerationResult = {
  
  kSuccess: 0,
  kUnknownError: 1,
  kErrorCaptureServiceCrash: 2,
  kErrorCaptureServiceDroppedRequest: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('media.mojom.VideoCaptureControlSupportSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureControlSupportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureFormatSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureFormatSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureFeedbackSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureFeedbackSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.PlaneStridesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaneStridesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureDeviceDescriptorSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureDeviceDescriptorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureDeviceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.VideoCaptureControlSupportSpec.$,
    'VideoCaptureControlSupport',
    [
      mojo.internal.StructField(
        'pan', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tilt', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'zoom', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureControlSupport');

/** @record */
media.mojom.VideoCaptureControlSupport = class {
  constructor() {
    /** @export { !boolean } */
    this.pan;
    /** @export { !boolean } */
    this.tilt;
    /** @export { !boolean } */
    this.zoom;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureFormatSpec.$,
    'VideoCaptureFormat',
    [
      mojo.internal.StructField(
        'frameSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameRate', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pixelFormat', 12,
        0,
        media.mojom.VideoCapturePixelFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoCaptureFormat');

/** @record */
media.mojom.VideoCaptureFormat = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.frameSize;
    /** @export { !number } */
    this.frameRate;
    /** @export { !media.mojom.VideoCapturePixelFormat } */
    this.pixelFormat;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureParamsSpec.$,
    'VideoCaptureParams',
    [
      mojo.internal.StructField(
        'requestedFormat', 0,
        0,
        media.mojom.VideoCaptureFormatSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bufferType', 8,
        0,
        media.mojom.VideoCaptureBufferTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resolutionChangePolicy', 12,
        0,
        media.mojom.ResolutionChangePolicySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'powerLineFrequency', 16,
        0,
        media.mojom.PowerLineFrequencySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableFaceDetection', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isHighDpiEnabled', 20,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'captureVersionSource', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.VideoCaptureParams');

/** @record */
media.mojom.VideoCaptureParams = class {
  constructor() {
    /** @export { !media.mojom.VideoCaptureFormat } */
    this.requestedFormat;
    /** @export { !media.mojom.VideoCaptureBufferType } */
    this.bufferType;
    /** @export { !media.mojom.ResolutionChangePolicy } */
    this.resolutionChangePolicy;
    /** @export { !media.mojom.PowerLineFrequency } */
    this.powerLineFrequency;
    /** @export { !boolean } */
    this.enableFaceDetection;
    /** @export { !boolean } */
    this.isHighDpiEnabled;
    /** @export { !number } */
    this.captureVersionSource;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureFeedbackSpec.$,
    'VideoCaptureFeedback',
    [
      mojo.internal.StructField(
        'resourceUtilization', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxFramerateFps', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxPixels', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireMappedFrame', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dEPRECATEDMappedSizes', 24,
        0,
        mojo.internal.Array(gfx.mojom.SizeSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameId', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasFrameId', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.VideoCaptureFeedback');

/** @record */
media.mojom.VideoCaptureFeedback = class {
  constructor() {
    /** @export { !number } */
    this.resourceUtilization;
    /** @export { !number } */
    this.maxFramerateFps;
    /** @export { !number } */
    this.maxPixels;
    /** @export { !boolean } */
    this.requireMappedFrame;
    /** @export { (Array<!gfx.mojom.Size>|undefined) } */
    this.dEPRECATEDMappedSizes;
    /** @export { !number } */
    this.frameId;
    /** @export { !boolean } */
    this.hasFrameId;
  }
};



mojo.internal.Struct(
    media.mojom.PlaneStridesSpec.$,
    'PlaneStrides',
    [
      mojo.internal.StructField(
        'strideByPlane', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.PlaneStrides');

/** @record */
media.mojom.PlaneStrides = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.strideByPlane;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureDeviceDescriptorSpec.$,
    'VideoCaptureDeviceDescriptor',
    [
      mojo.internal.StructField(
        'displayName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modelId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'facingMode', 24,
        0,
        media.mojom.VideoFacingModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'captureApi', 28,
        0,
        media.mojom.VideoCaptureApiSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controlSupport', 32,
        0,
        media.mojom.VideoCaptureControlSupportSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transportType', 40,
        0,
        media.mojom.VideoCaptureTransportTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'availability_$flag', 44,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "availability_$value",
          originalFieldName: "availability",
        }
      ),
      mojo.internal.StructField(
        'availability_$value', 48,
        0,
        media.mojom.CameraAvailabilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "availability",
        }
      ),
    ],
    [[0, 64],]);



goog.provide('media.mojom.VideoCaptureDeviceDescriptor');

/** @record */
media.mojom.VideoCaptureDeviceDescriptor = class {
  constructor() {
    /** @export { !string } */
    this.displayName;
    /** @export { !string } */
    this.deviceId;
    /** @export { !string } */
    this.modelId;
    /** @export { !media.mojom.VideoFacingMode } */
    this.facingMode;
    /** @export { !media.mojom.VideoCaptureApi } */
    this.captureApi;
    /** @export { !media.mojom.VideoCaptureControlSupport } */
    this.controlSupport;
    /** @export { !media.mojom.VideoCaptureTransportType } */
    this.transportType;
    /** @export { (media.mojom.CameraAvailability|undefined) } */
    this.availability;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureDeviceInfoSpec.$,
    'VideoCaptureDeviceInfo',
    [
      mojo.internal.StructField(
        'descriptor', 0,
        0,
        media.mojom.VideoCaptureDeviceDescriptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supportedFormats', 8,
        0,
        mojo.internal.Array(media.mojom.VideoCaptureFormatSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoCaptureDeviceInfo');

/** @record */
media.mojom.VideoCaptureDeviceInfo = class {
  constructor() {
    /** @export { !media.mojom.VideoCaptureDeviceDescriptor } */
    this.descriptor;
    /** @export { !Array<!media.mojom.VideoCaptureFormat> } */
    this.supportedFormats;
  }
};

