// media/capture/mojom/video_capture_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_DATA_VIEW_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/capture/mojom/video_capture_types.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace media::mojom {
class VideoCaptureControlSupportDataView;

class VideoCaptureFormatDataView;

class VideoCaptureParamsDataView;

class VideoCaptureFeedbackDataView;

class PlaneStridesDataView;

class VideoCaptureDeviceDescriptorDataView;

class VideoCaptureDeviceInfoDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureControlSupportDataView> {
  using Data = ::media::mojom::internal::VideoCaptureControlSupport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureFormatDataView> {
  using Data = ::media::mojom::internal::VideoCaptureFormat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureParamsDataView> {
  using Data = ::media::mojom::internal::VideoCaptureParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureFeedbackDataView> {
  using Data = ::media::mojom::internal::VideoCaptureFeedback_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PlaneStridesDataView> {
  using Data = ::media::mojom::internal::PlaneStrides_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureDeviceDescriptorDataView> {
  using Data = ::media::mojom::internal::VideoCaptureDeviceDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureDeviceInfoDataView> {
  using Data = ::media::mojom::internal::VideoCaptureDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class VideoCapturePixelFormat : int32_t {
  
  UNKNOWN = 0,
  
  I420 = 1,
  
  YV12 = 2,
  
  I422 = 3,
  
  I420A = 4,
  
  I444 = 5,
  
  NV12 = 6,
  
  NV21 = 7,
  
  UYVY = 8,
  
  YUY2 = 9,
  
  ARGB = 10,
  
  XRGB = 11,
  
  RGB24 = 12,
  
  MJPEG = 13,
  
  YUV420P9_DEPRECATED = 14,
  
  YUV420P10 = 15,
  
  YUV422P9_DEPRECATED = 16,
  
  YUV422P10 = 17,
  
  YUV444P9_DEPRECATED = 18,
  
  YUV444P10 = 19,
  
  YUV420P12 = 20,
  
  YUV422P12 = 21,
  
  YUV444P12 = 22,
  
  Y16 = 23,
  
  ABGR = 24,
  
  XBGR = 25,
  
  P010LE = 26,
  
  XR30 = 27,
  
  XB30 = 28,
  
  BGRA = 29,
  
  RGBAF16 = 30,
  
  I422A = 31,
  
  I444A = 32,
  
  YUV420AP10 = 33,
  
  YUV422AP10 = 34,
  
  YUV444AP10 = 35,
  
  NV12A = 36,
  
  NV16 = 37,
  
  NV24 = 38,
  
  P210LE = 39,
  
  P410LE = 40,
  kMinValue = 0,
  kMaxValue = 40,
};

 std::ostream& operator<<(std::ostream& os, VideoCapturePixelFormat value);
inline bool IsKnownEnumValue(VideoCapturePixelFormat value) {
  return internal::VideoCapturePixelFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolutionChangePolicy : int32_t {
  
  FIXED_RESOLUTION = 0,
  
  FIXED_ASPECT_RATIO = 1,
  
  ANY_WITHIN_LIMIT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ResolutionChangePolicy value);
inline bool IsKnownEnumValue(ResolutionChangePolicy value) {
  return internal::ResolutionChangePolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PowerLineFrequency : int32_t {
  
  DEFAULT = 0,
  
  HZ_50 = 1,
  
  HZ_60 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PowerLineFrequency value);
inline bool IsKnownEnumValue(PowerLineFrequency value) {
  return internal::PowerLineFrequency_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoFacingMode : int32_t {
  
  NONE = 0,
  
  USER = 1,
  
  ENVIRONMENT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, VideoFacingMode value);
inline bool IsKnownEnumValue(VideoFacingMode value) {
  return internal::VideoFacingMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CameraAvailability : int32_t {
  
  kAvailable = 0,
  
  kUnavailableExclusivelyUsedByOtherApplication = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CameraAvailability value);
inline bool IsKnownEnumValue(CameraAvailability value) {
  return internal::CameraAvailability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureApi : int32_t {
  
  LINUX_V4L2_SINGLE_PLANE = 0,
  
  WIN_MEDIA_FOUNDATION = 1,
  
  WIN_MEDIA_FOUNDATION_SENSOR = 2,
  
  WIN_DIRECT_SHOW = 3,
  
  MACOSX_AVFOUNDATION = 4,
  
  MACOSX_DECKLINK = 5,
  
  ANDROID_API1 = 6,
  
  ANDROID_API2_LEGACY = 7,
  
  ANDROID_API2_FULL = 8,
  
  ANDROID_API2_LIMITED = 9,
  
  FUCHSIA_CAMERA3 = 10,
  
  VIRTUAL_DEVICE = 11,
  
  UNKNOWN = 12,
  
  WEBRTC_LINUX_PIPEWIRE_SINGLE_PLANE = 13,
  kMinValue = 0,
  kMaxValue = 13,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureApi value);
inline bool IsKnownEnumValue(VideoCaptureApi value) {
  return internal::VideoCaptureApi_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureTransportType : int32_t {
  
  APPLE_USB_OR_BUILT_IN = 0,
  
  OTHER_TRANSPORT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureTransportType value);
inline bool IsKnownEnumValue(VideoCaptureTransportType value) {
  return internal::VideoCaptureTransportType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureBufferType : int32_t {
  
  kSharedMemory = 0,
  
  kSharedMemoryViaRawFileDescriptor_DEPRECATED = 1,
  
  kMailboxHolder = 2,
  
  kGpuMemoryBuffer = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureBufferType value);
inline bool IsKnownEnumValue(VideoCaptureBufferType value) {
  return internal::VideoCaptureBufferType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureError : int32_t {
  
  kNone = 0,
  
  kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested = 1,
  
  kVideoCaptureControllerIsAlreadyInErrorState = 2,
  
  kVideoCaptureManagerDeviceConnectionLost = 3,
  
  kFrameSinkVideoCaptureDeviceAlreadyEndedOnFatalError = 4,
  
  kFrameSinkVideoCaptureDeviceEncounteredFatalError = 5,
  
  kV4L2FailedToOpenV4L2DeviceDriverFile = 6,
  
  kV4L2ThisIsNotAV4L2VideoCaptureDevice = 7,
  
  kV4L2FailedToFindASupportedCameraFormat = 8,
  
  kV4L2FailedToSetVideoCaptureFormat = 9,
  
  kV4L2UnsupportedPixelFormat = 10,
  
  kV4L2FailedToSetCameraFramerate = 11,
  
  kV4L2ErrorRequestingMmapBuffers = 12,
  
  kV4L2AllocateBufferFailed = 13,
  
  kV4L2VidiocStreamonFailed = 14,
  
  kV4L2VidiocStreamoffFailed = 15,
  
  kV4L2FailedToVidiocReqbufsWithCount0 = 16,
  
  kV4L2PollFailed = 17,
  
  kV4L2MultipleContinuousTimeoutsWhileReadPolling = 18,
  
  kV4L2FailedToDequeueCaptureBuffer = 19,
  
  kV4L2FailedToEnqueueCaptureBuffer = 20,
  
  kSingleClientVideoCaptureHostLostConnectionToDevice = 21,
  
  kSingleClientVideoCaptureDeviceLaunchAborted = 22,
  
  kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed = 23,
  
  kFileVideoCaptureDeviceCouldNotOpenVideoFile = 24,
  
  kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate = 25,
  
  kErrorFakeDeviceIntentionallyEmittingErrorEvent = 26,
  
  kDeviceClientTooManyFramesDroppedY16 = 27,
  
  kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType = 28,
  
  kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound = 29,
  
  kInProcessDeviceLauncherFailedToCreateDeviceInstance = 30,
  
  kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart = 31,
  
  kServiceDeviceLauncherServiceRespondedWithDeviceNotFound = 32,
  
  kServiceDeviceLauncherConnectionLostWhileWaitingForCallback = 33,
  
  kIntentionalErrorRaisedByUnitTest = 34,
  
  kCrosHalV3FailedToStartDeviceThread = 35,
  
  kCrosHalV3DeviceDelegateMojoConnectionError = 36,
  
  kCrosHalV3DeviceDelegateFailedToGetCameraInfo = 37,
  
  kCrosHalV3DeviceDelegateMissingSensorOrientationInfo = 38,
  
  kCrosHalV3DeviceDelegateFailedToOpenCameraDevice = 39,
  
  kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice = 40,
  
  kCrosHalV3DeviceDelegateFailedToConfigureStreams = 41,
  
  kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured = 42,
  
  kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings = 43,
  
  kCrosHalV3BufferManagerHalRequestedTooManyBuffers = 44,
  
  kCrosHalV3BufferManagerFailedToCreateMappableSI = 45,
  
  kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer = 46,
  
  kCrosHalV3BufferManagerUnsupportedVideoPixelFormat = 47,
  
  kCrosHalV3BufferManagerFailedToDupFd = 48,
  
  kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle = 49,
  
  kCrosHalV3BufferManagerFailedToRegisterBuffer = 50,
  
  kCrosHalV3BufferManagerProcessCaptureRequestFailed = 51,
  
  kCrosHalV3BufferManagerInvalidPendingResultId = 52,
  
  kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata = 53,
  
  kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived = 54,
  
  kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived = 55,
  
  kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame = 56,
  
  kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg = 57,
  
  kCrosHalV3BufferManagerReceivedInvalidShutterTime = 58,
  
  kCrosHalV3BufferManagerFatalDeviceError = 59,
  
  kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder = 60,
  
  kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd = 61,
  
  kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut = 62,
  
  kCrosHalV3BufferManagerInvalidJpegBlob = 63,
  
  kAndroidFailedToAllocate = 64,
  
  kAndroidFailedToStartCapture = 65,
  
  kAndroidFailedToStopCapture = 66,
  
  kAndroidApi1CameraErrorCallbackReceived = 67,
  
  kAndroidApi2CameraDeviceErrorReceived = 68,
  
  kAndroidApi2CaptureSessionConfigureFailed = 69,
  
  kAndroidApi2ImageReaderUnexpectedImageFormat = 70,
  
  kAndroidApi2ImageReaderSizeDidNotMatchImageSize = 71,
  
  kAndroidApi2ErrorRestartingPreview = 72,
  
  kAndroidScreenCaptureUnsupportedFormat = 73,
  
  kAndroidScreenCaptureFailedToStartCaptureMachine = 74,
  
  kAndroidScreenCaptureTheUserDeniedScreenCapture = 75,
  
  kAndroidScreenCaptureFailedToStartScreenCapture = 76,
  
  kWinDirectShowCantGetCaptureFormatSettings = 77,
  
  kWinDirectShowFailedToGetNumberOfCapabilities = 78,
  
  kWinDirectShowFailedToGetCaptureDeviceCapabilities = 79,
  
  kWinDirectShowFailedToSetCaptureDeviceOutputFormat = 80,
  
  kWinDirectShowFailedToConnectTheCaptureGraph = 81,
  
  kWinDirectShowFailedToPauseTheCaptureDevice = 82,
  
  kWinDirectShowFailedToStartTheCaptureDevice = 83,
  
  kWinDirectShowFailedToStopTheCaptureGraph = 84,
  
  kWinMediaFoundationEngineIsNull = 85,
  
  kWinMediaFoundationEngineGetSourceFailed = 86,
  
  kWinMediaFoundationFillPhotoCapabilitiesFailed = 87,
  
  kWinMediaFoundationFillVideoCapabilitiesFailed = 88,
  
  kWinMediaFoundationNoVideoCapabilityFound = 89,
  
  kWinMediaFoundationGetAvailableDeviceMediaTypeFailed = 90,
  
  kWinMediaFoundationSetCurrentDeviceMediaTypeFailed = 91,
  
  kWinMediaFoundationEngineGetSinkFailed = 92,
  
  kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed = 93,
  
  kWinMediaFoundationSinkRemoveAllStreamsFailed = 94,
  
  kWinMediaFoundationCreateSinkVideoMediaTypeFailed = 95,
  
  kWinMediaFoundationConvertToVideoSinkMediaTypeFailed = 96,
  
  kWinMediaFoundationSinkAddStreamFailed = 97,
  
  kWinMediaFoundationSinkSetSampleCallbackFailed = 98,
  
  kWinMediaFoundationEngineStartPreviewFailed = 99,
  
  kWinMediaFoundationGetMediaEventStatusFailed = 100,
  
  kMacSetCaptureDeviceFailed = 101,
  
  kMacCouldNotStartCaptureDevice = 102,
  
  kMacReceivedFrameWithUnexpectedResolution = 103,
  
  kMacUpdateCaptureResolutionFailed = 104,
  
  kMacDeckLinkDeviceIdNotFoundInTheSystem = 105,
  
  kMacDeckLinkErrorQueryingInputInterface = 106,
  
  kMacDeckLinkErrorCreatingDisplayModeIterator = 107,
  
  kMacDeckLinkCouldNotFindADisplayMode = 108,
  
  kMacDeckLinkCouldNotSelectTheVideoFormatWeLike = 109,
  
  kMacDeckLinkCouldNotStartCapturing = 110,
  
  kMacDeckLinkUnsupportedPixelFormat = 111,
  
  kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification = 112,
  
  kAndroidApi2ErrorConfiguringCamera = 113,
  
  kCrosHalV3DeviceDelegateFailedToFlush = 114,
  
  kFuchsiaCameraDeviceDisconnected = 115,
  
  kFuchsiaCameraStreamDisconnected = 116,
  
  kFuchsiaSysmemDidNotSetImageFormat = 117,
  
  kFuchsiaSysmemInvalidBufferIndex = 118,
  
  kFuchsiaSysmemInvalidBufferSize = 119,
  
  kFuchsiaUnsupportedPixelFormat = 120,
  
  kFuchsiaFailedToMapSysmemBuffer = 121,
  
  kCrosHalV3DeviceContextDuplicatedClient = 122,
  
  kDesktopCaptureDeviceMacFailedStreamCreate = 123,
  
  kDesktopCaptureDeviceMacFailedStreamStart = 124,
  
  kCrosHalV3BufferManagerFailedToReserveBuffers = 125,
  
  kWinMediaFoundationSystemPermissionDenied = 126,
  
  kVideoCaptureImplTimedOutOnStart = 127,
  
  kLacrosVideoCaptureDeviceProxyAlreadyEndedOnFatalError = 128,
  
  kLacrosVideoCaptureDeviceProxyEncounteredFatalError = 129,
  
  kScreenCaptureKitFailedGetShareableContent = 130,
  
  kScreenCaptureKitFailedAddStreamOutput = 131,
  
  kScreenCaptureKitFailedStartCapture = 132,
  
  kScreenCaptureKitFailedStopCapture = 133,
  
  kScreenCaptureKitStreamError = 134,
  
  kScreenCaptureKitFailedToFindSCDisplay = 135,
  
  kVideoCaptureControllerInvalid = 136,
  
  kVideoCaptureDeviceFactoryChromeOSCreateDeviceFailed = 137,
  
  kVideoCaptureControllerUnsupportedPixelFormat = 138,
  
  kVideoCaptureDeviceAlreadyReleased = 139,
  
  kVideoCaptureSystemDeviceIdNotFound = 140,
  
  kVideoCaptureDeviceFactoryWinUnknownError = 141,
  
  kWinMediaFoundationDeviceInitializationFailed = 142,
  
  kWinMediaFoundationSourceCreationFailed = 143,
  
  kWinDirectShowDeviceFilterCreationFailed = 144,
  
  kWinDirectShowDeviceInitializationFailed = 145,
  
  kVideoCaptureDeviceFactorySecondCreateDenied = 146,
  
  kScreenCaptureKitResetStreamError = 147,
  
  kWinMediaFoundationCameraBusy = 148,
  
  kWebRtcStartCaptureFailed = 149,
  kMinValue = 0,
  kMaxValue = 149,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureError value);
inline bool IsKnownEnumValue(VideoCaptureError value) {
  return internal::VideoCaptureError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCaptureFrameDropReason : int32_t {
  
  kNone = 0,
  
  kDeviceClientFrameHasInvalidFormat = 1,
  
  kDeviceClientLibyuvConvertToI420Failed = 2,
  
  kV4L2BufferErrorFlagWasSet = 3,
  
  kV4L2InvalidNumberOfBytesInBuffer = 4,
  
  kAndroidThrottling = 5,
  
  kAndroidGetByteArrayElementsFailed = 6,
  
  kAndroidApi1UnexpectedDataLength = 7,
  
  kAndroidApi2AcquiredImageIsNull = 8,
  
  kWinDirectShowUnexpectedSampleLength = 9,
  
  kWinDirectShowFailedToGetMemoryPointerFromMediaSample = 10,
  
  kWinMediaFoundationReceivedSampleIsNull = 11,
  
  kWinMediaFoundationLockingBufferDelieveredNullptr = 12,
  
  kWinMediaFoundationGetBufferByIndexReturnedNull = 13,
  
  kBufferPoolMaxBufferCountExceeded = 14,
  
  kBufferPoolBufferAllocationFailed = 15,
  
  kVideoCaptureImplNotInStartedState = 16,
  
  kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame = 17,
  
  kVideoTrackAdapterHasNoResolutionAdapters = 18,
  
  kResolutionAdapterFrameIsNotValid = 19,
  
  kResolutionAdapterWrappingFrameForCroppingFailed = 20,
  
  kResolutionAdapterTimestampTooCloseToPrevious_DEPRECATED = 21,
  
  kResolutionAdapterFrameRateIsHigherThanRequested = 22,
  
  kResolutionAdapterHasNoCallbacks = 23,
  
  kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame = 24,
  
  kRendererSinkFrameDelivererIsNotStarted = 25,
  
  kCropVersionNotCurrent_DEPRECATED = 26,
  
  kGpuMemoryBufferMapFailed = 27,
  
  kSubCaptureTargetVersionNotCurrent_DEPRECATED = 28,
  
  kPostProcessingFailed = 29,
  
  kResolutionAdapterFrameIsNotMappable = 30,
  
  kResolutionAdapterCannotCreateConvertFrame = 31,
  
  kResolutionAdapterConvertAndScaleFailed = 32,
  
  kOldCaptureVersion = 33,
  kMinValue = 0,
  kMaxValue = 33,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureFrameDropReason value);
inline bool IsKnownEnumValue(VideoCaptureFrameDropReason value) {
  return internal::VideoCaptureFrameDropReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubCaptureTargetType : int32_t {
  
  kCropTarget = 0,
  
  kRestrictionTarget = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SubCaptureTargetType value);
inline bool IsKnownEnumValue(SubCaptureTargetType value) {
  return internal::SubCaptureTargetType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ApplySubCaptureTargetResult : int32_t {
  
  kSuccess = 0,
  
  kErrorGeneric = 1,
  
  kUnsupportedCaptureDevice = 2,
  
  kNotImplemented = 3,
  
  kNonIncreasingVersion = 4,
  
  kInvalidTarget = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, ApplySubCaptureTargetResult value);
inline bool IsKnownEnumValue(ApplySubCaptureTargetResult value) {
  return internal::ApplySubCaptureTargetResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeviceEnumerationResult : int32_t {
  
  kSuccess = 0,
  
  kUnknownError = 1,
  
  kErrorCaptureServiceCrash = 2,
  
  kErrorCaptureServiceDroppedRequest = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DeviceEnumerationResult value);
inline bool IsKnownEnumValue(DeviceEnumerationResult value) {
  return internal::DeviceEnumerationResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class VideoCaptureControlSupportDataView {
 public:
  VideoCaptureControlSupportDataView() = default;

  VideoCaptureControlSupportDataView(
      internal::VideoCaptureControlSupport_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool pan() const {
    return data_->pan;
  }
  bool tilt() const {
    return data_->tilt;
  }
  bool zoom() const {
    return data_->zoom;
  }
 private:
  internal::VideoCaptureControlSupport_Data* data_ = nullptr;
};


class VideoCaptureFormatDataView {
 public:
  VideoCaptureFormatDataView() = default;

  VideoCaptureFormatDataView(
      internal::VideoCaptureFormat_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSize(UserType* output) {
    
    auto* pointer = data_->frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float frame_rate() const {
    return data_->frame_rate;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPixelFormat(UserType* output) const {
    auto data_value = data_->pixel_format;
    return mojo::internal::Deserialize<::media::mojom::VideoCapturePixelFormat>(
        data_value, output);
  }
  VideoCapturePixelFormat pixel_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCapturePixelFormat>(data_->pixel_format));
  }
 private:
  internal::VideoCaptureFormat_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureParamsDataView {
 public:
  VideoCaptureParamsDataView() = default;

  VideoCaptureParamsDataView(
      internal::VideoCaptureParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestedFormatDataView(
      VideoCaptureFormatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedFormat(UserType* output) {
    
    auto* pointer = data_->requested_format.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureFormatDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBufferType(UserType* output) const {
    auto data_value = data_->buffer_type;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureBufferType>(
        data_value, output);
  }
  VideoCaptureBufferType buffer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCaptureBufferType>(data_->buffer_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResolutionChangePolicy(UserType* output) const {
    auto data_value = data_->resolution_change_policy;
    return mojo::internal::Deserialize<::media::mojom::ResolutionChangePolicy>(
        data_value, output);
  }
  ResolutionChangePolicy resolution_change_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::ResolutionChangePolicy>(data_->resolution_change_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPowerLineFrequency(UserType* output) const {
    auto data_value = data_->power_line_frequency;
    return mojo::internal::Deserialize<::media::mojom::PowerLineFrequency>(
        data_value, output);
  }
  PowerLineFrequency power_line_frequency() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::PowerLineFrequency>(data_->power_line_frequency));
  }
  bool enable_face_detection() const {
    return data_->enable_face_detection;
  }
  bool is_high_dpi_enabled() const {
    return data_->is_high_dpi_enabled;
  }
  uint32_t capture_version_source() const {
    return data_->capture_version_source;
  }
 private:
  internal::VideoCaptureParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureFeedbackDataView {
 public:
  VideoCaptureFeedbackDataView() = default;

  VideoCaptureFeedbackDataView(
      internal::VideoCaptureFeedback_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double resource_utilization() const {
    return data_->resource_utilization;
  }
  float max_framerate_fps() const {
    return data_->max_framerate_fps;
  }
  int32_t max_pixels() const {
    return data_->max_pixels;
  }
  bool require_mapped_frame() const {
    return data_->require_mapped_frame;
  }
  inline void GetDeprecatedMappedSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedMappedSizes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::gfx::mojom::SizeDataView>, UserType>(),
    "Attempting to read the optional `DEPRECATED_mapped_sizes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeprecatedMappedSizes` instead "
    "of `ReadDeprecatedMappedSizes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->DEPRECATED_mapped_sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  int32_t frame_id() const {
    return data_->frame_id;
  }
  bool has_frame_id() const {
    return data_->has_frame_id;
  }
 private:
  internal::VideoCaptureFeedback_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PlaneStridesDataView {
 public:
  PlaneStridesDataView() = default;

  PlaneStridesDataView(
      internal::PlaneStrides_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStrideByPlaneDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrideByPlane(UserType* output) {
    
    auto* pointer = data_->stride_by_plane.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
 private:
  internal::PlaneStrides_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureDeviceDescriptorDataView {
 public:
  VideoCaptureDeviceDescriptorDataView() = default;

  VideoCaptureDeviceDescriptorDataView(
      internal::VideoCaptureDeviceDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetModelIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelId(UserType* output) {
    
    auto* pointer = data_->model_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFacingMode(UserType* output) const {
    auto data_value = data_->facing_mode;
    return mojo::internal::Deserialize<::media::mojom::VideoFacingMode>(
        data_value, output);
  }
  VideoFacingMode facing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoFacingMode>(data_->facing_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCaptureApi(UserType* output) const {
    auto data_value = data_->capture_api;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureApi>(
        data_value, output);
  }
  VideoCaptureApi capture_api() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCaptureApi>(data_->capture_api));
  }
  inline void GetControlSupportDataView(
      VideoCaptureControlSupportDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadControlSupport(UserType* output) {
    
    auto* pointer = data_->control_support.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureControlSupportDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTransportType(UserType* output) const {
    auto data_value = data_->transport_type;
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureTransportType>(
        data_value, output);
  }
  VideoCaptureTransportType transport_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCaptureTransportType>(data_->transport_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAvailability(UserType* output) const {
    if (!data_->availability_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CameraAvailability>(
        data_->availability_$value, &output->emplace());
  }
  std::optional<CameraAvailability> availability() const {
    if (!data_->availability_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CameraAvailability>(data_->availability_$value));
  }
 private:
  internal::VideoCaptureDeviceDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureDeviceInfoDataView {
 public:
  VideoCaptureDeviceInfoDataView() = default;

  VideoCaptureDeviceInfoDataView(
      internal::VideoCaptureDeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDescriptorDataView(
      VideoCaptureDeviceDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptor(UserType* output) {
    
    auto* pointer = data_->descriptor.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureDeviceDescriptorDataView>(
        pointer, output, message_);
  }
  inline void GetSupportedFormatsDataView(
      mojo::ArrayDataView<VideoCaptureFormatDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedFormats(UserType* output) {
    
    auto* pointer = data_->supported_formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VideoCaptureDeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_DATA_VIEW_H_