// media/capture/mojom/video_capture_buffer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SEND_VALIDATION_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SEND_VALIDATION_H_

#include "media/capture/mojom/video_capture_buffer.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"

#include "media/capture/mojom/video_capture_buffer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoFrameInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoFrameInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoFrameInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in VideoFrameInfo struct");

      decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metadata)::BaseType> metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoFrameMetadataDataView, send_validation>(
        in_metadata,
        metadata_fragment);

      fragment->metadata.Set(
          metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->metadata.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in VideoFrameInfo struct");

      
      mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
        Traits::pixel_format(input),
        &fragment->pixel_format);

      decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_coded_size,
        coded_size_fragment);

      fragment->coded_size.Set(
          coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->coded_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size in VideoFrameInfo struct");

      decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_visible_rect,
        visible_rect_fragment);

      fragment->visible_rect.Set(
          visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visible_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_rect in VideoFrameInfo struct");

      fragment->is_premapped = Traits::is_premapped(input);

      decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_space)::BaseType> color_space_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView, send_validation>(
        in_color_space,
        color_space_fragment);

      fragment->color_space.Set(
          color_space_fragment.is_null() ? nullptr : color_space_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_space.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space in VideoFrameInfo struct");

      decltype(Traits::strides(input)) in_strides = Traits::strides(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->strides)::BaseType> strides_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::PlaneStridesDataView, send_validation>(
        in_strides,
        strides_fragment);

      fragment->strides.Set(
          strides_fragment.is_null() ? nullptr : strides_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::ReadyBufferDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ReadyBufferDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ReadyBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->buffer_id = Traits::buffer_id(input);

      decltype(Traits::info(input)) in_info = Traits::info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->info)::BaseType> info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView, send_validation>(
        in_info,
        info_fragment);

      fragment->info.Set(
          info_fragment.is_null() ? nullptr : info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null info in ReadyBuffer struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SharedImageBufferHandleSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SharedImageBufferHandleSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SharedImageBufferHandleSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView, send_validation>(
        in_shared_image,
        shared_image_fragment);

      fragment->shared_image.Set(
          shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->shared_image.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_image in SharedImageBufferHandleSet struct");

      decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_sync_token,
        sync_token_fragment);

      fragment->sync_token.Set(
          sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in SharedImageBufferHandleSet struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoBufferHandleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::VideoBufferHandleDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::VideoBufferHandle_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::VideoBufferHandleDataView::Tag::kUnsafeShmemRegion: {
    decltype(Traits::unsafe_shmem_region(input))
    in_unsafe_shmem_region = Traits::unsafe_shmem_region(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_unsafe_shmem_region)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView, send_validation>(
  in_unsafe_shmem_region,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null unsafe_shmem_region in VideoBufferHandle union");
    fragment->data.f_unsafe_shmem_region.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoBufferHandleDataView::Tag::kReadOnlyShmemRegion: {
    decltype(Traits::read_only_shmem_region(input))
    in_read_only_shmem_region = Traits::read_only_shmem_region(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_read_only_shmem_region)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, send_validation>(
  in_read_only_shmem_region,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null read_only_shmem_region in VideoBufferHandle union");
    fragment->data.f_read_only_shmem_region.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoBufferHandleDataView::Tag::kSharedImageHandle: {
    decltype(Traits::shared_image_handle(input))
    in_shared_image_handle = Traits::shared_image_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_image_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::SharedImageBufferHandleSetDataView, send_validation>(
  in_shared_image_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_image_handle in VideoBufferHandle union");
    fragment->data.f_shared_image_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoBufferHandleDataView::Tag::kGpuMemoryBufferHandle: {
    decltype(Traits::gpu_memory_buffer_handle(input))
    in_gpu_memory_buffer_handle = Traits::gpu_memory_buffer_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gpu_memory_buffer_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView, send_validation>(
  in_gpu_memory_buffer_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gpu_memory_buffer_handle in VideoBufferHandle union");
    fragment->data.f_gpu_memory_buffer_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SEND_VALIDATION_H_