// media/capture/mojom/video_capture_buffer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_BLINK_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_capture_buffer.mojom-features.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom-blink-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox_holder.mojom-blink-forward.h"
#include "gpu/ipc/common/exported_shared_image.mojom-blink.h"
#include "gpu/ipc/common/sync_token.mojom-blink.h"
#include "media/capture/mojom/video_capture_types.mojom-blink.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/buffer_types.mojom-blink.h"
#include "ui/gfx/mojom/color_space.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {








class BLINK_PLATFORM_EXPORT VideoBufferHandle {
 public:
  using DataView = VideoBufferHandleDataView;
  using Data_ = internal::VideoBufferHandle_Data;
  using Tag = Data_::VideoBufferHandle_Tag;

  template <typename... Args>
  static VideoBufferHandlePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |unsafe_shmem_region|.
  static VideoBufferHandlePtr NewUnsafeShmemRegion(
      ::base::UnsafeSharedMemoryRegion value);
  // Construct an instance holding |read_only_shmem_region|.
  static VideoBufferHandlePtr NewReadOnlyShmemRegion(
      ::base::ReadOnlySharedMemoryRegion value);
  // Construct an instance holding |shared_image_handle|.
  static VideoBufferHandlePtr NewSharedImageHandle(
      SharedImageBufferHandleSetPtr value);
  // Construct an instance holding |gpu_memory_buffer_handle|.
  static VideoBufferHandlePtr NewGpuMemoryBufferHandle(
      ::gfx::GpuMemoryBufferHandle value);

  template <typename U>
  static VideoBufferHandlePtr From(const U& u) {
    return mojo::TypeConverter<VideoBufferHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoBufferHandle>::Convert(*this);
  }
  ~VideoBufferHandle();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  VideoBufferHandle(const VideoBufferHandle& other) = delete;
  VideoBufferHandle& operator=(const VideoBufferHandle& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VideoBufferHandlePtr>
  VideoBufferHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoBufferHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoBufferHandle>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_unsafe_shmem_region() const { return tag_ == Tag::kUnsafeShmemRegion; }
  const ::base::UnsafeSharedMemoryRegion& get_unsafe_shmem_region() const {
    CHECK(tag_ == Tag::kUnsafeShmemRegion);
    return data_.unsafe_shmem_region;
  }
  ::base::UnsafeSharedMemoryRegion& get_unsafe_shmem_region() {
    CHECK(tag_ == Tag::kUnsafeShmemRegion);
    return data_.unsafe_shmem_region;
  }
  void set_unsafe_shmem_region(::base::UnsafeSharedMemoryRegion unsafe_shmem_region);

  bool is_read_only_shmem_region() const { return tag_ == Tag::kReadOnlyShmemRegion; }
  const ::base::ReadOnlySharedMemoryRegion& get_read_only_shmem_region() const {
    CHECK(tag_ == Tag::kReadOnlyShmemRegion);
    return data_.read_only_shmem_region;
  }
  ::base::ReadOnlySharedMemoryRegion& get_read_only_shmem_region() {
    CHECK(tag_ == Tag::kReadOnlyShmemRegion);
    return data_.read_only_shmem_region;
  }
  void set_read_only_shmem_region(::base::ReadOnlySharedMemoryRegion read_only_shmem_region);

  bool is_shared_image_handle() const { return tag_ == Tag::kSharedImageHandle; }
  const SharedImageBufferHandleSetPtr& get_shared_image_handle() const {
    CHECK(tag_ == Tag::kSharedImageHandle);
    return data_.shared_image_handle;
  }
  SharedImageBufferHandleSetPtr& get_shared_image_handle() {
    CHECK(tag_ == Tag::kSharedImageHandle);
    return data_.shared_image_handle;
  }
  void set_shared_image_handle(SharedImageBufferHandleSetPtr shared_image_handle);

  bool is_gpu_memory_buffer_handle() const { return tag_ == Tag::kGpuMemoryBufferHandle; }
  const ::gfx::GpuMemoryBufferHandle& get_gpu_memory_buffer_handle() const {
    CHECK(tag_ == Tag::kGpuMemoryBufferHandle);
    return data_.gpu_memory_buffer_handle;
  }
  ::gfx::GpuMemoryBufferHandle& get_gpu_memory_buffer_handle() {
    CHECK(tag_ == Tag::kGpuMemoryBufferHandle);
    return data_.gpu_memory_buffer_handle;
  }
  void set_gpu_memory_buffer_handle(::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoBufferHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VideoBufferHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnsafeShmemRegion)>,
        ::base::UnsafeSharedMemoryRegion value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReadOnlyShmemRegion)>,
        ::base::ReadOnlySharedMemoryRegion value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageHandle)>,
        SharedImageBufferHandleSetPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferHandle)>,
        ::gfx::GpuMemoryBufferHandle value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::UnsafeSharedMemoryRegion unsafe_shmem_region;
    ::base::ReadOnlySharedMemoryRegion read_only_shmem_region;
    SharedImageBufferHandleSetPtr shared_image_handle;
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle;
  };

  VideoBufferHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnsafeShmemRegion)>,
      ::base::UnsafeSharedMemoryRegion value);
  VideoBufferHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kReadOnlyShmemRegion)>,
      ::base::ReadOnlySharedMemoryRegion value);
  VideoBufferHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageHandle)>,
      SharedImageBufferHandleSetPtr value);
  VideoBufferHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferHandle)>,
      ::gfx::GpuMemoryBufferHandle value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT VideoFrameInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrameInfo, T>::value>;
  using DataView = VideoFrameInfoDataView;
  using Data_ = internal::VideoFrameInfo_Data;

  template <typename... Args>
  static VideoFrameInfoPtr New(Args&&... args) {
    return VideoFrameInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFrameInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameInfo>::Convert(*this);
  }


  VideoFrameInfo();

  VideoFrameInfo(
      ::base::TimeDelta timestamp,
      const ::media::VideoFrameMetadata& metadata,
      ::media::VideoPixelFormat pixel_format,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      bool is_premapped,
      const ::gfx::ColorSpace& color_space,
      ::media::mojom::blink::PlaneStridesPtr strides);

VideoFrameInfo(const VideoFrameInfo&) = delete;
VideoFrameInfo& operator=(const VideoFrameInfo&) = delete;

  ~VideoFrameInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFrameInfoPtr>
  VideoFrameInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrameInfo_UnserializedMessageContext<
            UserType, VideoFrameInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoFrameInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoFrameInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrameInfo_UnserializedMessageContext<
            UserType, VideoFrameInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrameInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta timestamp;
  
  ::media::VideoFrameMetadata metadata;
  
  ::media::VideoPixelFormat pixel_format;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  bool is_premapped;
  
  ::gfx::ColorSpace color_space;
  
  ::media::mojom::blink::PlaneStridesPtr strides;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrameInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ReadyBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadyBuffer, T>::value>;
  using DataView = ReadyBufferDataView;
  using Data_ = internal::ReadyBuffer_Data;

  template <typename... Args>
  static ReadyBufferPtr New(Args&&... args) {
    return ReadyBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadyBufferPtr From(const U& u) {
    return mojo::TypeConverter<ReadyBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadyBuffer>::Convert(*this);
  }


  ReadyBuffer();

  ReadyBuffer(
      int32_t buffer_id,
      VideoFrameInfoPtr info);

ReadyBuffer(const ReadyBuffer&) = delete;
ReadyBuffer& operator=(const ReadyBuffer&) = delete;

  ~ReadyBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadyBufferPtr>
  ReadyBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadyBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadyBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadyBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadyBuffer::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadyBuffer::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadyBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadyBuffer_UnserializedMessageContext<
            UserType, ReadyBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadyBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadyBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadyBuffer_UnserializedMessageContext<
            UserType, ReadyBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadyBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t buffer_id;
  
  VideoFrameInfoPtr info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadyBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadyBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadyBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadyBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SharedImageBufferHandleSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedImageBufferHandleSet, T>::value>;
  using DataView = SharedImageBufferHandleSetDataView;
  using Data_ = internal::SharedImageBufferHandleSet_Data;

  template <typename... Args>
  static SharedImageBufferHandleSetPtr New(Args&&... args) {
    return SharedImageBufferHandleSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedImageBufferHandleSetPtr From(const U& u) {
    return mojo::TypeConverter<SharedImageBufferHandleSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedImageBufferHandleSet>::Convert(*this);
  }


  SharedImageBufferHandleSet();

  SharedImageBufferHandleSet(
      ::gpu::ExportedSharedImage shared_image,
      const ::gpu::SyncToken& sync_token);

SharedImageBufferHandleSet(const SharedImageBufferHandleSet&) = delete;
SharedImageBufferHandleSet& operator=(const SharedImageBufferHandleSet&) = delete;

  ~SharedImageBufferHandleSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedImageBufferHandleSetPtr>
  SharedImageBufferHandleSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedImageBufferHandleSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedImageBufferHandleSet_UnserializedMessageContext<
            UserType, SharedImageBufferHandleSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedImageBufferHandleSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedImageBufferHandleSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedImageBufferHandleSet_UnserializedMessageContext<
            UserType, SharedImageBufferHandleSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedImageBufferHandleSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::ExportedSharedImage shared_image;
  
  ::gpu::SyncToken sync_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
VideoBufferHandlePtr VideoBufferHandle::Clone() const {
  switch (tag_) {
    case Tag::kUnsafeShmemRegion:
      return NewUnsafeShmemRegion(
          mojo::Clone(data_.unsafe_shmem_region));
    case Tag::kReadOnlyShmemRegion:
      return NewReadOnlyShmemRegion(
          mojo::Clone(data_.read_only_shmem_region));
    case Tag::kSharedImageHandle:
      return NewSharedImageHandle(
          mojo::Clone(data_.shared_image_handle));
    case Tag::kGpuMemoryBufferHandle:
      return NewGpuMemoryBufferHandle(
          mojo::Clone(data_.gpu_memory_buffer_handle));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VideoBufferHandle>::value>::type*>
bool VideoBufferHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kUnsafeShmemRegion:
      return mojo::Equals(data_.unsafe_shmem_region, other.data_.unsafe_shmem_region);
    case Tag::kReadOnlyShmemRegion:
      return mojo::Equals(data_.read_only_shmem_region, other.data_.read_only_shmem_region);
    case Tag::kSharedImageHandle:
      return mojo::Equals(data_.shared_image_handle, other.data_.shared_image_handle);
    case Tag::kGpuMemoryBufferHandle:
      return mojo::Equals(data_.gpu_memory_buffer_handle, other.data_.gpu_memory_buffer_handle);
  }

  return false;
}
template <typename StructPtrType>
VideoFrameInfoPtr VideoFrameInfo::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(metadata),
      mojo::Clone(pixel_format),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(is_premapped),
      mojo::Clone(color_space),
      mojo::Clone(strides)
  );
}

template <typename T, VideoFrameInfo::EnableIfSame<T>*>
bool VideoFrameInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->pixel_format, other_struct.pixel_format))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->is_premapped, other_struct.is_premapped))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->strides, other_struct.strides))
    return false;
  return true;
}

template <typename T, VideoFrameInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.pixel_format < rhs.pixel_format)
    return true;
  if (rhs.pixel_format < lhs.pixel_format)
    return false;
  if (lhs.coded_size < rhs.coded_size)
    return true;
  if (rhs.coded_size < lhs.coded_size)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.is_premapped < rhs.is_premapped)
    return true;
  if (rhs.is_premapped < lhs.is_premapped)
    return false;
  if (lhs.color_space < rhs.color_space)
    return true;
  if (rhs.color_space < lhs.color_space)
    return false;
  if (lhs.strides < rhs.strides)
    return true;
  if (rhs.strides < lhs.strides)
    return false;
  return false;
}
template <typename StructPtrType>
ReadyBufferPtr ReadyBuffer::Clone() const {
  return New(
      mojo::Clone(buffer_id),
      mojo::Clone(info)
  );
}

template <typename T, ReadyBuffer::EnableIfSame<T>*>
bool ReadyBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->buffer_id, other_struct.buffer_id))
    return false;
  if (!mojo::Equals(this->info, other_struct.info))
    return false;
  return true;
}

template <typename T, ReadyBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.buffer_id < rhs.buffer_id)
    return true;
  if (rhs.buffer_id < lhs.buffer_id)
    return false;
  if (lhs.info < rhs.info)
    return true;
  if (rhs.info < lhs.info)
    return false;
  return false;
}
template <typename StructPtrType>
SharedImageBufferHandleSetPtr SharedImageBufferHandleSet::Clone() const {
  return New(
      mojo::Clone(shared_image),
      mojo::Clone(sync_token)
  );
}

template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>*>
bool SharedImageBufferHandleSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_image, other_struct.shared_image))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  return true;
}

template <typename T, SharedImageBufferHandleSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.shared_image < rhs.shared_image)
    return true;
  if (rhs.shared_image < lhs.shared_image)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoFrameInfo::DataView,
                                         ::media::mojom::blink::VideoFrameInfoPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoFrameInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoFrameInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::VideoFrameInfo::timestamp)& timestamp(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::mojom::blink::VideoFrameInfo::metadata)& metadata(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->metadata;
  }

  static decltype(::media::mojom::blink::VideoFrameInfo::pixel_format) pixel_format(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->pixel_format;
  }

  static const decltype(::media::mojom::blink::VideoFrameInfo::coded_size)& coded_size(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::mojom::blink::VideoFrameInfo::visible_rect)& visible_rect(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->visible_rect;
  }

  static decltype(::media::mojom::blink::VideoFrameInfo::is_premapped) is_premapped(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->is_premapped;
  }

  static const decltype(::media::mojom::blink::VideoFrameInfo::color_space)& color_space(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->color_space;
  }

  static const decltype(::media::mojom::blink::VideoFrameInfo::strides)& strides(
      const ::media::mojom::blink::VideoFrameInfoPtr& input) {
    return input->strides;
  }

  static bool Read(::media::mojom::blink::VideoFrameInfo::DataView input, ::media::mojom::blink::VideoFrameInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::ReadyBuffer::DataView,
                                         ::media::mojom::blink::ReadyBufferPtr> {
  static bool IsNull(const ::media::mojom::blink::ReadyBufferPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::ReadyBufferPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::ReadyBuffer::buffer_id) buffer_id(
      const ::media::mojom::blink::ReadyBufferPtr& input) {
    return input->buffer_id;
  }

  static const decltype(::media::mojom::blink::ReadyBuffer::info)& info(
      const ::media::mojom::blink::ReadyBufferPtr& input) {
    return input->info;
  }

  static bool Read(::media::mojom::blink::ReadyBuffer::DataView input, ::media::mojom::blink::ReadyBufferPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SharedImageBufferHandleSet::DataView,
                                         ::media::mojom::blink::SharedImageBufferHandleSetPtr> {
  static bool IsNull(const ::media::mojom::blink::SharedImageBufferHandleSetPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SharedImageBufferHandleSetPtr* output) { output->reset(); }

  static  decltype(::media::mojom::blink::SharedImageBufferHandleSet::shared_image)& shared_image(
       ::media::mojom::blink::SharedImageBufferHandleSetPtr& input) {
    return input->shared_image;
  }

  static const decltype(::media::mojom::blink::SharedImageBufferHandleSet::sync_token)& sync_token(
      const ::media::mojom::blink::SharedImageBufferHandleSetPtr& input) {
    return input->sync_token;
  }

  static bool Read(::media::mojom::blink::SharedImageBufferHandleSet::DataView input, ::media::mojom::blink::SharedImageBufferHandleSetPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::VideoBufferHandle::DataView,
                                        ::media::mojom::blink::VideoBufferHandlePtr> {
  static bool IsNull(const ::media::mojom::blink::VideoBufferHandlePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoBufferHandlePtr* output) { output->reset(); }

  static ::media::mojom::blink::VideoBufferHandle::Tag GetTag(const ::media::mojom::blink::VideoBufferHandlePtr& input) {
    return input->which();
  }

  static  ::base::UnsafeSharedMemoryRegion& unsafe_shmem_region( ::media::mojom::blink::VideoBufferHandlePtr& input) {
    return input->get_unsafe_shmem_region();
  }

  static  ::base::ReadOnlySharedMemoryRegion& read_only_shmem_region( ::media::mojom::blink::VideoBufferHandlePtr& input) {
    return input->get_read_only_shmem_region();
  }

  static  ::media::mojom::blink::SharedImageBufferHandleSetPtr& shared_image_handle( ::media::mojom::blink::VideoBufferHandlePtr& input) {
    return input->get_shared_image_handle();
  }

  static  ::gfx::GpuMemoryBufferHandle& gpu_memory_buffer_handle( ::media::mojom::blink::VideoBufferHandlePtr& input) {
    return input->get_gpu_memory_buffer_handle();
  }

  static bool Read(::media::mojom::blink::VideoBufferHandle::DataView input, ::media::mojom::blink::VideoBufferHandlePtr* output);
};

}  // namespace mojo

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_BLINK_H_