// media/capture/mojom/video_capture.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.VideoCaptureError');
goog.require('media.mojom.VideoCaptureFrameDropReason');
goog.require('media.mojom.CaptureVersion');
goog.require('media.mojom.ReadyBuffer');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('media.mojom.VideoCaptureFeedback');
goog.require('media.mojom.VideoCaptureFormat');
goog.require('media.mojom.VideoCaptureParams');
goog.require('media.mojom.VideoBufferHandle');




goog.provide('media.mojom.VideoCaptureState');
goog.provide('media.mojom.VideoCaptureStateSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCaptureStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoCaptureState = {
  
  STARTED: 0,
  PAUSED: 1,
  RESUMED: 2,
  STOPPED: 3,
  ENDED: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('media.mojom.VideoCaptureObserver');
goog.provide('media.mojom.VideoCaptureObserverReceiver');
goog.provide('media.mojom.VideoCaptureObserverCallbackRouter');
goog.provide('media.mojom.VideoCaptureObserverInterface');
goog.provide('media.mojom.VideoCaptureObserverRemote');
goog.provide('media.mojom.VideoCaptureObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoCaptureObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoCaptureObserver.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoCaptureObserverInterface = class {
  
  /**
   * @param { !media.mojom.VideoCaptureResult } result
   */

  onStateChanged(result) {}
  
  /**
   * @param { !number } bufferId
   * @param { !media.mojom.VideoBufferHandle } bufferHandle
   */

  onNewBuffer(bufferId, bufferHandle) {}
  
  /**
   * @param { !media.mojom.ReadyBuffer } buffer
   */

  onBufferReady(buffer) {}
  
  /**
   * @param { !number } bufferId
   */

  onBufferDestroyed(bufferId) {}
  
  /**
   * @param { !media.mojom.VideoCaptureFrameDropReason } reason
   */

  onFrameDropped(reason) {}
  
  /**
   * @param { !media.mojom.CaptureVersion } captureVersion
   */

  onNewCaptureVersion(captureVersion) {}
};

/**
 * @export
 * @implements { media.mojom.VideoCaptureObserverInterface }
 */
media.mojom.VideoCaptureObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoCaptureObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoCaptureObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoCaptureObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.VideoCaptureResult } result
   */

  onStateChanged(
      result) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !number } bufferId
   * @param { !media.mojom.VideoBufferHandle } bufferHandle
   */

  onNewBuffer(
      bufferId,
      bufferHandle) {
    this.proxy.sendMessage(
        1,
        media.mojom.VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
        null,
        [
          bufferId,
          bufferHandle
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.ReadyBuffer } buffer
   */

  onBufferReady(
      buffer) {
    this.proxy.sendMessage(
        2,
        media.mojom.VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
        null,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !number } bufferId
   */

  onBufferDestroyed(
      bufferId) {
    this.proxy.sendMessage(
        3,
        media.mojom.VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
        null,
        [
          bufferId
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoCaptureFrameDropReason } reason
   */

  onFrameDropped(
      reason) {
    this.proxy.sendMessage(
        4,
        media.mojom.VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.CaptureVersion } captureVersion
   */

  onNewCaptureVersion(
      captureVersion) {
    this.proxy.sendMessage(
        5,
        media.mojom.VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
        null,
        [
          captureVersion
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoCaptureObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoCaptureObserverReceiver = class {
  /**
   * @param {!media.mojom.VideoCaptureObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoCaptureObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoCaptureObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoCaptureObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
        null,
        impl.onStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
        null,
        impl.onNewBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
        null,
        impl.onBufferReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
        null,
        impl.onBufferDestroyed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
        null,
        impl.onFrameDropped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
        null,
        impl.onNewCaptureVersion.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoCaptureObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoCaptureObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoCaptureObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoCaptureObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoCaptureObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoCaptureObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoCaptureObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoCaptureObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
        null,
        this.onStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
        null,
        this.onNewBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
        null,
        this.onBufferReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferDestroyed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
        null,
        this.onBufferDestroyed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFrameDropped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
        null,
        this.onFrameDropped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewCaptureVersion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
        null,
        this.onNewCaptureVersion.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoCaptureHost');
goog.provide('media.mojom.VideoCaptureHostReceiver');
goog.provide('media.mojom.VideoCaptureHostCallbackRouter');
goog.provide('media.mojom.VideoCaptureHostInterface');
goog.provide('media.mojom.VideoCaptureHostRemote');
goog.provide('media.mojom.VideoCaptureHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoCaptureHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoCaptureHost.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoCaptureHostInterface = class {
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !media.mojom.VideoCaptureParams } params
   * @param { !media.mojom.VideoCaptureObserverRemote } observer
   */

  start(deviceId, sessionId, params, observer) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   */

  stop(deviceId) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   */

  pause(deviceId) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !media.mojom.VideoCaptureParams } params
   */

  resume(deviceId, sessionId, params) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   */

  requestRefreshFrame(deviceId) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !number } bufferId
   * @param { !media.mojom.VideoCaptureFeedback } feedback
   */

  releaseBuffer(deviceId, bufferId, feedback) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @return {!Promise<{
        formatsSupported: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getDeviceSupportedFormats(deviceId, sessionId) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @return {!Promise<{
        formatsInUse: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getDeviceFormatsInUse(deviceId, sessionId) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !string } message
   */

  onLog(deviceId, message) {}
};

/**
 * @export
 * @implements { media.mojom.VideoCaptureHostInterface }
 */
media.mojom.VideoCaptureHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoCaptureHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoCaptureHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoCaptureHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !media.mojom.VideoCaptureParams } params
   * @param { !media.mojom.VideoCaptureObserverRemote } observer
   */

  start(
      deviceId,
      sessionId,
      params,
      observer) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoCaptureHost_Start_ParamsSpec.$,
        null,
        [
          deviceId,
          sessionId,
          params,
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   */

  stop(
      deviceId) {
    this.proxy.sendMessage(
        1,
        media.mojom.VideoCaptureHost_Stop_ParamsSpec.$,
        null,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   */

  pause(
      deviceId) {
    this.proxy.sendMessage(
        2,
        media.mojom.VideoCaptureHost_Pause_ParamsSpec.$,
        null,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @param { !media.mojom.VideoCaptureParams } params
   */

  resume(
      deviceId,
      sessionId,
      params) {
    this.proxy.sendMessage(
        3,
        media.mojom.VideoCaptureHost_Resume_ParamsSpec.$,
        null,
        [
          deviceId,
          sessionId,
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   */

  requestRefreshFrame(
      deviceId) {
    this.proxy.sendMessage(
        4,
        media.mojom.VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
        null,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !number } bufferId
   * @param { !media.mojom.VideoCaptureFeedback } feedback
   */

  releaseBuffer(
      deviceId,
      bufferId,
      feedback) {
    this.proxy.sendMessage(
        5,
        media.mojom.VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
        null,
        [
          deviceId,
          bufferId,
          feedback
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @return {!Promise<{
        formatsSupported: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getDeviceSupportedFormats(
      deviceId,
      sessionId) {
    return this.proxy.sendMessage(
        6,
        media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
        media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
        [
          deviceId,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !mojoBase.mojom.UnguessableToken } sessionId
   * @return {!Promise<{
        formatsInUse: !Array<!media.mojom.VideoCaptureFormat>,
   *  }>}
   */

  getDeviceFormatsInUse(
      deviceId,
      sessionId) {
    return this.proxy.sendMessage(
        7,
        media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
        media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
        [
          deviceId,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } deviceId
   * @param { !string } message
   */

  onLog(
      deviceId,
      message) {
    this.proxy.sendMessage(
        8,
        media.mojom.VideoCaptureHost_OnLog_ParamsSpec.$,
        null,
        [
          deviceId,
          message
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoCaptureHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoCaptureHostReceiver = class {
  /**
   * @param {!media.mojom.VideoCaptureHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoCaptureHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoCaptureHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoCaptureHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoCaptureHost_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoCaptureHost_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoCaptureHost_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoCaptureHost_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
        null,
        impl.requestRefreshFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
        null,
        impl.releaseBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
        media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
        impl.getDeviceSupportedFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
        media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
        impl.getDeviceFormatsInUse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        media.mojom.VideoCaptureHost_OnLog_ParamsSpec.$,
        null,
        impl.onLog.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoCaptureHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoCaptureHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoCaptureHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoCaptureHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoCaptureHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoCaptureHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoCaptureHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoCaptureHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoCaptureHost_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoCaptureHost_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoCaptureHost_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoCaptureHost_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestRefreshFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
        null,
        this.requestRefreshFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.releaseBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
        null,
        this.releaseBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceSupportedFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
        media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
        this.getDeviceSupportedFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceFormatsInUse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
        media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
        this.getDeviceFormatsInUse.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        media.mojom.VideoCaptureHost_OnLog_ParamsSpec.$,
        null,
        this.onLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoCaptureObserver_OnStateChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureObserver_OnStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureObserver_OnNewBuffer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureObserver_OnNewBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureObserver_OnBufferReady_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureObserver_OnBufferReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureObserver_OnBufferDestroyed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureObserver_OnBufferDestroyed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureObserver_OnFrameDropped_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureObserver_OnFrameDropped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_Start_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_Stop_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_Pause_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_Resume_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_RequestRefreshFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_RequestRefreshFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_ReleaseBuffer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_ReleaseBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureHost_OnLog_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoCaptureHost_OnLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoCaptureResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoCaptureResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
    'VideoCaptureObserver_OnStateChanged_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.VideoCaptureResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoCaptureObserver_OnStateChanged_Params');

/** @record */
media.mojom.VideoCaptureObserver_OnStateChanged_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoCaptureResult } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
    'VideoCaptureObserver_OnNewBuffer_Params',
    [
      mojo.internal.StructField(
        'bufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bufferHandle', 8,
        0,
        media.mojom.VideoBufferHandleSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.VideoCaptureObserver_OnNewBuffer_Params');

/** @record */
media.mojom.VideoCaptureObserver_OnNewBuffer_Params = class {
  constructor() {
    /** @export { !number } */
    this.bufferId;
    /** @export { !media.mojom.VideoBufferHandle } */
    this.bufferHandle;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
    'VideoCaptureObserver_OnBufferReady_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media.mojom.ReadyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureObserver_OnBufferReady_Params');

/** @record */
media.mojom.VideoCaptureObserver_OnBufferReady_Params = class {
  constructor() {
    /** @export { !media.mojom.ReadyBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
    'VideoCaptureObserver_OnBufferDestroyed_Params',
    [
      mojo.internal.StructField(
        'bufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureObserver_OnBufferDestroyed_Params');

/** @record */
media.mojom.VideoCaptureObserver_OnBufferDestroyed_Params = class {
  constructor() {
    /** @export { !number } */
    this.bufferId;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
    'VideoCaptureObserver_OnFrameDropped_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media.mojom.VideoCaptureFrameDropReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureObserver_OnFrameDropped_Params');

/** @record */
media.mojom.VideoCaptureObserver_OnFrameDropped_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoCaptureFrameDropReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
    'VideoCaptureObserver_OnNewCaptureVersion_Params',
    [
      mojo.internal.StructField(
        'captureVersion', 0,
        0,
        media.mojom.CaptureVersionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureObserver_OnNewCaptureVersion_Params');

/** @record */
media.mojom.VideoCaptureObserver_OnNewCaptureVersion_Params = class {
  constructor() {
    /** @export { !media.mojom.CaptureVersion } */
    this.captureVersion;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_Start_ParamsSpec.$,
    'VideoCaptureHost_Start_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 16,
        0,
        media.mojom.VideoCaptureParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 24,
        0,
        mojo.internal.InterfaceProxy(media.mojom.VideoCaptureObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.VideoCaptureHost_Start_Params');

/** @record */
media.mojom.VideoCaptureHost_Start_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !media.mojom.VideoCaptureParams } */
    this.params;
    /** @export { !media.mojom.VideoCaptureObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_Stop_ParamsSpec.$,
    'VideoCaptureHost_Stop_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureHost_Stop_Params');

/** @record */
media.mojom.VideoCaptureHost_Stop_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_Pause_ParamsSpec.$,
    'VideoCaptureHost_Pause_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureHost_Pause_Params');

/** @record */
media.mojom.VideoCaptureHost_Pause_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_Resume_ParamsSpec.$,
    'VideoCaptureHost_Resume_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 16,
        0,
        media.mojom.VideoCaptureParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.VideoCaptureHost_Resume_Params');

/** @record */
media.mojom.VideoCaptureHost_Resume_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
    /** @export { !media.mojom.VideoCaptureParams } */
    this.params;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
    'VideoCaptureHost_RequestRefreshFrame_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureHost_RequestRefreshFrame_Params');

/** @record */
media.mojom.VideoCaptureHost_RequestRefreshFrame_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
    'VideoCaptureHost_ReleaseBuffer_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bufferId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'feedback', 16,
        0,
        media.mojom.VideoCaptureFeedbackSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.VideoCaptureHost_ReleaseBuffer_Params');

/** @record */
media.mojom.VideoCaptureHost_ReleaseBuffer_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
    /** @export { !number } */
    this.bufferId;
    /** @export { !media.mojom.VideoCaptureFeedback } */
    this.feedback;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
    'VideoCaptureHost_GetDeviceSupportedFormats_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_Params');

/** @record */
media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
    'VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formatsSupported', 0,
        0,
        mojo.internal.Array(media.mojom.VideoCaptureFormatSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams');

/** @record */
media.mojom.VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams = class {
  constructor() {
    /** @export { !Array<!media.mojom.VideoCaptureFormat> } */
    this.formatsSupported;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
    'VideoCaptureHost_GetDeviceFormatsInUse_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_Params');

/** @record */
media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
    'VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams',
    [
      mojo.internal.StructField(
        'formatsInUse', 0,
        0,
        mojo.internal.Array(media.mojom.VideoCaptureFormatSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams');

/** @record */
media.mojom.VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams = class {
  constructor() {
    /** @export { !Array<!media.mojom.VideoCaptureFormat> } */
    this.formatsInUse;
  }
};



mojo.internal.Struct(
    media.mojom.VideoCaptureHost_OnLog_ParamsSpec.$,
    'VideoCaptureHost_OnLog_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoCaptureHost_OnLog_Params');

/** @record */
media.mojom.VideoCaptureHost_OnLog_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.deviceId;
    /** @export { !string } */
    this.message;
  }
};

goog.provide('media.mojom.VideoCaptureResult');


mojo.internal.Union(
    media.mojom.VideoCaptureResultSpec.$, 'VideoCaptureResult',
    {
      'state': {
        'ordinal': 0,
        'type': media.mojom.VideoCaptureStateSpec.$,
      },
      'errorCode': {
        'ordinal': 1,
        'type': media.mojom.VideoCaptureErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   state: (!media.mojom.VideoCaptureState|undefined),
 *   errorCode: (!media.mojom.VideoCaptureError|undefined),
 * } }
 */
media.mojom.VideoCaptureResult;
