// media/capture/mojom/video_capture.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_DATA_VIEW_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/capture/mojom/video_capture.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"


namespace media::mojom {
class VideoCaptureResultDataView;


}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoCaptureResultDataView> {
  using Data = ::media::mojom::internal::VideoCaptureResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class VideoCaptureState : int32_t {
  
  STARTED = 0,
  
  PAUSED = 1,
  
  RESUMED = 2,
  
  STOPPED = 3,
  
  ENDED = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, VideoCaptureState value);
inline bool IsKnownEnumValue(VideoCaptureState value) {
  return internal::VideoCaptureState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VideoCaptureObserverInterfaceBase {};

using VideoCaptureObserverPtrDataView =
    mojo::InterfacePtrDataView<VideoCaptureObserverInterfaceBase>;
using VideoCaptureObserverRequestDataView =
    mojo::InterfaceRequestDataView<VideoCaptureObserverInterfaceBase>;
using VideoCaptureObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoCaptureObserverInterfaceBase>;
using VideoCaptureObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoCaptureObserverInterfaceBase>;
class VideoCaptureHostInterfaceBase {};

using VideoCaptureHostPtrDataView =
    mojo::InterfacePtrDataView<VideoCaptureHostInterfaceBase>;
using VideoCaptureHostRequestDataView =
    mojo::InterfaceRequestDataView<VideoCaptureHostInterfaceBase>;
using VideoCaptureHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoCaptureHostInterfaceBase>;
using VideoCaptureHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoCaptureHostInterfaceBase>;


class VideoCaptureResultDataView {
 public:
  using Tag = internal::VideoCaptureResult_Data::VideoCaptureResult_Tag;

  VideoCaptureResultDataView() = default;

  VideoCaptureResultDataView(
      internal::VideoCaptureResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_state() const { return data_->tag == Tag::kState; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    CHECK(is_state());
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureState>(
        data_->data.f_state, output);
  }
  VideoCaptureState state() const {
    CHECK(is_state());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureState>(data_->data.f_state));
  }
  bool is_error_code() const { return data_->tag == Tag::kErrorCode; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    CHECK(is_error_code());
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureError>(
        data_->data.f_error_code, output);
  }
  ::media::mojom::VideoCaptureError error_code() const {
    CHECK(is_error_code());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoCaptureError>(data_->data.f_error_code));
  }

 private:
  internal::VideoCaptureResult_Data* data_ = nullptr;
};



}  // media::mojom

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_DATA_VIEW_H_