// media/capture/mojom/image_capture.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_DATA_VIEW_H_
#define MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/capture/mojom/image_capture.mojom-shared-internal.h"


namespace media::mojom {
class RangeDataView;

class PhotoStateDataView;

class Point2DDataView;

class PhotoSettingsDataView;

class BlobDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::RangeDataView> {
  using Data = ::media::mojom::internal::Range_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PhotoStateDataView> {
  using Data = ::media::mojom::internal::PhotoState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::Point2DDataView> {
  using Data = ::media::mojom::internal::Point2D_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PhotoSettingsDataView> {
  using Data = ::media::mojom::internal::PhotoSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::BlobDataView> {
  using Data = ::media::mojom::internal::Blob_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class BackgroundBlurMode : int32_t {
  
  OFF = 0,
  
  BLUR = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, BackgroundBlurMode value);
inline bool IsKnownEnumValue(BackgroundBlurMode value) {
  return internal::BackgroundBlurMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EyeGazeCorrectionMode : int32_t {
  
  OFF = 0,
  
  ON = 1,
  
  STARE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, EyeGazeCorrectionMode value);
inline bool IsKnownEnumValue(EyeGazeCorrectionMode value) {
  return internal::EyeGazeCorrectionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MeteringMode : int32_t {
  
  NONE = 0,
  
  MANUAL = 1,
  
  SINGLE_SHOT = 2,
  
  CONTINUOUS = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MeteringMode value);
inline bool IsKnownEnumValue(MeteringMode value) {
  return internal::MeteringMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RedEyeReduction : int32_t {
  
  NEVER = 0,
  
  ALWAYS = 1,
  
  CONTROLLABLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RedEyeReduction value);
inline bool IsKnownEnumValue(RedEyeReduction value) {
  return internal::RedEyeReduction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FillLightMode : int32_t {
  
  OFF = 0,
  
  AUTO = 1,
  
  FLASH = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FillLightMode value);
inline bool IsKnownEnumValue(FillLightMode value) {
  return internal::FillLightMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ImageCaptureInterfaceBase {};

using ImageCapturePtrDataView =
    mojo::InterfacePtrDataView<ImageCaptureInterfaceBase>;
using ImageCaptureRequestDataView =
    mojo::InterfaceRequestDataView<ImageCaptureInterfaceBase>;
using ImageCaptureAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImageCaptureInterfaceBase>;
using ImageCaptureAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImageCaptureInterfaceBase>;


class RangeDataView {
 public:
  RangeDataView() = default;

  RangeDataView(
      internal::Range_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double max() const {
    return data_->max;
  }
  double min() const {
    return data_->min;
  }
  double current() const {
    return data_->current;
  }
  double step() const {
    return data_->step;
  }
 private:
  internal::Range_Data* data_ = nullptr;
};


class PhotoStateDataView {
 public:
  PhotoStateDataView() = default;

  PhotoStateDataView(
      internal::PhotoState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedWhiteBalanceModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedWhiteBalanceModes(UserType* output) {
    
    auto* pointer = data_->supported_white_balance_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentWhiteBalanceMode(UserType* output) const {
    auto data_value = data_->current_white_balance_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_white_balance_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_white_balance_mode));
  }
  inline void GetSupportedExposureModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedExposureModes(UserType* output) {
    
    auto* pointer = data_->supported_exposure_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentExposureMode(UserType* output) const {
    auto data_value = data_->current_exposure_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_exposure_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_exposure_mode));
  }
  inline void GetSupportedFocusModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedFocusModes(UserType* output) {
    
    auto* pointer = data_->supported_focus_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentFocusMode(UserType* output) const {
    auto data_value = data_->current_focus_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_focus_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_focus_mode));
  }
  inline void GetPointsOfInterestDataView(
      mojo::ArrayDataView<Point2DDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointsOfInterest(UserType* output) {
    
    auto* pointer = data_->points_of_interest.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>>(
        pointer, output, message_);
  }
  inline void GetExposureCompensationDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExposureCompensation(UserType* output) {
    
    auto* pointer = data_->exposure_compensation.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetExposureTimeDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExposureTime(UserType* output) {
    
    auto* pointer = data_->exposure_time.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetColorTemperatureDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorTemperature(UserType* output) {
    
    auto* pointer = data_->color_temperature.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetIsoDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIso(UserType* output) {
    
    auto* pointer = data_->iso.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetBrightnessDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrightness(UserType* output) {
    
    auto* pointer = data_->brightness.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetContrastDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContrast(UserType* output) {
    
    auto* pointer = data_->contrast.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetSaturationDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSaturation(UserType* output) {
    
    auto* pointer = data_->saturation.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetSharpnessDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharpness(UserType* output) {
    
    auto* pointer = data_->sharpness.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetFocusDistanceDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFocusDistance(UserType* output) {
    
    auto* pointer = data_->focus_distance.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetPanDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPan(UserType* output) {
    
    auto* pointer = data_->pan.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetTiltDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTilt(UserType* output) {
    
    auto* pointer = data_->tilt.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetZoomDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadZoom(UserType* output) {
    
    auto* pointer = data_->zoom.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  bool supports_torch() const {
    return data_->supports_torch;
  }
  bool torch() const {
    return data_->torch;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRedEyeReduction(UserType* output) const {
    auto data_value = data_->red_eye_reduction;
    return mojo::internal::Deserialize<::media::mojom::RedEyeReduction>(
        data_value, output);
  }
  RedEyeReduction red_eye_reduction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RedEyeReduction>(data_->red_eye_reduction));
  }
  inline void GetHeightDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeight(UserType* output) {
    
    auto* pointer = data_->height.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetWidthDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidth(UserType* output) {
    
    auto* pointer = data_->width.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetFillLightModeDataView(
      mojo::ArrayDataView<FillLightMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFillLightMode(UserType* output) {
    
    auto* pointer = data_->fill_light_mode.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::FillLightMode>>(
        pointer, output, message_);
  }
  inline void GetSupportedBackgroundBlurModesDataView(
      mojo::ArrayDataView<BackgroundBlurMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedBackgroundBlurModes(UserType* output) {
    
    auto* pointer = data_->supported_background_blur_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::BackgroundBlurMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundBlurMode(UserType* output) const {
    auto data_value = data_->background_blur_mode;
    return mojo::internal::Deserialize<::media::mojom::BackgroundBlurMode>(
        data_value, output);
  }
  BackgroundBlurMode background_blur_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::BackgroundBlurMode>(data_->background_blur_mode));
  }
  inline void GetSupportedFaceFramingModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedFaceFramingModes(UserType* output) {
    
    auto* pointer = data_->supported_face_framing_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentFaceFramingMode(UserType* output) const {
    auto data_value = data_->current_face_framing_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_face_framing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_face_framing_mode));
  }
  inline void GetSupportedEyeGazeCorrectionModesDataView(
      mojo::ArrayDataView<EyeGazeCorrectionMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedEyeGazeCorrectionModes(UserType* output) {
    
    auto* pointer = data_->supported_eye_gaze_correction_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::EyeGazeCorrectionMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentEyeGazeCorrectionMode(UserType* output) const {
    auto data_value = data_->current_eye_gaze_correction_mode;
    return mojo::internal::Deserialize<::media::mojom::EyeGazeCorrectionMode>(
        data_value, output);
  }
  EyeGazeCorrectionMode current_eye_gaze_correction_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EyeGazeCorrectionMode>(data_->current_eye_gaze_correction_mode));
  }
  inline void GetSupportedBackgroundSegmentationMaskStatesDataView(
      mojo::ArrayDataView<bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedBackgroundSegmentationMaskStates(UserType* output) {
    
    auto* pointer = data_->supported_background_segmentation_mask_states.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        pointer, output, message_);
  }
  bool current_background_segmentation_mask_state() const {
    return data_->current_background_segmentation_mask_state;
  }
 private:
  internal::PhotoState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Point2DDataView {
 public:
  Point2DDataView() = default;

  Point2DDataView(
      internal::Point2D_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double x() const {
    return data_->x;
  }
  double y() const {
    return data_->y;
  }
 private:
  internal::Point2D_Data* data_ = nullptr;
};


class PhotoSettingsDataView {
 public:
  PhotoSettingsDataView() = default;

  PhotoSettingsDataView(
      internal::PhotoSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool has_white_balance_mode() const {
    return data_->has_white_balance_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWhiteBalanceMode(UserType* output) const {
    auto data_value = data_->white_balance_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode white_balance_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->white_balance_mode));
  }
  bool has_exposure_mode() const {
    return data_->has_exposure_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExposureMode(UserType* output) const {
    auto data_value = data_->exposure_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode exposure_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->exposure_mode));
  }
  bool has_focus_mode() const {
    return data_->has_focus_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFocusMode(UserType* output) const {
    auto data_value = data_->focus_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode focus_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->focus_mode));
  }
  inline void GetPointsOfInterestDataView(
      mojo::ArrayDataView<Point2DDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointsOfInterest(UserType* output) {
    
    auto* pointer = data_->points_of_interest.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>>(
        pointer, output, message_);
  }
  bool has_exposure_compensation() const {
    return data_->has_exposure_compensation;
  }
  double exposure_compensation() const {
    return data_->exposure_compensation;
  }
  bool has_exposure_time() const {
    return data_->has_exposure_time;
  }
  double exposure_time() const {
    return data_->exposure_time;
  }
  bool has_color_temperature() const {
    return data_->has_color_temperature;
  }
  double color_temperature() const {
    return data_->color_temperature;
  }
  bool has_iso() const {
    return data_->has_iso;
  }
  double iso() const {
    return data_->iso;
  }
  bool has_brightness() const {
    return data_->has_brightness;
  }
  double brightness() const {
    return data_->brightness;
  }
  bool has_contrast() const {
    return data_->has_contrast;
  }
  double contrast() const {
    return data_->contrast;
  }
  bool has_saturation() const {
    return data_->has_saturation;
  }
  double saturation() const {
    return data_->saturation;
  }
  bool has_sharpness() const {
    return data_->has_sharpness;
  }
  double sharpness() const {
    return data_->sharpness;
  }
  bool has_focus_distance() const {
    return data_->has_focus_distance;
  }
  double focus_distance() const {
    return data_->focus_distance;
  }
  bool has_pan() const {
    return data_->has_pan;
  }
  double pan() const {
    return data_->pan;
  }
  bool has_tilt() const {
    return data_->has_tilt;
  }
  double tilt() const {
    return data_->tilt;
  }
  bool has_zoom() const {
    return data_->has_zoom;
  }
  double zoom() const {
    return data_->zoom;
  }
  bool has_torch() const {
    return data_->has_torch;
  }
  bool torch() const {
    return data_->torch;
  }
  bool has_fill_light_mode() const {
    return data_->has_fill_light_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFillLightMode(UserType* output) const {
    auto data_value = data_->fill_light_mode;
    return mojo::internal::Deserialize<::media::mojom::FillLightMode>(
        data_value, output);
  }
  FillLightMode fill_light_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::FillLightMode>(data_->fill_light_mode));
  }
  bool has_width() const {
    return data_->has_width;
  }
  double width() const {
    return data_->width;
  }
  bool has_height() const {
    return data_->has_height;
  }
  double height() const {
    return data_->height;
  }
  bool has_red_eye_reduction() const {
    return data_->has_red_eye_reduction;
  }
  bool red_eye_reduction() const {
    return data_->red_eye_reduction;
  }
  bool has_background_blur_mode() const {
    return data_->has_background_blur_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundBlurMode(UserType* output) const {
    auto data_value = data_->background_blur_mode;
    return mojo::internal::Deserialize<::media::mojom::BackgroundBlurMode>(
        data_value, output);
  }
  BackgroundBlurMode background_blur_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::BackgroundBlurMode>(data_->background_blur_mode));
  }
  bool has_face_framing_mode() const {
    return data_->has_face_framing_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFaceFramingMode(UserType* output) const {
    auto data_value = data_->face_framing_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode face_framing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->face_framing_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEyeGazeCorrectionMode(UserType* output) const {
    if (!data_->eye_gaze_correction_mode_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::EyeGazeCorrectionMode>(
        data_->eye_gaze_correction_mode_$value, &output->emplace());
  }
  std::optional<EyeGazeCorrectionMode> eye_gaze_correction_mode() const {
    if (!data_->eye_gaze_correction_mode_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EyeGazeCorrectionMode>(data_->eye_gaze_correction_mode_$value));
  }
  std::optional<bool> background_segmentation_mask_state() const {

    return data_->background_segmentation_mask_state_$flag
        ? std::make_optional(!!data_->background_segmentation_mask_state_$value)
        : std::nullopt;
  }
 private:
  internal::PhotoSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlobDataView {
 public:
  BlobDataView() = default;

  BlobDataView(
      internal::Blob_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Blob_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_DATA_VIEW_H_