// ipc/ipc.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef IPC_IPC_MOJOM_SHARED_H_
#define IPC_IPC_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ipc/ipc.mojom-shared-internal.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ipc/ipc.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::IPC::mojom::MessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::IPC::mojom::MessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::IPC::mojom::internal::Message_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bytes)::BaseType>
        bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes,
      bytes_fragment,
      &bytes_validate_params);

    fragment->bytes.Set(
        bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in Message struct");

    decltype(Traits::handles(input)) in_handles = Traits::handles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->handles)::BaseType>
        handles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& handles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>>(
      in_handles,
      handles_fragment,
      &handles_validate_params);

    fragment->handles.Set(
        handles_fragment.is_null() ? nullptr : handles_fragment.data());
  }

  static bool Deserialize(::IPC::mojom::internal::Message_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::IPC::mojom::MessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace IPC::mojom {

inline void MessageDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void MessageDataView::GetHandlesDataView(
    mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>* output) {
  auto pointer = data_->handles.Get();
  *output = mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>(pointer, message_);
}



}  // IPC::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // IPC_IPC_MOJOM_SHARED_H_