// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "headless/lib/browser/protocol/headless_experimental.h"

#include "headless/lib/browser/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace headless {
namespace protocol {
namespace HeadlessExperimental {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "HeadlessExperimental";
const char Metainfo::commandPrefix[] = "HeadlessExperimental.";
const char Metainfo::version[] = "1.3";


const char* ScreenshotParams::FormatEnum::Jpeg = "jpeg";
const char* ScreenshotParams::FormatEnum::Png = "png";
const char* ScreenshotParams::FormatEnum::Webp = "webp";
CRDTP_BEGIN_DESERIALIZER(ScreenshotParams)
    CRDTP_DESERIALIZE_FIELD_OPT("format", m_format),
    CRDTP_DESERIALIZE_FIELD_OPT("optimizeForSpeed", m_optimizeForSpeed),
    CRDTP_DESERIALIZE_FIELD_OPT("quality", m_quality),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScreenshotParams)
    CRDTP_SERIALIZE_FIELD("format", m_format);
    CRDTP_SERIALIZE_FIELD("quality", m_quality);
    CRDTP_SERIALIZE_FIELD("optimizeForSpeed", m_optimizeForSpeed);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void beginFrame(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("beginFrame"),
          &DomainDispatcherImpl::beginFrame
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class BeginFrameCallbackImpl : public Backend::BeginFrameCallback, public DomainDispatcher::Callback {
public:
    BeginFrameCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("HeadlessExperimental.beginFrame"), message) { }

    void sendSuccess(bool hasDamage, std::optional<Binary> screenshotData) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("hasDamage"), hasDamage);
        serializer.AddField(crdtp::MakeSpan("screenshotData"), screenshotData);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct beginFrameParams : public crdtp::DeserializableProtocolObject<beginFrameParams> {
    std::optional<double> frameTimeTicks;
    std::optional<double> interval;
    std::optional<bool> noDisplayUpdates;
    std::unique_ptr<protocol::HeadlessExperimental::ScreenshotParams> screenshot;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(beginFrameParams)
    CRDTP_DESERIALIZE_FIELD_OPT("frameTimeTicks", frameTimeTicks),
    CRDTP_DESERIALIZE_FIELD_OPT("interval", interval),
    CRDTP_DESERIALIZE_FIELD_OPT("noDisplayUpdates", noDisplayUpdates),
    CRDTP_DESERIALIZE_FIELD_OPT("screenshot", screenshot),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::beginFrame(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    beginFrameParams params;
    if (!beginFrameParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->BeginFrame(std::move(params.frameTimeTicks), std::move(params.interval), std::move(params.noDisplayUpdates), std::move(params.screenshot), std::make_unique<BeginFrameCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("HeadlessExperimental.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("HeadlessExperimental.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("HeadlessExperimental"), SortedRedirects(), std::move(dispatcher));
}

} // HeadlessExperimental
} // namespace headless
} // namespace protocol
