// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef headless_protocol_Browser_h
#define headless_protocol_Browser_h

#include "headless/public/headless_export.h"
#include "headless/lib/browser/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace headless {
namespace protocol {
namespace Browser {
using BrowserContextID = String;
using WindowID = int;
using WindowState = String;
class Bounds;

// ------------- Forward and enum declarations.

namespace WindowStateEnum {
HEADLESS_EXPORT extern const char Normal[];
HEADLESS_EXPORT extern const char Minimized[];
HEADLESS_EXPORT extern const char Maximized[];
HEADLESS_EXPORT extern const char Fullscreen[];
} // namespace WindowStateEnum

namespace SetDownloadBehavior {
namespace BehaviorEnum {
HEADLESS_EXPORT extern const char* Deny;
HEADLESS_EXPORT extern const char* Allow;
HEADLESS_EXPORT extern const char* AllowAndName;
HEADLESS_EXPORT extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

namespace DownloadProgress {
namespace StateEnum {
HEADLESS_EXPORT extern const char* InProgress;
HEADLESS_EXPORT extern const char* Completed;
HEADLESS_EXPORT extern const char* Canceled;
} // StateEnum
} // DownloadProgress

// ------------- Type and builder declarations.

class HEADLESS_EXPORT Bounds : public ::crdtp::ProtocolObject<Bounds> {
public:
    ~Bounds() override;  // Defined below

    bool HasLeft() { return !!m_left; }
    int GetLeft(int defaultValue) const {
       return m_left.value_or(defaultValue);
    }
    const std::optional<int>& GetLeft() const {
       return m_left;
    }
    void SetLeft(int value);  // Defined below

    bool HasTop() { return !!m_top; }
    int GetTop(int defaultValue) const {
       return m_top.value_or(defaultValue);
    }
    const std::optional<int>& GetTop() const {
       return m_top;
    }
    void SetTop(int value);  // Defined below

    bool HasWidth() { return !!m_width; }
    int GetWidth(int defaultValue) const {
       return m_width.value_or(defaultValue);
    }
    const std::optional<int>& GetWidth() const {
       return m_width;
    }
    void SetWidth(int value);  // Defined below

    bool HasHeight() { return !!m_height; }
    int GetHeight(int defaultValue) const {
       return m_height.value_or(defaultValue);
    }
    const std::optional<int>& GetHeight() const {
       return m_height;
    }
    void SetHeight(int value);  // Defined below

    bool HasWindowState() { return !!m_windowState; }
    String GetWindowState(const String& defaultValue) const {
       return m_windowState.value_or(defaultValue);
    }
    const std::optional<String>& GetWindowState() const {
       return m_windowState;
    }
    void SetWindowState(const String& value);  // Defined below

    template<int STATE>
    class BoundsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        BoundsBuilder<STATE>& SetLeft(int value);  // Defined below

        BoundsBuilder<STATE>& SetTop(int value);  // Defined below

        BoundsBuilder<STATE>& SetWidth(int value);  // Defined below

        BoundsBuilder<STATE>& SetHeight(int value);  // Defined below

        BoundsBuilder<STATE>& SetWindowState(const String& value);  // Defined below

        std::unique_ptr<Bounds> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Bounds;
        BoundsBuilder() : m_result(new Bounds()) { }

        template<int STEP> BoundsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BoundsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Browser::Bounds> m_result;
    };

    static BoundsBuilder<0> Create()
    {
        return BoundsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Bounds();  // Defined below

    std::optional<int> m_left;
    std::optional<int> m_top;
    std::optional<int> m_width;
    std::optional<int> m_height;
    std::optional<String> m_windowState;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline Bounds::~Bounds() = default;
inline void Bounds::SetLeft(int value) { m_left = value; }
inline void Bounds::SetTop(int value) { m_top = value; }
inline void Bounds::SetWidth(int value) { m_width = value; }
inline void Bounds::SetHeight(int value) { m_height = value; }
inline void Bounds::SetWindowState(const String& value) { m_windowState = value; }

template<int STATE>
inline Bounds::BoundsBuilder<STATE>& Bounds::BoundsBuilder<STATE>::SetLeft(int value) {
  m_result->SetLeft(value);
  return *this;
}
template<int STATE>
inline Bounds::BoundsBuilder<STATE>& Bounds::BoundsBuilder<STATE>::SetTop(int value) {
  m_result->SetTop(value);
  return *this;
}
template<int STATE>
inline Bounds::BoundsBuilder<STATE>& Bounds::BoundsBuilder<STATE>::SetWidth(int value) {
  m_result->SetWidth(value);
  return *this;
}
template<int STATE>
inline Bounds::BoundsBuilder<STATE>& Bounds::BoundsBuilder<STATE>::SetHeight(int value) {
  m_result->SetHeight(value);
  return *this;
}
template<int STATE>
inline Bounds::BoundsBuilder<STATE>& Bounds::BoundsBuilder<STATE>::SetWindowState(const String& value) {
  m_result->SetWindowState(value);
  return *this;
}

inline Bounds::Bounds() {
}

// ------------- Backend interface.

class HEADLESS_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Close() = 0;
    virtual DispatchResponse GetWindowBounds(int in_windowId, std::unique_ptr<protocol::Browser::Bounds>* out_bounds) = 0;
    virtual DispatchResponse GetWindowForTarget(std::optional<String> in_targetId, int* out_windowId, std::unique_ptr<protocol::Browser::Bounds>* out_bounds) = 0;
    virtual DispatchResponse SetWindowBounds(int in_windowId, std::unique_ptr<protocol::Browser::Bounds> in_bounds) = 0;
    virtual DispatchResponse SetContentsSize(int in_windowId, std::optional<int> in_width, std::optional<int> in_height) = 0;
    virtual DispatchResponse SetDockTile(std::optional<String> in_badgeLabel, std::optional<Binary> in_image) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class HEADLESS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class HEADLESS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class HEADLESS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Browser
} // namespace headless
} // namespace protocol

#endif // !defined(headless_protocol_Browser_h)
