// gpu/ipc/common/vulkan_ycbcr_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_YCBCR_INFO_MOJOM_H_
#define GPU_IPC_COMMON_VULKAN_YCBCR_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "gpu/ipc/common/vulkan_ycbcr_info_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {








class GPU_EXPORT VulkanYCbCrInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VulkanYCbCrInfo, T>::value>;
  using DataView = VulkanYCbCrInfoDataView;
  using Data_ = internal::VulkanYCbCrInfo_Data;

  template <typename... Args>
  static VulkanYCbCrInfoPtr New(Args&&... args) {
    return VulkanYCbCrInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VulkanYCbCrInfoPtr From(const U& u) {
    return mojo::TypeConverter<VulkanYCbCrInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VulkanYCbCrInfo>::Convert(*this);
  }


  VulkanYCbCrInfo();

  VulkanYCbCrInfo(
      uint32_t image_format,
      uint64_t external_format,
      uint32_t suggested_ycbcr_model,
      uint32_t suggested_ycbcr_range,
      uint32_t suggested_xchroma_offset,
      uint32_t suggested_ychroma_offset,
      uint32_t format_features);


  ~VulkanYCbCrInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VulkanYCbCrInfoPtr>
  VulkanYCbCrInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VulkanYCbCrInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VulkanYCbCrInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VulkanYCbCrInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VulkanYCbCrInfo_UnserializedMessageContext<
            UserType, VulkanYCbCrInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VulkanYCbCrInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VulkanYCbCrInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VulkanYCbCrInfo_UnserializedMessageContext<
            UserType, VulkanYCbCrInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VulkanYCbCrInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t image_format;
  
  uint64_t external_format;
  
  uint32_t suggested_ycbcr_model;
  
  uint32_t suggested_ycbcr_range;
  
  uint32_t suggested_xchroma_offset;
  
  uint32_t suggested_ychroma_offset;
  
  uint32_t format_features;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VulkanYCbCrInfoPtr VulkanYCbCrInfo::Clone() const {
  return New(
      mojo::Clone(image_format),
      mojo::Clone(external_format),
      mojo::Clone(suggested_ycbcr_model),
      mojo::Clone(suggested_ycbcr_range),
      mojo::Clone(suggested_xchroma_offset),
      mojo::Clone(suggested_ychroma_offset),
      mojo::Clone(format_features)
  );
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>*>
bool VulkanYCbCrInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_format, other_struct.image_format))
    return false;
  if (!mojo::Equals(this->external_format, other_struct.external_format))
    return false;
  if (!mojo::Equals(this->suggested_ycbcr_model, other_struct.suggested_ycbcr_model))
    return false;
  if (!mojo::Equals(this->suggested_ycbcr_range, other_struct.suggested_ycbcr_range))
    return false;
  if (!mojo::Equals(this->suggested_xchroma_offset, other_struct.suggested_xchroma_offset))
    return false;
  if (!mojo::Equals(this->suggested_ychroma_offset, other_struct.suggested_ychroma_offset))
    return false;
  if (!mojo::Equals(this->format_features, other_struct.format_features))
    return false;
  return true;
}

template <typename T, VulkanYCbCrInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_format < rhs.image_format)
    return true;
  if (rhs.image_format < lhs.image_format)
    return false;
  if (lhs.external_format < rhs.external_format)
    return true;
  if (rhs.external_format < lhs.external_format)
    return false;
  if (lhs.suggested_ycbcr_model < rhs.suggested_ycbcr_model)
    return true;
  if (rhs.suggested_ycbcr_model < lhs.suggested_ycbcr_model)
    return false;
  if (lhs.suggested_ycbcr_range < rhs.suggested_ycbcr_range)
    return true;
  if (rhs.suggested_ycbcr_range < lhs.suggested_ycbcr_range)
    return false;
  if (lhs.suggested_xchroma_offset < rhs.suggested_xchroma_offset)
    return true;
  if (rhs.suggested_xchroma_offset < lhs.suggested_xchroma_offset)
    return false;
  if (lhs.suggested_ychroma_offset < rhs.suggested_ychroma_offset)
    return true;
  if (rhs.suggested_ychroma_offset < lhs.suggested_ychroma_offset)
    return false;
  if (lhs.format_features < rhs.format_features)
    return true;
  if (rhs.format_features < lhs.format_features)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VulkanYCbCrInfo::DataView,
                                         ::gpu::mojom::VulkanYCbCrInfoPtr> {
  static bool IsNull(const ::gpu::mojom::VulkanYCbCrInfoPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VulkanYCbCrInfoPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VulkanYCbCrInfo::image_format) image_format(
      const ::gpu::mojom::VulkanYCbCrInfoPtr& input) {
    return input->image_format;
  }

  static decltype(::gpu::mojom::VulkanYCbCrInfo::external_format) external_format(
      const ::gpu::mojom::VulkanYCbCrInfoPtr& input) {
    return input->external_format;
  }

  static decltype(::gpu::mojom::VulkanYCbCrInfo::suggested_ycbcr_model) suggested_ycbcr_model(
      const ::gpu::mojom::VulkanYCbCrInfoPtr& input) {
    return input->suggested_ycbcr_model;
  }

  static decltype(::gpu::mojom::VulkanYCbCrInfo::suggested_ycbcr_range) suggested_ycbcr_range(
      const ::gpu::mojom::VulkanYCbCrInfoPtr& input) {
    return input->suggested_ycbcr_range;
  }

  static decltype(::gpu::mojom::VulkanYCbCrInfo::suggested_xchroma_offset) suggested_xchroma_offset(
      const ::gpu::mojom::VulkanYCbCrInfoPtr& input) {
    return input->suggested_xchroma_offset;
  }

  static decltype(::gpu::mojom::VulkanYCbCrInfo::suggested_ychroma_offset) suggested_ychroma_offset(
      const ::gpu::mojom::VulkanYCbCrInfoPtr& input) {
    return input->suggested_ychroma_offset;
  }

  static decltype(::gpu::mojom::VulkanYCbCrInfo::format_features) format_features(
      const ::gpu::mojom::VulkanYCbCrInfoPtr& input) {
    return input->format_features;
  }

  static bool Read(::gpu::mojom::VulkanYCbCrInfo::DataView input, ::gpu::mojom::VulkanYCbCrInfoPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_VULKAN_YCBCR_INFO_MOJOM_H_