// gpu/ipc/common/sync_token.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_H_
#define GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/sync_token.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/sync_token.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/sync_token.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "gpu/ipc/common/sync_token_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {





class GPU_EXPORT SyncToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyncToken, T>::value>;
  using DataView = SyncTokenDataView;
  using Data_ = internal::SyncToken_Data;

  template <typename... Args>
  static SyncTokenPtr New(Args&&... args) {
    return SyncTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyncTokenPtr From(const U& u) {
    return mojo::TypeConverter<SyncTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyncToken>::Convert(*this);
  }


  SyncToken();

  SyncToken(
      bool verified_flush,
      CommandBufferNamespace namespace_id,
      uint64_t command_buffer_id,
      uint64_t release_count);


  ~SyncToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyncTokenPtr>
  SyncTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyncToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyncToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyncToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyncToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyncToken_UnserializedMessageContext<
            UserType, SyncToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyncToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyncToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyncToken_UnserializedMessageContext<
            UserType, SyncToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyncToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool verified_flush;
  
  CommandBufferNamespace namespace_id;
  
  uint64_t command_buffer_id;
  
  uint64_t release_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyncToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyncToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyncToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyncToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SyncTokenPtr SyncToken::Clone() const {
  return New(
      mojo::Clone(verified_flush),
      mojo::Clone(namespace_id),
      mojo::Clone(command_buffer_id),
      mojo::Clone(release_count)
  );
}

template <typename T, SyncToken::EnableIfSame<T>*>
bool SyncToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->verified_flush, other_struct.verified_flush))
    return false;
  if (!mojo::Equals(this->namespace_id, other_struct.namespace_id))
    return false;
  if (!mojo::Equals(this->command_buffer_id, other_struct.command_buffer_id))
    return false;
  if (!mojo::Equals(this->release_count, other_struct.release_count))
    return false;
  return true;
}

template <typename T, SyncToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.verified_flush < rhs.verified_flush)
    return true;
  if (rhs.verified_flush < lhs.verified_flush)
    return false;
  if (lhs.namespace_id < rhs.namespace_id)
    return true;
  if (rhs.namespace_id < lhs.namespace_id)
    return false;
  if (lhs.command_buffer_id < rhs.command_buffer_id)
    return true;
  if (rhs.command_buffer_id < lhs.command_buffer_id)
    return false;
  if (lhs.release_count < rhs.release_count)
    return true;
  if (rhs.release_count < lhs.release_count)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::SyncToken::DataView,
                                         ::gpu::mojom::SyncTokenPtr> {
  static bool IsNull(const ::gpu::mojom::SyncTokenPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::SyncTokenPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::SyncToken::verified_flush) verified_flush(
      const ::gpu::mojom::SyncTokenPtr& input) {
    return input->verified_flush;
  }

  static decltype(::gpu::mojom::SyncToken::namespace_id) namespace_id(
      const ::gpu::mojom::SyncTokenPtr& input) {
    return input->namespace_id;
  }

  static decltype(::gpu::mojom::SyncToken::command_buffer_id) command_buffer_id(
      const ::gpu::mojom::SyncTokenPtr& input) {
    return input->command_buffer_id;
  }

  static decltype(::gpu::mojom::SyncToken::release_count) release_count(
      const ::gpu::mojom::SyncTokenPtr& input) {
    return input->release_count;
  }

  static bool Read(::gpu::mojom::SyncToken::DataView input, ::gpu::mojom::SyncTokenPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_H_